/*
 * Decompiled with CFR 0.152.
 */
package gnu.trove;

import gnu.trove.HashFunctions;
import gnu.trove.SerializationProcedure;
import gnu.trove.TLongFunction;
import gnu.trove.TLongProcedure;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Random;

public class TLongArrayList
implements Serializable,
Cloneable {
    protected transient long[] _data;
    protected transient int _pos;
    protected static final int DEFAULT_CAPACITY = 4;

    public TLongArrayList() {
    }

    public TLongArrayList(int capacity) {
        this._data = new long[capacity];
        this._pos = 0;
    }

    public TLongArrayList(long[] values2) {
        this(Math.max(values2.length, 4));
        this.add(values2);
    }

    public void ensureCapacity(int capacity) {
        if (this._data == null) {
            this._data = new long[Math.max(4, capacity)];
        }
        if (capacity > this._data.length) {
            int newCap = Math.max(this._data.length << 1, capacity);
            long[] tmp = new long[newCap];
            System.arraycopy(this._data, 0, tmp, 0, this._data.length);
            this._data = tmp;
        }
    }

    public int size() {
        return this._pos;
    }

    public boolean isEmpty() {
        return this._pos == 0;
    }

    public void trimToSize() {
        if (this._data != null && this._data.length > this.size()) {
            long[] tmp = new long[this.size()];
            this.toNativeArray(tmp, 0, tmp.length);
            this._data = tmp;
        }
    }

    public void add(long val) {
        this.ensureCapacity(this._pos + 1);
        this._data[this._pos++] = val;
    }

    public void add(long[] vals) {
        this.add(vals, 0, vals.length);
    }

    public void add(long[] vals, int offset, int length) {
        this.ensureCapacity(this._pos + length);
        System.arraycopy(vals, offset, this._data, this._pos, length);
        this._pos += length;
    }

    public void insert(int offset, long value2) {
        if (offset == this._pos) {
            this.add(value2);
            return;
        }
        this.ensureCapacity(this._pos + 1);
        System.arraycopy(this._data, offset, this._data, offset + 1, this._pos - offset);
        this._data[offset] = value2;
        ++this._pos;
    }

    public void insert(int offset, long[] values2) {
        this.insert(offset, values2, 0, values2.length);
    }

    public void insert(int offset, long[] values2, int valOffset, int len) {
        if (offset == this._pos) {
            this.add(values2, valOffset, len);
            return;
        }
        this.ensureCapacity(this._pos + len);
        System.arraycopy(this._data, offset, this._data, offset + len, this._pos - offset);
        System.arraycopy(values2, valOffset, this._data, offset, len);
        this._pos += len;
    }

    public long get(int offset) {
        if (offset >= this._pos) {
            throw new ArrayIndexOutOfBoundsException(offset);
        }
        return this._data[offset];
    }

    public long getQuick(int offset) {
        return this._data[offset];
    }

    public void set(int offset, long val) {
        if (offset < 0 || offset >= this._pos) {
            throw new ArrayIndexOutOfBoundsException(offset);
        }
        this._data[offset] = val;
    }

    public long getSet(int offset, long val) {
        if (offset < 0 || offset >= this._pos) {
            throw new ArrayIndexOutOfBoundsException(offset);
        }
        long old = this._data[offset];
        this._data[offset] = val;
        return old;
    }

    public void set(int offset, long[] values2) {
        this.set(offset, values2, 0, values2.length);
    }

    public void set(int offset, long[] values2, int valOffset, int length) {
        if (offset < 0 || offset + length > this._pos) {
            throw new ArrayIndexOutOfBoundsException(offset);
        }
        System.arraycopy(this._data, offset, values2, valOffset, length);
    }

    public void setQuick(int offset, long val) {
        this._data[offset] = val;
    }

    public void clear() {
        this._data = null;
        this._pos = 0;
    }

    public void clear(int capacity) {
        this._data = new long[capacity];
        this._pos = 0;
    }

    public void reset() {
        this.fill(0L);
        this._pos = 0;
    }

    public void resetQuick() {
        this._pos = 0;
    }

    public long remove(int offset) {
        long old = this.get(offset);
        this.remove(offset, 1);
        return old;
    }

    public void remove(int offset, int length) {
        if (offset < 0 || offset >= this._pos) {
            throw new ArrayIndexOutOfBoundsException(offset);
        }
        if (offset == 0) {
            System.arraycopy(this._data, length, this._data, 0, this._pos - length);
        } else if (this._pos - length != offset) {
            System.arraycopy(this._data, offset + length, this._data, offset, this._pos - (offset + length));
        }
        this._pos -= length;
    }

    public void transformValues(TLongFunction function) {
        int i = this._pos;
        while (i-- > 0) {
            this._data[i] = function.execute(this._data[i]);
        }
    }

    public void reverse() {
        this.reverse(0, this._pos);
    }

    public void reverse(int from, int to) {
        if (from == to) {
            return;
        }
        if (from > to) {
            throw new IllegalArgumentException("from cannot be greater than to");
        }
        int i = from;
        for (int j = to - 1; i < j; ++i, --j) {
            this.swap(i, j);
        }
    }

    public void shuffle(Random rand) {
        int i = this._pos;
        while (i-- > 1) {
            this.swap(i, rand.nextInt(i));
        }
    }

    private void swap(int i, int j) {
        long tmp = this._data[i];
        this._data[i] = this._data[j];
        this._data[j] = tmp;
    }

    public Object clone() {
        TLongArrayList clone = null;
        try {
            clone = (TLongArrayList)super.clone();
            clone._data = this._data == null ? null : (long[])this._data.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return clone;
    }

    public long[] toNativeArray() {
        return this.toNativeArray(0, this._pos);
    }

    public long[] toNativeArray(int offset, int len) {
        long[] rv = new long[len];
        this.toNativeArray(rv, offset, len);
        return rv;
    }

    public void toNativeArray(long[] dest, int offset, int len) {
        if (len == 0) {
            return;
        }
        if (offset < 0 || offset >= this._pos) {
            throw new ArrayIndexOutOfBoundsException(offset);
        }
        System.arraycopy(this._data, offset, dest, 0, len);
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof TLongArrayList) {
            TLongArrayList that = (TLongArrayList)other;
            if (that.size() != this.size()) {
                return false;
            }
            int i = this._pos;
            while (i-- > 0) {
                if (this._data[i] == that._data[i]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        int h = 0;
        int i = this._pos;
        while (i-- > 0) {
            h += HashFunctions.hash(this._data[i]);
        }
        return h;
    }

    public boolean forEach(TLongProcedure procedure) {
        for (int i = 0; i < this._pos; ++i) {
            if (procedure.execute(this._data[i])) continue;
            return false;
        }
        return true;
    }

    public boolean forEachDescending(TLongProcedure procedure) {
        int i = this._pos;
        while (i-- > 0) {
            if (procedure.execute(this._data[i])) continue;
            return false;
        }
        return true;
    }

    public void sort() {
        if (!this.isEmpty()) {
            Arrays.sort(this._data, 0, this._pos);
        }
    }

    public void sort(int fromIndex, int toIndex) {
        if (!this.isEmpty()) {
            Arrays.sort(this._data, fromIndex, toIndex);
        }
    }

    public void fill(long val) {
        if (!this.isEmpty()) {
            Arrays.fill(this._data, 0, this._pos, val);
        }
    }

    public void fill(int fromIndex, int toIndex, long val) {
        if (toIndex > this._pos) {
            this.ensureCapacity(toIndex);
            this._pos = toIndex;
        }
        if (!this.isEmpty()) {
            Arrays.fill(this._data, fromIndex, toIndex, val);
        }
    }

    public int binarySearch(long value2) {
        return this.binarySearch(value2, 0, this._pos);
    }

    public int binarySearch(long value2, int fromIndex, int toIndex) {
        if (fromIndex < 0) {
            throw new ArrayIndexOutOfBoundsException(fromIndex);
        }
        if (toIndex > this._pos) {
            throw new ArrayIndexOutOfBoundsException(toIndex);
        }
        int low = fromIndex;
        int high = toIndex - 1;
        while (low <= high) {
            int mid = low + high >> 1;
            long midVal = this._data[mid];
            if (midVal < value2) {
                low = mid + 1;
                continue;
            }
            if (midVal > value2) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    public int indexOf(long value2) {
        return this.indexOf(0, value2);
    }

    public int indexOf(int offset, long value2) {
        for (int i = offset; i < this._pos; ++i) {
            if (this._data[i] != value2) continue;
            return i;
        }
        return -1;
    }

    public int lastIndexOf(long value2) {
        return this.lastIndexOf(this._pos, value2);
    }

    public int lastIndexOf(int offset, long value2) {
        int i = offset;
        while (i-- > 0) {
            if (this._data[i] != value2) continue;
            return i;
        }
        return -1;
    }

    public boolean contains(long value2) {
        return this.lastIndexOf(value2) >= 0;
    }

    public TLongArrayList grep(TLongProcedure condition2) {
        TLongArrayList list2 = new TLongArrayList();
        for (int i = 0; i < this._pos; ++i) {
            if (!condition2.execute(this._data[i])) continue;
            list2.add(this._data[i]);
        }
        return list2;
    }

    public TLongArrayList inverseGrep(TLongProcedure condition2) {
        TLongArrayList list2 = new TLongArrayList();
        for (int i = 0; i < this._pos; ++i) {
            if (condition2.execute(this._data[i])) continue;
            list2.add(this._data[i]);
        }
        return list2;
    }

    public long max() {
        if (this.size() == 0) {
            throw new IllegalStateException("cannot find maximum of an empty list");
        }
        long max = this._data[this._pos - 1];
        int i = this._pos - 1;
        while (i-- > 0) {
            max = Math.max(max, this._data[this._pos]);
        }
        return max;
    }

    public long min() {
        if (this.size() == 0) {
            throw new IllegalStateException("cannot find minimum of an empty list");
        }
        long min = this._data[this._pos - 1];
        int i = this._pos - 1;
        while (i-- > 0) {
            min = Math.min(min, this._data[this._pos]);
        }
        return min;
    }

    public String toString() {
        final StringBuffer buf = new StringBuffer("{");
        this.forEach(new TLongProcedure(){

            public boolean execute(long val) {
                buf.append(val);
                buf.append(", ");
                return true;
            }
        });
        buf.append("}");
        return buf.toString();
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
        stream.writeInt(this.size());
        SerializationProcedure writeProcedure = new SerializationProcedure(stream);
        if (!this.forEach(writeProcedure)) {
            throw writeProcedure.exception;
        }
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        int size = stream.readInt();
        this._data = new long[size];
        while (size-- > 0) {
            long val = stream.readLong();
            this.add(val);
        }
    }
}

