/*
 * Decompiled with CFR 0.152.
 */
package gnu.trove;

import gnu.trove.HashFunctions;
import gnu.trove.SerializationProcedure;
import gnu.trove.THash;
import gnu.trove.TLongHashingStrategy;
import gnu.trove.TLongObjectIterator;
import gnu.trove.TLongObjectProcedure;
import gnu.trove.TLongProcedure;
import gnu.trove.TObjectFunction;
import gnu.trove.TObjectHash;
import gnu.trove.TObjectProcedure;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TLongObjectHashMap<V>
extends THash
implements TLongHashingStrategy {
    protected transient V[] _values;
    protected transient long[] _set;
    protected final TLongHashingStrategy _hashingStrategy;

    public TLongObjectHashMap() {
        this._hashingStrategy = this;
    }

    public TLongObjectHashMap(int initialCapacity) {
        super(initialCapacity);
        this._hashingStrategy = this;
    }

    public TLongObjectHashMap(int initialCapacity, float loadFactor) {
        super(initialCapacity, loadFactor);
        this._hashingStrategy = this;
    }

    public TLongObjectHashMap(TLongHashingStrategy strategy) {
        this._hashingStrategy = strategy;
    }

    public TLongObjectHashMap(int initialCapacity, TLongHashingStrategy strategy) {
        super(initialCapacity);
        this._hashingStrategy = strategy;
    }

    public TLongObjectHashMap(int initialCapacity, float loadFactor, TLongHashingStrategy strategy) {
        super(initialCapacity, loadFactor);
        this._hashingStrategy = strategy;
    }

    @Override
    public TLongObjectHashMap<V> clone() {
        TLongObjectHashMap m = (TLongObjectHashMap)super.clone();
        m._values = this._values == EMPTY_OBJECT_ARRAY ? EMPTY_OBJECT_ARRAY : (Object[])this._values.clone();
        m._set = this._values == EMPTY_OBJECT_ARRAY ? null : (long[])this._set.clone();
        return m;
    }

    public TLongObjectIterator<V> iterator() {
        return new TLongObjectIterator(this);
    }

    @Override
    protected int setUp(int initialCapacity) {
        int capacity = super.setUp(initialCapacity);
        this._values = initialCapacity == -1 ? EMPTY_OBJECT_ARRAY : new Object[capacity];
        this._set = initialCapacity == -1 ? null : new long[capacity];
        return capacity;
    }

    public boolean contains(long val) {
        return this.index(val) >= 0;
    }

    @Override
    protected int capacity() {
        return this._values.length;
    }

    public boolean forEach(TLongProcedure procedure) {
        long[] set = this._set;
        Object[] values2 = this._values;
        int i = values2.length;
        while (i-- > 0) {
            if (!TLongObjectHashMap.isFull(values2, i) || procedure.execute(set[i])) continue;
            return false;
        }
        return true;
    }

    public V put(long key, V value2) {
        boolean wasFree = false;
        V previous = null;
        int index = this.insertionIndex(key);
        boolean isNewMapping = true;
        if (index < 0) {
            index = -index - 1;
            previous = TLongObjectHashMap.unwrapNull(this._values[index]);
            isNewMapping = false;
        } else {
            wasFree = TLongObjectHashMap.isFree(this._values, index);
        }
        this._set[index] = key;
        this._values[index] = TLongObjectHashMap.wrapNull(value2);
        if (isNewMapping) {
            this.postInsertHook(wasFree);
        }
        return previous;
    }

    @Override
    protected void rehash(int newCapacity) {
        int oldCapacity = this.capacity();
        long[] oldKeys = this._set;
        Object[] oldVals = this._values;
        this._set = new long[newCapacity];
        this._values = new Object[newCapacity];
        int i = oldCapacity;
        while (i-- > 0) {
            if (!TLongObjectHashMap.isFull(oldVals, i)) continue;
            long o = oldKeys[i];
            int index = this.insertionIndex(o);
            this._set[index] = o;
            this._values[index] = oldVals[i];
        }
    }

    public V get(long key) {
        int index = this.index(key);
        return index < 0 ? null : (V)TLongObjectHashMap.unwrapNull(this._values[index]);
    }

    private static <V> V unwrapNull(V value2) {
        return value2 == TObjectHash.NULL ? null : (V)value2;
    }

    private static <V> V wrapNull(V value2) {
        return (V)(value2 == null ? TObjectHash.NULL : value2);
    }

    @Override
    public void clear() {
        super.clear();
        long[] keys2 = this._set;
        V[] values2 = this._values;
        int i = values2.length;
        while (i-- > 0) {
            keys2[i] = 0L;
            values2[i] = null;
        }
    }

    public V remove(long key) {
        V prev = null;
        int index = this.index(key);
        if (index >= 0) {
            prev = TLongObjectHashMap.unwrapNull(this._values[index]);
            this.removeAt(index);
        }
        return prev;
    }

    protected int index(long val) {
        long[] set = this._set;
        Object[] values2 = this._values;
        if (values2 == EMPTY_OBJECT_ARRAY) {
            return -1;
        }
        int length = set.length;
        int hash2 = this._hashingStrategy.computeHashCode(val) & Integer.MAX_VALUE;
        int index = hash2 % length;
        if (!TLongObjectHashMap.isFree(values2, index) && (TLongObjectHashMap.isRemoved(values2, index) || set[index] != val)) {
            int probe = 1 + hash2 % (length - 2);
            do {
                if ((index -= probe) >= 0) continue;
                index += length;
            } while (!TLongObjectHashMap.isFree(values2, index) && (TLongObjectHashMap.isRemoved(values2, index) || set[index] != val));
        }
        return TLongObjectHashMap.isFree(values2, index) ? -1 : index;
    }

    protected int insertionIndex(long val) {
        int firstRemoved;
        if (this._values == EMPTY_OBJECT_ARRAY) {
            this.setUp(6);
        }
        Object[] values2 = this._values;
        long[] set = this._set;
        int length = set.length;
        int hash2 = this._hashingStrategy.computeHashCode(val) & Integer.MAX_VALUE;
        int index = hash2 % length;
        if (TLongObjectHashMap.isFree(values2, index)) {
            return index;
        }
        if (TLongObjectHashMap.isFull(values2, index) && set[index] == val) {
            return -index - 1;
        }
        int probe = 1 + hash2 % (length - 2);
        int n = firstRemoved = TLongObjectHashMap.isRemoved(values2, index) ? index : -1;
        do {
            if ((index -= probe) < 0) {
                index += length;
            }
            if (firstRemoved != -1 || !TLongObjectHashMap.isRemoved(values2, index)) continue;
            firstRemoved = index;
        } while (TLongObjectHashMap.isFull(values2, index) && set[index] != val);
        if (TLongObjectHashMap.isRemoved(values2, index)) {
            while (!TLongObjectHashMap.isFree(values2, index) && (TLongObjectHashMap.isRemoved(values2, index) || set[index] != val)) {
                if ((index -= probe) >= 0) continue;
                index += length;
            }
        }
        if (TLongObjectHashMap.isFull(values2, index)) {
            return -index - 1;
        }
        return firstRemoved == -1 ? index : firstRemoved;
    }

    static boolean isFull(Object[] values2, int index) {
        Object value2 = values2[index];
        return value2 != null && value2 != TObjectHash.REMOVED;
    }

    private static boolean isRemoved(Object[] values2, int index) {
        return values2[index] == TObjectHash.REMOVED;
    }

    private static boolean isFree(Object[] values2, int index) {
        return values2[index] == null;
    }

    public boolean equals(Object other) {
        if (!(other instanceof TLongObjectHashMap)) {
            return false;
        }
        TLongObjectHashMap that = (TLongObjectHashMap)other;
        if (that.size() != this.size()) {
            return false;
        }
        return this.forEachEntry(new EqProcedure(that));
    }

    public int hashCode() {
        HashProcedure p = new HashProcedure();
        this.forEachEntry(p);
        return p.getHashCode();
    }

    @Override
    protected void removeAt(int index) {
        this._values[index] = TObjectHash.REMOVED;
        super.removeAt(index);
    }

    public Object[] getValues() {
        Object[] vals = new Object[this.size()];
        Object[] values2 = this._values;
        int i = values2.length;
        int j = 0;
        while (i-- > 0) {
            if (!TLongObjectHashMap.isFull(values2, i)) continue;
            vals[j++] = TLongObjectHashMap.unwrapNull(values2[i]);
        }
        return vals;
    }

    public long[] keys() {
        long[] keys2 = new long[this.size()];
        long[] k = this._set;
        Object[] values2 = this._values;
        int i = values2.length;
        int j = 0;
        while (i-- > 0) {
            if (!TLongObjectHashMap.isFull(values2, i)) continue;
            keys2[j++] = k[i];
        }
        return keys2;
    }

    public boolean containsValue(V val) {
        Object[] values2 = this._values;
        if (null == val) {
            int i = values2.length;
            while (i-- > 0) {
                if (TObjectHash.NULL != values2[i]) continue;
                return true;
            }
        } else {
            int i = values2.length;
            while (i-- > 0) {
                V value2 = TLongObjectHashMap.unwrapNull(values2[i]);
                if (!TLongObjectHashMap.isFull(values2, i) || val != value2 && !val.equals(value2)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean containsKey(long key) {
        return this.contains(key);
    }

    public boolean forEachKey(TLongProcedure procedure) {
        return this.forEach(procedure);
    }

    public boolean forEachValue(TObjectProcedure<V> procedure) {
        Object[] values2 = this._values;
        int i = values2.length;
        while (i-- > 0) {
            if (!TLongObjectHashMap.isFull(values2, i) || procedure.execute(TLongObjectHashMap.unwrapNull(values2[i]))) continue;
            return false;
        }
        return true;
    }

    public boolean forEachEntry(TLongObjectProcedure<V> procedure) {
        long[] keys2 = this._set;
        Object[] values2 = this._values;
        int i = values2.length;
        while (i-- > 0) {
            if (!TLongObjectHashMap.isFull(values2, i) || procedure.execute(keys2[i], TLongObjectHashMap.unwrapNull(values2[i]))) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean retainEntries(TLongObjectProcedure<V> procedure) {
        boolean modified = false;
        long[] keys2 = this._set;
        Object[] values2 = this._values;
        this.stopCompactingOnRemove();
        try {
            int i = values2.length;
            while (i-- > 0) {
                if (!TLongObjectHashMap.isFull(values2, i) || procedure.execute(keys2[i], TLongObjectHashMap.unwrapNull(values2[i]))) continue;
                this.removeAt(i);
                modified = true;
            }
        }
        finally {
            this.startCompactingOnRemove(modified);
        }
        return modified;
    }

    public void transformValues(TObjectFunction<V, V> function) {
        Object[] values2 = this._values;
        int i = values2.length;
        while (i-- > 0) {
            if (!TLongObjectHashMap.isFull(values2, i)) continue;
            values2[i] = TLongObjectHashMap.wrapNull(function.execute(TLongObjectHashMap.unwrapNull(values2[i])));
        }
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
        stream.writeInt(this._size);
        SerializationProcedure writeProcedure = new SerializationProcedure(stream);
        if (!this.forEachEntry(writeProcedure)) {
            throw writeProcedure.exception;
        }
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        int size = stream.readInt();
        this.setUp(size);
        while (size-- > 0) {
            long key = stream.readLong();
            Object val = stream.readObject();
            this.put(key, val);
        }
    }

    @Override
    public final int computeHashCode(long val) {
        return HashFunctions.hash(val);
    }

    public String toString() {
        final StringBuilder sb = new StringBuilder();
        this.forEachEntry(new TLongObjectProcedure<V>(){

            @Override
            public boolean execute(long key, V value2) {
                if (sb.length() != 0) {
                    sb.append(',').append(' ');
                }
                sb.append(key);
                sb.append('=');
                sb.append((Object)(value2 == this ? "(this Map)" : value2));
                return true;
            }
        });
        sb.append('}');
        sb.insert(0, '{');
        return sb.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class EqProcedure<V>
    implements TLongObjectProcedure<V> {
        private final TLongObjectHashMap<V> _otherMap;

        EqProcedure(TLongObjectHashMap<V> otherMap) {
            this._otherMap = otherMap;
        }

        @Override
        public final boolean execute(long key, V value2) {
            int index = this._otherMap.index(key);
            return index >= 0 && EqProcedure.eq(value2, this._otherMap.get(key));
        }

        private static boolean eq(Object o1, Object o2) {
            return o1 == o2 || o1 != null && o1.equals(o2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class HashProcedure
    implements TLongObjectProcedure<V> {
        private int h;

        HashProcedure() {
        }

        public int getHashCode() {
            return this.h;
        }

        @Override
        public final boolean execute(long key, V value2) {
            this.h += TLongObjectHashMap.this._hashingStrategy.computeHashCode(key) ^ HashFunctions.hash(value2);
            return true;
        }
    }
}

