/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.regexp;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ReflectionUtil;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.charset.StandardCharsets;
import java.util.function.Consumer;
import org.intellij.lang.regexp.AsciiUtil;

public class UnicodeCharacterNames {
    public static void iterate(Consumer<? super String> consumer) {
        try {
            Class<?> aClass = Class.forName("java.lang.CharacterName");
            Method initNamePool = ReflectionUtil.getDeclaredMethod(aClass, "initNamePool", new Class[0]);
            if (initNamePool != null) {
                byte[] namePool = (byte[])initNamePool.invoke(null, new Object[0]);
                int[][] lookup2d = ReflectionUtil.getStaticFieldValue(aClass, int[][].class, "lookup");
                if (lookup2d == null) {
                    return;
                }
                for (int[] indexes : lookup2d) {
                    if (indexes == null) continue;
                    for (int index : indexes) {
                        if (index == 0) continue;
                        String name = new String(namePool, index >>> 8, index & 0xFF, AsciiUtil.ASCII_CHARSET);
                        consumer.accept(name);
                    }
                }
            } else {
                Method instance2 = ReflectionUtil.getDeclaredMethod(aClass, "getInstance", new Class[0]);
                Field field1 = ReflectionUtil.getDeclaredField(aClass, "strPool");
                Field field2 = ReflectionUtil.getDeclaredField(aClass, "lookup");
                if (instance2 != null && field1 != null && field2 != null) {
                    int[] lookup2;
                    Object characterName = instance2.invoke(null, new Object[0]);
                    byte[] namePool = (byte[])field1.get(characterName);
                    for (int index : lookup2 = (int[])field2.get(characterName)) {
                        if (index == 0) continue;
                        String name = new String(namePool, index >>> 8, index & 0xFF, AsciiUtil.ASCII_CHARSET);
                        consumer.accept(name);
                    }
                }
            }
        }
        catch (ClassNotFoundException | IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public static int getCodePoint(String name) {
        if (name == null) {
            return -1;
        }
        Method method2 = ReflectionUtil.getMethod(Character.class, "codePointOf", String.class);
        if (method2 != null) {
            try {
                return (Integer)method2.invoke(null, name);
            }
            catch (IllegalArgumentException e) {
                return -1;
            }
            catch (InvocationTargetException e) {
                if (e.getCause() instanceof IllegalArgumentException) {
                    return -1;
                }
                throw new RuntimeException(e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
        try {
            Class<?> aClass = Class.forName("java.lang.CharacterName");
            Method initNamePool = ReflectionUtil.getDeclaredMethod(aClass, "initNamePool", new Class[0]);
            if (initNamePool == null) {
                return -1;
            }
            byte[] namePool = (byte[])initNamePool.invoke(null, new Object[0]);
            name = StringUtil.toUpperCase(name.trim());
            byte[] key = name.getBytes(StandardCharsets.ISO_8859_1);
            int[][] lookup2 = ReflectionUtil.getField(aClass, null, int[][].class, "lookup");
            if (lookup2 == null) {
                throw new RuntimeException();
            }
            for (int i = 0; i < lookup2.length; ++i) {
                int[] indexes = lookup2[i];
                if (indexes == null) continue;
                for (int j = 0; j < indexes.length; ++j) {
                    int index = indexes[j];
                    if ((index & 0xFF) != key.length || !UnicodeCharacterNames.matches(namePool, index >>> 8, key)) continue;
                    return i << 8 | j;
                }
            }
            return UnicodeCharacterNames.getUnnamedUnicodeCharacterCodePoint(name);
        }
        catch (ClassNotFoundException | IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    private static int getUnnamedUnicodeCharacterCodePoint(String name) {
        int index = name.lastIndexOf(32);
        if (index != -1) {
            try {
                int c = Integer.parseInt(name.substring(index + 1), 16);
                if (Character.isValidCodePoint(c) && name.equals(Character.getName(c))) {
                    return c;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return -1;
    }

    private static boolean matches(byte[] bytes, int offset, byte[] key) {
        if (offset < 0 || offset + key.length > bytes.length) {
            throw new IllegalArgumentException();
        }
        for (int i = 0; i < key.length; ++i) {
            if (bytes[i + offset] == key[i]) continue;
            return false;
        }
        return true;
    }
}

