/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.regexp.ecmascript;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLiteralValue;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import org.intellij.lang.regexp.RegExpMatchResult;
import org.intellij.lang.regexp.RegExpMatcherProvider;
import org.jetbrains.annotations.NotNull;

public class EcmaScriptRegExpMatcherProvider
implements RegExpMatcherProvider {
    @Override
    @NotNull
    public RegExpMatchResult matches(String regExp, PsiFile regExpFile, PsiElement elementInHost, String sampleText, long timeoutMillis) {
        RegExpMatchResult regExpMatchResult;
        String modifiers = "";
        if (elementInHost instanceof PsiLiteralValue) {
            int slash;
            String text2 = elementInHost.getText();
            int n = slash = StringUtil.isQuotedString(text2) ? -1 : text2.lastIndexOf(47);
            if (slash > 0) {
                if (text2.indexOf(105, slash) > 0) {
                    modifiers = modifiers + 'i';
                }
                if (text2.indexOf(109, slash) > 0) {
                    modifiers = modifiers + 'm';
                }
                if (text2.indexOf(117, slash) > 0) {
                    modifiers = modifiers + 'u';
                }
            }
        }
        ScriptEngine engine = new ScriptEngineManager().getEngineByName("nashorn");
        try {
            String script = "var a = \"" + StringUtil.escapeStringCharacters(sampleText) + "\".match(/" + StringUtil.escapeChar(regExp, '/') + "/" + modifiers + ");\na !== null";
            regExpMatchResult = engine.eval(script) == Boolean.TRUE ? RegExpMatchResult.MATCHES : RegExpMatchResult.NO_MATCH;
        }
        catch (ScriptException e) {
            RegExpMatchResult regExpMatchResult2 = RegExpMatchResult.BAD_REGEXP;
            if (regExpMatchResult2 == null) {
                EcmaScriptRegExpMatcherProvider.$$$reportNull$$$0(1);
            }
            return regExpMatchResult2;
        }
        if (regExpMatchResult == null) {
            EcmaScriptRegExpMatcherProvider.$$$reportNull$$$0(0);
        }
        return regExpMatchResult;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/lang/regexp/ecmascript/EcmaScriptRegExpMatcherProvider", "matches"));
    }
}

