/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.regexp.inspection;

import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import java.util.Collection;
import org.intellij.lang.regexp.RegExpLanguageHosts;
import org.intellij.lang.regexp.RegExpTT;
import org.intellij.lang.regexp.psi.RegExpBackref;
import org.intellij.lang.regexp.psi.RegExpElementVisitor;
import org.intellij.lang.regexp.psi.RegExpGroup;
import org.jetbrains.annotations.NotNull;

public class AnonymousGroupInspection
extends LocalInspectionTool {
    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            AnonymousGroupInspection.$$$reportNull$$$0(0);
        }
        return new AnonymousGroupVisitor(holder);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "org/intellij/lang/regexp/inspection/AnonymousGroupInspection", "buildVisitor"));
    }

    private static class AnonymousGroupVisitor
    extends RegExpElementVisitor {
        private final ProblemsHolder myHolder;

        AnonymousGroupVisitor(ProblemsHolder holder) {
            this.myHolder = holder;
        }

        @Override
        public void visitRegExpGroup(RegExpGroup group) {
            if (group.getType() != RegExpGroup.Type.CAPTURING_GROUP) {
                return;
            }
            Collection<RegExpGroup.Type> types = RegExpLanguageHosts.getInstance().getSupportedNamedGroupTypes(group);
            if (types.isEmpty()) {
                return;
            }
            if (group.getNode().getLastChildNode().getElementType() != RegExpTT.GROUP_END) {
                return;
            }
            this.myHolder.registerProblem(group.getFirstChild(), "Anonymous capturing group", new LocalQuickFix[0]);
        }

        @Override
        public void visitRegExpBackref(RegExpBackref backref) {
            Collection<RegExpGroup.Type> types = RegExpLanguageHosts.getInstance().getSupportedNamedGroupTypes(backref);
            if (types.isEmpty()) {
                return;
            }
            this.myHolder.registerProblem((PsiElement)backref, "Numeric back reference", new LocalQuickFix[0]);
        }
    }
}

