/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.regexp.inspection;

import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import org.intellij.lang.regexp.psi.RegExpBranch;
import org.intellij.lang.regexp.psi.RegExpElementVisitor;
import org.intellij.lang.regexp.psi.RegExpPattern;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class EmptyAlternationBranchInspection
extends LocalInspectionTool {
    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            EmptyAlternationBranchInspection.$$$reportNull$$$0(0);
        }
        return new EmptyAlternationBranchVisitor(holder);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "org/intellij/lang/regexp/inspection/EmptyAlternationBranchInspection", "buildVisitor"));
    }

    private static class EmptyAlternationBranchFix
    implements LocalQuickFix {
        private EmptyAlternationBranchFix() {
        }

        @Override
        @Nls
        @NotNull
        public String getFamilyName() {
            return "Remove empty branch";
        }

        @Override
        public void applyFix(@NotNull Project project2, @NotNull ProblemDescriptor descriptor2) {
            PsiElement element2;
            if (project2 == null) {
                EmptyAlternationBranchFix.$$$reportNull$$$0(0);
            }
            if (descriptor2 == null) {
                EmptyAlternationBranchFix.$$$reportNull$$$0(1);
            }
            if (!((element2 = descriptor2.getPsiElement()).getParent() instanceof RegExpPattern)) {
                return;
            }
            element2.getNextSibling().delete();
            element2.delete();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "project";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "descriptor";
                    break;
                }
            }
            objectArray[1] = "org/intellij/lang/regexp/inspection/EmptyAlternationBranchInspection$EmptyAlternationBranchFix";
            objectArray[2] = "applyFix";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class EmptyAlternationBranchVisitor
    extends RegExpElementVisitor {
        private final ProblemsHolder myHolder;

        EmptyAlternationBranchVisitor(ProblemsHolder holder) {
            this.myHolder = holder;
        }

        @Override
        public void visitRegExpPattern(RegExpPattern pattern) {
            RegExpBranch[] branches = pattern.getBranches();
            if (branches.length < 2) {
                return;
            }
            boolean emptyBranchSeen = false;
            for (int i = 0; i < branches.length; ++i) {
                RegExpBranch branch = branches[i];
                if (branch.getAtoms().length > 0) continue;
                if (i == 0) {
                    emptyBranchSeen = true;
                    continue;
                }
                if (!emptyBranchSeen && i == branches.length - 1) continue;
                this.myHolder.registerProblem(branch.getPrevSibling(), "Empty branch in alternation", new EmptyAlternationBranchFix());
            }
        }
    }
}

