/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.regexp.inspection;

import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.util.PsiTreeUtil;
import org.intellij.lang.regexp.RegExpTT;
import org.intellij.lang.regexp.psi.RegExpAtom;
import org.intellij.lang.regexp.psi.RegExpClosure;
import org.intellij.lang.regexp.psi.RegExpElementVisitor;
import org.intellij.lang.regexp.psi.RegExpGroup;
import org.intellij.lang.regexp.psi.RegExpNumber;
import org.intellij.lang.regexp.psi.RegExpQuantifier;
import org.jetbrains.annotations.NotNull;

public class ReDoSInspection
extends LocalInspectionTool {
    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            ReDoSInspection.$$$reportNull$$$0(0);
        }
        return new ReDoSVisitor(holder);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "org/intellij/lang/regexp/inspection/ReDoSInspection", "buildVisitor"));
    }

    private static class ReDoSVisitor
    extends RegExpElementVisitor {
        private final ProblemsHolder myHolder;

        ReDoSVisitor(ProblemsHolder holder) {
            this.myHolder = holder;
        }

        @Override
        public void visitRegExpClosure(RegExpClosure closure) {
            if (!ReDoSVisitor.hasSuspiciousQuantifier(closure)) {
                return;
            }
            RegExpClosure parent = PsiTreeUtil.getParentOfType((PsiElement)closure, RegExpClosure.class);
            while (parent != null) {
                if (ReDoSVisitor.hasSuspiciousQuantifier(parent)) {
                    if (ReDoSVisitor.isAtomic(closure)) {
                        return;
                    }
                    this.myHolder.registerProblem((PsiElement)parent, "Potential exponential backtracking", new LocalQuickFix[0]);
                    return;
                }
                parent = PsiTreeUtil.getParentOfType((PsiElement)parent, RegExpClosure.class);
            }
        }

        private static boolean hasSuspiciousQuantifier(RegExpClosure closure) {
            RegExpQuantifier quantifier = closure.getQuantifier();
            if (!quantifier.isCounted()) {
                ASTNode token = quantifier.getToken();
                return token != null && token.getElementType() != RegExpTT.QUEST;
            }
            RegExpNumber max = quantifier.getMax();
            if (max == null) {
                return true;
            }
            Number value2 = max.getValue();
            return value2 == null || value2.doubleValue() >= 10.0;
        }

        private static boolean isAtomic(RegExpAtom element2) {
            while (element2 != null) {
                RegExpGroup group;
                RegExpClosure closure;
                if (element2 instanceof RegExpClosure ? (closure = (RegExpClosure)element2).getQuantifier().isPossessive() : element2 instanceof RegExpGroup && (group = (RegExpGroup)element2).getType() == RegExpGroup.Type.ATOMIC) {
                    return true;
                }
                element2 = (RegExpAtom)PsiTreeUtil.getParentOfType((PsiElement)element2, RegExpClosure.class, RegExpGroup.class);
            }
            return false;
        }
    }
}

