/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.regexp.inspection;

import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.util.PsiTreeUtil;
import org.intellij.lang.regexp.psi.RegExpBoundary;
import org.intellij.lang.regexp.psi.RegExpChar;
import org.intellij.lang.regexp.psi.RegExpElementVisitor;
import org.intellij.lang.regexp.psi.RegExpSetOptions;
import org.intellij.lang.regexp.psi.RegExpSimpleClass;
import org.jetbrains.annotations.NotNull;

public class UnexpectedAnchorInspection
extends LocalInspectionTool {
    @Override
    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            UnexpectedAnchorInspection.$$$reportNull$$$0(0);
        }
        return new UnexpectedAnchorVisitor(holder);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "org/intellij/lang/regexp/inspection/UnexpectedAnchorInspection", "buildVisitor"));
    }

    private static class UnexpectedAnchorVisitor
    extends RegExpElementVisitor {
        private final ProblemsHolder myHolder;

        UnexpectedAnchorVisitor(ProblemsHolder holder) {
            this.myHolder = holder;
        }

        @Override
        public void visitRegExpBoundary(RegExpBoundary boundary) {
            super.visitRegExpBoundary(boundary);
            RegExpBoundary.Type type = boundary.getType();
            switch (type) {
                case BEGIN: {
                    if (UnexpectedAnchorVisitor.hasUnexpectedSibling(boundary, false, false)) break;
                    return;
                }
                case LINE_START: {
                    if (UnexpectedAnchorVisitor.hasUnexpectedSibling(boundary, false, true)) break;
                    return;
                }
                case END: 
                case END_NO_LINE_TERM: {
                    if (UnexpectedAnchorVisitor.hasUnexpectedSibling(boundary, true, false)) break;
                    return;
                }
                case LINE_END: {
                    if (UnexpectedAnchorVisitor.hasUnexpectedSibling(boundary, true, true)) break;
                    return;
                }
                default: {
                    return;
                }
            }
            this.myHolder.registerProblem((PsiElement)boundary, "Anchor <code>#ref</code> in unexpected position", new LocalQuickFix[0]);
        }

        private static boolean hasUnexpectedSibling(PsiElement element2, boolean next, boolean line) {
            PsiElement sibling;
            PsiElement psiElement = sibling = next ? PsiTreeUtil.skipSiblingsForward(element2, PsiComment.class, PsiWhiteSpace.class, RegExpSetOptions.class) : PsiTreeUtil.skipSiblingsBackward(element2, PsiComment.class, PsiWhiteSpace.class, RegExpSetOptions.class);
            if (sibling == null) {
                return false;
            }
            if (line) {
                if (sibling instanceof RegExpChar) {
                    int value2 = ((RegExpChar)sibling).getValue();
                    return value2 != 10 && value2 != 13;
                }
                if (sibling instanceof RegExpSimpleClass) {
                    RegExpSimpleClass.Kind kind = ((RegExpSimpleClass)sibling).getKind();
                    switch (kind) {
                        case ANY: 
                        case NON_DIGIT: 
                        case NON_WORD: 
                        case SPACE: 
                        case NON_HORIZONTAL_SPACE: 
                        case NON_VERTICAL_SPACE: 
                        case NON_XML_NAME_START: 
                        case NON_XML_NAME_PART: 
                        case UNICODE_LINEBREAK: {
                            return false;
                        }
                    }
                    return true;
                }
                return sibling instanceof RegExpBoundary;
            }
            return true;
        }
    }
}

