/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.regexp.psi.impl;

import com.intellij.lang.ASTNode;
import com.intellij.psi.StringEscapesTokenTypes;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import org.intellij.lang.regexp.RegExpTT;
import org.intellij.lang.regexp.UnicodeCharacterNames;
import org.intellij.lang.regexp.psi.RegExpChar;
import org.intellij.lang.regexp.psi.RegExpElementVisitor;
import org.intellij.lang.regexp.psi.impl.RegExpElementImpl;
import org.jetbrains.annotations.NotNull;

public class RegExpCharImpl
extends RegExpElementImpl
implements RegExpChar {
    private static final TokenSet OCT_CHARS = TokenSet.create(RegExpTT.OCT_CHAR, RegExpTT.BAD_OCT_VALUE);
    private static final TokenSet HEX_CHARS = TokenSet.create(RegExpTT.HEX_CHAR, RegExpTT.BAD_HEX_VALUE);
    private static final TokenSet UNICODE_CHARS = TokenSet.create(RegExpTT.UNICODE_CHAR, StringEscapesTokenTypes.INVALID_UNICODE_ESCAPE_TOKEN);

    public RegExpCharImpl(ASTNode astNode) {
        super(astNode);
    }

    @Override
    @NotNull
    public RegExpChar.Type getType() {
        ASTNode child2 = this.getNode().getFirstChildNode();
        assert (child2 != null);
        IElementType t = child2.getElementType();
        if (OCT_CHARS.contains(t)) {
            RegExpChar.Type type = RegExpChar.Type.OCT;
            if (type == null) {
                RegExpCharImpl.$$$reportNull$$$0(0);
            }
            return type;
        }
        if (HEX_CHARS.contains(t)) {
            RegExpChar.Type type = RegExpChar.Type.HEX;
            if (type == null) {
                RegExpCharImpl.$$$reportNull$$$0(1);
            }
            return type;
        }
        if (UNICODE_CHARS.contains(t)) {
            RegExpChar.Type type = RegExpChar.Type.UNICODE;
            if (type == null) {
                RegExpCharImpl.$$$reportNull$$$0(2);
            }
            return type;
        }
        if (t == RegExpTT.NAMED_CHARACTER) {
            RegExpChar.Type type = RegExpChar.Type.NAMED;
            if (type == null) {
                RegExpCharImpl.$$$reportNull$$$0(3);
            }
            return type;
        }
        RegExpChar.Type type = RegExpChar.Type.CHAR;
        if (type == null) {
            RegExpCharImpl.$$$reportNull$$$0(4);
        }
        return type;
    }

    @Override
    public int getValue() {
        String s = this.getUnescapedText();
        if (s.equals("\\") && this.getType() == RegExpChar.Type.CHAR) {
            return 92;
        }
        return RegExpCharImpl.unescapeChar(s);
    }

    private static int unescapeChar(String s) {
        int length = s.length();
        assert (length > 0);
        int codePoint = s.codePointAt(0);
        if (codePoint != 92) {
            return codePoint;
        }
        codePoint = s.codePointAt(1);
        switch (codePoint) {
            case 110: {
                return 10;
            }
            case 114: {
                return 13;
            }
            case 116: {
                return 9;
            }
            case 97: {
                return 7;
            }
            case 101: {
                return 27;
            }
            case 102: {
                return 12;
            }
            case 98: {
                return 8;
            }
            case 99: {
                return (char)(codePoint ^ 0x40);
            }
            case 78: {
                if (length < 4 || s.charAt(2) != '{' || s.charAt(length - 1) != '}') {
                    return -1;
                }
                int value2 = UnicodeCharacterNames.getCodePoint(s.substring(3, length - 1));
                if (value2 == -1) {
                    return -1;
                }
                return value2;
            }
            case 120: {
                if (length <= 2) {
                    return -1;
                }
                if (s.charAt(2) == '{') {
                    char c = s.charAt(length - 1);
                    return c != '}' ? -1 : RegExpCharImpl.parseNumber(s, 3, 16);
                }
                if (length == 3) {
                    return RegExpCharImpl.parseNumber(s, 2, 16);
                }
                return length == 4 ? RegExpCharImpl.parseNumber(s, 2, 16) : -1;
            }
            case 117: {
                if (length <= 2) {
                    return 117;
                }
                if (s.charAt(2) == '{') {
                    char c = s.charAt(length - 1);
                    return c != '}' ? -1 : RegExpCharImpl.parseNumber(s, 3, 16);
                }
                if (length != 6) {
                    return -1;
                }
                return RegExpCharImpl.parseNumber(s, 2, 16);
            }
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: {
                return RegExpCharImpl.parseNumber(s, 1, 8);
            }
        }
        return codePoint;
    }

    private static int parseNumber(String s, int offset, int radix) {
        int digit;
        int i;
        int sum = 0;
        for (i = offset; i < s.length() && (digit = Character.digit(s.charAt(i), radix)) >= 0; ++i) {
            if ((sum = sum * radix + digit) <= 0x10FFFF) continue;
            return -1;
        }
        if (i - offset <= 0) {
            return -1;
        }
        return sum;
    }

    @Override
    public void accept(RegExpElementVisitor visitor) {
        visitor.visitRegExpChar(this);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/lang/regexp/psi/impl/RegExpCharImpl", "getType"));
    }
}

