/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.regexp.surroundWith;

import com.intellij.lang.ASTNode;
import com.intellij.lang.surroundWith.Surrounder;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import org.intellij.lang.regexp.RegExpFileType;
import org.intellij.lang.regexp.psi.RegExpAtom;
import org.intellij.lang.regexp.psi.RegExpPattern;
import org.intellij.lang.regexp.psi.impl.RegExpElementImpl;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class GroupSurrounder
implements Surrounder {
    private final String myTitle;
    private final String myGroupStart;

    GroupSurrounder(@Nls String title, String groupStart) {
        this.myTitle = title;
        this.myGroupStart = groupStart;
    }

    @Override
    public String getTemplateDescription() {
        return this.myTitle;
    }

    @Override
    public boolean isApplicable(PsiElement @NotNull [] elements2) {
        if (elements2 == null) {
            GroupSurrounder.$$$reportNull$$$0(0);
        }
        return elements2.length == 1 || PsiTreeUtil.findCommonParent(elements2) == elements2[0].getParent();
    }

    @Override
    @Nullable
    public TextRange surroundElements(@NotNull Project project2, @NotNull Editor editor, PsiElement @NotNull [] elements2) throws IncorrectOperationException {
        if (project2 == null) {
            GroupSurrounder.$$$reportNull$$$0(1);
        }
        if (editor == null) {
            GroupSurrounder.$$$reportNull$$$0(2);
        }
        if (elements2 == null) {
            GroupSurrounder.$$$reportNull$$$0(3);
        }
        assert (elements2.length == 1 || PsiTreeUtil.findCommonParent(elements2) == elements2[0].getParent());
        PsiElement e = elements2[0];
        ASTNode node = e.getNode();
        assert (node != null);
        ASTNode parent = node.getTreeParent();
        StringBuilder s = new StringBuilder();
        for (int i = 0; i < elements2.length; ++i) {
            PsiElement element2 = elements2[i];
            if (element2 instanceof RegExpElementImpl) {
                s.append(((RegExpElementImpl)element2).getUnescapedText());
            } else {
                s.append(element2.getText());
            }
            if (i <= 0) continue;
            ASTNode child2 = element2.getNode();
            assert (child2 != null);
            parent.removeChild(child2);
        }
        PsiFileFactory factory = PsiFileFactory.getInstance(project2);
        PsiFile f = factory.createFileFromText("dummy.regexp", RegExpFileType.INSTANCE, (CharSequence)this.makeReplacement(s));
        RegExpPattern pattern = PsiTreeUtil.getChildOfType(f, RegExpPattern.class);
        assert (pattern != null);
        RegExpAtom element3 = pattern.getBranches()[0].getAtoms()[0];
        if (GroupSurrounder.isInsideStringLiteral(e)) {
            Document doc = editor.getDocument();
            PsiDocumentManager.getInstance(project2).doPostponedOperationsAndUnblockDocument(doc);
            TextRange tr = e.getTextRange();
            doc.replaceString(tr.getStartOffset(), tr.getEndOffset(), StringUtil.escapeStringCharacters(element3.getText()));
            return TextRange.from(e.getTextRange().getEndOffset(), 0);
        }
        PsiElement n = e.replace(element3);
        return TextRange.from(n.getTextRange().getEndOffset(), 0);
    }

    private static boolean isInsideStringLiteral(PsiElement context) {
        while (context != null) {
            if (RegExpElementImpl.isLiteralExpression(context)) {
                return true;
            }
            context = context.getContext();
        }
        return false;
    }

    protected String makeReplacement(StringBuilder s) {
        return this.myGroupStart + s + ")";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
        }
        objectArray2[1] = "org/intellij/lang/regexp/surroundWith/GroupSurrounder";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "isApplicable";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "surroundElements";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

