/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.lang.regexp.validation;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.CommonQuickFixBundle;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import org.intellij.lang.regexp.RegExpFileType;
import org.intellij.lang.regexp.inspection.RegExpReplacementUtil;
import org.intellij.lang.regexp.psi.RegExpClosure;
import org.intellij.lang.regexp.psi.RegExpPattern;
import org.intellij.lang.regexp.psi.RegExpQuantifier;
import org.jetbrains.annotations.NotNull;

class SimplifyQuantifierAction
implements IntentionAction {
    private final RegExpQuantifier myQuantifier;
    private final String myReplacement;

    SimplifyQuantifierAction(RegExpQuantifier quantifier, String s) {
        this.myQuantifier = quantifier;
        this.myReplacement = s;
    }

    @Override
    @NotNull
    public String getText() {
        String string = this.myReplacement == null ? CommonQuickFixBundle.message("fix.remove", "{1,1}") : CommonQuickFixBundle.message("fix.replace.with.x", this.myReplacement);
        if (string == null) {
            SimplifyQuantifierAction.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Override
    @NotNull
    public String getFamilyName() {
        return "Simplify quantifier";
    }

    @Override
    public boolean isAvailable(@NotNull Project project2, Editor editor, PsiFile file2) {
        if (project2 == null) {
            SimplifyQuantifierAction.$$$reportNull$$$0(1);
        }
        return this.myQuantifier.isValid();
    }

    @Override
    public void invoke(@NotNull Project project2, Editor editor, PsiFile file2) throws IncorrectOperationException {
        if (project2 == null) {
            SimplifyQuantifierAction.$$$reportNull$$$0(2);
        }
        if (this.myReplacement == null) {
            PsiElement parent = this.myQuantifier.getParent();
            if (!(parent instanceof RegExpClosure)) {
                return;
            }
            RegExpClosure closure = (RegExpClosure)parent;
            RegExpReplacementUtil.replaceInContext(closure, closure.getAtom().getUnescapedText());
        } else {
            PsiFileFactory factory = PsiFileFactory.getInstance(project2);
            ASTNode modifier = this.myQuantifier.getModifier();
            PsiFile f = factory.createFileFromText("dummy.regexp", RegExpFileType.INSTANCE, (CharSequence)("a" + this.myReplacement + (modifier != null ? modifier.getText() : "")));
            RegExpPattern pattern = PsiTreeUtil.getChildOfType(f, RegExpPattern.class);
            assert (pattern != null);
            RegExpClosure closure = (RegExpClosure)pattern.getBranches()[0].getAtoms()[0];
            this.myQuantifier.replace(closure.getQuantifier());
        }
    }

    @Override
    public boolean startInWriteAction() {
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/intellij/lang/regexp/validation/SimplifyQuantifierAction";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getText";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "org/intellij/lang/regexp/validation/SimplifyQuantifierAction";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "invoke";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

