/*
 * Decompiled with CFR 0.152.
 */
package org.jdom.filter2;

import org.jdom.Attribute;
import org.jdom.Namespace;
import org.jdom.filter2.AbstractFilter;

public class AttributeFilter
extends AbstractFilter<Attribute> {
    private static final long serialVersionUID = 200L;
    private final String name;
    private final Namespace namespace;

    public AttributeFilter() {
        this(null, null);
    }

    public AttributeFilter(String name) {
        this(name, null);
    }

    public AttributeFilter(Namespace namespace) {
        this(null, namespace);
    }

    public AttributeFilter(String name, Namespace namespace) {
        this.name = name;
        this.namespace = namespace;
    }

    @Override
    public Attribute filter(Object content2) {
        if (content2 instanceof Attribute) {
            Attribute att = (Attribute)content2;
            if (this.name == null) {
                if (this.namespace == null) {
                    return att;
                }
                return this.namespace.equals(att.getNamespace()) ? att : null;
            }
            if (!this.name.equals(att.getName())) {
                return null;
            }
            if (this.namespace == null) {
                return att;
            }
            return this.namespace.equals(att.getNamespace()) ? att : null;
        }
        return null;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof AttributeFilter)) {
            return false;
        }
        AttributeFilter filter2 = (AttributeFilter)obj;
        if (this.name != null ? !this.name.equals(filter2.name) : filter2.name != null) {
            return false;
        }
        return !(this.namespace != null ? !this.namespace.equals(filter2.namespace) : filter2.namespace != null);
    }

    public int hashCode() {
        int result2 = this.name != null ? this.name.hashCode() : 0;
        result2 = 29 * result2 + (this.namespace != null ? this.namespace.hashCode() : 0);
        return result2;
    }
}

