/*
 * Decompiled with CFR 0.152.
 */
package org.jdom.input;

import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jdom.AttributeType;
import org.jdom.CDATA;
import org.jdom.Comment;
import org.jdom.Content;
import org.jdom.DefaultJDOMFactory;
import org.jdom.DocType;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.EntityRef;
import org.jdom.JDOMException;
import org.jdom.JDOMFactory;
import org.jdom.Namespace;
import org.jdom.ProcessingInstruction;
import org.jdom.Text;
import org.jdom.Verifier;
import org.jdom.input.stax.DTDParser;
import org.jdom.input.stax.StAXFilter;

public class StAXStreamBuilder {
    private JDOMFactory builderfactory = new DefaultJDOMFactory();

    private static final Document process(JDOMFactory factory, XMLStreamReader stream) throws JDOMException {
        try {
            int state = stream.getEventType();
            if (7 != state) {
                throw new JDOMException("JDOM requires that XMLStreamReaders are at their beginning when being processed.");
            }
            Document document = factory.document(null);
            while (state != 8) {
                switch (state) {
                    case 7: {
                        document.setBaseURI(stream.getLocation().getSystemId());
                        document.setProperty("ENCODING_SCHEME", stream.getCharacterEncodingScheme());
                        document.setProperty("STANDALONE", String.valueOf(stream.isStandalone()));
                        document.setProperty("ENCODING", stream.getEncoding());
                        break;
                    }
                    case 11: {
                        document.setDocType(DTDParser.parse(stream.getText(), factory));
                        break;
                    }
                    case 1: {
                        document.setRootElement(StAXStreamBuilder.processElementFragment(factory, stream));
                        break;
                    }
                    case 2: {
                        throw new JDOMException("Unexpected XMLStream event at Document level: END_ELEMENT");
                    }
                    case 9: {
                        throw new JDOMException("Unexpected XMLStream event at Document level: ENTITY_REFERENCE");
                    }
                    case 12: {
                        throw new JDOMException("Unexpected XMLStream event at Document level: CDATA");
                    }
                    case 6: {
                        document.addContent(factory.text(stream.getText()));
                        break;
                    }
                    case 4: {
                        String badtxt = stream.getText();
                        if (Verifier.isAllXMLWhitespace(badtxt)) break;
                        throw new JDOMException("Unexpected XMLStream event at Document level: CHARACTERS (" + badtxt + ")");
                    }
                    case 5: {
                        document.addContent(factory.comment(stream.getText()));
                        break;
                    }
                    case 3: {
                        document.addContent(factory.processingInstruction(stream.getPITarget(), stream.getPIData()));
                        break;
                    }
                    default: {
                        throw new JDOMException("Unexpected XMLStream event " + state);
                    }
                }
                if (stream.hasNext()) {
                    state = stream.next();
                    continue;
                }
                throw new JDOMException("Unexpected end-of-XMLStreamReader");
            }
            return document;
        }
        catch (XMLStreamException xse) {
            throw new JDOMException("Unable to process XMLStream. See Cause.", xse);
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private List<Content> processFragments(JDOMFactory factory, XMLStreamReader stream, StAXFilter filter) throws JDOMException {
        state = stream.getEventType();
        if (7 != state) {
            throw new JDOMException("JDOM requires that XMLStreamReaders are at their beginning when being processed.");
        }
        ret = new ArrayList<Content>();
        depth = 0;
        text = null;
lbl7:
        // 8 sources

        try {
            block14: while (stream.hasNext() && (state = stream.next()) != 8) {
                switch (state) {
                    case 7: {
                        throw new JDOMException("Illegal state for XMLStreamReader. Cannot get XML Fragment for state START_DOCUMENT");
                    }
                    case 8: {
                        throw new JDOMException("Illegal state for XMLStreamReader. Cannot get XML Fragment for state END_DOCUMENT");
                    }
                    case 2: {
                        throw new JDOMException("Illegal state for XMLStreamReader. Cannot get XML Fragment for state END_ELEMENT");
                    }
                    case 1: {
                        qn = stream.getName();
                        if (!filter.includeElement(depth, qn.getLocalPart(), Namespace.getNamespace(qn.getPrefix(), qn.getNamespaceURI()))) ** GOTO lbl22
                        ret.add(StAXStreamBuilder.processPrunableElement(factory, stream, depth, filter));
                        ** GOTO lbl7
lbl22:
                        // 1 sources

                        back = depth++;
                        while (depth > back && stream.hasNext()) {
                            state = stream.next();
                            if (state == 1) {
                                ++depth;
                                continue;
                            }
                            if (state != 2) continue;
                            --depth;
                        }
                        continue block14;
                    }
                    case 11: {
                        if (!filter.includeDocType()) continue block14;
                        ret.add(DTDParser.parse(stream.getText(), factory));
                        ** GOTO lbl7
                    }
                    case 12: {
                        text = filter.includeCDATA(depth, stream.getText());
                        if (text == null) continue block14;
                        ret.add(factory.cdata(text));
                        ** GOTO lbl7
                    }
                    case 4: 
                    case 6: {
                        text = filter.includeText(depth, stream.getText());
                        if (text == null) continue block14;
                        ret.add(factory.text(text));
                        ** GOTO lbl7
                    }
                    case 5: {
                        text = filter.includeComment(depth, stream.getText());
                        if (text == null) continue block14;
                        ret.add(factory.comment(text));
                        ** GOTO lbl7
                    }
                    case 9: {
                        if (!filter.includeEntityRef(depth, stream.getLocalName())) continue block14;
                        ret.add(factory.entityRef(stream.getLocalName()));
                        ** GOTO lbl7
                    }
                    case 3: {
                        if (!filter.includeProcessingInstruction(depth, stream.getPITarget())) continue block14;
                        ret.add(factory.processingInstruction(stream.getPITarget(), stream.getPIData()));
                        ** GOTO lbl7
                    }
                }
                throw new JDOMException("Unexpected XMLStream event " + stream.getEventType());
            }
            return ret;
        }
        catch (XMLStreamException e) {
            throw new JDOMException("Unable to process fragments from XMLStreamReader.", e);
        }
    }

    private static final Element processPrunableElement(JDOMFactory factory, XMLStreamReader reader, int topdepth, StAXFilter filter2) throws XMLStreamException, JDOMException {
        Element fragment;
        if (1 != reader.getEventType()) {
            throw new JDOMException("JDOM requires that the XMLStreamReader is at the START_ELEMENT state when retrieving an Element Fragment.");
        }
        Element current2 = fragment = StAXStreamBuilder.processElement(factory, reader);
        int depth = topdepth + 1;
        String text2 = null;
        block9: while (depth > topdepth && reader.hasNext()) {
            switch (reader.next()) {
                case 1: {
                    QName qn = reader.getName();
                    if (!filter2.pruneElement(depth, qn.getLocalPart(), Namespace.getNamespace(qn.getPrefix(), qn.getNamespaceURI()))) {
                        Element tmp = StAXStreamBuilder.processElement(factory, reader);
                        current2.addContent(tmp);
                        current2 = tmp;
                        ++depth;
                        break;
                    }
                    int edepth = depth++;
                    int state = 0;
                    while (depth > edepth && reader.hasNext() && (state = reader.next()) != 8) {
                        if (state == 1) {
                            ++depth;
                            continue;
                        }
                        if (state != 2) continue;
                        --depth;
                    }
                    continue block9;
                }
                case 2: {
                    current2 = current2.getParentElement();
                    --depth;
                    break;
                }
                case 12: {
                    text2 = filter2.pruneCDATA(depth, reader.getText());
                    if (text2 == null) continue block9;
                    current2.addContent(factory.cdata(text2));
                    break;
                }
                case 4: 
                case 6: {
                    text2 = filter2.pruneText(depth, reader.getText());
                    if (text2 == null) continue block9;
                    current2.addContent(factory.text(text2));
                    break;
                }
                case 5: {
                    text2 = filter2.pruneComment(depth, reader.getText());
                    if (text2 == null) continue block9;
                    current2.addContent(factory.comment(text2));
                    break;
                }
                case 9: {
                    if (filter2.pruneEntityRef(depth, reader.getLocalName())) continue block9;
                    current2.addContent(factory.entityRef(reader.getLocalName()));
                    break;
                }
                case 3: {
                    if (filter2.pruneProcessingInstruction(depth, reader.getPITarget())) continue block9;
                    current2.addContent(factory.processingInstruction(reader.getPITarget(), reader.getPIData()));
                    break;
                }
                default: {
                    throw new JDOMException("Unexpected XMLStream event " + reader.getEventType());
                }
            }
        }
        return fragment;
    }

    private static final Content processFragment(JDOMFactory factory, XMLStreamReader stream) throws JDOMException {
        try {
            switch (stream.getEventType()) {
                case 7: {
                    throw new JDOMException("Illegal state for XMLStreamReader. Cannot get XML Fragment for state START_DOCUMENT");
                }
                case 8: {
                    throw new JDOMException("Illegal state for XMLStreamReader. Cannot get XML Fragment for state END_DOCUMENT");
                }
                case 2: {
                    throw new JDOMException("Illegal state for XMLStreamReader. Cannot get XML Fragment for state END_ELEMENT");
                }
                case 1: {
                    Element emt = StAXStreamBuilder.processElementFragment(factory, stream);
                    stream.next();
                    return emt;
                }
                case 11: {
                    DocType dt = DTDParser.parse(stream.getText(), factory);
                    stream.next();
                    return dt;
                }
                case 12: {
                    CDATA cd = factory.cdata(stream.getText());
                    stream.next();
                    return cd;
                }
                case 4: 
                case 6: {
                    Text txt = factory.text(stream.getText());
                    stream.next();
                    return txt;
                }
                case 5: {
                    Comment comment = factory.comment(stream.getText());
                    stream.next();
                    return comment;
                }
                case 9: {
                    EntityRef er = factory.entityRef(stream.getLocalName());
                    stream.next();
                    return er;
                }
                case 3: {
                    ProcessingInstruction pi = factory.processingInstruction(stream.getPITarget(), stream.getPIData());
                    stream.next();
                    return pi;
                }
            }
            throw new JDOMException("Unexpected XMLStream event " + stream.getEventType());
        }
        catch (XMLStreamException xse) {
            throw new JDOMException("Unable to process XMLStream. See Cause.", xse);
        }
    }

    private static final Element processElementFragment(JDOMFactory factory, XMLStreamReader reader) throws XMLStreamException, JDOMException {
        Element fragment;
        if (1 != reader.getEventType()) {
            throw new JDOMException("JDOM requires that the XMLStreamReader is at the START_ELEMENT state when retrieving an Element Fragment.");
        }
        Element current2 = fragment = StAXStreamBuilder.processElement(factory, reader);
        int depth = 1;
        block9: while (depth > 0 && reader.hasNext()) {
            switch (reader.next()) {
                case 1: {
                    Element tmp = StAXStreamBuilder.processElement(factory, reader);
                    current2.addContent(tmp);
                    current2 = tmp;
                    ++depth;
                    continue block9;
                }
                case 2: {
                    current2 = current2.getParentElement();
                    --depth;
                    continue block9;
                }
                case 12: {
                    current2.addContent(factory.cdata(reader.getText()));
                    continue block9;
                }
                case 4: 
                case 6: {
                    current2.addContent(factory.text(reader.getText()));
                    continue block9;
                }
                case 5: {
                    current2.addContent(factory.comment(reader.getText()));
                    continue block9;
                }
                case 9: {
                    current2.addContent(factory.entityRef(reader.getLocalName()));
                    continue block9;
                }
                case 3: {
                    current2.addContent(factory.processingInstruction(reader.getPITarget(), reader.getPIData()));
                    continue block9;
                }
            }
            throw new JDOMException("Unexpected XMLStream event " + reader.getEventType());
        }
        return fragment;
    }

    private static final Element processElement(JDOMFactory factory, XMLStreamReader reader) {
        int i;
        Element element2 = factory.element(reader.getLocalName(), Namespace.getNamespace(reader.getPrefix(), reader.getNamespaceURI()));
        int len = reader.getAttributeCount();
        for (i = 0; i < len; ++i) {
            factory.setAttribute(element2, factory.attribute(reader.getAttributeLocalName(i), reader.getAttributeValue(i), AttributeType.getAttributeType(reader.getAttributeType(i)), Namespace.getNamespace(reader.getAttributePrefix(i), reader.getAttributeNamespace(i))));
        }
        len = reader.getNamespaceCount();
        for (i = 0; i < len; ++i) {
            element2.addNamespaceDeclaration(Namespace.getNamespace(reader.getNamespacePrefix(i), reader.getNamespaceURI(i)));
        }
        return element2;
    }

    public JDOMFactory getFactory() {
        return this.builderfactory;
    }

    public void setFactory(JDOMFactory factory) {
        this.builderfactory = factory;
    }

    public Document build(XMLStreamReader reader) throws JDOMException {
        return StAXStreamBuilder.process(this.builderfactory, reader);
    }

    public List<Content> buildFragments(XMLStreamReader reader, StAXFilter filter2) throws JDOMException {
        return this.processFragments(this.builderfactory, reader, filter2);
    }

    public Content fragment(XMLStreamReader reader) throws JDOMException {
        return StAXStreamBuilder.processFragment(this.builderfactory, reader);
    }
}

