/*
 * Decompiled with CFR 0.152.
 */
package org.jdom.output;

import java.util.List;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.util.XMLEventConsumer;
import org.jdom.CDATA;
import org.jdom.Comment;
import org.jdom.Content;
import org.jdom.DocType;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.EntityRef;
import org.jdom.ProcessingInstruction;
import org.jdom.Text;
import org.jdom.output.Format;
import org.jdom.output.support.AbstractStAXEventProcessor;
import org.jdom.output.support.StAXEventProcessor;

public final class StAXEventOutputter
implements Cloneable {
    private static final DefaultStAXEventProcessor DEFAULTPROCESSOR = new DefaultStAXEventProcessor();
    private static final XMLEventFactory DEFAULTEVENTFACTORY = XMLEventFactory.newInstance();
    private Format myFormat = null;
    private StAXEventProcessor myProcessor = null;
    private XMLEventFactory myEventFactory = null;

    public StAXEventOutputter(Format format, StAXEventProcessor processor2, XMLEventFactory eventfactory) {
        this.myFormat = format == null ? Format.getRawFormat() : format.clone();
        this.myProcessor = processor2 == null ? DEFAULTPROCESSOR : processor2;
        this.myEventFactory = eventfactory == null ? DEFAULTEVENTFACTORY : eventfactory;
    }

    public StAXEventOutputter() {
        this(null, null, null);
    }

    public StAXEventOutputter(Format format) {
        this(format, null, null);
    }

    public StAXEventOutputter(StAXEventProcessor processor2) {
        this(null, processor2, null);
    }

    public StAXEventOutputter(XMLEventFactory eventfactory) {
        this(null, null, eventfactory);
    }

    public void setFormat(Format newFormat) {
        this.myFormat = newFormat.clone();
    }

    public Format getFormat() {
        return this.myFormat;
    }

    public StAXEventProcessor getStAXStream() {
        return this.myProcessor;
    }

    public void setStAXEventProcessor(StAXEventProcessor processor2) {
        this.myProcessor = processor2;
    }

    public XMLEventFactory getEventFactory() {
        return this.myEventFactory;
    }

    public void setEventFactory(XMLEventFactory myEventFactory) {
        this.myEventFactory = myEventFactory;
    }

    public final void output(Document doc, XMLEventConsumer out) throws XMLStreamException {
        this.myProcessor.process(out, this.myFormat, this.myEventFactory, doc);
    }

    public final void output(DocType doctype, XMLEventConsumer out) throws XMLStreamException {
        this.myProcessor.process(out, this.myFormat, this.myEventFactory, doctype);
    }

    public final void output(Element element2, XMLEventConsumer out) throws XMLStreamException {
        this.myProcessor.process(out, this.myFormat, this.myEventFactory, element2);
    }

    public final void outputElementContent(Element element2, XMLEventConsumer out) throws XMLStreamException {
        this.myProcessor.process(out, this.myFormat, this.myEventFactory, element2.getContent());
    }

    public final void output(List<? extends Content> list2, XMLEventConsumer out) throws XMLStreamException {
        this.myProcessor.process(out, this.myFormat, this.myEventFactory, list2);
    }

    public final void output(CDATA cdata, XMLEventConsumer out) throws XMLStreamException {
        this.myProcessor.process(out, this.myFormat, this.myEventFactory, cdata);
    }

    public final void output(Text text2, XMLEventConsumer out) throws XMLStreamException {
        this.myProcessor.process(out, this.myFormat, this.myEventFactory, text2);
    }

    public final void output(Comment comment, XMLEventConsumer out) throws XMLStreamException {
        this.myProcessor.process(out, this.myFormat, this.myEventFactory, comment);
    }

    public final void output(ProcessingInstruction pi, XMLEventConsumer out) throws XMLStreamException {
        this.myProcessor.process(out, this.myFormat, this.myEventFactory, pi);
    }

    public final void output(EntityRef entity, XMLEventConsumer out) throws XMLStreamException {
        this.myProcessor.process(out, this.myFormat, this.myEventFactory, entity);
    }

    public StAXEventOutputter clone() {
        try {
            return (StAXEventOutputter)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e.toString());
        }
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("StAXStreamOutputter[omitDeclaration = ");
        buffer.append(this.myFormat.omitDeclaration);
        buffer.append(", ");
        buffer.append("encoding = ");
        buffer.append(this.myFormat.encoding);
        buffer.append(", ");
        buffer.append("omitEncoding = ");
        buffer.append(this.myFormat.omitEncoding);
        buffer.append(", ");
        buffer.append("indent = '");
        buffer.append(this.myFormat.indent);
        buffer.append("'");
        buffer.append(", ");
        buffer.append("expandEmptyElements = ");
        buffer.append(this.myFormat.expandEmptyElements);
        buffer.append(", ");
        buffer.append("lineSeparator = '");
        block5: for (char ch : this.myFormat.lineSeparator.toCharArray()) {
            switch (ch) {
                case '\r': {
                    buffer.append("\\r");
                    continue block5;
                }
                case '\n': {
                    buffer.append("\\n");
                    continue block5;
                }
                case '\t': {
                    buffer.append("\\t");
                    continue block5;
                }
                default: {
                    buffer.append("[" + ch + "]");
                }
            }
        }
        buffer.append("', ");
        buffer.append("textMode = ");
        buffer.append((Object)((Object)this.myFormat.mode) + "]");
        return buffer.toString();
    }

    private static final class DefaultStAXEventProcessor
    extends AbstractStAXEventProcessor {
        private DefaultStAXEventProcessor() {
        }
    }
}

