/*
 * Decompiled with CFR 0.152.
 */
package org.jdom.output;

import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.List;
import org.jdom.CDATA;
import org.jdom.Comment;
import org.jdom.Content;
import org.jdom.DocType;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.EntityRef;
import org.jdom.ProcessingInstruction;
import org.jdom.Text;
import org.jdom.output.Format;
import org.jdom.output.support.AbstractXMLOutputProcessor;
import org.jdom.output.support.FormatStack;
import org.jdom.output.support.XMLOutputProcessor;

public final class XMLOutputter2
implements Cloneable {
    private static final DefaultXMLProcessor DEFAULTPROCESSOR = new DefaultXMLProcessor();
    private Format myFormat = null;
    private XMLOutputProcessor myProcessor = null;

    private static final Writer makeWriter(OutputStream out, Format format) throws UnsupportedEncodingException {
        return new BufferedWriter(new OutputStreamWriter((OutputStream)new BufferedOutputStream(out), format.getEncoding()));
    }

    public XMLOutputter2(Format format, XMLOutputProcessor processor2) {
        this.myFormat = format == null ? Format.getRawFormat() : format.clone();
        this.myProcessor = processor2 == null ? DEFAULTPROCESSOR : processor2;
    }

    public XMLOutputter2() {
        this(null, null);
    }

    public XMLOutputter2(XMLOutputter2 that) {
        this(that.myFormat, null);
    }

    public XMLOutputter2(Format format) {
        this(format, null);
    }

    public XMLOutputter2(XMLOutputProcessor processor2) {
        this(null, processor2);
    }

    public void setFormat(Format newFormat) {
        this.myFormat = newFormat.clone();
    }

    public Format getFormat() {
        return this.myFormat;
    }

    public XMLOutputProcessor getXMLOutputProcessor() {
        return this.myProcessor;
    }

    public void setXMLOutputProcessor(XMLOutputProcessor processor2) {
        this.myProcessor = processor2;
    }

    public final void output(Document doc, OutputStream out) throws IOException {
        this.output(doc, XMLOutputter2.makeWriter(out, this.myFormat));
    }

    public final void output(DocType doctype, OutputStream out) throws IOException {
        this.output(doctype, XMLOutputter2.makeWriter(out, this.myFormat));
    }

    public final void output(Element element2, OutputStream out) throws IOException {
        this.output(element2, XMLOutputter2.makeWriter(out, this.myFormat));
    }

    public final void outputElementContent(Element element2, OutputStream out) throws IOException {
        this.outputElementContent(element2, XMLOutputter2.makeWriter(out, this.myFormat));
    }

    public final void output(List<? extends Content> list2, OutputStream out) throws IOException {
        this.output(list2, XMLOutputter2.makeWriter(out, this.myFormat));
    }

    public final void output(CDATA cdata, OutputStream out) throws IOException {
        this.output(cdata, XMLOutputter2.makeWriter(out, this.myFormat));
    }

    public final void output(Text text2, OutputStream out) throws IOException {
        this.output(text2, XMLOutputter2.makeWriter(out, this.myFormat));
    }

    public final void output(Comment comment, OutputStream out) throws IOException {
        this.output(comment, XMLOutputter2.makeWriter(out, this.myFormat));
    }

    public final void output(ProcessingInstruction pi, OutputStream out) throws IOException {
        this.output(pi, XMLOutputter2.makeWriter(out, this.myFormat));
    }

    public void output(EntityRef entity, OutputStream out) throws IOException {
        this.output(entity, XMLOutputter2.makeWriter(out, this.myFormat));
    }

    public final String outputString(Document doc) {
        StringWriter out = new StringWriter();
        try {
            this.output(doc, (Writer)out);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return out.toString();
    }

    public final String outputString(DocType doctype) {
        StringWriter out = new StringWriter();
        try {
            this.output(doctype, (Writer)out);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return out.toString();
    }

    public final String outputString(Element element2) {
        StringWriter out = new StringWriter();
        try {
            this.output(element2, (Writer)out);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return out.toString();
    }

    public final String outputString(List<? extends Content> list2) {
        StringWriter out = new StringWriter();
        try {
            this.output(list2, (Writer)out);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return out.toString();
    }

    public final String outputString(CDATA cdata) {
        StringWriter out = new StringWriter();
        try {
            this.output(cdata, (Writer)out);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return out.toString();
    }

    public final String outputString(Text text2) {
        StringWriter out = new StringWriter();
        try {
            this.output(text2, (Writer)out);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return out.toString();
    }

    public final String outputString(Comment comment) {
        StringWriter out = new StringWriter();
        try {
            this.output(comment, (Writer)out);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return out.toString();
    }

    public final String outputString(ProcessingInstruction pi) {
        StringWriter out = new StringWriter();
        try {
            this.output(pi, (Writer)out);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return out.toString();
    }

    public final String outputString(EntityRef entity) {
        StringWriter out = new StringWriter();
        try {
            this.output(entity, (Writer)out);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return out.toString();
    }

    public final String outputElementContentString(Element element2) {
        StringWriter out = new StringWriter();
        try {
            this.outputElementContent(element2, out);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return out.toString();
    }

    public final void output(Document doc, Writer out) throws IOException {
        this.myProcessor.process(out, this.myFormat, doc);
        out.flush();
    }

    public final void output(DocType doctype, Writer out) throws IOException {
        this.myProcessor.process(out, this.myFormat, doctype);
        out.flush();
    }

    public final void output(Element element2, Writer out) throws IOException {
        this.myProcessor.process(out, this.myFormat, element2);
        out.flush();
    }

    public final void outputElementContent(Element element2, Writer out) throws IOException {
        this.myProcessor.process(out, this.myFormat, element2.getContent());
        out.flush();
    }

    public final void output(List<? extends Content> list2, Writer out) throws IOException {
        this.myProcessor.process(out, this.myFormat, list2);
        out.flush();
    }

    public final void output(CDATA cdata, Writer out) throws IOException {
        this.myProcessor.process(out, this.myFormat, cdata);
        out.flush();
    }

    public final void output(Text text2, Writer out) throws IOException {
        this.myProcessor.process(out, this.myFormat, text2);
        out.flush();
    }

    public final void output(Comment comment, Writer out) throws IOException {
        this.myProcessor.process(out, this.myFormat, comment);
        out.flush();
    }

    public final void output(ProcessingInstruction pi, Writer out) throws IOException {
        this.myProcessor.process(out, this.myFormat, pi);
        out.flush();
    }

    public final void output(EntityRef entity, Writer out) throws IOException {
        this.myProcessor.process(out, this.myFormat, entity);
        out.flush();
    }

    public String escapeAttributeEntities(String str) {
        return DEFAULTPROCESSOR.escapeAttributeEntities(str, this.myFormat);
    }

    public String escapeElementEntities(String str) {
        return DEFAULTPROCESSOR.escapeElementEntities(str, this.myFormat);
    }

    public XMLOutputter2 clone() {
        try {
            return (XMLOutputter2)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e.toString());
        }
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("XMLOutputter[omitDeclaration = ");
        buffer.append(this.myFormat.omitDeclaration);
        buffer.append(", ");
        buffer.append("encoding = ");
        buffer.append(this.myFormat.encoding);
        buffer.append(", ");
        buffer.append("omitEncoding = ");
        buffer.append(this.myFormat.omitEncoding);
        buffer.append(", ");
        buffer.append("indent = '");
        buffer.append(this.myFormat.indent);
        buffer.append("'");
        buffer.append(", ");
        buffer.append("expandEmptyElements = ");
        buffer.append(this.myFormat.expandEmptyElements);
        buffer.append(", ");
        buffer.append("lineSeparator = '");
        block5: for (char ch : this.myFormat.lineSeparator.toCharArray()) {
            switch (ch) {
                case '\r': {
                    buffer.append("\\r");
                    continue block5;
                }
                case '\n': {
                    buffer.append("\\n");
                    continue block5;
                }
                case '\t': {
                    buffer.append("\\t");
                    continue block5;
                }
                default: {
                    buffer.append("[" + ch + "]");
                }
            }
        }
        buffer.append("', ");
        buffer.append("textMode = ");
        buffer.append((Object)((Object)this.myFormat.mode) + "]");
        return buffer.toString();
    }

    private static final class DefaultXMLProcessor
    extends AbstractXMLOutputProcessor {
        private DefaultXMLProcessor() {
        }

        public String escapeAttributeEntities(String str, Format format) {
            StringWriter sw = new StringWriter();
            try {
                super.attributeEscapedEntitiesFilter(sw, new FormatStack(format), str);
            }
            catch (IOException e) {
                // empty catch block
            }
            return sw.toString();
        }

        public final String escapeElementEntities(String str, Format format) {
            return Format.escapeText(format.getEscapeStrategy(), format.getLineSeparator(), str);
        }
    }
}

