/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.builtInWebServer;

import com.intellij.execution.process.OSProcessHandler;
import com.intellij.openapi.project.Project;
import com.intellij.util.Consumer;
import com.intellij.util.io.ConnectToChannelResult;
import com.intellij.util.io.NettyKt;
import com.intellij.util.net.NetKt;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.InetSocketAddress;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.builtInWebServer.NetService;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;
import org.jetbrains.ide.BuiltInServerManager;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000bH\u0014J\b\u0010\u0011\u001a\u00020\u000fH\u0014J\u001e\u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0005\u001a\u00020\u00062\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014H$J\u000e\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u000b0\u0017H\u0004J4\u0010\u0018\u001a\u00020\u000f2\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001a2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u001c\u001a\u00020\u001b2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014H\u0004J\u001c\u0010\u001d\u001a\u00020\u000f2\u0006\u0010\u001e\u001a\u00020\u001f2\n\u0010\u0019\u001a\u0006\u0012\u0002\b\u00030\u001aH\u0002R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006 "}, d2={"Lorg/jetbrains/builtInWebServer/SingleConnectionNetService;", "Lorg/jetbrains/builtInWebServer/NetService;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "bootstrap", "Lio/netty/bootstrap/Bootstrap;", "port", "", "processChannel", "Ljava/util/concurrent/atomic/AtomicReference;", "Lio/netty/channel/Channel;", "getProcessChannel", "()Ljava/util/concurrent/atomic/AtomicReference;", "addCloseListener", "", "it", "closeProcessConnections", "configureBootstrap", "errorOutputConsumer", "Lcom/intellij/util/Consumer;", "", "connectAgain", "Lorg/jetbrains/concurrency/Promise;", "connectToProcess", "promise", "Lorg/jetbrains/concurrency/AsyncPromise;", "Lcom/intellij/execution/process/OSProcessHandler;", "processHandler", "handleErrors", "connectResult", "Lcom/intellij/util/io/ConnectToChannelResult;", "intellij.platform.builtInServer.impl"})
public abstract class SingleConnectionNetService
extends NetService {
    @NotNull
    private final AtomicReference<Channel> processChannel;
    private volatile int port;
    private volatile Bootstrap bootstrap;

    @NotNull
    protected final AtomicReference<Channel> getProcessChannel() {
        return this.processChannel;
    }

    protected abstract void configureBootstrap(@NotNull Bootstrap var1, @NotNull Consumer<String> var2);

    @Override
    protected final void connectToProcess(@NotNull AsyncPromise<OSProcessHandler> promise2, int port, @NotNull OSProcessHandler processHandler2, @NotNull Consumer<String> errorOutputConsumer) {
        Intrinsics.checkParameterIsNotNull(promise2, (String)"promise");
        Intrinsics.checkParameterIsNotNull((Object)processHandler2, (String)"processHandler");
        Intrinsics.checkParameterIsNotNull(errorOutputConsumer, (String)"errorOutputConsumer");
        Bootstrap bootstrap = BuiltInServerManager.Companion.getInstance().createClientBootstrap();
        this.configureBootstrap(bootstrap, errorOutputConsumer);
        this.bootstrap = bootstrap;
        this.port = port;
        ConnectToChannelResult connectResult = NettyKt.connectRetrying$default((Bootstrap)bootstrap, (InetSocketAddress)NetKt.loopbackSocketAddress((int)port), (int)0, null, (int)6, null);
        Channel channel = connectResult.getChannel();
        if (channel != null) {
            Channel channel2 = channel;
            boolean bl = false;
            boolean bl2 = false;
            Channel it = channel2;
            boolean bl3 = false;
            AsyncPromise<OSProcessHandler> $this$catchError$iv = promise2;
            boolean $i$f$catchError = false;
            try {
                boolean bl4 = false;
                this.processChannel.set(it);
                this.addCloseListener(it);
                promise2.setResult((Object)processHandler2);
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable e$iv) {
                $this$catchError$iv.setError(e$iv);
                Object var15_16 = null;
            }
        }
        this.handleErrors(connectResult, promise2);
    }

    @NotNull
    protected final Promise<Channel> connectAgain() {
        Channel channel = this.processChannel.get();
        if (channel != null) {
            return Promises.resolvedPromise((Object)channel);
        }
        AsyncPromise promise2 = new AsyncPromise();
        Bootstrap bootstrap = this.bootstrap;
        if (bootstrap == null) {
            Intrinsics.throwNpe();
        }
        ConnectToChannelResult connectResult = NettyKt.connectRetrying$default((Bootstrap)bootstrap, (InetSocketAddress)NetKt.loopbackSocketAddress((int)this.port), (int)0, null, (int)6, null);
        Channel channel2 = connectResult.getChannel();
        if (channel2 != null) {
            Channel channel3 = channel2;
            boolean bl = false;
            boolean bl2 = false;
            Channel it = channel3;
            boolean bl3 = false;
            AsyncPromise $this$catchError$iv = promise2;
            boolean $i$f$catchError = false;
            try {
                boolean bl4 = false;
                this.processChannel.set(it);
                this.addCloseListener(it);
                promise2.setResult((Object)it);
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable e$iv) {
                $this$catchError$iv.setError(e$iv);
                Object var12_13 = null;
            }
        }
        this.handleErrors(connectResult, promise2);
        return (Promise)promise2;
    }

    private final void handleErrors(ConnectToChannelResult connectResult, AsyncPromise<?> promise2) {
        connectResult.handleError((java.util.function.Consumer)new java.util.function.Consumer<String>(promise2){
            final /* synthetic */ AsyncPromise $promise;

            public final void accept(@NotNull String it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                this.$promise.setError(it);
            }
            {
                this.$promise = asyncPromise;
            }
        }).handleThrowable((java.util.function.Consumer)new java.util.function.Consumer<Throwable>(promise2){
            final /* synthetic */ AsyncPromise $promise;

            public final void accept(@NotNull Throwable it) {
                Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
                this.$promise.setError(it);
            }
            {
                this.$promise = asyncPromise;
            }
        });
    }

    protected void addCloseListener(@NotNull Channel it) {
        Intrinsics.checkParameterIsNotNull((Object)it, (String)"it");
        ChannelFuture channelFuture = it.closeFuture();
        Intrinsics.checkExpressionValueIsNotNull((Object)channelFuture, (String)"it.closeFuture()");
        ChannelFuture $this$addChannelListener$iv = channelFuture;
        boolean $i$f$addChannelListener = false;
        $this$addChannelListener$iv.addListener((GenericFutureListener)new GenericFutureListener<ChannelFuture>(this){
            final /* synthetic */ SingleConnectionNetService this$0;
            {
                this.this$0 = singleConnectionNetService;
            }

            public final void operationComplete(ChannelFuture it) {
                ChannelFuture channelFuture = it;
                Intrinsics.checkExpressionValueIsNotNull((Object)channelFuture, (String)"it");
                ChannelFuture it2 = channelFuture;
                boolean bl = false;
                this.this$0.getProcessChannel().compareAndSet(it2.channel(), null);
            }
        });
    }

    @Override
    protected void closeProcessConnections() {
        block0: {
            Channel channel = this.processChannel.getAndSet(null);
            if (channel == null) break block0;
            NettyKt.closeAndShutdownEventLoop((Channel)channel);
        }
    }

    public SingleConnectionNetService(@NotNull Project project2) {
        Intrinsics.checkParameterIsNotNull((Object)project2, (String)"project");
        super(project2, null, 2, null);
        this.processChannel = new AtomicReference();
        this.port = -1;
    }
}

