/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.debugger;

import com.intellij.xdebugger.frame.XCompositeNode;
import com.intellij.xdebugger.frame.XValueChildrenList;
import com.intellij.xdebugger.frame.XValueGroup;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function4;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.debugger.LazyVariablesGroup;
import org.jetbrains.debugger.VariableContext;
import org.jetbrains.debugger.values.ObjectValue;
import org.jetbrains.debugger.values.ValueType;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u0000X\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0015\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u00a5\u0001\u0010\u0000\u001a\u00020\u0001\"\u0004\b\u0000\u0010\u00022\u0006\u0010\u0003\u001a\u0002H\u00022`\u0010\u0004\u001a\\\u0012\u0013\u0012\u0011H\u0002\u00a2\u0006\f\b\u0006\u0012\b\b\u0007\u0012\u0004\b\b(\u0003\u0012\u0013\u0012\u00110\b\u00a2\u0006\f\b\u0006\u0012\b\b\u0007\u0012\u0004\b\b(\t\u0012\u0013\u0012\u00110\b\u00a2\u0006\f\b\u0006\u0012\b\b\u0007\u0012\u0004\b\b(\n\u0012\u0013\u0012\u00110\u000b\u00a2\u0006\f\b\u0006\u0012\b\b\u0007\u0012\u0004\b\b(\f\u0012\u0004\u0012\u00020\r0\u00052\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\b2\u0006\u0010\u0012\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\u000bH\u0000\u00a2\u0006\u0002\u0010\u0013\u001a.\u0010\u0014\u001a\u00020\u00012\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u001b\u001a\u00020\u001c\u001a4\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\r0\u001e2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u001f\u001a\u00020\b2\u0006\u0010 \u001a\u00020\b2\u0006\u0010!\u001a\u00020\b\u001a(\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\u00162\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\u000bH\u0000\u00a8\u0006%"}, d2={"addGroups", "", "T", "data", "groupFactory", "Lkotlin/Function4;", "Lkotlin/ParameterName;", "name", "", "start", "end", "Lorg/jetbrains/debugger/VariableContext;", "context", "Lcom/intellij/xdebugger/frame/XValueGroup;", "groupList", "Lcom/intellij/xdebugger/frame/XValueChildrenList;", "_from", "limit", "bucketSize", "(Ljava/lang/Object;Lkotlin/jvm/functions/Function4;Lcom/intellij/xdebugger/frame/XValueChildrenList;IIILorg/jetbrains/debugger/VariableContext;)V", "addRanges", "value", "Lorg/jetbrains/debugger/values/ObjectValue;", "ranges", "", "node", "Lcom/intellij/xdebugger/frame/XCompositeNode;", "isLast", "", "computeNotSparseGroups", "", "_fromInclusive", "toExclusive", "bucketThreshold", "lazyVariablesGroup", "Lorg/jetbrains/debugger/LazyVariablesGroup;", "variables", "intellij.platform.scriptDebugger.ui"})
public final class LazyVariablesGroupKt {
    @NotNull
    public static final LazyVariablesGroup lazyVariablesGroup(@NotNull ObjectValue variables2, int start2, int end, @NotNull VariableContext context) {
        Intrinsics.checkParameterIsNotNull((Object)variables2, (String)"variables");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        return new LazyVariablesGroup(variables2, start2, end, context, null, false, 48, null);
    }

    @NotNull
    public static final List<XValueGroup> computeNotSparseGroups(@NotNull ObjectValue value2, @NotNull VariableContext context, int _fromInclusive, int toExclusive, int bucketThreshold) {
        int fromInclusive;
        Intrinsics.checkParameterIsNotNull((Object)value2, (String)"value");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        int size = toExclusive - fromInclusive;
        int bucketSize = (int)Math.pow(bucketThreshold, Math.ceil(Math.log(size) / Math.log(bucketThreshold)) - 1.0);
        ArrayList<LazyVariablesGroup> groupList = new ArrayList<LazyVariablesGroup>((int)Math.ceil(size / bucketSize));
        for (fromInclusive = _fromInclusive; fromInclusive < toExclusive; fromInclusive += bucketSize) {
            groupList.add(new LazyVariablesGroup(value2, fromInclusive, fromInclusive + (Math.min(bucketSize, toExclusive - fromInclusive) - 1), context, ValueType.NUMBER, false));
        }
        return groupList;
    }

    public static final void addRanges(@NotNull ObjectValue value2, @NotNull int[] ranges2, @NotNull XCompositeNode node, @NotNull VariableContext context, boolean isLast) {
        Intrinsics.checkParameterIsNotNull((Object)value2, (String)"value");
        Intrinsics.checkParameterIsNotNull((Object)ranges2, (String)"ranges");
        Intrinsics.checkParameterIsNotNull((Object)node, (String)"node");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        XValueChildrenList groupList = new XValueChildrenList(ranges2.length / 2);
        int n = ranges2.length;
        for (int i = 0; i < n; i += 2) {
            groupList.addTopGroup(new LazyVariablesGroup(value2, ranges2[i], ranges2[i + 1], context, null, false, 48, null));
        }
        node.addChildren(groupList, isLast);
    }

    public static final <T> void addGroups(T data2, @NotNull Function4<? super T, ? super Integer, ? super Integer, ? super VariableContext, ? extends XValueGroup> groupFactory, @NotNull XValueChildrenList groupList, int _from, int limit, int bucketSize, @NotNull VariableContext context) {
        Intrinsics.checkParameterIsNotNull(groupFactory, (String)"groupFactory");
        Intrinsics.checkParameterIsNotNull((Object)groupList, (String)"groupList");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        int from = _from;
        int to = Math.min(bucketSize, limit);
        boolean done = false;
        do {
            int groupFrom = from;
            int groupTo = to;
            if ((to = (from += bucketSize) + Math.min(bucketSize, limit - from)) - from == 1) {
                ++groupTo;
                done = true;
            }
            groupList.addTopGroup((XValueGroup)groupFactory.invoke(data2, (Object)groupFrom, (Object)groupTo, (Object)context));
        } while (from < limit && !done);
    }
}

