/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.debugger.values;

import com.intellij.util.SmartList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;
import org.jetbrains.debugger.EvaluateContext;
import org.jetbrains.debugger.ValueModifier;
import org.jetbrains.debugger.Variable;
import org.jetbrains.debugger.values.Value;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u0000\u001e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a6\u0010\u0000\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00020\u00012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u00022\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u00022\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006\t"}, d2={"getSpecifiedProperties", "Lorg/jetbrains/concurrency/Promise;", "", "Lorg/jetbrains/debugger/Variable;", "variables", "names", "", "evaluateContext", "Lorg/jetbrains/debugger/EvaluateContext;", "intellij.platform.scriptDebugger.backend"})
public final class ObjectValueBaseKt {
    @NotNull
    public static final Promise<List<Variable>> getSpecifiedProperties(@NotNull List<? extends Variable> variables2, @NotNull List<String> names2, @NotNull EvaluateContext evaluateContext2) {
        Intrinsics.checkParameterIsNotNull(variables2, (String)"variables");
        Intrinsics.checkParameterIsNotNull(names2, (String)"names");
        Intrinsics.checkParameterIsNotNull((Object)evaluateContext2, (String)"evaluateContext");
        SmartList<Variable> properties = new SmartList<Variable>();
        int getterCount = 0;
        for (Variable variable : variables2) {
            if (!variable.isReadable() || !names2.contains(variable.getName())) continue;
            if (!properties.isEmpty()) {
                Collections.sort((List)properties, new Comparator<T>(names2){
                    final /* synthetic */ List $names;

                    public final int compare(Variable o1, Variable o2) {
                        Variable variable = o1;
                        Intrinsics.checkExpressionValueIsNotNull((Object)variable, (String)"o1");
                        int n = this.$names.indexOf(variable.getName());
                        Variable variable2 = o2;
                        Intrinsics.checkExpressionValueIsNotNull((Object)variable2, (String)"o2");
                        return n - this.$names.indexOf(variable2.getName());
                    }
                    {
                        this.$names = list2;
                    }
                });
            }
            properties.add(variable);
            if (variable.getValue() != null) continue;
            ++getterCount;
        }
        if (getterCount == 0) {
            return Promises.resolvedPromise(properties);
        }
        SmartList<Promise<Value>> smartList = new SmartList<Promise<Value>>();
        Iterator iterator2 = properties.iterator();
        while (iterator2.hasNext()) {
            ValueModifier valueModifier;
            Variable variable;
            Variable variable2 = variable = (Variable)iterator2.next();
            Intrinsics.checkExpressionValueIsNotNull((Object)variable2, (String)"variable");
            if (variable2.getValue() != null) continue;
            if (variable.getValueModifier() == null) {
                Intrinsics.throwNpe();
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)valueModifier, (String)"variable.valueModifier!!");
            smartList.add(valueModifier.evaluateGet(variable, evaluateContext2));
        }
        return Promises.all$default((Collection)smartList, properties, (boolean)false, (int)2, null);
    }
}

