/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.ide;

import com.intellij.idea.StartupUtil;
import com.intellij.notification.NotificationDisplayType;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Url;
import com.intellij.util.Urls;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.io.NettyKt;
import com.intellij.util.net.NetUtils;
import io.netty.bootstrap.Bootstrap;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.oio.OioEventLoopGroup;
import java.io.IOException;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.URLConnection;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.builtInWebServer.BuiltInServerOptions;
import org.jetbrains.builtInWebServer.BuiltInWebServerKt;
import org.jetbrains.ide.BuiltInServerBundle;
import org.jetbrains.ide.BuiltInServerManager;
import org.jetbrains.ide.BuiltInServerManagerImplKt;
import org.jetbrains.io.BuiltInServer;
import org.jetbrains.io.NettyUtil;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u0000 \u001f2\u00020\u0001:\u0001\u001fB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0010H\u0016J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\r\u0010\u0016\u001a\u00070\u0017\u00a2\u0006\u0002\b\u0018H\u0016J\u0006\u0010\u0019\u001a\u00020\u001aJ\u0012\u0010\u001b\u001a\u00020\u001c2\b\u0010\u0011\u001a\u0004\u0018\u00010\u0010H\u0016J\f\u0010\u001d\u001a\u0006\u0012\u0002\b\u00030\u000eH\u0002J\b\u0010\u001e\u001a\u00020\u0001H\u0016R\u0014\u0010\u0003\u001a\u00020\u00048VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\u0004\u0018\u00010\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lorg/jetbrains/ide/BuiltInServerManagerImpl;", "Lorg/jetbrains/ide/BuiltInServerManager;", "()V", "port", "", "getPort", "()I", "server", "Lorg/jetbrains/io/BuiltInServer;", "serverDisposable", "Lcom/intellij/openapi/Disposable;", "getServerDisposable", "()Lcom/intellij/openapi/Disposable;", "serverStartFuture", "Ljava/util/concurrent/Future;", "addAuthToken", "Lcom/intellij/util/Url;", "url", "configureRequestToWebServer", "", "connection", "Ljava/net/URLConnection;", "createClientBootstrap", "Lio/netty/bootstrap/Bootstrap;", "Lorg/jetbrains/annotations/NotNull;", "createServerBootstrap", "Lio/netty/bootstrap/ServerBootstrap;", "isOnBuiltInWebServer", "", "startServerInPooledThread", "waitForStart", "Companion", "intellij.platform.builtInServer.impl"})
public final class BuiltInServerManagerImpl
extends BuiltInServerManager {
    private Future<?> serverStartFuture;
    private BuiltInServer server;
    @JvmField
    @NotNull
    public static final NotNullLazyValue<NotificationGroup> NOTIFICATION_GROUP;
    public static final Companion Companion;

    @Override
    public int getPort() {
        int n;
        if (this.server == null) {
            n = BuiltInServerManagerImplKt.access$getDefaultPort$p();
        } else {
            BuiltInServer builtInServer = this.server;
            if (builtInServer == null) {
                Intrinsics.throwNpe();
            }
            n = builtInServer.getPort();
        }
        return n;
    }

    @Override
    @Nullable
    public Disposable getServerDisposable() {
        return (Disposable)this.server;
    }

    @Override
    @NotNull
    public Bootstrap createClientBootstrap() {
        BuiltInServer builtInServer = this.server;
        if (builtInServer == null) {
            Intrinsics.throwNpe();
        }
        Bootstrap bootstrap = NettyUtil.nioClientBootstrap((EventLoopGroup)builtInServer.getEventLoopGroup());
        Intrinsics.checkExpressionValueIsNotNull((Object)bootstrap, (String)"NettyUtil.nioClientBoots\u2026(server!!.eventLoopGroup)");
        return bootstrap;
    }

    @NotNull
    public final ServerBootstrap createServerBootstrap() {
        BuiltInServer builtInServer = this.server;
        if (builtInServer == null) {
            Intrinsics.throwNpe();
        }
        return NettyKt.serverBootstrap((EventLoopGroup)builtInServer.getEventLoopGroup());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Override
    @NotNull
    public BuiltInServerManager waitForStart() {
        v0 = BuiltInServerManagerImplKt.access$getLOG$p();
        v1 = ApplicationManager.getApplication();
        Intrinsics.checkExpressionValueIsNotNull((Object)v1, (String)"ApplicationManager.getApplication()");
        if (v1.isUnitTestMode()) ** GOTO lbl-1000
        v2 = ApplicationManager.getApplication();
        Intrinsics.checkExpressionValueIsNotNull((Object)v2, (String)"ApplicationManager.getApplication()");
        if (v2.isHeadlessEnvironment()) ** GOTO lbl-1000
        v3 = ApplicationManager.getApplication();
        Intrinsics.checkExpressionValueIsNotNull((Object)v3, (String)"ApplicationManager.getApplication()");
        if (!v3.isDispatchThread()) lbl-1000:
        // 3 sources

        {
            v4 = true;
        } else {
            v4 = false;
        }
        v0.assertTrue(v4);
        future = new Ref.ObjectRef();
        var2_2 = this;
        var3_3 = false;
        var4_4 = false;
        synchronized (var2_2) {
            $i$a$-synchronized-BuiltInServerManagerImpl$waitForStart$1 = false;
            future.element = this.serverStartFuture;
            if ((Future)future.element == null) {
                future.element = this.startServerInPooledThread();
                this.serverStartFuture = (Future)future.element;
            }
            var4_5 = Unit.INSTANCE;
        }
        v5 = (Future)future.element;
        if (v5 == null) {
            Intrinsics.throwNpe();
        }
        v5.get();
        return this;
    }

    private final Future<?> startServerInPooledThread() {
        CompletionStage completionStage = StartupUtil.getServerFuture().thenAcceptAsync((Consumer)new Consumer<BuiltInServer>(this){
            final /* synthetic */ BuiltInServerManagerImpl this$0;

            public final void accept(BuiltInServer mainServer) {
                try {
                    BuiltInServerManagerImpl.access$setServer$p(this.this$0, mainServer == null || mainServer.getEventLoopGroup() instanceof OioEventLoopGroup ? BuiltInServer.Companion.start$default((BuiltInServer.Companion)BuiltInServer.Companion, (int)BuiltInServer.Companion.getRecommendedWorkerCount(), (int)BuiltInServerManagerImplKt.access$getDefaultPort$p(), (int)20, (boolean)false, null, (int)24, null) : BuiltInServer.Companion.start(mainServer.getEventLoopGroup(), false, BuiltInServerManagerImplKt.access$getDefaultPort$p(), 20, true, null));
                    BuiltInServer builtInServer = BuiltInServerManagerImpl.access$getServer$p(this.this$0);
                    if (builtInServer == null) {
                        Intrinsics.throwNpe();
                    }
                    BuiltInServerManagerImplKt.access$bindCustomPorts(builtInServer);
                }
                catch (Throwable e) {
                    BuiltInServerManagerImplKt.access$getLOG$p().info(e);
                    StringBuilder stringBuilder = new StringBuilder().append(BuiltInServerBundle.message("notification.content.cannot.start.internal.http.server.git.integration.javascript.debugger.and.liveedit.may.operate.with.errors", new Object[0])).append(BuiltInServerBundle.message("notification.content.please.check.your.firewall.settings.and.restart", new Object[0]));
                    ApplicationNamesInfo applicationNamesInfo = ApplicationNamesInfo.getInstance();
                    Intrinsics.checkExpressionValueIsNotNull((Object)applicationNamesInfo, (String)"ApplicationNamesInfo.getInstance()");
                    BuiltInServerManagerImpl.NOTIFICATION_GROUP.getValue().createNotification(stringBuilder.append(applicationNamesInfo.getFullProductName()).toString(), NotificationType.ERROR).notify(null);
                    return;
                }
                Logger logger = BuiltInServerManagerImplKt.access$getLOG$p();
                StringBuilder stringBuilder = new StringBuilder().append("built-in server started, port ");
                BuiltInServer builtInServer = BuiltInServerManagerImpl.access$getServer$p(this.this$0);
                if (builtInServer == null) {
                    Intrinsics.throwNpe();
                }
                logger.info(stringBuilder.append(builtInServer.getPort()).toString());
                Disposable disposable2 = ApplicationManager.getApplication();
                BuiltInServer builtInServer2 = BuiltInServerManagerImpl.access$getServer$p(this.this$0);
                if (builtInServer2 == null) {
                    Intrinsics.throwNpe();
                }
                Disposer.register(disposable2, (Disposable)builtInServer2);
            }
            {
                this.this$0 = builtInServerManagerImpl;
            }
        }, (Executor)AppExecutorUtil.getAppExecutorService());
        Intrinsics.checkExpressionValueIsNotNull((Object)completionStage, (String)"StartupUtil.getServerFut\u2026.getAppExecutorService())");
        return (Future)((Object)completionStage);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isOnBuiltInWebServer(@Nullable Url url) {
        if (url == null) return false;
        CharSequence charSequence = url.getAuthority();
        boolean bl = false;
        boolean bl2 = false;
        if (charSequence == null) return false;
        if (charSequence.length() == 0) {
            return false;
        }
        boolean bl3 = false;
        if (bl3) return false;
        String string = url.getAuthority();
        if (string == null) {
            Intrinsics.throwNpe();
        }
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"url.authority!!");
        if (!Companion.isOnBuiltInWebServerByAuthority(string)) return false;
        return true;
    }

    @Override
    @NotNull
    public Url addAuthToken(@NotNull Url url) {
        Url url2;
        Intrinsics.checkParameterIsNotNull((Object)url, (String)"url");
        if (url.getParameters() != null) {
            url2 = url;
        } else {
            String string = url.getScheme();
            if (string == null) {
                Intrinsics.throwNpe();
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"url.scheme!!");
            String string2 = url.getAuthority();
            if (string2 == null) {
                Intrinsics.throwNpe();
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"url.authority!!");
            String string3 = url.getPath();
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"url.path");
            Map<String, String> map2 = Collections.singletonMap("_ijt", BuiltInWebServerKt.acquireToken());
            Intrinsics.checkExpressionValueIsNotNull(map2, (String)"Collections.singletonMap\u2026RAM_NAME, acquireToken())");
            url2 = Urls.newUrl((String)string, (String)string2, (String)string3, map2);
        }
        return url2;
    }

    @Override
    public void configureRequestToWebServer(@NotNull URLConnection connection) {
        Intrinsics.checkParameterIsNotNull((Object)connection, (String)"connection");
        connection.setRequestProperty("x-ijt", BuiltInWebServerKt.acquireToken());
    }

    public BuiltInServerManagerImpl() {
        Application application = ApplicationManager.getApplication();
        Intrinsics.checkExpressionValueIsNotNull((Object)application, (String)"ApplicationManager.getApplication()");
        this.serverStartFuture = application.isUnitTestMode() ? null : this.startServerInPooledThread();
    }

    static {
        Companion = new Companion(null);
        NOTIFICATION_GROUP = new NotNullLazyValue<NotificationGroup>(){

            @NotNull
            protected NotificationGroup compute() {
                return new NotificationGroup("Built-in Server", NotificationDisplayType.STICKY_BALLOON, true, null, null, 24, null);
            }
        };
    }

    public static final /* synthetic */ BuiltInServer access$getServer$p(BuiltInServerManagerImpl $this) {
        return $this.server;
    }

    public static final /* synthetic */ void access$setServer$p(BuiltInServerManagerImpl $this, BuiltInServer builtInServer) {
        $this.server = builtInServer;
    }

    @JvmStatic
    public static final boolean isOnBuiltInWebServerByAuthority(@NotNull String authority) {
        return Companion.isOnBuiltInWebServerByAuthority(authority);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0007R\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0000X\u0081\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lorg/jetbrains/ide/BuiltInServerManagerImpl$Companion;", "", "()V", "NOTIFICATION_GROUP", "Lcom/intellij/openapi/util/NotNullLazyValue;", "Lcom/intellij/notification/NotificationGroup;", "isOnBuiltInWebServerByAuthority", "", "authority", "", "intellij.platform.builtInServer.impl"})
    public static final class Companion {
        @JvmStatic
        public final boolean isOnBuiltInWebServerByAuthority(@NotNull String authority) {
            Intrinsics.checkParameterIsNotNull((Object)authority, (String)"authority");
            int portIndex = StringsKt.indexOf$default((CharSequence)authority, (char)':', (int)0, (boolean)false, (int)6, null);
            if (portIndex < 0 || portIndex == authority.length() - 1) {
                return false;
            }
            String string = authority;
            int n = portIndex + 1;
            boolean bl = false;
            String string2 = string.substring(n);
            Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"(this as java.lang.String).substring(startIndex)");
            int port = StringUtil.parseInt(string2, -1);
            if (port == -1) {
                return false;
            }
            BuiltInServerOptions options = BuiltInServerOptions.getInstance();
            int idePort = BuiltInServerManager.Companion.getInstance().getPort();
            if (options.builtInServerPort != port && idePort != port) {
                return false;
            }
            String string3 = authority;
            int n2 = 0;
            boolean bl2 = false;
            String string4 = string3.substring(n2, portIndex);
            Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            String host = string4;
            if (NetUtils.isLocalhost((String)host)) {
                return true;
            }
            try {
                InetAddress inetAddress;
                InetAddress inetAddress2 = inetAddress = InetAddress.getByName(host);
                Intrinsics.checkExpressionValueIsNotNull((Object)inetAddress2, (String)"inetAddress");
                return inetAddress2.isLoopbackAddress() || inetAddress.isAnyLocalAddress() || options.builtInServerAvailableExternally && idePort != port && NetworkInterface.getByInetAddress(inetAddress) != null;
            }
            catch (IOException e) {
                return false;
            }
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

