/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.utils.library;

import com.intellij.jarRepository.RepositoryLibraryDefinition;
import com.intellij.openapi.roots.DependencyScope;
import com.intellij.util.containers.ContainerUtil;
import icons.OpenapiIcons;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.utils.library.RepositoryLibraryProperties;
import org.jetbrains.jps.model.library.JpsMavenRepositoryLibraryDescriptor;

public class RepositoryLibraryDescription {
    @NotNull
    public static final String LatestVersionId = "LATEST";
    @NotNull
    public static final String LatestVersionDisplayName = "Latest";
    @NotNull
    public static final String ReleaseVersionId = "RELEASE";
    @NotNull
    public static final String DefaultVersionId = "RELEASE";
    @NotNull
    public static final String ReleaseVersionDisplayName = "Release";
    @NotNull
    public static final String SnapshotVersionSuffix = "-SNAPSHOT";
    public static final Icon DEFAULT_ICON = OpenapiIcons.RepositoryLibraryLogo;
    private static volatile Map<String, RepositoryLibraryDescription> ourStaticallyDefinedLibraries;
    private final String groupId;
    private final String artifactId;
    private final String libraryName;

    protected RepositoryLibraryDescription(String groupId2, String artifactId2, String libraryName) {
        this.groupId = groupId2 == null ? "" : groupId2;
        this.artifactId = artifactId2 == null ? "" : artifactId2;
        this.libraryName = libraryName == null ? "<unknown>" : libraryName;
    }

    @NotNull
    public static RepositoryLibraryDescription findDescription(@Nullable String groupId2, @Nullable String artifactId2) {
        if (ourStaticallyDefinedLibraries == null) {
            HashMap<String, RepositoryLibraryDescription> map2 = new HashMap<String, RepositoryLibraryDescription>();
            for (RepositoryLibraryDefinition def : RepositoryLibraryDefinition.EP_NAME.getExtensions()) {
                String id2 = def.groupId + ":" + def.artifactId;
                map2.put(id2, new RepositoryLibraryDescription(def.groupId, def.artifactId, def.name));
            }
            ourStaticallyDefinedLibraries = Collections.unmodifiableMap(Collections.synchronizedMap(map2));
        }
        String id3 = groupId2 == null && artifactId2 == null ? "<unknown>" : groupId2 + ":" + artifactId2;
        RepositoryLibraryDescription description = ourStaticallyDefinedLibraries.get(id3);
        return description != null ? description : new RepositoryLibraryDescription(groupId2, artifactId2, id3);
    }

    @NotNull
    public static RepositoryLibraryDescription findDescription(@NotNull RepositoryLibraryProperties properties) {
        if (properties == null) {
            RepositoryLibraryDescription.$$$reportNull$$$0(0);
        }
        return RepositoryLibraryDescription.findDescription(properties.getGroupId(), properties.getArtifactId());
    }

    @NotNull
    public static RepositoryLibraryDescription findDescription(@NotNull JpsMavenRepositoryLibraryDescriptor descriptor2) {
        if (descriptor2 == null) {
            RepositoryLibraryDescription.$$$reportNull$$$0(1);
        }
        return RepositoryLibraryDescription.findDescription(descriptor2.getGroupId(), descriptor2.getArtifactId());
    }

    @NotNull
    public String getGroupId() {
        String string = this.groupId;
        if (string == null) {
            RepositoryLibraryDescription.$$$reportNull$$$0(2);
        }
        return string;
    }

    @NotNull
    public String getArtifactId() {
        String string = this.artifactId;
        if (string == null) {
            RepositoryLibraryDescription.$$$reportNull$$$0(3);
        }
        return string;
    }

    @NotNull
    public String getDisplayName() {
        String string = this.libraryName;
        if (string == null) {
            RepositoryLibraryDescription.$$$reportNull$$$0(4);
        }
        return string;
    }

    @NotNull
    public Icon getIcon() {
        Icon icon2 = DEFAULT_ICON;
        if (icon2 == null) {
            RepositoryLibraryDescription.$$$reportNull$$$0(5);
        }
        return icon2;
    }

    @Nullable
    public DependencyScope getSuggestedScope() {
        return null;
    }

    public int getWeight() {
        return 1000;
    }

    public RepositoryLibraryProperties createDefaultProperties() {
        return new RepositoryLibraryProperties(this.getGroupId(), this.getArtifactId(), "RELEASE", true, ContainerUtil.emptyList());
    }

    public String getDisplayName(String version2) {
        if (LatestVersionId.equals(version2)) {
            version2 = LatestVersionDisplayName;
        } else if ("RELEASE".equals(version2)) {
            version2 = ReleaseVersionDisplayName;
        }
        return this.getDisplayName() + (version2 == null ? "" : ":" + version2);
    }

    public String getMavenCoordinates(String version2) {
        return this.getGroupId() + ":" + this.getArtifactId() + ":" + version2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "properties";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/maven/utils/library/RepositoryLibraryDescription";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/maven/utils/library/RepositoryLibraryDescription";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getGroupId";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getArtifactId";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisplayName";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getIcon";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findDescription";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

