/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.utils.library;

import com.intellij.openapi.roots.libraries.LibraryProperties;
import com.intellij.openapi.util.Comparing;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xmlb.annotations.Attribute;
import com.intellij.util.xmlb.annotations.Transient;
import com.intellij.util.xmlb.annotations.XCollection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.model.library.JpsMavenRepositoryLibraryDescriptor;

public class RepositoryLibraryProperties
extends LibraryProperties<RepositoryLibraryProperties> {
    private JpsMavenRepositoryLibraryDescriptor myDescriptor;

    public RepositoryLibraryProperties() {
    }

    public RepositoryLibraryProperties(JpsMavenRepositoryLibraryDescriptor descriptor2) {
        this.myDescriptor = descriptor2;
    }

    public RepositoryLibraryProperties(String mavenId, boolean includeTransitiveDependencies) {
        this(new JpsMavenRepositoryLibraryDescriptor(mavenId, includeTransitiveDependencies, Collections.emptyList()));
    }

    public RepositoryLibraryProperties(String mavenId, String packaging, boolean includeTransitiveDependencies) {
        this(new JpsMavenRepositoryLibraryDescriptor(mavenId, packaging, includeTransitiveDependencies, Collections.emptyList()));
    }

    public RepositoryLibraryProperties(@NotNull String groupId2, @NotNull String artifactId2, @NotNull String version2) {
        if (groupId2 == null) {
            RepositoryLibraryProperties.$$$reportNull$$$0(0);
        }
        if (artifactId2 == null) {
            RepositoryLibraryProperties.$$$reportNull$$$0(1);
        }
        if (version2 == null) {
            RepositoryLibraryProperties.$$$reportNull$$$0(2);
        }
        this(groupId2, artifactId2, version2, true, ContainerUtil.emptyList());
    }

    public RepositoryLibraryProperties(@NotNull String groupId2, @NotNull String artifactId2, @NotNull String version2, boolean includeTransitiveDependencies, @NotNull List<String> excludedDependencies) {
        if (groupId2 == null) {
            RepositoryLibraryProperties.$$$reportNull$$$0(3);
        }
        if (artifactId2 == null) {
            RepositoryLibraryProperties.$$$reportNull$$$0(4);
        }
        if (version2 == null) {
            RepositoryLibraryProperties.$$$reportNull$$$0(5);
        }
        if (excludedDependencies == null) {
            RepositoryLibraryProperties.$$$reportNull$$$0(6);
        }
        this(new JpsMavenRepositoryLibraryDescriptor(groupId2, artifactId2, version2, includeTransitiveDependencies, excludedDependencies));
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof RepositoryLibraryProperties && Comparing.equal(this.myDescriptor, ((RepositoryLibraryProperties)obj).myDescriptor);
    }

    @Override
    public int hashCode() {
        return Comparing.hashcode(this.getMavenId());
    }

    @Override
    public RepositoryLibraryProperties getState() {
        return this;
    }

    @Override
    public void loadState(@NotNull RepositoryLibraryProperties state) {
        if (state == null) {
            RepositoryLibraryProperties.$$$reportNull$$$0(7);
        }
        this.myDescriptor = state.myDescriptor;
    }

    @Attribute(value="maven-id")
    public String getMavenId() {
        return this.call(JpsMavenRepositoryLibraryDescriptor::getMavenId, null);
    }

    @Attribute(value="packaging")
    public String getPackaging() {
        return this.call(JpsMavenRepositoryLibraryDescriptor::getPackaging, "jar");
    }

    public void setMavenId(String mavenId) {
        this.myDescriptor = new JpsMavenRepositoryLibraryDescriptor(mavenId, this.getPackaging(), this.isIncludeTransitiveDependencies(), this.getExcludedDependencies());
    }

    public void setPackaging(String packaging) {
        this.myDescriptor = new JpsMavenRepositoryLibraryDescriptor(this.getMavenId(), packaging, this.isIncludeTransitiveDependencies(), this.getExcludedDependencies());
    }

    @Attribute(value="include-transitive-deps")
    public boolean isIncludeTransitiveDependencies() {
        return this.call(JpsMavenRepositoryLibraryDescriptor::isIncludeTransitiveDependencies, Boolean.TRUE);
    }

    public void setIncludeTransitiveDependencies(boolean value2) {
        this.myDescriptor = new JpsMavenRepositoryLibraryDescriptor(this.getMavenId(), this.getPackaging(), value2, this.getExcludedDependencies());
    }

    public String getGroupId() {
        return this.call(JpsMavenRepositoryLibraryDescriptor::getGroupId, null);
    }

    public String getArtifactId() {
        return this.call(JpsMavenRepositoryLibraryDescriptor::getArtifactId, null);
    }

    public String getVersion() {
        return this.call(JpsMavenRepositoryLibraryDescriptor::getVersion, null);
    }

    public void changeVersion(String version2) {
        this.myDescriptor = new JpsMavenRepositoryLibraryDescriptor(this.getGroupId(), this.getArtifactId(), version2, this.getPackaging(), this.isIncludeTransitiveDependencies(), this.getExcludedDependencies());
    }

    private <T> T call(Function<? super JpsMavenRepositoryLibraryDescriptor, ? extends T> method2, T defaultValue) {
        JpsMavenRepositoryLibraryDescriptor descriptor2 = this.myDescriptor;
        return descriptor2 != null ? method2.apply(descriptor2) : defaultValue;
    }

    @Transient
    public List<String> getExcludedDependencies() {
        return this.call(JpsMavenRepositoryLibraryDescriptor::getExcludedDependencies, Collections.emptyList());
    }

    public void setExcludedDependencies(List<String> dependencyMavenIds) {
        this.myDescriptor = new JpsMavenRepositoryLibraryDescriptor(this.getMavenId(), this.getPackaging(), this.isIncludeTransitiveDependencies(), dependencyMavenIds);
    }

    @XCollection(propertyElementName="exclude", elementName="dependency", valueAttributeName="maven-id")
    public List<String> getExcludedDependenciesBean() {
        return this.myDescriptor != null ? new ArrayList<String>(this.myDescriptor.getExcludedDependencies()) : new ArrayList();
    }

    public void setExcludedDependenciesBean(List<String> dependencyMavenIds) {
        this.setExcludedDependencies(dependencyMavenIds);
    }

    @NotNull
    public JpsMavenRepositoryLibraryDescriptor getRepositoryLibraryDescriptor() {
        return this.myDescriptor != null ? this.myDescriptor : new JpsMavenRepositoryLibraryDescriptor(null, true, Collections.emptyList());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "groupId";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "artifactId";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "version";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "excludedDependencies";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/idea/maven/utils/library/RepositoryLibraryProperties";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "loadState";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

