/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.model.library;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JpsMavenRepositoryLibraryDescriptor {
    public static final String DEFAULT_PACKAGING = "jar";
    private final String myMavenId;
    private final String myGroupId;
    private final String myArtifactId;
    private final String myVersion;
    private final String myPackaging;
    private final boolean myIncludeTransitiveDependencies;
    private final List<String> myExcludedDependencies;

    public JpsMavenRepositoryLibraryDescriptor(@NotNull String groupId2, @NotNull String artifactId2, @NotNull String version2) {
        if (groupId2 == null) {
            JpsMavenRepositoryLibraryDescriptor.$$$reportNull$$$0(0);
        }
        if (artifactId2 == null) {
            JpsMavenRepositoryLibraryDescriptor.$$$reportNull$$$0(1);
        }
        if (version2 == null) {
            JpsMavenRepositoryLibraryDescriptor.$$$reportNull$$$0(2);
        }
        this(groupId2, artifactId2, version2, true, Collections.emptyList());
    }

    public JpsMavenRepositoryLibraryDescriptor(@NotNull String groupId2, @NotNull String artifactId2, @NotNull String version2, boolean includeTransitiveDependencies, @NotNull List<String> excludedDependencies) {
        if (groupId2 == null) {
            JpsMavenRepositoryLibraryDescriptor.$$$reportNull$$$0(3);
        }
        if (artifactId2 == null) {
            JpsMavenRepositoryLibraryDescriptor.$$$reportNull$$$0(4);
        }
        if (version2 == null) {
            JpsMavenRepositoryLibraryDescriptor.$$$reportNull$$$0(5);
        }
        if (excludedDependencies == null) {
            JpsMavenRepositoryLibraryDescriptor.$$$reportNull$$$0(6);
        }
        this(groupId2, artifactId2, version2, DEFAULT_PACKAGING, includeTransitiveDependencies, excludedDependencies);
    }

    public JpsMavenRepositoryLibraryDescriptor(@NotNull String groupId2, @NotNull String artifactId2, @NotNull String version2, @NotNull String packaging, boolean includeTransitiveDependencies, @NotNull List<String> excludedDependencies) {
        if (groupId2 == null) {
            JpsMavenRepositoryLibraryDescriptor.$$$reportNull$$$0(7);
        }
        if (artifactId2 == null) {
            JpsMavenRepositoryLibraryDescriptor.$$$reportNull$$$0(8);
        }
        if (version2 == null) {
            JpsMavenRepositoryLibraryDescriptor.$$$reportNull$$$0(9);
        }
        if (packaging == null) {
            JpsMavenRepositoryLibraryDescriptor.$$$reportNull$$$0(10);
        }
        if (excludedDependencies == null) {
            JpsMavenRepositoryLibraryDescriptor.$$$reportNull$$$0(11);
        }
        this.myGroupId = groupId2;
        this.myArtifactId = artifactId2;
        this.myVersion = version2;
        this.myPackaging = packaging;
        this.myIncludeTransitiveDependencies = includeTransitiveDependencies;
        this.myExcludedDependencies = excludedDependencies;
        this.myMavenId = groupId2 + ":" + artifactId2 + ":" + version2;
    }

    public JpsMavenRepositoryLibraryDescriptor(@Nullable String mavenId) {
        this(mavenId, true, Collections.emptyList());
    }

    public JpsMavenRepositoryLibraryDescriptor(@NotNull String groupId2, @NotNull String artifactId2, @NotNull String version2, boolean includeTransitiveDependencies) {
        if (groupId2 == null) {
            JpsMavenRepositoryLibraryDescriptor.$$$reportNull$$$0(12);
        }
        if (artifactId2 == null) {
            JpsMavenRepositoryLibraryDescriptor.$$$reportNull$$$0(13);
        }
        if (version2 == null) {
            JpsMavenRepositoryLibraryDescriptor.$$$reportNull$$$0(14);
        }
        this(groupId2, artifactId2, version2, includeTransitiveDependencies, Collections.emptyList());
    }

    public JpsMavenRepositoryLibraryDescriptor(@Nullable String mavenId, boolean includeTransitiveDependencies, List<String> excludedDependencies) {
        this(mavenId, DEFAULT_PACKAGING, includeTransitiveDependencies, excludedDependencies);
    }

    public JpsMavenRepositoryLibraryDescriptor(@Nullable String mavenId, @NotNull String packaging, boolean includeTransitiveDependencies, List<String> excludedDependencies) {
        if (packaging == null) {
            JpsMavenRepositoryLibraryDescriptor.$$$reportNull$$$0(15);
        }
        this.myMavenId = mavenId;
        this.myIncludeTransitiveDependencies = includeTransitiveDependencies;
        this.myExcludedDependencies = excludedDependencies;
        this.myPackaging = packaging;
        if (mavenId == null) {
            this.myVersion = null;
            this.myArtifactId = null;
            this.myGroupId = null;
        } else {
            String[] parts = mavenId.split(":");
            this.myGroupId = parts.length > 0 ? parts[0] : null;
            this.myArtifactId = parts.length > 1 ? parts[1] : null;
            this.myVersion = parts.length > 2 ? parts[2] : null;
        }
    }

    public String getMavenId() {
        return this.myMavenId;
    }

    public String getGroupId() {
        return this.myGroupId;
    }

    public String getArtifactId() {
        return this.myArtifactId;
    }

    public boolean isIncludeTransitiveDependencies() {
        return this.myIncludeTransitiveDependencies;
    }

    public List<String> getExcludedDependencies() {
        return this.myExcludedDependencies;
    }

    public String getVersion() {
        return this.myVersion;
    }

    public String getPackaging() {
        return this.myPackaging;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JpsMavenRepositoryLibraryDescriptor that = (JpsMavenRepositoryLibraryDescriptor)o;
        return this.myIncludeTransitiveDependencies == that.myIncludeTransitiveDependencies && this.myMavenId.equals(that.myMavenId) && this.myPackaging.equals(that.myPackaging) && this.myExcludedDependencies.equals(that.myExcludedDependencies);
    }

    public int hashCode() {
        return Objects.hash(this.myMavenId, this.myPackaging, this.myIncludeTransitiveDependencies, this.myExcludedDependencies);
    }

    public String toString() {
        return this.myMavenId != null ? this.myMavenId : "null";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "groupId";
                break;
            }
            case 1: 
            case 4: 
            case 8: 
            case 13: {
                objectArray = objectArray2;
                objectArray2[0] = "artifactId";
                break;
            }
            case 2: 
            case 5: 
            case 9: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[0] = "version";
                break;
            }
            case 6: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[0] = "excludedDependencies";
                break;
            }
            case 10: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[0] = "packaging";
                break;
            }
        }
        objectArray[1] = "org/jetbrains/jps/model/library/JpsMavenRepositoryLibraryDescriptor";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

