/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.org.objectweb.asm.tree;

import java.util.ArrayList;
import java.util.List;
import org.jetbrains.org.objectweb.asm.AnnotationVisitor;
import org.jetbrains.org.objectweb.asm.Attribute;
import org.jetbrains.org.objectweb.asm.ClassVisitor;
import org.jetbrains.org.objectweb.asm.FieldVisitor;
import org.jetbrains.org.objectweb.asm.MethodVisitor;
import org.jetbrains.org.objectweb.asm.ModuleVisitor;
import org.jetbrains.org.objectweb.asm.TypePath;
import org.jetbrains.org.objectweb.asm.tree.AnnotationNode;
import org.jetbrains.org.objectweb.asm.tree.FieldNode;
import org.jetbrains.org.objectweb.asm.tree.InnerClassNode;
import org.jetbrains.org.objectweb.asm.tree.MethodNode;
import org.jetbrains.org.objectweb.asm.tree.ModuleNode;
import org.jetbrains.org.objectweb.asm.tree.TypeAnnotationNode;
import org.jetbrains.org.objectweb.asm.tree.UnsupportedClassVersionException;
import org.jetbrains.org.objectweb.asm.tree.Util;

public class ClassNode
extends ClassVisitor {
    public int version;
    public int access;
    public String name;
    public String signature;
    public String superName;
    public List<String> interfaces = new ArrayList<String>();
    public String sourceFile;
    public String sourceDebug;
    public ModuleNode module;
    public String outerClass;
    public String outerMethod;
    public String outerMethodDesc;
    public List<AnnotationNode> visibleAnnotations;
    public List<AnnotationNode> invisibleAnnotations;
    public List<TypeAnnotationNode> visibleTypeAnnotations;
    public List<TypeAnnotationNode> invisibleTypeAnnotations;
    public List<Attribute> attrs;
    public List<InnerClassNode> innerClasses = new ArrayList<InnerClassNode>();
    public String nestHostClass;
    public List<String> nestMembers;
    public List<FieldNode> fields = new ArrayList<FieldNode>();
    public List<MethodNode> methods = new ArrayList<MethodNode>();

    public ClassNode() {
        this(458752);
        if (this.getClass() != ClassNode.class) {
            throw new IllegalStateException();
        }
    }

    public ClassNode(int api) {
        super(api);
    }

    public void visit(int version2, int access, String name, String signature, String superName, String[] interfaces) {
        this.version = version2;
        this.access = access;
        this.name = name;
        this.signature = signature;
        this.superName = superName;
        this.interfaces = Util.asArrayList(interfaces);
    }

    public void visitSource(String file2, String debug) {
        this.sourceFile = file2;
        this.sourceDebug = debug;
    }

    public ModuleVisitor visitModule(String name, int access, String version2) {
        this.module = new ModuleNode(name, access, version2);
        return this.module;
    }

    public void visitNestHost(String nestHost) {
        this.nestHostClass = nestHost;
    }

    public void visitOuterClass(String owner, String name, String descriptor2) {
        this.outerClass = owner;
        this.outerMethod = name;
        this.outerMethodDesc = descriptor2;
    }

    public AnnotationVisitor visitAnnotation(String descriptor2, boolean visible) {
        AnnotationNode annotation = new AnnotationNode(descriptor2);
        if (visible) {
            if (this.visibleAnnotations == null) {
                this.visibleAnnotations = new ArrayList<AnnotationNode>(1);
            }
            this.visibleAnnotations.add(annotation);
        } else {
            if (this.invisibleAnnotations == null) {
                this.invisibleAnnotations = new ArrayList<AnnotationNode>(1);
            }
            this.invisibleAnnotations.add(annotation);
        }
        return annotation;
    }

    public AnnotationVisitor visitTypeAnnotation(int typeRef, TypePath typePath, String descriptor2, boolean visible) {
        TypeAnnotationNode typeAnnotation = new TypeAnnotationNode(typeRef, typePath, descriptor2);
        if (visible) {
            if (this.visibleTypeAnnotations == null) {
                this.visibleTypeAnnotations = new ArrayList<TypeAnnotationNode>(1);
            }
            this.visibleTypeAnnotations.add(typeAnnotation);
        } else {
            if (this.invisibleTypeAnnotations == null) {
                this.invisibleTypeAnnotations = new ArrayList<TypeAnnotationNode>(1);
            }
            this.invisibleTypeAnnotations.add(typeAnnotation);
        }
        return typeAnnotation;
    }

    public void visitAttribute(Attribute attribute) {
        if (this.attrs == null) {
            this.attrs = new ArrayList<Attribute>(1);
        }
        this.attrs.add(attribute);
    }

    public void visitNestMember(String nestMember) {
        if (this.nestMembers == null) {
            this.nestMembers = new ArrayList<String>();
        }
        this.nestMembers.add(nestMember);
    }

    public void visitInnerClass(String name, String outerName, String innerName, int access) {
        InnerClassNode innerClass = new InnerClassNode(name, outerName, innerName, access);
        this.innerClasses.add(innerClass);
    }

    public FieldVisitor visitField(int access, String name, String descriptor2, String signature, Object value2) {
        FieldNode field = new FieldNode(access, name, descriptor2, signature, value2);
        this.fields.add(field);
        return field;
    }

    public MethodVisitor visitMethod(int access, String name, String descriptor2, String signature, String[] exceptions) {
        MethodNode method2 = new MethodNode(access, name, descriptor2, signature, exceptions);
        this.methods.add(method2);
        return method2;
    }

    public void visitEnd() {
    }

    public void check(int api) {
        int i;
        if (api < 458752 && (this.nestHostClass != null || this.nestMembers != null)) {
            throw new UnsupportedClassVersionException();
        }
        if (api < 393216 && this.module != null) {
            throw new UnsupportedClassVersionException();
        }
        if (api < 327680) {
            if (this.visibleTypeAnnotations != null && !this.visibleTypeAnnotations.isEmpty()) {
                throw new UnsupportedClassVersionException();
            }
            if (this.invisibleTypeAnnotations != null && !this.invisibleTypeAnnotations.isEmpty()) {
                throw new UnsupportedClassVersionException();
            }
        }
        if (this.visibleAnnotations != null) {
            for (i = this.visibleAnnotations.size() - 1; i >= 0; --i) {
                this.visibleAnnotations.get(i).check(api);
            }
        }
        if (this.invisibleAnnotations != null) {
            for (i = this.invisibleAnnotations.size() - 1; i >= 0; --i) {
                this.invisibleAnnotations.get(i).check(api);
            }
        }
        if (this.visibleTypeAnnotations != null) {
            for (i = this.visibleTypeAnnotations.size() - 1; i >= 0; --i) {
                this.visibleTypeAnnotations.get(i).check(api);
            }
        }
        if (this.invisibleTypeAnnotations != null) {
            for (i = this.invisibleTypeAnnotations.size() - 1; i >= 0; --i) {
                this.invisibleTypeAnnotations.get(i).check(api);
            }
        }
        for (i = this.fields.size() - 1; i >= 0; --i) {
            this.fields.get(i).check(api);
        }
        for (i = this.methods.size() - 1; i >= 0; --i) {
            this.methods.get(i).check(api);
        }
    }

    public void accept(ClassVisitor classVisitor) {
        TypeAnnotationNode typeAnnotation;
        AnnotationNode annotation;
        int i;
        int n;
        String[] interfacesArray = new String[this.interfaces.size()];
        this.interfaces.toArray(interfacesArray);
        classVisitor.visit(this.version, this.access, this.name, this.signature, this.superName, interfacesArray);
        if (this.sourceFile != null || this.sourceDebug != null) {
            classVisitor.visitSource(this.sourceFile, this.sourceDebug);
        }
        if (this.module != null) {
            this.module.accept(classVisitor);
        }
        if (this.nestHostClass != null) {
            classVisitor.visitNestHost(this.nestHostClass);
        }
        if (this.outerClass != null) {
            classVisitor.visitOuterClass(this.outerClass, this.outerMethod, this.outerMethodDesc);
        }
        if (this.visibleAnnotations != null) {
            n = this.visibleAnnotations.size();
            for (i = 0; i < n; ++i) {
                annotation = this.visibleAnnotations.get(i);
                annotation.accept(classVisitor.visitAnnotation(annotation.desc, true));
            }
        }
        if (this.invisibleAnnotations != null) {
            n = this.invisibleAnnotations.size();
            for (i = 0; i < n; ++i) {
                annotation = this.invisibleAnnotations.get(i);
                annotation.accept(classVisitor.visitAnnotation(annotation.desc, false));
            }
        }
        if (this.visibleTypeAnnotations != null) {
            n = this.visibleTypeAnnotations.size();
            for (i = 0; i < n; ++i) {
                typeAnnotation = this.visibleTypeAnnotations.get(i);
                typeAnnotation.accept(classVisitor.visitTypeAnnotation(typeAnnotation.typeRef, typeAnnotation.typePath, typeAnnotation.desc, true));
            }
        }
        if (this.invisibleTypeAnnotations != null) {
            n = this.invisibleTypeAnnotations.size();
            for (i = 0; i < n; ++i) {
                typeAnnotation = this.invisibleTypeAnnotations.get(i);
                typeAnnotation.accept(classVisitor.visitTypeAnnotation(typeAnnotation.typeRef, typeAnnotation.typePath, typeAnnotation.desc, false));
            }
        }
        if (this.attrs != null) {
            n = this.attrs.size();
            for (i = 0; i < n; ++i) {
                classVisitor.visitAttribute(this.attrs.get(i));
            }
        }
        if (this.nestMembers != null) {
            n = this.nestMembers.size();
            for (i = 0; i < n; ++i) {
                classVisitor.visitNestMember(this.nestMembers.get(i));
            }
        }
        n = this.innerClasses.size();
        for (i = 0; i < n; ++i) {
            this.innerClasses.get(i).accept(classVisitor);
        }
        n = this.fields.size();
        for (i = 0; i < n; ++i) {
            this.fields.get(i).accept(classVisitor);
        }
        n = this.methods.size();
        for (i = 0; i < n; ++i) {
            this.methods.get(i).accept(classVisitor);
        }
        classVisitor.visitEnd();
    }
}

