/*
 * Decompiled with CFR 0.152.
 */
package org.picocontainer.defaults;

import java.lang.reflect.Field;
import java.util.Collections;
import java.util.List;
import org.picocontainer.ComponentAdapter;
import org.picocontainer.Parameter;
import org.picocontainer.PicoContainer;
import org.picocontainer.defaults.AmbiguousComponentResolutionException;
import org.picocontainer.defaults.CollectionComponentParameter;
import org.picocontainer.defaults.UnsatisfiableDependenciesException;

public final class ComponentParameter
implements Parameter {
    public static final ComponentParameter DEFAULT = new ComponentParameter();
    public static final ComponentParameter ARRAY = new ComponentParameter(false);
    private final Parameter collectionParameter;
    private final Object componentKey;

    public ComponentParameter(Object componentKey) {
        this(componentKey, null);
    }

    public ComponentParameter() {
        this(false);
    }

    public ComponentParameter(boolean emptyCollection) {
        this(null, emptyCollection ? CollectionComponentParameter.ARRAY_ALLOW_EMPTY : CollectionComponentParameter.ARRAY);
    }

    public ComponentParameter(Class componentValueType, boolean emptyCollection) {
        this(null, new CollectionComponentParameter(componentValueType, emptyCollection));
    }

    public ComponentParameter(Class componentKeyType, Class componentValueType, boolean emptyCollection) {
        this(null, new CollectionComponentParameter(componentKeyType, componentValueType, emptyCollection));
    }

    private ComponentParameter(Object componentKey, Parameter collectionParameter) {
        this.componentKey = componentKey;
        this.collectionParameter = collectionParameter;
    }

    @Override
    public Object resolveInstance(PicoContainer container2, ComponentAdapter adapter, Class expectedType) {
        Object result2 = null;
        ComponentAdapter componentAdapter = this.resolveAdapter(container2, adapter, expectedType);
        if (componentAdapter != null) {
            result2 = container2.getComponentInstance(componentAdapter.getComponentKey());
        }
        if (result2 == null && this.collectionParameter != null) {
            result2 = this.collectionParameter.resolveInstance(container2, adapter, expectedType);
        }
        return result2;
    }

    @Override
    public boolean isResolvable(PicoContainer container2, ComponentAdapter adapter, Class expectedType) {
        if (this.resolveAdapter(container2, adapter, expectedType) == null) {
            if (this.collectionParameter != null) {
                return this.collectionParameter.isResolvable(container2, adapter, expectedType);
            }
            return false;
        }
        return true;
    }

    @Override
    public void verify(PicoContainer container2, ComponentAdapter adapter, Class expectedType) {
        try {
            ComponentAdapter componentAdapter = this.resolveAdapter(container2, adapter, expectedType);
            if (componentAdapter == null) {
                throw new UnsatisfiableDependenciesException(adapter, Collections.singleton(expectedType), container2);
            }
        }
        catch (UnsatisfiableDependenciesException e) {
            if (this.collectionParameter != null) {
                this.collectionParameter.verify(container2, adapter, expectedType);
                return;
            }
            throw e;
        }
    }

    private ComponentAdapter resolveAdapter(PicoContainer container2, ComponentAdapter adapter, Class expectedType) {
        ComponentAdapter result2 = this.getTargetAdapter(container2, expectedType, adapter);
        if (result2 == null) {
            return null;
        }
        if (!expectedType.isAssignableFrom(result2.getComponentImplementation())) {
            if (expectedType.isPrimitive()) {
                try {
                    Field field = result2.getComponentImplementation().getField("TYPE");
                    Class type = (Class)field.get(result2.getComponentInstance(null));
                    if (expectedType.isAssignableFrom(type)) {
                        return result2;
                    }
                }
                catch (NoSuchFieldException noSuchFieldException) {
                }
                catch (IllegalArgumentException illegalArgumentException) {
                }
                catch (IllegalAccessException illegalAccessException) {
                }
                catch (ClassCastException classCastException) {
                    // empty catch block
                }
            }
            return null;
        }
        return result2;
    }

    private ComponentAdapter getTargetAdapter(PicoContainer container2, Class expectedType, ComponentAdapter excludeAdapter) {
        if (this.componentKey != null) {
            return container2.getComponentAdapter(this.componentKey);
        }
        if (excludeAdapter == null) {
            return container2.getComponentAdapterOfType(expectedType);
        }
        Object excludeKey = excludeAdapter.getComponentKey();
        ComponentAdapter byKey = container2.getComponentAdapter(expectedType);
        if (byKey != null && !excludeKey.equals(byKey.getComponentKey())) {
            return byKey;
        }
        List<ComponentAdapter> found2 = container2.getComponentAdaptersOfType(expectedType);
        ComponentAdapter exclude = null;
        for (ComponentAdapter o : found2) {
            ComponentAdapter work = o;
            if (!work.getComponentKey().equals(excludeKey)) continue;
            exclude = work;
        }
        found2.remove(exclude);
        if (found2.size() == 0) {
            if (container2.getParent() != null) {
                return container2.getParent().getComponentAdapterOfType(expectedType);
            }
            return null;
        }
        if (found2.size() == 1) {
            return found2.get(0);
        }
        Object[] foundClasses = new Class[found2.size()];
        for (int i = 0; i < foundClasses.length; ++i) {
            foundClasses[i] = found2.get(i).getComponentImplementation();
        }
        throw new AmbiguousComponentResolutionException(expectedType, foundClasses);
    }
}

