/*
 * Decompiled with CFR 0.152.
 */
package org.picocontainer.defaults;

import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessController;
import java.security.CodeSource;
import java.security.PermissionCollection;
import java.security.Permissions;
import java.security.PrivilegedAction;
import java.util.Map;

public class CustomPermissionsURLClassLoader
extends URLClassLoader {
    private final Map permissionsMap;

    public CustomPermissionsURLClassLoader(URL[] urls, Map permissionsMap, ClassLoader parent) {
        super(urls, parent);
        this.permissionsMap = permissionsMap;
    }

    public Class loadClass(String name) throws ClassNotFoundException {
        try {
            return super.loadClass(name);
        }
        catch (ClassNotFoundException e) {
            throw this.decorateException(name, e);
        }
    }

    protected Class findClass(String name) throws ClassNotFoundException {
        try {
            return super.findClass(name);
        }
        catch (ClassNotFoundException e) {
            throw this.decorateException(name, e);
        }
    }

    private ClassNotFoundException decorateException(String name, ClassNotFoundException e) {
        if (name.startsWith("class ")) {
            return new ClassNotFoundException("Class '" + name + "' is not a classInstance.getName(). It's a classInstance.toString(). The clue is that it starts with 'class ', no classname contains a space.");
        }
        ClassLoader classLoader = this;
        StringBuilder sb = new StringBuilder("'").append(name).append("' classloader stack [");
        while (classLoader != null) {
            sb.append(((Object)classLoader).toString()).append("\n");
            final CustomPermissionsURLClassLoader cl = classLoader;
            classLoader = (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return cl.getParent();
                }
            });
        }
        return new ClassNotFoundException(sb.append("]").toString(), e);
    }

    public String toString() {
        URL[] urls;
        StringBuilder result2 = new StringBuilder(CustomPermissionsURLClassLoader.class.getName() + " " + System.identityHashCode(this) + ":");
        for (URL url : urls = this.getURLs()) {
            result2.append("\n\t").append(url.toString());
        }
        return result2.toString();
    }

    @Override
    public PermissionCollection getPermissions(CodeSource codeSource) {
        return (Permissions)this.permissionsMap.get(codeSource.getLocation());
    }
}

