/*
 * Decompiled with CFR 0.152.
 */
package sqldelight.com.intellij.openapi.application.impl;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Objects;
import java.util.TimeZone;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import sqldelight.com.intellij.diagnostic.Activity;
import sqldelight.com.intellij.diagnostic.StartUpMeasurer;
import sqldelight.com.intellij.ide.plugins.PluginManagerCore;
import sqldelight.com.intellij.openapi.application.ApplicationNamesInfo;
import sqldelight.com.intellij.openapi.application.IdeUrlTrackingParametersProvider;
import sqldelight.com.intellij.openapi.application.PathManager;
import sqldelight.com.intellij.openapi.application.ex.ApplicationInfoEx;
import sqldelight.com.intellij.openapi.application.ex.ProgressSlide;
import sqldelight.com.intellij.openapi.extensions.PluginId;
import sqldelight.com.intellij.openapi.util.BuildNumber;
import sqldelight.com.intellij.openapi.util.text.StringUtil;
import sqldelight.com.intellij.openapi.util.text.StringUtilRt;
import sqldelight.com.intellij.serviceContainer.NonInjectable;
import sqldelight.org.jdom.Element;
import sqldelight.org.jetbrains.annotations.NotNull;
import sqldelight.org.jetbrains.annotations.Nullable;

public final class ApplicationInfoImpl
extends ApplicationInfoEx {
    private String myCodeName;
    private String myMajorVersion;
    private String myMinorVersion;
    private String myMicroVersion;
    private String myPatchVersion;
    private String myFullVersionFormat;
    private String myBuildNumber;
    private String myApiVersion;
    private String myVersionSuffix;
    private String myCompanyName;
    private String myCopyrightStart;
    private String myShortCompanyName;
    private String myCompanyUrl;
    private long myProgressColor;
    private long myCopyrightForeground;
    private long myAboutForeground;
    private long myAboutLinkColor;
    private int[] myAboutLogoRect;
    private String myProgressTailIconName;
    private int myProgressHeight;
    private int myProgressY;
    private String mySplashImageUrl;
    private String myAboutImageUrl;
    private String myIconUrl;
    private String mySmallIconUrl;
    private String myBigIconUrl;
    private String mySvgIconUrl;
    private String mySvgEapIconUrl;
    private String mySmallSvgIconUrl;
    private String mySmallSvgEapIconUrl;
    private String myToolWindowIconUrl;
    private String myWelcomeScreenLogoUrl;
    private Calendar myBuildDate;
    private Calendar myMajorReleaseBuildDate;
    private String myPackageCode;
    private boolean myShowLicensee;
    private String myCustomizeIDEWizardStepsProvider;
    private final ApplicationInfoEx.UpdateUrls myUpdateUrls;
    private String myDocumentationUrl;
    private String mySupportUrl;
    private String myYoutrackUrl;
    private String myFeedbackUrl;
    private String myPluginManagerUrl;
    private String myPluginsListUrl;
    private String myChannelsListUrl;
    private String myPluginsDownloadUrl;
    private String myBuiltinPluginsUrl;
    private String myWhatsNewUrl;
    private String myWinKeymapUrl;
    private String myMacKeymapUrl;
    private boolean myEAP;
    private boolean myHasHelp;
    private boolean myHasContextHelp;
    private String myWebHelpUrl;
    private final List<PluginId> myEssentialPluginsIds;
    private final String myEventLogSettingsUrl;
    private String myJetBrainsTvUrl;
    private String myEvalLicenseUrl;
    private String myKeyConversionUrl;
    private String mySubscriptionFormId;
    private String mySubscriptionNewsKey;
    private String mySubscriptionNewsValue;
    private String mySubscriptionTipsKey;
    private boolean mySubscriptionTipsAvailable;
    private String mySubscriptionAdditionalFormData;
    private final List<ProgressSlide> myProgressSlides;
    private static final String ELEMENT_VERSION = "version";
    private static final String ATTRIBUTE_MAJOR = "major";
    private static final String ATTRIBUTE_MINOR = "minor";
    private static final String ATTRIBUTE_MICRO = "micro";
    private static final String ATTRIBUTE_PATCH = "patch";
    private static final String ATTRIBUTE_FULL = "full";
    private static final String ATTRIBUTE_CODENAME = "codename";
    private static final String ATTRIBUTE_NAME = "name";
    private static final String ELEMENT_BUILD = "build";
    private static final String ELEMENT_COMPANY = "company";
    private static final String ATTRIBUTE_NUMBER = "number";
    private static final String ATTRIBUTE_API_VERSION = "apiVersion";
    private static final String ATTRIBUTE_DATE = "date";
    private static final String ATTRIBUTE_MAJOR_RELEASE_DATE = "majorReleaseDate";
    private static final String ELEMENT_LOGO = "logo";
    private static final String ATTRIBUTE_URL = "url";
    private static final String COPYRIGHT_START = "copyrightStart";
    private static final String ATTRIBUTE_PROGRESS_COLOR = "progressColor";
    private static final String ATTRIBUTE_ABOUT_FOREGROUND_COLOR = "foreground";
    private static final String ATTRIBUTE_ABOUT_COPYRIGHT_FOREGROUND_COLOR = "copyrightForeground";
    private static final String ATTRIBUTE_ABOUT_LINK_COLOR = "linkColor";
    private static final String ATTRIBUTE_PROGRESS_HEIGHT = "progressHeight";
    private static final String ATTRIBUTE_PROGRESS_Y = "progressY";
    private static final String ATTRIBUTE_PROGRESS_TAIL_ICON = "progressTailIcon";
    private static final String ELEMENT_ABOUT = "about";
    private static final String ELEMENT_ICON = "icon";
    private static final String ATTRIBUTE_SIZE16 = "size16";
    private static final String ATTRIBUTE_SIZE12 = "size12";
    private static final String ELEMENT_PACKAGE = "package";
    private static final String ATTRIBUTE_CODE = "code";
    private static final String ELEMENT_LICENSEE = "licensee";
    private static final String ATTRIBUTE_SHOW = "show";
    private static final String WELCOME_SCREEN_ELEMENT_NAME = "welcome-screen";
    private static final String LOGO_URL_ATTR = "logo-url";
    private static final String UPDATE_URLS_ELEMENT_NAME = "update-urls";
    private static final String ATTRIBUTE_EAP = "eap";
    private static final String HELP_ELEMENT_NAME = "help";
    private static final String ELEMENT_DOCUMENTATION = "documentation";
    private static final String ELEMENT_SUPPORT = "support";
    private static final String ELEMENT_YOUTRACK = "youtrack";
    private static final String ELEMENT_FEEDBACK = "feedback";
    private static final String ELEMENT_PLUGINS = "plugins";
    private static final String ATTRIBUTE_LIST_URL = "list-url";
    private static final String ATTRIBUTE_CHANNEL_LIST_URL = "channel-list-url";
    private static final String ATTRIBUTE_DOWNLOAD_URL = "download-url";
    private static final String ATTRIBUTE_BUILTIN_URL = "builtin-url";
    private static final String ATTRIBUTE_WEBHELP_URL = "webhelp-url";
    private static final String ATTRIBUTE_HAS_HELP = "has-help";
    private static final String ATTRIBUTE_HAS_CONTEXT_HELP = "has-context-help";
    private static final String ELEMENT_WHATS_NEW = "whatsnew";
    private static final String ELEMENT_KEYMAP = "keymap";
    private static final String ATTRIBUTE_WINDOWS_URL = "win";
    private static final String ATTRIBUTE_MAC_URL = "mac";
    private static final String ELEMENT_STATISTICS = "statistics";
    private static final String ATTRIBUTE_EVENT_LOG_STATISTICS_SETTINGS = "event-log-settings";
    private static final String ELEMENT_JB_TV = "jetbrains-tv";
    private static final String CUSTOMIZE_IDE_WIZARD_STEPS = "customize-ide-wizard";
    private static final String STEPS_PROVIDER = "provider";
    private static final String ELEMENT_EVALUATION = "evaluation";
    private static final String ATTRIBUTE_EVAL_LICENSE_URL = "license-url";
    private static final String ELEMENT_LICENSING = "licensing";
    private static final String ATTRIBUTE_KEY_CONVERSION_URL = "key-conversion-url";
    private static final String ESSENTIAL_PLUGIN = "essential-plugin";
    private static final String ELEMENT_SUBSCRIPTIONS = "subscriptions";
    private static final String ATTRIBUTE_SUBSCRIPTIONS_FORM_ID = "formid";
    private static final String ATTRIBUTE_SUBSCRIPTIONS_NEWS_KEY = "news-key";
    private static final String ATTRIBUTE_SUBSCRIPTIONS_NEWS_VALUE = "news-value";
    private static final String ATTRIBUTE_SUBSCRIPTIONS_TIPS_KEY = "tips-key";
    private static final String ATTRIBUTE_SUBSCRIPTIONS_TIPS_AVAILABLE = "tips-available";
    private static final String ATTRIBUTE_SUBSCRIPTIONS_ADDITIONAL_FORM_DATA = "additional-form-data";
    private static final String PROGRESS_SLIDE = "progressSlide";
    private static final String PROGRESS_PERCENT = "progressPercent";
    static final String DEFAULT_PLUGINS_HOST = "https://plugins.jetbrains.com";
    static final String IDEA_PLUGINS_HOST_PROPERTY = "idea.plugins.host";
    private static volatile ApplicationInfoImpl instance;
    private static volatile boolean myInStressTest;

    private ApplicationInfoImpl() {
        this(ApplicationNamesInfo.initAndGetRawData());
    }

    @NonInjectable
    ApplicationInfoImpl(@NotNull Element element) {
        Element subscriptionsElement;
        String url;
        Element licensingElement;
        String url2;
        Element evaluationElement;
        List<Element> essentialPluginsElements;
        Element whatsNewElement;
        Element feedbackElement;
        Element youtrackElement;
        Element supportElement;
        Element updateUrls;
        Element helpElement;
        Element wizardSteps;
        Element welcomeScreen;
        Element showLicensee;
        Element packageElement;
        Element iconEap;
        Element iconElement;
        Element aboutLogoElement;
        Element logoElement;
        Element buildElement;
        Element companyElement;
        if (element == null) {
            ApplicationInfoImpl.$$$reportNull$$$0(0);
        }
        this.myCompanyName = "JetBrains s.r.o.";
        this.myCopyrightStart = "2000";
        this.myCompanyUrl = "https://www.jetbrains.com/";
        this.myProgressColor = -1L;
        this.myCopyrightForeground = -1L;
        this.myAboutForeground = -1L;
        this.myAboutLinkColor = -1L;
        this.myProgressHeight = 2;
        this.myProgressY = 350;
        this.myIconUrl = "/icon.png";
        this.mySmallIconUrl = "/icon_small.png";
        this.myToolWindowIconUrl = "/toolwindows/toolWindowProject.png";
        this.myShowLicensee = true;
        this.myHasHelp = true;
        this.myHasContextHelp = true;
        this.myWebHelpUrl = "https://www.jetbrains.com/idea/webhelp/";
        this.myEvalLicenseUrl = "https://www.jetbrains.com/store/license.html";
        this.myKeyConversionUrl = "https://www.jetbrains.com/shop/eform/keys-exchange";
        this.myProgressSlides = new ArrayList<ProgressSlide>();
        Element versionElement = ApplicationInfoImpl.getChild(element, ELEMENT_VERSION);
        if (versionElement != null) {
            this.myMajorVersion = versionElement.getAttributeValue(ATTRIBUTE_MAJOR);
            this.myMinorVersion = versionElement.getAttributeValue(ATTRIBUTE_MINOR);
            this.myMicroVersion = versionElement.getAttributeValue(ATTRIBUTE_MICRO);
            this.myPatchVersion = versionElement.getAttributeValue(ATTRIBUTE_PATCH);
            this.myFullVersionFormat = versionElement.getAttributeValue(ATTRIBUTE_FULL);
            this.myCodeName = versionElement.getAttributeValue(ATTRIBUTE_CODENAME);
            this.myEAP = Boolean.parseBoolean(versionElement.getAttributeValue(ATTRIBUTE_EAP));
            this.myVersionSuffix = versionElement.getAttributeValue("suffix");
            if (this.myVersionSuffix == null && this.myEAP) {
                this.myVersionSuffix = "EAP";
            }
        }
        if ((companyElement = ApplicationInfoImpl.getChild(element, ELEMENT_COMPANY)) != null) {
            this.myCompanyName = companyElement.getAttributeValue(ATTRIBUTE_NAME, this.myCompanyName);
            this.myShortCompanyName = companyElement.getAttributeValue("shortName", ApplicationInfoImpl.shortenCompanyName(this.myCompanyName));
            this.myCompanyUrl = companyElement.getAttributeValue(ATTRIBUTE_URL, this.myCompanyUrl);
            this.myCopyrightStart = companyElement.getAttributeValue(COPYRIGHT_START, this.myCopyrightStart);
        }
        if ((buildElement = ApplicationInfoImpl.getChild(element, ELEMENT_BUILD)) != null) {
            this.readBuildInfo(buildElement);
        }
        if ((logoElement = ApplicationInfoImpl.getChild(element, ELEMENT_LOGO)) != null) {
            this.readLogoInfo(logoElement);
        }
        if ((aboutLogoElement = ApplicationInfoImpl.getChild(element, ELEMENT_ABOUT)) != null) {
            String c;
            this.myAboutImageUrl = aboutLogoElement.getAttributeValue(ATTRIBUTE_URL);
            String v = aboutLogoElement.getAttributeValue(ATTRIBUTE_ABOUT_FOREGROUND_COLOR);
            if (v != null) {
                this.myAboutForeground = ApplicationInfoImpl.parseColor(v);
            }
            if ((v = aboutLogoElement.getAttributeValue(ATTRIBUTE_ABOUT_COPYRIGHT_FOREGROUND_COLOR)) != null) {
                this.myCopyrightForeground = ApplicationInfoImpl.parseColor(v);
            }
            if ((c = aboutLogoElement.getAttributeValue(ATTRIBUTE_ABOUT_LINK_COLOR)) != null) {
                this.myAboutLinkColor = ApplicationInfoImpl.parseColor(c);
            }
            String logoX = aboutLogoElement.getAttributeValue("logoX");
            String logoY = aboutLogoElement.getAttributeValue("logoY");
            String logoW = aboutLogoElement.getAttributeValue("logoW");
            String logoH = aboutLogoElement.getAttributeValue("logoH");
            if (logoX != null && logoY != null && logoW != null && logoH != null) {
                try {
                    this.myAboutLogoRect = new int[]{Integer.parseInt(logoX), Integer.parseInt(logoY), Integer.parseInt(logoW), Integer.parseInt(logoH)};
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        if ((iconElement = ApplicationInfoImpl.getChild(element, ELEMENT_ICON)) != null) {
            this.myIconUrl = iconElement.getAttributeValue("size32");
            this.mySmallIconUrl = iconElement.getAttributeValue(ATTRIBUTE_SIZE16, this.mySmallIconUrl);
            this.myBigIconUrl = ApplicationInfoImpl.getAttributeValue(iconElement, "size128");
            String toolWindowIcon = ApplicationInfoImpl.getAttributeValue(iconElement, ATTRIBUTE_SIZE12);
            if (toolWindowIcon != null) {
                this.myToolWindowIconUrl = toolWindowIcon;
            }
            this.mySvgIconUrl = iconElement.getAttributeValue("svg");
            this.mySmallSvgIconUrl = iconElement.getAttributeValue("svg-small");
        }
        if ((iconEap = ApplicationInfoImpl.getChild(element, "icon-eap")) != null) {
            this.mySvgEapIconUrl = iconEap.getAttributeValue("svg");
            this.mySmallSvgEapIconUrl = iconEap.getAttributeValue("svg-small");
        }
        if ((packageElement = ApplicationInfoImpl.getChild(element, ELEMENT_PACKAGE)) != null) {
            this.myPackageCode = packageElement.getAttributeValue(ATTRIBUTE_CODE);
        }
        if ((showLicensee = ApplicationInfoImpl.getChild(element, ELEMENT_LICENSEE)) != null) {
            this.myShowLicensee = Boolean.parseBoolean(showLicensee.getAttributeValue(ATTRIBUTE_SHOW));
        }
        if ((welcomeScreen = ApplicationInfoImpl.getChild(element, WELCOME_SCREEN_ELEMENT_NAME)) != null) {
            this.myWelcomeScreenLogoUrl = welcomeScreen.getAttributeValue(LOGO_URL_ATTR);
        }
        if ((wizardSteps = ApplicationInfoImpl.getChild(element, CUSTOMIZE_IDE_WIZARD_STEPS)) != null) {
            this.myCustomizeIDEWizardStepsProvider = wizardSteps.getAttributeValue(STEPS_PROVIDER);
        }
        if ((helpElement = ApplicationInfoImpl.getChild(element, HELP_ELEMENT_NAME)) != null) {
            String attValue;
            String webHelpUrl = ApplicationInfoImpl.getAttributeValue(helpElement, ATTRIBUTE_WEBHELP_URL);
            if (webHelpUrl != null) {
                this.myWebHelpUrl = webHelpUrl;
            }
            this.myHasHelp = (attValue = helpElement.getAttributeValue(ATTRIBUTE_HAS_HELP)) == null || Boolean.parseBoolean(attValue);
            attValue = helpElement.getAttributeValue(ATTRIBUTE_HAS_CONTEXT_HELP);
            this.myHasContextHelp = attValue == null || Boolean.parseBoolean(attValue);
        }
        this.myUpdateUrls = (updateUrls = ApplicationInfoImpl.getChild(element, UPDATE_URLS_ELEMENT_NAME)) == null ? null : new UpdateUrlsImpl(updateUrls);
        Element documentationElement = ApplicationInfoImpl.getChild(element, ELEMENT_DOCUMENTATION);
        if (documentationElement != null) {
            this.myDocumentationUrl = documentationElement.getAttributeValue(ATTRIBUTE_URL);
        }
        if ((supportElement = ApplicationInfoImpl.getChild(element, ELEMENT_SUPPORT)) != null) {
            this.mySupportUrl = supportElement.getAttributeValue(ATTRIBUTE_URL);
        }
        if ((youtrackElement = ApplicationInfoImpl.getChild(element, ELEMENT_YOUTRACK)) != null) {
            this.myYoutrackUrl = youtrackElement.getAttributeValue(ATTRIBUTE_URL);
        }
        if ((feedbackElement = ApplicationInfoImpl.getChild(element, ELEMENT_FEEDBACK)) != null) {
            this.myFeedbackUrl = feedbackElement.getAttributeValue(ATTRIBUTE_URL);
        }
        if ((whatsNewElement = ApplicationInfoImpl.getChild(element, ELEMENT_WHATS_NEW)) != null) {
            this.myWhatsNewUrl = whatsNewElement.getAttributeValue(ATTRIBUTE_URL);
        }
        this.readPluginInfo(ApplicationInfoImpl.getChild(element, ELEMENT_PLUGINS));
        Element keymapElement = ApplicationInfoImpl.getChild(element, ELEMENT_KEYMAP);
        if (keymapElement != null) {
            this.myWinKeymapUrl = keymapElement.getAttributeValue(ATTRIBUTE_WINDOWS_URL);
            this.myMacKeymapUrl = keymapElement.getAttributeValue(ATTRIBUTE_MAC_URL);
        }
        if ((essentialPluginsElements = ApplicationInfoImpl.getChildren(element, ESSENTIAL_PLUGIN)).isEmpty()) {
            this.myEssentialPluginsIds = Collections.emptyList();
        } else {
            ArrayList<PluginId> essentialPluginsIds = new ArrayList<PluginId>(essentialPluginsElements.size());
            for (Element element1 : essentialPluginsElements) {
                String id = element1.getTextTrim();
                if (id.isEmpty()) continue;
                essentialPluginsIds.add(PluginId.getId(id));
            }
            essentialPluginsIds.sort(null);
            this.myEssentialPluginsIds = Collections.unmodifiableList(essentialPluginsIds);
        }
        Element statisticsElement = ApplicationInfoImpl.getChild(element, ELEMENT_STATISTICS);
        this.myEventLogSettingsUrl = statisticsElement != null ? statisticsElement.getAttributeValue(ATTRIBUTE_EVENT_LOG_STATISTICS_SETTINGS) : "https://resources.jetbrains.com/storage/fus/config/v3/%s/%s.json";
        Element tvElement = ApplicationInfoImpl.getChild(element, ELEMENT_JB_TV);
        if (tvElement != null) {
            this.myJetBrainsTvUrl = tvElement.getAttributeValue(ATTRIBUTE_URL);
        }
        if ((evaluationElement = ApplicationInfoImpl.getChild(element, ELEMENT_EVALUATION)) != null && (url2 = ApplicationInfoImpl.getAttributeValue(evaluationElement, ATTRIBUTE_EVAL_LICENSE_URL)) != null) {
            this.myEvalLicenseUrl = url2.trim();
        }
        if ((licensingElement = ApplicationInfoImpl.getChild(element, ELEMENT_LICENSING)) != null && (url = ApplicationInfoImpl.getAttributeValue(licensingElement, ATTRIBUTE_KEY_CONVERSION_URL)) != null) {
            this.myKeyConversionUrl = url.trim();
        }
        if ((subscriptionsElement = ApplicationInfoImpl.getChild(element, ELEMENT_SUBSCRIPTIONS)) != null) {
            this.mySubscriptionFormId = subscriptionsElement.getAttributeValue(ATTRIBUTE_SUBSCRIPTIONS_FORM_ID);
            this.mySubscriptionNewsKey = subscriptionsElement.getAttributeValue(ATTRIBUTE_SUBSCRIPTIONS_NEWS_KEY);
            this.mySubscriptionNewsValue = subscriptionsElement.getAttributeValue(ATTRIBUTE_SUBSCRIPTIONS_NEWS_VALUE, "yes");
            this.mySubscriptionTipsKey = subscriptionsElement.getAttributeValue(ATTRIBUTE_SUBSCRIPTIONS_TIPS_KEY);
            this.mySubscriptionTipsAvailable = Boolean.parseBoolean(subscriptionsElement.getAttributeValue(ATTRIBUTE_SUBSCRIPTIONS_TIPS_AVAILABLE));
            this.mySubscriptionAdditionalFormData = subscriptionsElement.getAttributeValue(ATTRIBUTE_SUBSCRIPTIONS_ADDITIONAL_FORM_DATA);
        }
    }

    private void readLogoInfo(@NotNull Element element) {
        if (element == null) {
            ApplicationInfoImpl.$$$reportNull$$$0(1);
        }
        this.mySplashImageUrl = ApplicationInfoImpl.getAttributeValue(element, ATTRIBUTE_URL);
        String v = ApplicationInfoImpl.getAttributeValue(element, ATTRIBUTE_PROGRESS_COLOR);
        if (v != null) {
            this.myProgressColor = ApplicationInfoImpl.parseColor(v);
        }
        if ((v = ApplicationInfoImpl.getAttributeValue(element, ATTRIBUTE_PROGRESS_TAIL_ICON)) != null) {
            this.myProgressTailIconName = v;
        }
        if ((v = ApplicationInfoImpl.getAttributeValue(element, ATTRIBUTE_PROGRESS_HEIGHT)) != null) {
            this.myProgressHeight = Integer.parseInt(v);
        }
        if ((v = ApplicationInfoImpl.getAttributeValue(element, ATTRIBUTE_PROGRESS_Y)) != null) {
            this.myProgressY = Integer.parseInt(v);
        }
        for (Element child : ApplicationInfoImpl.getChildren(element, PROGRESS_SLIDE)) {
            String slideUrl = child.getAttributeValue(ATTRIBUTE_URL);
            assert (slideUrl != null);
            String progressPercentString = child.getAttributeValue(PROGRESS_PERCENT);
            assert (progressPercentString != null);
            int progressPercentInt = Integer.parseInt(progressPercentString);
            assert (progressPercentInt <= 100 && progressPercentInt >= 0);
            float progressPercentFloat = (float)progressPercentInt / 100.0f;
            this.myProgressSlides.add(new ProgressSlide(slideUrl, progressPercentFloat));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static ApplicationInfoEx getShadowInstance() {
        ApplicationInfoImpl result = instance;
        if (result != null) {
            ApplicationInfoImpl applicationInfoImpl = result;
            if (applicationInfoImpl == null) {
                ApplicationInfoImpl.$$$reportNull$$$0(2);
            }
            return applicationInfoImpl;
        }
        Class<ApplicationInfoImpl> clazz = ApplicationInfoImpl.class;
        synchronized (ApplicationInfoImpl.class) {
            result = instance;
            if (result == null) {
                Activity activity = StartUpMeasurer.startActivity("app info loading");
                try {
                    instance = result = new ApplicationInfoImpl(ApplicationNamesInfo.initAndGetRawData());
                }
                finally {
                    activity.end();
                }
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            ApplicationInfoImpl applicationInfoImpl = result;
            if (applicationInfoImpl == null) {
                ApplicationInfoImpl.$$$reportNull$$$0(3);
            }
            return applicationInfoImpl;
        }
    }

    @Override
    public Calendar getBuildDate() {
        return this.myBuildDate;
    }

    @Override
    public Calendar getMajorReleaseBuildDate() {
        return this.myMajorReleaseBuildDate != null ? this.myMajorReleaseBuildDate : this.myBuildDate;
    }

    @Override
    @NotNull
    public BuildNumber getBuild() {
        BuildNumber buildNumber = Objects.requireNonNull(BuildNumber.fromString(this.myBuildNumber));
        if (buildNumber == null) {
            ApplicationInfoImpl.$$$reportNull$$$0(4);
        }
        return buildNumber;
    }

    @Override
    @NotNull
    public String getApiVersion() {
        String string = this.getApiVersionAsNumber().asString();
        if (string == null) {
            ApplicationInfoImpl.$$$reportNull$$$0(5);
        }
        return string;
    }

    @Override
    @NotNull
    public BuildNumber getApiVersionAsNumber() {
        BuildNumber api;
        BuildNumber build = this.getBuild();
        if (this.myApiVersion != null && (api = BuildNumber.fromStringWithProductCode(this.myApiVersion, build.getProductCode())) != null) {
            BuildNumber buildNumber = api;
            if (buildNumber == null) {
                ApplicationInfoImpl.$$$reportNull$$$0(6);
            }
            return buildNumber;
        }
        BuildNumber buildNumber = build;
        if (buildNumber == null) {
            ApplicationInfoImpl.$$$reportNull$$$0(7);
        }
        return buildNumber;
    }

    @Override
    public String getMajorVersion() {
        return this.myMajorVersion;
    }

    @Override
    public String getMinorVersion() {
        return this.myMinorVersion;
    }

    @Override
    public String getMicroVersion() {
        return this.myMicroVersion;
    }

    @Override
    public String getPatchVersion() {
        return this.myPatchVersion;
    }

    @Override
    @NotNull
    public String getFullVersion() {
        String result = this.myFullVersionFormat != null ? MessageFormat.format(this.myFullVersionFormat, this.myMajorVersion, this.myMinorVersion, this.myMicroVersion, this.myPatchVersion) : StringUtilRt.notNullize(this.myMajorVersion, "0") + '.' + StringUtilRt.notNullize(this.myMinorVersion, "0");
        if (!StringUtilRt.isEmpty(this.myVersionSuffix)) {
            result = result + " " + this.myVersionSuffix;
        }
        String string = result;
        if (string == null) {
            ApplicationInfoImpl.$$$reportNull$$$0(8);
        }
        return string;
    }

    @Override
    @NotNull
    public String getStrictVersion() {
        String string = this.myMajorVersion + "." + this.myMinorVersion + "." + StringUtilRt.notNullize(this.myMicroVersion, "0") + "." + StringUtilRt.notNullize(this.myPatchVersion, "0");
        if (string == null) {
            ApplicationInfoImpl.$$$reportNull$$$0(9);
        }
        return string;
    }

    @Override
    public String getVersionName() {
        String fullName = ApplicationNamesInfo.getInstance().getFullProductName();
        if (this.myEAP && !StringUtilRt.isEmptyOrSpaces(this.myCodeName)) {
            fullName = fullName + " (" + this.myCodeName + ")";
        }
        return fullName;
    }

    @Override
    public String getShortCompanyName() {
        return this.myShortCompanyName;
    }

    @Override
    public String getCompanyName() {
        return this.myCompanyName;
    }

    @Override
    public String getCompanyURL() {
        return IdeUrlTrackingParametersProvider.getInstance().augmentUrl(this.myCompanyUrl);
    }

    @Override
    public String getSplashImageUrl() {
        return this.mySplashImageUrl;
    }

    @Override
    public String getAboutImageUrl() {
        return this.myAboutImageUrl;
    }

    @Override
    public long getProgressColor() {
        return this.myProgressColor;
    }

    @Override
    public long getCopyrightForeground() {
        return this.myCopyrightForeground;
    }

    @Override
    public int getProgressHeight() {
        return this.myProgressHeight;
    }

    @Override
    public int getProgressY() {
        return this.myProgressY;
    }

    @Override
    @Nullable
    public String getProgressTailIcon() {
        return this.myProgressTailIconName;
    }

    @Override
    public String getIconUrl() {
        return this.myIconUrl;
    }

    @Override
    @NotNull
    public String getSmallIconUrl() {
        String string = this.mySmallIconUrl;
        if (string == null) {
            ApplicationInfoImpl.$$$reportNull$$$0(10);
        }
        return string;
    }

    @Override
    @Nullable
    public String getBigIconUrl() {
        return this.myBigIconUrl;
    }

    @Override
    @Nullable
    public String getApplicationSvgIconUrl() {
        return this.isEAP() && this.mySvgEapIconUrl != null ? this.mySvgEapIconUrl : this.mySvgIconUrl;
    }

    @Override
    @Nullable
    public String getSmallApplicationSvgIconUrl() {
        return this.isEAP() && this.mySmallSvgEapIconUrl != null ? this.mySmallSvgEapIconUrl : this.mySmallSvgIconUrl;
    }

    @Override
    public String getToolWindowIconUrl() {
        return this.myToolWindowIconUrl;
    }

    @Override
    @Nullable
    public String getWelcomeScreenLogoUrl() {
        return this.myWelcomeScreenLogoUrl;
    }

    @Override
    @Nullable
    public String getCustomizeIDEWizardStepsProvider() {
        return this.myCustomizeIDEWizardStepsProvider;
    }

    @Override
    public String getPackageCode() {
        return this.myPackageCode;
    }

    @Override
    public boolean isEAP() {
        return this.myEAP;
    }

    @Override
    public boolean isMajorEAP() {
        return this.myEAP && (this.myMinorVersion == null || this.myMinorVersion.indexOf(46) < 0);
    }

    @Override
    @Nullable
    public ApplicationInfoEx.UpdateUrls getUpdateUrls() {
        return this.myUpdateUrls;
    }

    @Override
    public String getDocumentationUrl() {
        return this.myDocumentationUrl;
    }

    @Override
    public String getSupportUrl() {
        return this.mySupportUrl;
    }

    @Override
    public String getYoutrackUrl() {
        return this.myYoutrackUrl;
    }

    @Override
    public String getFeedbackUrl() {
        return this.myFeedbackUrl;
    }

    @Override
    public String getPluginManagerUrl() {
        return this.myPluginManagerUrl;
    }

    @Override
    public boolean usesJetBrainsPluginRepository() {
        return DEFAULT_PLUGINS_HOST.equalsIgnoreCase(this.myPluginManagerUrl);
    }

    @Override
    public String getPluginsListUrl() {
        return this.myPluginsListUrl;
    }

    @Override
    public String getChannelsListUrl() {
        return this.myChannelsListUrl;
    }

    @Override
    public String getPluginsDownloadUrl() {
        return this.myPluginsDownloadUrl;
    }

    @Override
    public String getBuiltinPluginsUrl() {
        return this.myBuiltinPluginsUrl;
    }

    @Override
    public String getWebHelpUrl() {
        return this.myWebHelpUrl;
    }

    @Override
    public boolean hasHelp() {
        return this.myHasHelp;
    }

    @Override
    public boolean hasContextHelp() {
        return this.myHasContextHelp;
    }

    @Override
    public String getWhatsNewUrl() {
        return this.myWhatsNewUrl;
    }

    @Override
    public String getWinKeymapUrl() {
        return this.myWinKeymapUrl;
    }

    @Override
    public String getMacKeymapUrl() {
        return this.myMacKeymapUrl;
    }

    @Override
    public long getAboutForeground() {
        return this.myAboutForeground;
    }

    public long getAboutLinkColor() {
        return this.myAboutLinkColor;
    }

    @Override
    public String getFullApplicationName() {
        return this.getVersionName() + " " + this.getFullVersion();
    }

    @Override
    public boolean showLicenseeInfo() {
        return this.myShowLicensee;
    }

    public String getCopyrightStart() {
        return this.myCopyrightStart;
    }

    public String getEventLogSettingsUrl() {
        return this.myEventLogSettingsUrl;
    }

    @Override
    public String getJetBrainsTvUrl() {
        return this.myJetBrainsTvUrl;
    }

    @Override
    public String getEvalLicenseUrl() {
        return this.myEvalLicenseUrl;
    }

    @Override
    public String getKeyConversionUrl() {
        return this.myKeyConversionUrl;
    }

    @Override
    @Nullable
    public int[] getAboutLogoRect() {
        return this.myAboutLogoRect;
    }

    @Override
    public String getSubscriptionFormId() {
        return this.mySubscriptionFormId;
    }

    @Override
    public String getSubscriptionNewsKey() {
        return this.mySubscriptionNewsKey;
    }

    @Override
    public String getSubscriptionNewsValue() {
        return this.mySubscriptionNewsValue;
    }

    @Override
    public String getSubscriptionTipsKey() {
        return this.mySubscriptionTipsKey;
    }

    @Override
    public boolean areSubscriptionTipsAvailable() {
        return this.mySubscriptionTipsAvailable;
    }

    @Override
    @Nullable
    public String getSubscriptionAdditionalFormData() {
        return this.mySubscriptionAdditionalFormData;
    }

    @Override
    public List<ProgressSlide> getProgressSlides() {
        return this.myProgressSlides;
    }

    @Nullable
    private static String getAttributeValue(@NotNull Element element, @NotNull String name) {
        String value;
        if (element == null) {
            ApplicationInfoImpl.$$$reportNull$$$0(11);
        }
        if (name == null) {
            ApplicationInfoImpl.$$$reportNull$$$0(12);
        }
        return (value = element.getAttributeValue(name)) == null || value.isEmpty() ? null : value;
    }

    private void readBuildInfo(@NotNull Element element) {
        String majorReleaseDateString;
        if (element == null) {
            ApplicationInfoImpl.$$$reportNull$$$0(13);
        }
        this.myBuildNumber = ApplicationInfoImpl.getAttributeValue(element, ATTRIBUTE_NUMBER);
        this.myApiVersion = ApplicationInfoImpl.getAttributeValue(element, ATTRIBUTE_API_VERSION);
        String dateString = element.getAttributeValue(ATTRIBUTE_DATE);
        if ("__BUILD_DATE__".equals(dateString)) {
            this.myBuildDate = new GregorianCalendar();
            try (JarFile bootstrapJar2 = new JarFile(PathManager.getHomePath() + "/lib/bootstrap.jar");){
                JarEntry jarEntry = bootstrapJar2.entries().nextElement();
                this.myBuildDate.setTime(new Date(jarEntry.getTime()));
            }
            catch (Exception bootstrapJar2) {}
        } else {
            this.myBuildDate = dateString == null ? Calendar.getInstance() : ApplicationInfoImpl.parseDate(dateString);
        }
        if ((majorReleaseDateString = element.getAttributeValue(ATTRIBUTE_MAJOR_RELEASE_DATE)) != null) {
            this.myMajorReleaseBuildDate = ApplicationInfoImpl.parseDate(majorReleaseDateString);
        }
    }

    private void readPluginInfo(@Nullable Element element) {
        String pluginsHost;
        String pluginManagerUrl = DEFAULT_PLUGINS_HOST;
        String pluginsListUrl = null;
        this.myChannelsListUrl = null;
        this.myPluginsDownloadUrl = null;
        if (element != null) {
            String builtinPluginsUrl;
            String downloadUrl;
            String channelListUrl;
            String listUrl;
            String url = element.getAttributeValue(ATTRIBUTE_URL);
            if (url != null) {
                String string = pluginManagerUrl = url.endsWith("/") ? url.substring(0, url.length() - 1) : url;
            }
            if ((listUrl = element.getAttributeValue(ATTRIBUTE_LIST_URL)) != null) {
                pluginsListUrl = listUrl;
            }
            if ((channelListUrl = element.getAttributeValue(ATTRIBUTE_CHANNEL_LIST_URL)) != null) {
                this.myChannelsListUrl = channelListUrl;
            }
            if ((downloadUrl = element.getAttributeValue(ATTRIBUTE_DOWNLOAD_URL)) != null) {
                this.myPluginsDownloadUrl = downloadUrl;
            }
            if (StringUtil.isNotEmpty(builtinPluginsUrl = element.getAttributeValue(ATTRIBUTE_BUILTIN_URL))) {
                this.myBuiltinPluginsUrl = builtinPluginsUrl;
            }
        }
        if ((pluginsHost = System.getProperty(IDEA_PLUGINS_HOST_PROPERTY)) != null) {
            pluginManagerUrl = pluginsHost.endsWith("/") ? pluginsHost.substring(0, pluginsHost.length() - 1) : pluginsHost;
            this.myPluginsDownloadUrl = null;
            this.myChannelsListUrl = null;
            pluginsListUrl = null;
        }
        this.myPluginManagerUrl = pluginManagerUrl;
        String string = this.myPluginsListUrl = pluginsListUrl == null ? pluginManagerUrl + "/plugins/list/" : pluginsListUrl;
        if (this.myChannelsListUrl == null) {
            this.myChannelsListUrl = pluginManagerUrl + "/channels/list/";
        }
        if (this.myPluginsDownloadUrl == null) {
            this.myPluginsDownloadUrl = pluginManagerUrl + "/pluginManager/";
        }
    }

    @NotNull
    private static List<Element> getChildren(@NotNull Element parentNode, @NotNull String name) {
        if (parentNode == null) {
            ApplicationInfoImpl.$$$reportNull$$$0(14);
        }
        if (name == null) {
            ApplicationInfoImpl.$$$reportNull$$$0(15);
        }
        List<Element> list = parentNode.getChildren(name, parentNode.getNamespace());
        if (list == null) {
            ApplicationInfoImpl.$$$reportNull$$$0(16);
        }
        return list;
    }

    private static Element getChild(@NotNull Element parentNode, @NotNull String name) {
        if (parentNode == null) {
            ApplicationInfoImpl.$$$reportNull$$$0(17);
        }
        if (name == null) {
            ApplicationInfoImpl.$$$reportNull$$$0(18);
        }
        return parentNode.getChild(name, parentNode.getNamespace());
    }

    static String shortenCompanyName(@NotNull String name) {
        if (name == null) {
            ApplicationInfoImpl.$$$reportNull$$$0(19);
        }
        if (name.endsWith(" s.r.o.")) {
            name = name.substring(0, name.length() - " s.r.o.".length());
        }
        if (name.endsWith(" Inc.")) {
            name = name.substring(0, name.length() - " Inc.".length());
        }
        return name;
    }

    @NotNull
    private static GregorianCalendar parseDate(@NotNull String dateString) {
        if (dateString == null) {
            ApplicationInfoImpl.$$$reportNull$$$0(20);
        }
        GregorianCalendar calendar = new GregorianCalendar(TimeZone.getTimeZone("UTC"));
        try {
            calendar.set(1, Integer.parseInt(dateString.substring(0, 4)));
            calendar.set(2, Integer.parseInt(dateString.substring(4, 6)) - 1);
            calendar.set(5, Integer.parseInt(dateString.substring(6, 8)));
            if (dateString.length() > 8) {
                calendar.set(11, Integer.parseInt(dateString.substring(8, 10)));
                calendar.set(12, Integer.parseInt(dateString.substring(10, 12)));
            } else {
                calendar.set(11, 0);
                calendar.set(12, 0);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        GregorianCalendar gregorianCalendar = calendar;
        if (gregorianCalendar == null) {
            ApplicationInfoImpl.$$$reportNull$$$0(21);
        }
        return gregorianCalendar;
    }

    public static long parseColor(@NotNull String colorString) {
        if (colorString == null) {
            ApplicationInfoImpl.$$$reportNull$$$0(22);
        }
        return Long.parseLong(colorString, 16);
    }

    @Override
    public boolean isEssentialPlugin(@NotNull String pluginId) {
        if (pluginId == null) {
            ApplicationInfoImpl.$$$reportNull$$$0(23);
        }
        return "sqldelight.com.intellij".equals(pluginId) || this.isEssentialPlugin(PluginId.getId(pluginId));
    }

    @Override
    public boolean isEssentialPlugin(@NotNull PluginId pluginId) {
        if (pluginId == null) {
            ApplicationInfoImpl.$$$reportNull$$$0(24);
        }
        return PluginManagerCore.CORE_ID == pluginId || Collections.binarySearch(this.myEssentialPluginsIds, pluginId) >= 0;
    }

    @NotNull
    public List<PluginId> getEssentialPluginsIds() {
        List<PluginId> list = this.myEssentialPluginsIds;
        if (list == null) {
            ApplicationInfoImpl.$$$reportNull$$$0(25);
        }
        return list;
    }

    public static boolean isInStressTest() {
        return myInStressTest;
    }

    public static void setInStressTest(boolean inStressTest) {
        myInStressTest = inStressTest;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 16: 
            case 21: 
            case 25: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 16: 
            case 21: 
            case 25: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 16: 
            case 21: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sqldelight/com/intellij/openapi/application/impl/ApplicationInfoImpl";
                break;
            }
            case 12: 
            case 15: 
            case 18: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = ATTRIBUTE_NAME;
                break;
            }
            case 14: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentNode";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dateString";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "colorString";
                break;
            }
            case 23: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "sqldelight/com/intellij/openapi/application/impl/ApplicationInfoImpl";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getShadowInstance";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getBuild";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getApiVersion";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getApiVersionAsNumber";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getFullVersion";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getStrictVersion";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getSmallIconUrl";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "parseDate";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getEssentialPluginsIds";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "readLogoInfo";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 16: 
            case 21: 
            case 25: {
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getAttributeValue";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "readBuildInfo";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getChildren";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getChild";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "shortenCompanyName";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "parseDate";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "parseColor";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "isEssentialPlugin";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 16: 
            case 21: 
            case 25: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class UpdateUrlsImpl
    implements ApplicationInfoEx.UpdateUrls {
        private final String myCheckingUrl;
        private final String myPatchesUrl;

        private UpdateUrlsImpl(@NotNull Element element) {
            if (element == null) {
                UpdateUrlsImpl.$$$reportNull$$$0(0);
            }
            this.myCheckingUrl = element.getAttributeValue("check");
            this.myPatchesUrl = element.getAttributeValue("patches");
        }

        @Override
        public String getCheckingUrl() {
            return this.myCheckingUrl;
        }

        @Override
        public String getPatchesUrl() {
            return this.myPatchesUrl;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "sqldelight/com/intellij/openapi/application/impl/ApplicationInfoImpl$UpdateUrlsImpl", "<init>"));
        }
    }
}

