/*
 * Decompiled with CFR 0.152.
 */
package sqldelight.com.intellij.openapi.editor.event;

import java.util.EventObject;
import sqldelight.com.intellij.openapi.editor.Editor;
import sqldelight.com.intellij.openapi.util.Pair;
import sqldelight.com.intellij.openapi.util.TextRange;

public class SelectionEvent
extends EventObject {
    private final Pair<TextRange[], TextRange> myOldRanges;
    private final Pair<TextRange[], TextRange> myNewRanges;

    public SelectionEvent(Editor editor, int[] oldSelectionStarts, int[] oldSelectionEnds, int[] newSelectionStarts, int[] newSelectionEnds) {
        super(editor);
        SelectionEvent.assertCorrectSelection(oldSelectionStarts, oldSelectionEnds);
        SelectionEvent.assertCorrectSelection(newSelectionStarts, newSelectionEnds);
        this.myOldRanges = SelectionEvent.getRanges(oldSelectionStarts, oldSelectionEnds);
        this.myNewRanges = SelectionEvent.getRanges(newSelectionStarts, newSelectionEnds);
    }

    public SelectionEvent(Editor editor, int oldStart, int oldEnd, int newStart, int newEnd) {
        this(editor, new int[]{oldStart}, new int[]{oldEnd}, new int[]{newStart}, new int[]{newEnd});
    }

    private static void assertCorrectSelection(int[] starts, int[] ends) {
        assert (starts.length == ends.length);
    }

    public Editor getEditor() {
        return (Editor)this.getSource();
    }

    public TextRange getOldRange() {
        return (TextRange)this.myOldRanges.second;
    }

    public TextRange getNewRange() {
        return (TextRange)this.myNewRanges.second;
    }

    public TextRange[] getOldRanges() {
        return (TextRange[])this.myOldRanges.first;
    }

    public TextRange[] getNewRanges() {
        return (TextRange[])this.myNewRanges.first;
    }

    private static Pair<TextRange[], TextRange> getRanges(int[] starts, int[] ends) {
        if (starts.length == 0) {
            return Pair.create(TextRange.EMPTY_ARRAY, TextRange.EMPTY_RANGE);
        }
        TextRange[] ranges = new TextRange[starts.length];
        int startOffset = Integer.MAX_VALUE;
        int endOffset = Integer.MIN_VALUE;
        for (int i = 0; i < starts.length; ++i) {
            int start = starts[i];
            int end = ends[i];
            ranges[i] = new TextRange(start, end);
            startOffset = Math.min(startOffset, start);
            endOffset = Math.max(endOffset, end);
        }
        return Pair.create(ranges, new TextRange(startOffset, endOffset));
    }
}

