/*
 * Decompiled with CFR 0.152.
 */
package sqldelight.com.intellij.openapi.extensions.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import sqldelight.com.intellij.diagnostic.ActivityCategory;
import sqldelight.com.intellij.diagnostic.StartUpMeasurer;
import sqldelight.com.intellij.openapi.Disposable;
import sqldelight.com.intellij.openapi.components.ComponentManager;
import sqldelight.com.intellij.openapi.diagnostic.Logger;
import sqldelight.com.intellij.openapi.extensions.ExtensionException;
import sqldelight.com.intellij.openapi.extensions.ExtensionNotApplicableException;
import sqldelight.com.intellij.openapi.extensions.ExtensionPoint;
import sqldelight.com.intellij.openapi.extensions.ExtensionPointAdapter;
import sqldelight.com.intellij.openapi.extensions.ExtensionPointAndAreaListener;
import sqldelight.com.intellij.openapi.extensions.ExtensionPointChangeListener;
import sqldelight.com.intellij.openapi.extensions.ExtensionPointListener;
import sqldelight.com.intellij.openapi.extensions.ExtensionPointPriorityListener;
import sqldelight.com.intellij.openapi.extensions.ExtensionsArea;
import sqldelight.com.intellij.openapi.extensions.LoadingOrder;
import sqldelight.com.intellij.openapi.extensions.PluginDescriptor;
import sqldelight.com.intellij.openapi.extensions.impl.BeanExtensionPoint;
import sqldelight.com.intellij.openapi.extensions.impl.ExtensionComponentAdapter;
import sqldelight.com.intellij.openapi.progress.ProcessCanceledException;
import sqldelight.com.intellij.openapi.util.Disposer;
import sqldelight.com.intellij.openapi.util.EmptyRunnable;
import sqldelight.com.intellij.util.ArrayFactory;
import sqldelight.com.intellij.util.ArrayUtil;
import sqldelight.com.intellij.util.ArrayUtilRt;
import sqldelight.com.intellij.util.ThreeState;
import sqldelight.com.intellij.util.containers.ContainerUtil;
import sqldelight.com.intellij.util.pico.DefaultPicoContainer;
import sqldelight.it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import sqldelight.org.jdom.Element;
import sqldelight.org.jetbrains.annotations.ApiStatus;
import sqldelight.org.jetbrains.annotations.NotNull;
import sqldelight.org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public abstract class ExtensionPointImpl<@NotNull T>
implements ExtensionPoint<T>,
Iterable<T> {
    private static final ExtensionPointListener<?>[] EMPTY_ARRAY = new ExtensionPointListener[0];
    static final Logger LOG = Logger.getInstance(ExtensionPointImpl.class);
    private static Set<ExtensionPointImpl<?>> POINTS_IN_READONLY_MODE;
    private static final ArrayFactory<ExtensionPointListener<?>> LISTENER_ARRAY_FACTORY;
    private final String myName;
    private final String myClassName;
    private volatile List<T> myExtensionsCache;
    private volatile T @Nullable [] myExtensionsCacheAsArray;
    private ComponentManager componentManager;
    @NotNull
    protected final PluginDescriptor pluginDescriptor;
    @NotNull
    private volatile List<ExtensionComponentAdapter> myAdapters;
    private volatile boolean adaptersIsSorted;
    private ExtensionPointListener<T> @NotNull [] myListeners;
    @Nullable
    private Class<T> myExtensionClass;
    private final boolean isDynamic;
    private final AtomicReference<ConcurrentMap<?, Map<?, ?>>> keyMapperToCacheRef;
    private static Runnable CHECK_CANCELED;

    ExtensionPointImpl(@NotNull String name, @NotNull String className, @NotNull PluginDescriptor pluginDescriptor, @Nullable Class<T> extensionClass, boolean dynamic) {
        if (name == null) {
            ExtensionPointImpl.$$$reportNull$$$0(0);
        }
        if (className == null) {
            ExtensionPointImpl.$$$reportNull$$$0(1);
        }
        if (pluginDescriptor == null) {
            ExtensionPointImpl.$$$reportNull$$$0(2);
        }
        this.myAdapters = Collections.emptyList();
        this.adaptersIsSorted = true;
        this.myListeners = EMPTY_ARRAY;
        this.keyMapperToCacheRef = new AtomicReference();
        this.myName = name;
        this.myClassName = className;
        this.pluginDescriptor = pluginDescriptor;
        this.myExtensionClass = extensionClass;
        this.isDynamic = dynamic;
    }

    final void setComponentManager(@NotNull ComponentManager value) {
        if (value == null) {
            ExtensionPointImpl.$$$reportNull$$$0(3);
        }
        this.componentManager = value;
    }

    @NotNull
    final <CACHE_KEY, V> @NotNull ConcurrentMap<@NotNull CACHE_KEY, V> getCacheMap() {
        ConcurrentMap<?, Map<?, ?>> keyMapperToCache = this.keyMapperToCacheRef.get();
        if (keyMapperToCache == null) {
            keyMapperToCache = this.keyMapperToCacheRef.updateAndGet(prev -> prev == null ? new ConcurrentHashMap() : prev);
        }
        ConcurrentMap<?, Map<?, ?>> concurrentMap = keyMapperToCache;
        if (concurrentMap == null) {
            ExtensionPointImpl.$$$reportNull$$$0(4);
        }
        return concurrentMap;
    }

    @NotNull
    public final String getName() {
        String string = this.myName;
        if (string == null) {
            ExtensionPointImpl.$$$reportNull$$$0(5);
        }
        return string;
    }

    @Override
    @NotNull
    public final String getClassName() {
        String string = this.myClassName;
        if (string == null) {
            ExtensionPointImpl.$$$reportNull$$$0(6);
        }
        return string;
    }

    @Override
    public final boolean isDynamic() {
        return this.isDynamic;
    }

    @Override
    public final void registerExtension(@NotNull T extension, @NotNull LoadingOrder order) {
        if (extension == null) {
            ExtensionPointImpl.$$$reportNull$$$0(7);
        }
        if (order == null) {
            ExtensionPointImpl.$$$reportNull$$$0(8);
        }
        this.doRegisterExtension(extension, order, this.getPluginDescriptor(), null);
    }

    @Override
    public final void registerExtension(@NotNull T extension, @NotNull Disposable parentDisposable) {
        if (extension == null) {
            ExtensionPointImpl.$$$reportNull$$$0(9);
        }
        if (parentDisposable == null) {
            ExtensionPointImpl.$$$reportNull$$$0(10);
        }
        this.registerExtension(extension, this.getPluginDescriptor(), parentDisposable);
    }

    @Override
    public final void registerExtension(@NotNull T extension, @NotNull PluginDescriptor pluginDescriptor, @NotNull Disposable parentDisposable) {
        if (extension == null) {
            ExtensionPointImpl.$$$reportNull$$$0(11);
        }
        if (pluginDescriptor == null) {
            ExtensionPointImpl.$$$reportNull$$$0(12);
        }
        if (parentDisposable == null) {
            ExtensionPointImpl.$$$reportNull$$$0(13);
        }
        this.doRegisterExtension(extension, LoadingOrder.ANY, pluginDescriptor, parentDisposable);
    }

    @Override
    @NotNull
    public final PluginDescriptor getPluginDescriptor() {
        PluginDescriptor pluginDescriptor = this.pluginDescriptor;
        if (pluginDescriptor == null) {
            ExtensionPointImpl.$$$reportNull$$$0(14);
        }
        return pluginDescriptor;
    }

    @Override
    public final void registerExtension(@NotNull T extension, @NotNull LoadingOrder order, @NotNull Disposable parentDisposable) {
        if (extension == null) {
            ExtensionPointImpl.$$$reportNull$$$0(15);
        }
        if (order == null) {
            ExtensionPointImpl.$$$reportNull$$$0(16);
        }
        if (parentDisposable == null) {
            ExtensionPointImpl.$$$reportNull$$$0(17);
        }
        this.doRegisterExtension(extension, order, this.getPluginDescriptor(), parentDisposable);
    }

    public final ComponentManager getComponentManager() {
        return this.componentManager;
    }

    private synchronized void doRegisterExtension(@NotNull T extension, @NotNull LoadingOrder order, @NotNull PluginDescriptor pluginDescriptor, @Nullable Disposable parentDisposable) {
        if (extension == null) {
            ExtensionPointImpl.$$$reportNull$$$0(18);
        }
        if (order == null) {
            ExtensionPointImpl.$$$reportNull$$$0(19);
        }
        if (pluginDescriptor == null) {
            ExtensionPointImpl.$$$reportNull$$$0(20);
        }
        this.assertNotReadOnlyMode();
        this.checkExtensionType(extension, this.getExtensionClass(), null);
        for (ExtensionComponentAdapter adapter : this.myAdapters) {
            if (!(adapter instanceof ObjectComponentAdapter) || ((ObjectComponentAdapter)adapter).componentInstance != extension) continue;
            LOG.error("Extension was already added: " + extension);
            return;
        }
        ObjectComponentAdapter adapter = new ObjectComponentAdapter(extension, pluginDescriptor, order);
        this.addExtensionAdapter(adapter);
        this.notifyListeners(false, Collections.singletonList(adapter), this.myListeners);
        if (parentDisposable != null) {
            Disposer.register(parentDisposable, () -> {
                ExtensionPointImpl extensionPointImpl = this;
                synchronized (extensionPointImpl) {
                    int index = ContainerUtil.indexOfIdentity(this.myAdapters, adapter);
                    if (index < 0) {
                        LOG.error("Extension to be removed not found: " + adapter.componentInstance);
                    }
                    ArrayList<ExtensionComponentAdapter> list = new ArrayList<ExtensionComponentAdapter>(this.myAdapters);
                    list.remove(index);
                    this.myAdapters = list;
                    this.clearCache();
                    this.notifyListeners(true, Collections.singletonList(adapter), this.myListeners);
                }
            });
        }
    }

    public final synchronized void registerExtensions(@NotNull List<? extends T> extensions) {
        if (extensions == null) {
            ExtensionPointImpl.$$$reportNull$$$0(21);
        }
        for (ExtensionComponentAdapter extensionComponentAdapter : this.myAdapters) {
            if (!(extensionComponentAdapter instanceof ObjectComponentAdapter) || !ContainerUtil.containsIdentity(extensions, extensionComponentAdapter)) continue;
            LOG.error("Extension was already added: " + ((ObjectComponentAdapter)extensionComponentAdapter).componentInstance);
            return;
        }
        ArrayList<ExtensionComponentAdapter> newAdapters = new ArrayList<ExtensionComponentAdapter>(extensions.size());
        for (T extension : extensions) {
            newAdapters.add(new ObjectComponentAdapter(extension, this.getPluginDescriptor(), LoadingOrder.ANY));
        }
        if (this.myAdapters == Collections.emptyList()) {
            this.myAdapters = newAdapters;
        } else {
            ArrayList<ExtensionComponentAdapter> arrayList = new ArrayList<ExtensionComponentAdapter>(this.myAdapters.size() + newAdapters.size());
            arrayList.addAll(this.myAdapters);
            arrayList.addAll(ExtensionPointImpl.findInsertionIndexForAnyOrder(this.myAdapters), newAdapters);
            this.myAdapters = arrayList;
        }
        this.clearCache();
        this.notifyListeners(false, newAdapters, this.myListeners);
    }

    private static int findInsertionIndexForAnyOrder(@NotNull List<ExtensionComponentAdapter> adapters) {
        ExtensionComponentAdapter lastAdapter;
        int index;
        if (adapters == null) {
            ExtensionPointImpl.$$$reportNull$$$0(22);
        }
        for (index = adapters.size(); index > 0 && (lastAdapter = adapters.get(index - 1)).getOrder() == LoadingOrder.LAST; --index) {
        }
        return index;
    }

    private void checkExtensionType(@NotNull T extension, @NotNull Class<T> extensionClass, @Nullable ExtensionComponentAdapter adapter) {
        if (extension == null) {
            ExtensionPointImpl.$$$reportNull$$$0(23);
        }
        if (extensionClass == null) {
            ExtensionPointImpl.$$$reportNull$$$0(24);
        }
        if (!extensionClass.isInstance(extension)) {
            String message = "Extension " + extension.getClass() + " does not implement " + extensionClass;
            if (adapter != null) {
                message = message + " (adapter=" + adapter + ")";
            }
            throw new ExtensionException(message, extension.getClass());
        }
    }

    @Override
    @NotNull
    public final List<T> getExtensionList() {
        List<T> result = this.myExtensionsCache;
        List<T> list = result != null ? result : this.calcExtensionList();
        if (list == null) {
            ExtensionPointImpl.$$$reportNull$$$0(25);
        }
        return list;
    }

    private synchronized List<T> calcExtensionList() {
        List<T> result = this.myExtensionsCache;
        if (result == null) {
            T[] array = this.processAdapters();
            this.myExtensionsCacheAsArray = array;
            this.myExtensionsCache = result = array.length == 0 ? Collections.emptyList() : ContainerUtil.immutableList(array);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final T @NotNull [] getExtensions() {
        T[] array = this.myExtensionsCacheAsArray;
        if (array == null) {
            ExtensionPointImpl extensionPointImpl = this;
            synchronized (extensionPointImpl) {
                array = this.myExtensionsCacheAsArray;
                if (array == null) {
                    this.myExtensionsCacheAsArray = array = this.processAdapters();
                    this.myExtensionsCache = array.length == 0 ? Collections.emptyList() : ContainerUtil.immutableList(array);
                }
            }
        }
        Object[] objectArray = array.length == 0 ? array : (Object[])array.clone();
        if (objectArray == null) {
            ExtensionPointImpl.$$$reportNull$$$0(26);
        }
        return objectArray;
    }

    @Override
    @ApiStatus.Experimental
    @NotNull
    public final Iterator<T> iterator() {
        List<T> result = this.myExtensionsCache;
        Iterator<T> iterator = result == null ? this.createIterator() : result.iterator();
        if (iterator == null) {
            ExtensionPointImpl.$$$reportNull$$$0(27);
        }
        return iterator;
    }

    public final void processWithPluginDescriptor(boolean shouldBeSorted, @NotNull BiConsumer<? super T, ? super PluginDescriptor> consumer) {
        if (consumer == null) {
            ExtensionPointImpl.$$$reportNull$$$0(28);
        }
        if (this.isInReadOnlyMode()) {
            for (T extension : this.myExtensionsCache) {
                consumer.accept(extension, this.pluginDescriptor);
            }
            return;
        }
        for (ExtensionComponentAdapter adapter : shouldBeSorted ? this.getThreadSafeAdapterList(true) : this.myAdapters) {
            T extension = this.processAdapter(adapter);
            if (extension == null) continue;
            consumer.accept(extension, adapter.getPluginDescriptor());
        }
    }

    public final void processImplementations(boolean shouldBeSorted, @NotNull BiConsumer<Supplier<T>, ? super PluginDescriptor> consumer) {
        if (consumer == null) {
            ExtensionPointImpl.$$$reportNull$$$0(29);
        }
        if (this.isInReadOnlyMode()) {
            for (Object extension : this.myExtensionsCache) {
                consumer.accept(() -> extension, this.pluginDescriptor);
            }
            return;
        }
        for (ExtensionComponentAdapter adapter : shouldBeSorted ? this.getSortedAdapters() : this.myAdapters) {
            consumer.accept(() -> adapter.createInstance(this.componentManager), adapter.getPluginDescriptor());
        }
    }

    @NotNull
    private List<ExtensionComponentAdapter> getThreadSafeAdapterList(boolean failIfListenerAdded) {
        CHECK_CANCELED.run();
        if (!this.isDynamic && this.myListeners.length > 0) {
            String message = "Listeners not allowed for extension point " + this.getName();
            if (failIfListenerAdded) {
                LOG.error(message);
            } else {
                LOG.warn(message);
                this.getExtensionList();
            }
        }
        return this.getSortedAdapters();
    }

    @NotNull
    private Iterator<T> createIterator() {
        final List<ExtensionComponentAdapter> adapters = this.getThreadSafeAdapterList(true);
        final int size = adapters.size();
        if (size == 0) {
            Iterator iterator = Collections.emptyIterator();
            if (iterator == null) {
                ExtensionPointImpl.$$$reportNull$$$0(30);
            }
            return iterator;
        }
        return new Iterator<T>(){
            private int currentIndex;

            @Override
            public boolean hasNext() {
                return this.currentIndex < size;
            }

            @Override
            @Nullable
            public T next() {
                do {
                    Object extension;
                    if ((extension = ExtensionPointImpl.this.processAdapter((ExtensionComponentAdapter)adapters.get(this.currentIndex++))) == null) continue;
                    return extension;
                } while (this.hasNext());
                return null;
            }
        };
    }

    @Override
    public final Spliterator<T> spliterator() {
        return Spliterators.spliterator(this.iterator(), (long)this.size(), 1281);
    }

    @Override
    @NotNull
    public final Stream<T> extensions() {
        List<T> result = this.myExtensionsCache;
        Stream<Object> stream = result == null ? StreamSupport.stream(this.spliterator(), false) : result.stream();
        if (stream == null) {
            ExtensionPointImpl.$$$reportNull$$$0(31);
        }
        return stream;
    }

    @Override
    public final int size() {
        List<T> cache = this.myExtensionsCache;
        return cache == null ? this.myAdapters.size() : cache.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @NotNull
    private List<ExtensionComponentAdapter> getSortedAdapters() {
        if (this.adaptersIsSorted) {
            List<ExtensionComponentAdapter> list = this.myAdapters;
            if (list == null) {
                ExtensionPointImpl.$$$reportNull$$$0(32);
            }
            return list;
        }
        ExtensionPointImpl extensionPointImpl = this;
        synchronized (extensionPointImpl) {
            if (this.adaptersIsSorted) {
                List<ExtensionComponentAdapter> list = this.myAdapters;
                // MONITOREXIT @DISABLED, blocks:[2, 6] lbl10 : MonitorExitStatement: MONITOREXIT : var1_1
                if (list == null) {
                    ExtensionPointImpl.$$$reportNull$$$0(33);
                }
                return list;
            }
            if (this.myAdapters.size() > 1) {
                ArrayList<ExtensionComponentAdapter> list = new ArrayList<ExtensionComponentAdapter>(this.myAdapters);
                LoadingOrder.sort(list);
                this.myAdapters = list;
            }
            this.adaptersIsSorted = true;
        }
        List<ExtensionComponentAdapter> list = this.myAdapters;
        if (list == null) {
            ExtensionPointImpl.$$$reportNull$$$0(34);
        }
        return list;
    }

    private T @NotNull [] processAdapters() {
        this.assertNotReadOnlyMode();
        CHECK_CANCELED.run();
        long startTime = StartUpMeasurer.getCurrentTime();
        List<ExtensionComponentAdapter> adapters = this.getSortedAdapters();
        int totalSize = adapters.size();
        Class<T> extensionClass = this.getExtensionClass();
        T[] result = ArrayUtil.newArray(extensionClass, totalSize);
        if (totalSize == 0) {
            if (result == null) {
                ExtensionPointImpl.$$$reportNull$$$0(35);
            }
            return result;
        }
        ObjectOpenHashSet duplicates = this instanceof BeanExtensionPoint ? null : new ObjectOpenHashSet(totalSize);
        ExtensionPointListener<T>[] listeners = this.myListeners;
        int extensionIndex = 0;
        for (int i = 0; i < adapters.size(); ++i) {
            T extension = this.processAdapter(adapters.get(i), listeners, result, duplicates, extensionClass, adapters);
            if (extension == null) continue;
            result[extensionIndex++] = extension;
        }
        if (extensionIndex != result.length) {
            result = Arrays.copyOf(result, extensionIndex);
        }
        ActivityCategory category = ExtensionPointImpl.getActivityCategory((DefaultPicoContainer)this.componentManager.getPicoContainer());
        StartUpMeasurer.addCompletedActivity(startTime, extensionClass, category, null, StartUpMeasurer.MEASURE_THRESHOLD);
        if (result == null) {
            ExtensionPointImpl.$$$reportNull$$$0(36);
        }
        return result;
    }

    @NotNull
    public abstract ExtensionPointImpl<T> cloneFor(@NotNull ComponentManager var1);

    @NotNull
    private static ActivityCategory getActivityCategory(@NotNull DefaultPicoContainer picoContainer) {
        DefaultPicoContainer parent;
        if (picoContainer == null) {
            ExtensionPointImpl.$$$reportNull$$$0(37);
        }
        if ((parent = picoContainer.getParent()) == null) {
            ActivityCategory activityCategory = ActivityCategory.APP_EXTENSION;
            if (activityCategory == null) {
                ExtensionPointImpl.$$$reportNull$$$0(38);
            }
            return activityCategory;
        }
        if (parent.getParent() == null) {
            ActivityCategory activityCategory = ActivityCategory.PROJECT_EXTENSION;
            if (activityCategory == null) {
                ExtensionPointImpl.$$$reportNull$$$0(39);
            }
            return activityCategory;
        }
        ActivityCategory activityCategory = ActivityCategory.MODULE_EXTENSION;
        if (activityCategory == null) {
            ExtensionPointImpl.$$$reportNull$$$0(40);
        }
        return activityCategory;
    }

    @Nullable
    private synchronized T processAdapter(@NotNull ExtensionComponentAdapter adapter) {
        if (adapter == null) {
            ExtensionPointImpl.$$$reportNull$$$0(41);
        }
        try {
            return adapter.createInstance(this.componentManager);
        }
        catch (ExtensionNotApplicableException ignore) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(adapter + " not loaded because it reported that not applicable");
            }
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (Throwable e) {
            LOG.error(e);
        }
        return null;
    }

    @Nullable
    private T processAdapter(@NotNull ExtensionComponentAdapter adapter, ExtensionPointListener<T> @Nullable [] listeners, T @Nullable [] result, @Nullable ObjectOpenHashSet<T> duplicates, @NotNull Class<T> extensionClassForCheck, @NotNull List<? extends ExtensionComponentAdapter> adapters) {
        if (adapter == null) {
            ExtensionPointImpl.$$$reportNull$$$0(42);
        }
        if (extensionClassForCheck == null) {
            ExtensionPointImpl.$$$reportNull$$$0(43);
        }
        if (adapters == null) {
            ExtensionPointImpl.$$$reportNull$$$0(44);
        }
        try {
            T duplicate;
            boolean isNotifyThatAdded = listeners != null && listeners.length != 0 && !adapter.isInstanceCreated() && !this.isDynamic;
            Object extension = adapter.createInstance(this.componentManager);
            if (duplicates != null && !duplicates.add((T)extension)) {
                duplicate = duplicates.get(extension);
                assert (result != null);
            } else {
                this.checkExtensionType(extension, extensionClassForCheck, adapter);
                if (isNotifyThatAdded) {
                    this.notifyListeners(false, Collections.singletonList(adapter), listeners);
                }
                return extension;
            }
            LOG.error("Duplicate extension found:\n                   " + extension + ";\n  prev extension:  " + duplicate + ";\n  adapter:         " + adapter + ";\n  extension class: " + extensionClassForCheck + ";\n  result:          " + Arrays.asList(result) + ";\n  adapters:        " + adapters);
        }
        catch (ExtensionNotApplicableException ignore) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(adapter + " not loaded because it reported that not applicable");
            }
        }
        catch (ProcessCanceledException e) {
            throw e;
        }
        catch (Throwable e) {
            LOG.error(e);
        }
        return null;
    }

    public final synchronized void removeUnloadableExtensions() {
        List<ExtensionComponentAdapter> adapters = this.myAdapters;
        for (int i = adapters.size() - 1; i >= 0; --i) {
            ExtensionComponentAdapter adapter = adapters.get(i);
            try {
                adapter.getImplementationClass();
                continue;
            }
            catch (Throwable e) {
                if (adapters == this.myAdapters) {
                    adapters = new ArrayList<ExtensionComponentAdapter>(adapters);
                }
                adapters.remove(i);
                this.clearCache();
            }
        }
        this.myAdapters = adapters;
    }

    @ApiStatus.Internal
    public final synchronized void maskAll(final @NotNull List<T> list, @NotNull Disposable parentDisposable, final boolean fireEvents) {
        if (list == null) {
            ExtensionPointImpl.$$$reportNull$$$0(45);
        }
        if (parentDisposable == null) {
            ExtensionPointImpl.$$$reportNull$$$0(46);
        }
        if (POINTS_IN_READONLY_MODE == null) {
            POINTS_IN_READONLY_MODE = Collections.newSetFromMap(new IdentityHashMap());
        } else {
            this.assertNotReadOnlyMode();
        }
        final List<T> oldList = this.myExtensionsCache;
        final Object[] oldArray = this.myExtensionsCacheAsArray;
        this.myExtensionsCache = ContainerUtil.immutableList(list);
        this.myExtensionsCacheAsArray = list.toArray(ArrayUtil.newArray(this.getExtensionClass(), 0));
        POINTS_IN_READONLY_MODE.add(this);
        ExtensionPointListener<T>[] listeners = this.myListeners;
        if (fireEvents && listeners.length > 0) {
            if (oldList != null) {
                this.doNotifyListeners(true, oldList, listeners);
            }
            this.doNotifyListeners(false, list, this.myListeners);
        }
        this.clearUserCache();
        Disposer.register(parentDisposable, new Disposable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void dispose() {
                2 var1_1 = this;
                synchronized (var1_1) {
                    POINTS_IN_READONLY_MODE.remove(ExtensionPointImpl.this);
                    ExtensionPointImpl.this.myExtensionsCache = oldList;
                    ExtensionPointImpl.access$502(ExtensionPointImpl.this, oldArray);
                    ExtensionPointListener[] listeners = ExtensionPointImpl.this.myListeners;
                    if (fireEvents && listeners.length > 0) {
                        ExtensionPointImpl.this.doNotifyListeners(true, list, listeners);
                        if (oldList != null) {
                            ExtensionPointImpl.this.doNotifyListeners(false, oldList, listeners);
                        }
                    }
                    ExtensionPointImpl.this.clearUserCache();
                }
            }
        });
    }

    private void doNotifyListeners(boolean isRemoved, @NotNull List<T> extensions, @NotNull @NotNull ExtensionPointListener<T> @NotNull [] listeners) {
        if (extensions == null) {
            ExtensionPointImpl.$$$reportNull$$$0(47);
        }
        if (listeners == null) {
            ExtensionPointImpl.$$$reportNull$$$0(48);
        }
        for (ExtensionPointListener<T> listener : listeners) {
            if (listener instanceof ExtensionPointAdapter) {
                try {
                    ((ExtensionPointAdapter)listener).extensionListChanged();
                    continue;
                }
                catch (ProcessCanceledException e) {
                    throw e;
                }
                catch (Throwable e) {
                    LOG.error(e);
                    continue;
                }
            }
            for (T extension : extensions) {
                try {
                    if (isRemoved) {
                        listener.extensionRemoved(extension, this.pluginDescriptor);
                        continue;
                    }
                    listener.extensionAdded(extension, this.pluginDescriptor);
                }
                catch (ProcessCanceledException e) {
                    throw e;
                }
                catch (Throwable e) {
                    LOG.error(e);
                }
            }
        }
    }

    @Override
    public final synchronized void unregisterExtensions(@NotNull Predicate<? super T> filter) {
        if (filter == null) {
            ExtensionPointImpl.$$$reportNull$$$0(49);
        }
        this.getExtensionList();
        this.unregisterExtensions((clsName, adapter) -> {
            Object extension = adapter.createInstance(this.componentManager);
            return !filter.test((T)extension);
        }, false);
    }

    @Override
    public final synchronized void unregisterExtension(@NotNull T extension) {
        if (extension == null) {
            ExtensionPointImpl.$$$reportNull$$$0(50);
        }
        if (!this.unregisterExtensions((className, adapter) -> !adapter.isInstanceCreated() || adapter.createInstance(this.componentManager) != extension, true)) {
            LOG.warn("Extension to be removed not found: " + extension);
        }
    }

    @Override
    public final void unregisterExtension(@NotNull Class<? extends T> extensionClass) {
        String classNameToUnregister;
        if (extensionClass == null) {
            ExtensionPointImpl.$$$reportNull$$$0(51);
        }
        if (!this.unregisterExtensions((arg_0, arg_1) -> ExtensionPointImpl.lambda$unregisterExtension$7(classNameToUnregister = extensionClass.getCanonicalName(), arg_0, arg_1), true)) {
            LOG.warn("Extension to be removed not found: " + extensionClass);
        }
    }

    @Override
    public final boolean unregisterExtensions(@NotNull BiPredicate<? super String, ? super ExtensionComponentAdapter> extensionClassFilter, boolean stopAfterFirstMatch) {
        if (extensionClassFilter == null) {
            ExtensionPointImpl.$$$reportNull$$$0(52);
        }
        ArrayList<Runnable> listenerCallbacks = new ArrayList<Runnable>();
        ArrayList<Runnable> priorityListenerCallbacks = new ArrayList<Runnable>();
        boolean result = this.unregisterExtensions(extensionClassFilter, stopAfterFirstMatch, priorityListenerCallbacks, listenerCallbacks);
        for (Runnable callback : priorityListenerCallbacks) {
            callback.run();
        }
        for (Runnable callback : listenerCallbacks) {
            callback.run();
        }
        return result;
    }

    final synchronized boolean unregisterExtensions(@NotNull BiPredicate<? super String, ? super ExtensionComponentAdapter> extensionClassFilter, boolean stopAfterFirstMatch, @NotNull List<Runnable> priorityListenerCallbacks, @NotNull List<Runnable> listenerCallbacks) {
        if (extensionClassFilter == null) {
            ExtensionPointImpl.$$$reportNull$$$0(53);
        }
        if (priorityListenerCallbacks == null) {
            ExtensionPointImpl.$$$reportNull$$$0(54);
        }
        if (listenerCallbacks == null) {
            ExtensionPointImpl.$$$reportNull$$$0(55);
        }
        boolean found = false;
        ExtensionPointListener<T>[] listeners = this.myListeners;
        ArrayList<ExtensionComponentAdapter> removedAdapters = null;
        List<ExtensionComponentAdapter> adapters = this.myAdapters;
        for (int i = adapters.size() - 1; i >= 0; --i) {
            ExtensionComponentAdapter adapter = adapters.get(i);
            if (extensionClassFilter.test(adapter.getAssignableToClassName(), adapter)) continue;
            this.clearCache();
            if (adapters == this.myAdapters) {
                adapters = new ArrayList<ExtensionComponentAdapter>(adapters);
            }
            adapters.remove(i);
            if (listeners.length != 0) {
                if (removedAdapters == null) {
                    removedAdapters = new ArrayList<ExtensionComponentAdapter>();
                }
                removedAdapters.add(adapter);
            }
            found = true;
            if (stopAfterFirstMatch) break;
        }
        this.myAdapters = adapters;
        if (removedAdapters != null) {
            ArrayList<ExtensionComponentAdapter> finalRemovedAdapters = removedAdapters;
            List<ExtensionPointListener> priorityListeners = ContainerUtil.filter(listeners, listener -> listener instanceof ExtensionPointPriorityListener);
            List<ExtensionPointListener> regularListeners = ContainerUtil.filter(listeners, listener -> !(listener instanceof ExtensionPointPriorityListener));
            if (!priorityListeners.isEmpty()) {
                priorityListenerCallbacks.add(() -> this.notifyListeners(true, finalRemovedAdapters, priorityListeners.toArray(new ExtensionPointListener[priorityListeners.size()])));
            }
            if (!regularListeners.isEmpty()) {
                listenerCallbacks.add(() -> this.notifyListeners(true, finalRemovedAdapters, regularListeners.toArray(new ExtensionPointListener[regularListeners.size()])));
            }
        }
        return found;
    }

    abstract void unregisterExtensions(@NotNull ComponentManager var1, @NotNull PluginDescriptor var2, @NotNull List<Element> var3, @NotNull List<Runnable> var4, @NotNull List<Runnable> var5);

    private void notifyListeners(boolean isRemoved, @NotNull List<ExtensionComponentAdapter> adapters, @NotNull @NotNull ExtensionPointListener<T> @NotNull [] listeners) {
        if (adapters == null) {
            ExtensionPointImpl.$$$reportNull$$$0(56);
        }
        if (listeners == null) {
            ExtensionPointImpl.$$$reportNull$$$0(57);
        }
        for (ExtensionPointListener listener : listeners) {
            if (listener instanceof ExtensionPointAdapter) {
                try {
                    ((ExtensionPointAdapter)listener).extensionListChanged();
                    continue;
                }
                catch (ProcessCanceledException e) {
                    throw e;
                }
                catch (Throwable e) {
                    LOG.error(e);
                    continue;
                }
            }
            for (ExtensionComponentAdapter adapter : adapters) {
                if (isRemoved && !adapter.isInstanceCreated()) continue;
                Object extension = adapter.createInstance(this.componentManager);
                try {
                    if (isRemoved) {
                        listener.extensionRemoved(extension, adapter.getPluginDescriptor());
                        continue;
                    }
                    listener.extensionAdded(extension, adapter.getPluginDescriptor());
                }
                catch (ProcessCanceledException e) {
                    throw e;
                }
                catch (Throwable e) {
                    LOG.error(e);
                }
            }
        }
    }

    @Override
    public final synchronized void addExtensionPointListener(@NotNull ExtensionPointListener<T> listener, boolean invokeForLoadedExtensions, @Nullable Disposable parentDisposable) {
        boolean isAdded;
        if (listener == null) {
            ExtensionPointImpl.$$$reportNull$$$0(58);
        }
        if ((isAdded = this.addListener(listener)) && invokeForLoadedExtensions) {
            this.notifyListeners(false, this.myAdapters, new ExtensionPointListener[]{listener});
        }
        if (parentDisposable != null) {
            Disposer.register(parentDisposable, () -> this.removeExtensionPointListener(listener));
        }
    }

    @NotNull
    private static <T> ArrayFactory<ExtensionPointListener<T>> listenerArrayFactory() {
        ArrayFactory<ExtensionPointListener<T>> arrayFactory = LISTENER_ARRAY_FACTORY;
        if (arrayFactory == null) {
            ExtensionPointImpl.$$$reportNull$$$0(59);
        }
        return arrayFactory;
    }

    private boolean addListener(@NotNull ExtensionPointListener<T> listener) {
        if (listener == null) {
            ExtensionPointImpl.$$$reportNull$$$0(60);
        }
        if (ArrayUtilRt.indexOf(this.myListeners, listener, 0, this.myListeners.length) != -1) {
            return false;
        }
        this.myListeners = listener instanceof ExtensionPointPriorityListener ? ArrayUtil.prepend(listener, this.myListeners, ExtensionPointImpl.listenerArrayFactory()) : ArrayUtil.append(this.myListeners, listener, ExtensionPointImpl.listenerArrayFactory());
        return true;
    }

    @Override
    public final void addExtensionPointListener(@NotNull ExtensionPointListener<T> listener) {
        if (listener == null) {
            ExtensionPointImpl.$$$reportNull$$$0(61);
        }
        this.addExtensionPointListener(listener, true, null);
    }

    @Override
    public final void addExtensionPointListener(final @NotNull ExtensionPointChangeListener listener, boolean invokeForLoadedExtensions, @Nullable Disposable parentDisposable) {
        if (listener == null) {
            ExtensionPointImpl.$$$reportNull$$$0(62);
        }
        this.addExtensionPointListener(new ExtensionPointAdapter<T>(){

            @Override
            public void extensionListChanged() {
                listener.extensionListChanged();
            }
        }, invokeForLoadedExtensions, parentDisposable);
    }

    @Override
    public final void addChangeListener(final @NotNull Runnable listener, @Nullable Disposable parentDisposable) {
        if (listener == null) {
            ExtensionPointImpl.$$$reportNull$$$0(63);
        }
        ExtensionPointAdapter listenerAdapter = new ExtensionPointAdapter<T>(){

            @Override
            public void extensionListChanged() {
                listener.run();
            }
        };
        this.myListeners = ArrayUtil.append(this.myListeners, listenerAdapter, ExtensionPointImpl.listenerArrayFactory());
        if (parentDisposable != null) {
            Disposer.register(parentDisposable, () -> this.removeExtensionPointListener(listenerAdapter));
        }
    }

    @Override
    public final synchronized void removeExtensionPointListener(@NotNull ExtensionPointListener<T> listener) {
        if (listener == null) {
            ExtensionPointImpl.$$$reportNull$$$0(64);
        }
        this.myListeners = ArrayUtil.remove(this.myListeners, listener, ExtensionPointImpl.listenerArrayFactory());
    }

    public final synchronized void reset() {
        List<ExtensionComponentAdapter> adapters = this.myAdapters;
        this.myAdapters = Collections.emptyList();
        this.clearCache();
        if (!adapters.isEmpty() && this.myListeners.length > 0) {
            this.notifyListeners(true, adapters, this.myListeners);
        }
        this.myListeners = EMPTY_ARRAY;
        this.myExtensionClass = null;
    }

    @NotNull
    public final Class<T> getExtensionClass() {
        Class<Object> extensionClass = this.myExtensionClass;
        if (extensionClass == null) {
            try {
                ClassLoader pluginClassLoader = this.pluginDescriptor.getPluginClassLoader();
                this.myExtensionClass = extensionClass = pluginClassLoader == null ? Class.forName(this.myClassName) : Class.forName(this.myClassName, true, pluginClassLoader);
            }
            catch (ClassNotFoundException e) {
                throw this.componentManager.createError(e, this.pluginDescriptor.getPluginId());
            }
        }
        Class<T> clazz = extensionClass;
        if (clazz == null) {
            ExtensionPointImpl.$$$reportNull$$$0(65);
        }
        return clazz;
    }

    public final String toString() {
        return this.getName();
    }

    final synchronized void addExtensionAdapter(@NotNull ExtensionComponentAdapter adapter) {
        if (adapter == null) {
            ExtensionPointImpl.$$$reportNull$$$0(66);
        }
        ArrayList<ExtensionComponentAdapter> list = new ArrayList<ExtensionComponentAdapter>(this.myAdapters.size() + 1);
        list.addAll(this.myAdapters);
        list.add(adapter);
        this.myAdapters = list;
        this.clearCache();
    }

    final void clearUserCache() {
        ConcurrentMap<?, Map<?, ?>> map = this.keyMapperToCacheRef.get();
        if (map != null) {
            map.clear();
        }
    }

    private void clearCache() {
        this.myExtensionsCache = null;
        this.myExtensionsCacheAsArray = null;
        this.adaptersIsSorted = false;
        this.clearUserCache();
        this.assertNotReadOnlyMode();
    }

    private void assertNotReadOnlyMode() {
        if (this.isInReadOnlyMode()) {
            throw new IllegalStateException(this + " in a read-only mode and cannot be modified");
        }
    }

    @NotNull
    protected abstract ExtensionComponentAdapter createAdapterAndRegisterInPicoContainerIfNeeded(@NotNull Element var1, @NotNull PluginDescriptor var2, @NotNull ComponentManager var3);

    final synchronized void createAndRegisterAdapter(@NotNull Element extensionElement, @NotNull PluginDescriptor pluginDescriptor, @NotNull ComponentManager componentManager) {
        if (extensionElement == null) {
            ExtensionPointImpl.$$$reportNull$$$0(67);
        }
        if (pluginDescriptor == null) {
            ExtensionPointImpl.$$$reportNull$$$0(68);
        }
        if (componentManager == null) {
            ExtensionPointImpl.$$$reportNull$$$0(69);
        }
        this.addExtensionAdapter(this.createAdapterAndRegisterInPicoContainerIfNeeded(extensionElement, pluginDescriptor, componentManager));
    }

    final synchronized void registerExtensions(@NotNull List<Element> extensionElements, @NotNull PluginDescriptor pluginDescriptor, @NotNull ComponentManager componentManager, @Nullable List<Runnable> listenerCallbacks) {
        List<ExtensionComponentAdapter> adapters;
        if (extensionElements == null) {
            ExtensionPointImpl.$$$reportNull$$$0(70);
        }
        if (pluginDescriptor == null) {
            ExtensionPointImpl.$$$reportNull$$$0(71);
        }
        if (componentManager == null) {
            ExtensionPointImpl.$$$reportNull$$$0(72);
        }
        if (this.componentManager != componentManager) {
            LOG.error("The same point on different levels (pointName=" + this.getName() + ")");
        }
        if ((adapters = this.myAdapters) == Collections.emptyList()) {
            this.myAdapters = adapters = new ArrayList<ExtensionComponentAdapter>(extensionElements.size());
            this.adaptersIsSorted = false;
        } else {
            ((ArrayList)adapters).ensureCapacity(adapters.size() + extensionElements.size());
        }
        int oldSize = adapters.size();
        for (Element extensionElement : extensionElements) {
            adapters.add(this.createAdapterAndRegisterInPicoContainerIfNeeded(extensionElement, pluginDescriptor, componentManager));
        }
        int newSize = adapters.size();
        this.clearCache();
        ExtensionPointListener[] listeners = this.myListeners;
        if (listenerCallbacks == null || listeners.length == 0) {
            return;
        }
        List addedAdapters = Collections.emptyList();
        for (ExtensionPointListener<T> extensionPointListener : listeners) {
            if (extensionPointListener instanceof ExtensionPointAdapter) continue;
            List<ExtensionComponentAdapter> newlyAddedUnsortedList = adapters.subList(oldSize, newSize);
            Set newlyAddedSet = Collections.newSetFromMap(new IdentityHashMap(newlyAddedUnsortedList.size()));
            newlyAddedSet.addAll(newlyAddedUnsortedList);
            addedAdapters = new ArrayList(newlyAddedSet.size());
            for (ExtensionComponentAdapter adapter : this.getSortedAdapters()) {
                if (!newlyAddedSet.contains(adapter)) continue;
                addedAdapters.add(adapter);
            }
            break;
        }
        List finalAddedAdapters = addedAdapters;
        listenerCallbacks.add(() -> this.notifyListeners(false, finalAddedAdapters, listeners));
    }

    final synchronized void notifyAreaReplaced(@NotNull ExtensionsArea oldArea) {
        if (oldArea == null) {
            ExtensionPointImpl.$$$reportNull$$$0(73);
        }
        for (ExtensionPointListener<T> listener : this.myListeners) {
            if (!(listener instanceof ExtensionPointAndAreaListener)) continue;
            ((ExtensionPointAndAreaListener)listener).areaReplaced(oldArea);
        }
    }

    @Nullable
    public final <V extends T> V findExtension(@NotNull Class<V> aClass, boolean isRequired, @NotNull ThreeState strictMatch) {
        List<T> extensionsCache;
        if (aClass == null) {
            ExtensionPointImpl.$$$reportNull$$$0(74);
        }
        if (strictMatch == null) {
            ExtensionPointImpl.$$$reportNull$$$0(75);
        }
        if (strictMatch != ThreeState.NO) {
            V result = this.findExtensionByExactClass(aClass);
            if (result != null) {
                return result;
            }
            if (strictMatch == ThreeState.YES) {
                return null;
            }
        }
        if ((extensionsCache = this.myExtensionsCache) == null) {
            for (ExtensionComponentAdapter adapter : this.getThreadSafeAdapterList(false)) {
                try {
                    if (!aClass.isAssignableFrom(adapter.getImplementationClass())) continue;
                    return (V)this.processAdapter(adapter);
                }
                catch (ClassNotFoundException e) {
                    this.componentManager.logError(e, adapter.getPluginDescriptor().getPluginId());
                }
            }
        } else {
            for (Object extension : extensionsCache) {
                if (!aClass.isInstance(extension)) continue;
                return (V)extension;
            }
        }
        if (isRequired) {
            String message = "could not find extension implementation " + aClass;
            if (this.isInReadOnlyMode()) {
                message = message + " (point in read-only mode)";
            }
            throw new IllegalArgumentException(message);
        }
        return null;
    }

    @Nullable
    private T findExtensionByExactClass(@NotNull Class<? extends T> aClass) {
        List<T> extensionsCache;
        if (aClass == null) {
            ExtensionPointImpl.$$$reportNull$$$0(76);
        }
        if ((extensionsCache = this.myExtensionsCache) == null) {
            for (ExtensionComponentAdapter adapter : this.getThreadSafeAdapterList(false)) {
                Object classOrName = adapter.myImplementationClassOrName;
                if (!(classOrName instanceof String ? classOrName.equals(aClass.getName()) : classOrName == aClass)) continue;
                return this.processAdapter(adapter);
            }
        } else {
            for (T extension : extensionsCache) {
                if (aClass != extension.getClass()) continue;
                return extension;
            }
        }
        return null;
    }

    private synchronized boolean isInReadOnlyMode() {
        return POINTS_IN_READONLY_MODE != null && POINTS_IN_READONLY_MODE.contains(this);
    }

    public static void setCheckCanceledAction(@NotNull Runnable checkCanceled) {
        if (checkCanceled == null) {
            ExtensionPointImpl.$$$reportNull$$$0(77);
        }
        CHECK_CANCELED = () -> {
            block2: {
                try {
                    checkCanceled.run();
                }
                catch (ProcessCanceledException e) {
                    if (ExtensionPointImpl.isInsideClassInitializer(e.getStackTrace())) break block2;
                    throw e;
                }
            }
        };
    }

    private static boolean isInsideClassInitializer(StackTraceElement @NotNull [] trace) {
        if (trace == null) {
            ExtensionPointImpl.$$$reportNull$$$0(78);
        }
        return Arrays.stream(trace).anyMatch(s -> "<clinit>".equals(s.getMethodName()));
    }

    private static /* synthetic */ boolean lambda$unregisterExtension$7(String classNameToUnregister, String className, ExtensionComponentAdapter adapter) {
        return !className.equals(classNameToUnregister);
    }

    static /* synthetic */ Object[] access$502(ExtensionPointImpl x0, Object[] x1) {
        x0.myExtensionsCacheAsArray = x1;
        return x1;
    }

    static {
        LISTENER_ARRAY_FACTORY = n -> n == 0 ? EMPTY_ARRAY : new ExtensionPointListener[n];
        CHECK_CANCELED = EmptyRunnable.getInstance();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 14: 
            case 25: 
            case 26: 
            case 27: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 38: 
            case 39: 
            case 40: 
            case 59: 
            case 65: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 14: 
            case 25: 
            case 26: 
            case 27: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 38: 
            case 39: 
            case 40: 
            case 59: 
            case 65: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "className";
                break;
            }
            case 2: 
            case 12: 
            case 20: 
            case 68: 
            case 71: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginDescriptor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 14: 
            case 25: 
            case 26: 
            case 27: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 38: 
            case 39: 
            case 40: 
            case 59: 
            case 65: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sqldelight/com/intellij/openapi/extensions/impl/ExtensionPointImpl";
                break;
            }
            case 7: 
            case 9: 
            case 11: 
            case 15: 
            case 18: 
            case 23: 
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extension";
                break;
            }
            case 8: 
            case 16: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "order";
                break;
            }
            case 10: 
            case 13: 
            case 17: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 21: 
            case 47: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extensions";
                break;
            }
            case 22: 
            case 44: 
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "adapters";
                break;
            }
            case 24: 
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extensionClass";
                break;
            }
            case 28: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "picoContainer";
                break;
            }
            case 41: 
            case 42: 
            case 66: {
                objectArray2 = objectArray3;
                objectArray3[0] = "adapter";
                break;
            }
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extensionClassForCheck";
                break;
            }
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 48: 
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listeners";
                break;
            }
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 52: 
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extensionClassFilter";
                break;
            }
            case 54: {
                objectArray2 = objectArray3;
                objectArray3[0] = "priorityListenerCallbacks";
                break;
            }
            case 55: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listenerCallbacks";
                break;
            }
            case 58: 
            case 60: 
            case 61: 
            case 62: 
            case 63: 
            case 64: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 67: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extensionElement";
                break;
            }
            case 69: 
            case 72: {
                objectArray2 = objectArray3;
                objectArray3[0] = "componentManager";
                break;
            }
            case 70: {
                objectArray2 = objectArray3;
                objectArray3[0] = "extensionElements";
                break;
            }
            case 73: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldArea";
                break;
            }
            case 74: 
            case 76: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 75: {
                objectArray2 = objectArray3;
                objectArray3[0] = "strictMatch";
                break;
            }
            case 77: {
                objectArray2 = objectArray3;
                objectArray3[0] = "checkCanceled";
                break;
            }
            case 78: {
                objectArray2 = objectArray3;
                objectArray3[0] = "trace";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "sqldelight/com/intellij/openapi/extensions/impl/ExtensionPointImpl";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getCacheMap";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getClassName";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getPluginDescriptor";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getExtensionList";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getExtensions";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "iterator";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "createIterator";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "extensions";
                break;
            }
            case 32: 
            case 33: 
            case 34: {
                objectArray = objectArray2;
                objectArray2[1] = "getSortedAdapters";
                break;
            }
            case 35: 
            case 36: {
                objectArray = objectArray2;
                objectArray2[1] = "processAdapters";
                break;
            }
            case 38: 
            case 39: 
            case 40: {
                objectArray = objectArray2;
                objectArray2[1] = "getActivityCategory";
                break;
            }
            case 59: {
                objectArray = objectArray2;
                objectArray2[1] = "listenerArrayFactory";
                break;
            }
            case 65: {
                objectArray = objectArray2;
                objectArray2[1] = "getExtensionClass";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setComponentManager";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 14: 
            case 25: 
            case 26: 
            case 27: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 38: 
            case 39: 
            case 40: 
            case 59: 
            case 65: {
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "registerExtension";
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "doRegisterExtension";
                break;
            }
            case 21: 
            case 70: 
            case 71: 
            case 72: {
                objectArray = objectArray;
                objectArray[2] = "registerExtensions";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "findInsertionIndexForAnyOrder";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "checkExtensionType";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "processWithPluginDescriptor";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "processImplementations";
                break;
            }
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "getActivityCategory";
                break;
            }
            case 41: 
            case 42: 
            case 43: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "processAdapter";
                break;
            }
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "maskAll";
                break;
            }
            case 47: 
            case 48: {
                objectArray = objectArray;
                objectArray[2] = "doNotifyListeners";
                break;
            }
            case 49: 
            case 52: 
            case 53: 
            case 54: 
            case 55: {
                objectArray = objectArray;
                objectArray[2] = "unregisterExtensions";
                break;
            }
            case 50: 
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "unregisterExtension";
                break;
            }
            case 56: 
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "notifyListeners";
                break;
            }
            case 58: 
            case 61: 
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "addExtensionPointListener";
                break;
            }
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "addListener";
                break;
            }
            case 63: {
                objectArray = objectArray;
                objectArray[2] = "addChangeListener";
                break;
            }
            case 64: {
                objectArray = objectArray;
                objectArray[2] = "removeExtensionPointListener";
                break;
            }
            case 66: {
                objectArray = objectArray;
                objectArray[2] = "addExtensionAdapter";
                break;
            }
            case 67: 
            case 68: 
            case 69: {
                objectArray = objectArray;
                objectArray[2] = "createAndRegisterAdapter";
                break;
            }
            case 73: {
                objectArray = objectArray;
                objectArray[2] = "notifyAreaReplaced";
                break;
            }
            case 74: 
            case 75: {
                objectArray = objectArray;
                objectArray[2] = "findExtension";
                break;
            }
            case 76: {
                objectArray = objectArray;
                objectArray[2] = "findExtensionByExactClass";
                break;
            }
            case 77: {
                objectArray = objectArray;
                objectArray[2] = "setCheckCanceledAction";
                break;
            }
            case 78: {
                objectArray = objectArray;
                objectArray[2] = "isInsideClassInitializer";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 14: 
            case 25: 
            case 26: 
            case 27: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 38: 
            case 39: 
            case 40: 
            case 59: 
            case 65: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static final class ObjectComponentAdapter<T>
    extends ExtensionComponentAdapter {
        @NotNull
        private final T componentInstance;

        private ObjectComponentAdapter(@NotNull T extension, @NotNull PluginDescriptor pluginDescriptor, @NotNull LoadingOrder loadingOrder) {
            if (extension == null) {
                ObjectComponentAdapter.$$$reportNull$$$0(0);
            }
            if (pluginDescriptor == null) {
                ObjectComponentAdapter.$$$reportNull$$$0(1);
            }
            if (loadingOrder == null) {
                ObjectComponentAdapter.$$$reportNull$$$0(2);
            }
            super(extension.getClass().getName(), pluginDescriptor, null, loadingOrder);
            this.componentInstance = extension;
        }

        @Override
        boolean isInstanceCreated() {
            return true;
        }

        @NotNull
        public <I> I createInstance(@Nullable ComponentManager componentManager) {
            T t = this.componentInstance;
            if (t == null) {
                ObjectComponentAdapter.$$$reportNull$$$0(3);
            }
            return (I)t;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "extension";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "pluginDescriptor";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "loadingOrder";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "sqldelight/com/intellij/openapi/extensions/impl/ExtensionPointImpl$ObjectComponentAdapter";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "sqldelight/com/intellij/openapi/extensions/impl/ExtensionPointImpl$ObjectComponentAdapter";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createInstance";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

