/*
 * Decompiled with CFR 0.152.
 */
package sqldelight.com.intellij.openapi.roots.libraries;

import java.util.EventListener;
import java.util.Iterator;
import sqldelight.com.intellij.openapi.Disposable;
import sqldelight.com.intellij.openapi.roots.ProjectModelExternalSource;
import sqldelight.com.intellij.openapi.roots.libraries.Library;
import sqldelight.com.intellij.openapi.roots.libraries.LibraryTablePresentation;
import sqldelight.com.intellij.openapi.roots.libraries.PersistentLibraryKind;
import sqldelight.org.jetbrains.annotations.ApiStatus;
import sqldelight.org.jetbrains.annotations.NonNls;
import sqldelight.org.jetbrains.annotations.NotNull;
import sqldelight.org.jetbrains.annotations.Nullable;

@ApiStatus.NonExtendable
public interface LibraryTable {
    public Library @NotNull [] getLibraries();

    @NotNull
    public Library createLibrary();

    @NotNull
    public Library createLibrary(@NonNls String var1);

    public void removeLibrary(@NotNull Library var1);

    @NotNull
    public Iterator<Library> getLibraryIterator();

    @Nullable
    public Library getLibraryByName(@NotNull String var1);

    @NotNull
    public String getTableLevel();

    @NotNull
    public LibraryTablePresentation getPresentation();

    default public boolean isEditable() {
        return true;
    }

    @NotNull
    public ModifiableModel getModifiableModel();

    public void addListener(@NotNull Listener var1);

    public void addListener(@NotNull Listener var1, @NotNull Disposable var2);

    public void removeListener(@NotNull Listener var1);

    public static interface Listener
    extends EventListener {
        default public void afterLibraryAdded(@NotNull Library newLibrary) {
            if (newLibrary == null) {
                Listener.$$$reportNull$$$0(0);
            }
        }

        @Deprecated
        default public void afterLibraryRenamed(@NotNull Library library) {
            if (library == null) {
                Listener.$$$reportNull$$$0(1);
            }
        }

        default public void afterLibraryRenamed(@NotNull Library library, @Nullable String oldName) {
            if (library == null) {
                Listener.$$$reportNull$$$0(2);
            }
            this.afterLibraryRenamed(library);
        }

        default public void beforeLibraryRemoved(@NotNull Library library) {
            if (library == null) {
                Listener.$$$reportNull$$$0(3);
            }
        }

        default public void afterLibraryRemoved(@NotNull Library library) {
            if (library == null) {
                Listener.$$$reportNull$$$0(4);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "newLibrary";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "library";
                    break;
                }
            }
            objectArray2[1] = "sqldelight/com/intellij/openapi/roots/libraries/LibraryTable$Listener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "afterLibraryAdded";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "afterLibraryRenamed";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "beforeLibraryRemoved";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "afterLibraryRemoved";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static interface ModifiableModel
    extends Disposable {
        @NotNull
        public Library createLibrary(String var1);

        @NotNull
        public Library createLibrary(String var1, @Nullable PersistentLibraryKind<?> var2);

        @NotNull
        public Library createLibrary(String var1, @Nullable PersistentLibraryKind<?> var2, @Nullable ProjectModelExternalSource var3);

        public void removeLibrary(@NotNull Library var1);

        public void commit();

        @NotNull
        public Iterator<Library> getLibraryIterator();

        @Nullable
        public Library getLibraryByName(@NotNull String var1);

        public Library @NotNull [] getLibraries();

        public boolean isChanged();
    }
}

