/*
 * Decompiled with CFR 0.152.
 */
package sqldelight.com.intellij.openapi.util;

import java.lang.management.ManagementFactory;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryType;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.function.Consumer;
import javax.management.Notification;
import javax.management.NotificationEmitter;
import javax.management.NotificationListener;
import sqldelight.com.intellij.openapi.Disposable;
import sqldelight.com.intellij.openapi.diagnostic.Logger;
import sqldelight.com.intellij.openapi.util.LowMemoryWatcher;
import sqldelight.com.intellij.util.ConcurrencyUtil;
import sqldelight.com.intellij.util.SystemProperties;
import sqldelight.com.intellij.util.concurrency.SequentialTaskExecutor;
import sqldelight.org.jetbrains.annotations.NotNull;

public final class LowMemoryWatcherManager
implements Disposable {
    private static final long MEM_THRESHOLD = 0x500000L;
    @NotNull
    private final ExecutorService myExecutorService;
    private Future<?> mySubmitted;
    private final Future<?> myMemoryPoolMXBeansFuture;
    private final Consumer<Boolean> myJanitor;
    private final NotificationListener myLowMemoryListener;

    @NotNull
    private static Logger getLogger() {
        Logger logger2 = Logger.getInstance(LowMemoryWatcherManager.class);
        if (logger2 == null) {
            LowMemoryWatcherManager.$$$reportNull$$$0(0);
        }
        return logger2;
    }

    public LowMemoryWatcherManager(@NotNull ExecutorService backendExecutorService) {
        if (backendExecutorService == null) {
            LowMemoryWatcherManager.$$$reportNull$$$0(1);
        }
        this.myJanitor = new Consumer<Boolean>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void accept(@NotNull Boolean afterGc) {
                if (afterGc == null) {
                    1.$$$reportNull$$$0(0);
                }
                Consumer consumer = LowMemoryWatcherManager.this.myJanitor;
                synchronized (consumer) {
                    LowMemoryWatcherManager.this.mySubmitted = null;
                }
                LowMemoryWatcher.onLowMemorySignalReceived(afterGc);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "afterGc", "sqldelight/com/intellij/openapi/util/LowMemoryWatcherManager$1", "accept"));
            }
        };
        this.myLowMemoryListener = new NotificationListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void handleNotification(Notification notification, Object __) {
                if (LowMemoryWatcher.notificationsSuppressed()) {
                    return;
                }
                boolean memoryThreshold = "java.management.memory.threshold.exceeded".equals(notification.getType());
                boolean memoryCollectionThreshold = "java.management.memory.collection.threshold.exceeded".equals(notification.getType());
                if (memoryThreshold || memoryCollectionThreshold) {
                    Consumer consumer = LowMemoryWatcherManager.this.myJanitor;
                    synchronized (consumer) {
                        if (LowMemoryWatcherManager.this.mySubmitted == null) {
                            LowMemoryWatcherManager.this.mySubmitted = LowMemoryWatcherManager.this.myExecutorService.submit(() -> LowMemoryWatcherManager.this.myJanitor.accept(memoryCollectionThreshold));
                            if (LowMemoryWatcherManager.this.mySubmitted.isDone()) {
                                LowMemoryWatcherManager.this.mySubmitted = null;
                            }
                        }
                    }
                }
            }
        };
        this.myExecutorService = SystemProperties.getBooleanProperty("low.memory.watcher.sync", false) ? ConcurrencyUtil.newSameThreadExecutorService() : SequentialTaskExecutor.createSequentialApplicationPoolExecutor("LowMemoryWatcherManager", backendExecutorService);
        this.myMemoryPoolMXBeansFuture = this.initializeMXBeanListenersLater(backendExecutorService);
    }

    @NotNull
    private Future<?> initializeMXBeanListenersLater(@NotNull ExecutorService backendExecutorService) {
        if (backendExecutorService == null) {
            LowMemoryWatcherManager.$$$reportNull$$$0(2);
        }
        Future<?> future = backendExecutorService.submit(() -> {
            try {
                for (MemoryPoolMXBean bean : ManagementFactory.getMemoryPoolMXBeans()) {
                    long max;
                    long threshold;
                    if (bean.getType() != MemoryType.HEAP || !bean.isCollectionUsageThresholdSupported() || !bean.isUsageThresholdSupported() || (threshold = Math.min((long)((float)(max = bean.getUsage().getMax()) * LowMemoryWatcherManager.getOccupiedMemoryThreshold()), max - 0x500000L)) <= 0L) continue;
                    bean.setUsageThreshold(threshold);
                    bean.setCollectionUsageThreshold(threshold);
                }
                ((NotificationEmitter)((Object)ManagementFactory.getMemoryMXBean())).addNotificationListener(this.myLowMemoryListener, null, null);
            }
            catch (Throwable e) {
                LowMemoryWatcherManager.getLogger().info("Errors initializing LowMemoryWatcher: ", e);
            }
        });
        if (future == null) {
            LowMemoryWatcherManager.$$$reportNull$$$0(3);
        }
        return future;
    }

    private static float getOccupiedMemoryThreshold() {
        return SystemProperties.getFloatProperty("low.memory.watcher.notification.threshold", 0.95f);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispose() {
        try {
            this.myMemoryPoolMXBeansFuture.get();
            ((NotificationEmitter)((Object)ManagementFactory.getMemoryMXBean())).removeNotificationListener(this.myLowMemoryListener);
        }
        catch (Exception e) {
            LowMemoryWatcherManager.getLogger().error(e);
        }
        Consumer<Boolean> consumer = this.myJanitor;
        synchronized (consumer) {
            if (this.mySubmitted != null) {
                this.mySubmitted.cancel(false);
                this.mySubmitted = null;
            }
        }
        LowMemoryWatcher.stopAll();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sqldelight/com/intellij/openapi/util/LowMemoryWatcherManager";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "backendExecutorService";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getLogger";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "sqldelight/com/intellij/openapi/util/LowMemoryWatcherManager";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "initializeMXBeanListenersLater";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "initializeMXBeanListenersLater";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

