/*
 * Decompiled with CFR 0.152.
 */
package sqldelight.com.intellij.pom.wrappers;

import sqldelight.com.intellij.injected.editor.VirtualFileWindow;
import sqldelight.com.intellij.lang.ASTNode;
import sqldelight.com.intellij.openapi.editor.Document;
import sqldelight.com.intellij.openapi.fileEditor.FileDocumentManager;
import sqldelight.com.intellij.openapi.vfs.VirtualFile;
import sqldelight.com.intellij.pom.PomModelAspect;
import sqldelight.com.intellij.pom.event.PomModelEvent;
import sqldelight.com.intellij.pom.tree.TreeAspect;
import sqldelight.com.intellij.pom.tree.events.TreeChangeEvent;
import sqldelight.com.intellij.pom.tree.events.impl.TreeChangeEventImpl;
import sqldelight.com.intellij.psi.PsiDocumentManager;
import sqldelight.com.intellij.psi.PsiFile;
import sqldelight.com.intellij.psi.impl.PsiDocumentManagerBase;
import sqldelight.com.intellij.psi.impl.PsiManagerImpl;
import sqldelight.com.intellij.psi.impl.PsiToDocumentSynchronizer;
import sqldelight.com.intellij.psi.impl.source.DummyHolder;
import sqldelight.com.intellij.testFramework.LightVirtualFile;
import sqldelight.org.jetbrains.annotations.NotNull;

public final class PsiEventWrapperAspect
implements PomModelAspect {
    private final TreeAspect myTreeAspect;

    public PsiEventWrapperAspect(@NotNull TreeAspect treeAspect) {
        if (treeAspect == null) {
            PsiEventWrapperAspect.$$$reportNull$$$0(0);
        }
        this.myTreeAspect = treeAspect;
    }

    @Override
    public void update(PomModelEvent event) {
        TreeChangeEvent changeSet = (TreeChangeEvent)event.getChangeSet(this.myTreeAspect);
        if (changeSet == null) {
            return;
        }
        PsiEventWrapperAspect.sendAfterEvents(changeSet);
    }

    private static void sendAfterEvents(TreeChangeEvent changeSet) {
        ASTNode rootElement = changeSet.getRootElement();
        PsiFile file = (PsiFile)rootElement.getPsi();
        if (!file.isPhysical()) {
            PsiEventWrapperAspect.promoteNonPhysicalChangesToDocument(rootElement, file);
            ((PsiManagerImpl)file.getManager()).afterChange(false);
            return;
        }
        ((TreeChangeEventImpl)changeSet).fireEvents();
    }

    private static void promoteNonPhysicalChangesToDocument(ASTNode rootElement, PsiFile file) {
        Document document;
        if (file instanceof DummyHolder) {
            return;
        }
        if (((PsiDocumentManagerBase)PsiDocumentManager.getInstance(file.getProject())).isCommitInProgress()) {
            return;
        }
        VirtualFile vFile = file.getViewProvider().getVirtualFile();
        if (vFile instanceof LightVirtualFile && !(vFile instanceof VirtualFileWindow) && (document = FileDocumentManager.getInstance().getCachedDocument(vFile)) != null) {
            CharSequence text = rootElement.getChars();
            PsiToDocumentSynchronizer.performAtomically(file, () -> document.replaceString(0, document.getTextLength(), text));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "treeAspect", "sqldelight/com/intellij/pom/wrappers/PsiEventWrapperAspect", "<init>"));
    }
}

