/*
 * Decompiled with CFR 0.152.
 */
package sqldelight.com.intellij.psi;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import sqldelight.com.intellij.codeInsight.AnnotationTargetUtil;
import sqldelight.com.intellij.core.JavaPsiBundle;
import sqldelight.com.intellij.openapi.diagnostic.Logger;
import sqldelight.com.intellij.openapi.util.registry.Registry;
import sqldelight.com.intellij.psi.HierarchicalMethodSignature;
import sqldelight.com.intellij.psi.JavaPsiFacade;
import sqldelight.com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import sqldelight.com.intellij.psi.JavaResolveResult;
import sqldelight.com.intellij.psi.PsiAnnotation;
import sqldelight.com.intellij.psi.PsiAnonymousClass;
import sqldelight.com.intellij.psi.PsiArrayInitializerExpression;
import sqldelight.com.intellij.psi.PsiArrayType;
import sqldelight.com.intellij.psi.PsiAssignmentExpression;
import sqldelight.com.intellij.psi.PsiBlockStatement;
import sqldelight.com.intellij.psi.PsiCall;
import sqldelight.com.intellij.psi.PsiCallExpression;
import sqldelight.com.intellij.psi.PsiClass;
import sqldelight.com.intellij.psi.PsiClassType;
import sqldelight.com.intellij.psi.PsiCodeBlock;
import sqldelight.com.intellij.psi.PsiConditionalExpression;
import sqldelight.com.intellij.psi.PsiConstructorCall;
import sqldelight.com.intellij.psi.PsiDiamondType;
import sqldelight.com.intellij.psi.PsiElement;
import sqldelight.com.intellij.psi.PsiEllipsisType;
import sqldelight.com.intellij.psi.PsiEnumConstant;
import sqldelight.com.intellij.psi.PsiExpression;
import sqldelight.com.intellij.psi.PsiExpressionList;
import sqldelight.com.intellij.psi.PsiExpressionStatement;
import sqldelight.com.intellij.psi.PsiFunctionalExpression;
import sqldelight.com.intellij.psi.PsiIntersectionType;
import sqldelight.com.intellij.psi.PsiJavaCodeReferenceElement;
import sqldelight.com.intellij.psi.PsiLambdaExpression;
import sqldelight.com.intellij.psi.PsiLambdaExpressionType;
import sqldelight.com.intellij.psi.PsiLambdaParameterType;
import sqldelight.com.intellij.psi.PsiMember;
import sqldelight.com.intellij.psi.PsiMethod;
import sqldelight.com.intellij.psi.PsiMethodCallExpression;
import sqldelight.com.intellij.psi.PsiMethodReferenceExpression;
import sqldelight.com.intellij.psi.PsiMethodReferenceType;
import sqldelight.com.intellij.psi.PsiModifierListOwner;
import sqldelight.com.intellij.psi.PsiNewExpression;
import sqldelight.com.intellij.psi.PsiParameter;
import sqldelight.com.intellij.psi.PsiParameterList;
import sqldelight.com.intellij.psi.PsiParenthesizedExpression;
import sqldelight.com.intellij.psi.PsiReferenceExpression;
import sqldelight.com.intellij.psi.PsiResolveHelper;
import sqldelight.com.intellij.psi.PsiReturnStatement;
import sqldelight.com.intellij.psi.PsiStatement;
import sqldelight.com.intellij.psi.PsiSubstitutor;
import sqldelight.com.intellij.psi.PsiSuperExpression;
import sqldelight.com.intellij.psi.PsiSwitchBlock;
import sqldelight.com.intellij.psi.PsiSwitchExpression;
import sqldelight.com.intellij.psi.PsiSwitchLabeledRuleStatement;
import sqldelight.com.intellij.psi.PsiThisExpression;
import sqldelight.com.intellij.psi.PsiType;
import sqldelight.com.intellij.psi.PsiTypeCastExpression;
import sqldelight.com.intellij.psi.PsiTypeElement;
import sqldelight.com.intellij.psi.PsiTypeParameter;
import sqldelight.com.intellij.psi.PsiVariable;
import sqldelight.com.intellij.psi.PsiYieldStatement;
import sqldelight.com.intellij.psi.ThreadLocalTypes;
import sqldelight.com.intellij.psi.codeStyle.JavaCodeStyleManager;
import sqldelight.com.intellij.psi.impl.source.resolve.graphInference.PsiPolyExpressionUtil;
import sqldelight.com.intellij.psi.infos.MethodCandidateInfo;
import sqldelight.com.intellij.psi.util.CachedValuesManager;
import sqldelight.com.intellij.psi.util.InheritanceUtil;
import sqldelight.com.intellij.psi.util.MethodSignature;
import sqldelight.com.intellij.psi.util.MethodSignatureBackedByPsiMethod;
import sqldelight.com.intellij.psi.util.MethodSignatureUtil;
import sqldelight.com.intellij.psi.util.PsiSuperMethodUtil;
import sqldelight.com.intellij.psi.util.PsiTreeUtil;
import sqldelight.com.intellij.psi.util.PsiTypesUtil;
import sqldelight.com.intellij.psi.util.PsiUtil;
import sqldelight.com.intellij.psi.util.TypeConversionUtil;
import sqldelight.com.intellij.util.Consumer;
import sqldelight.com.intellij.util.IncorrectOperationException;
import sqldelight.com.intellij.util.ObjectUtils;
import sqldelight.com.intellij.util.containers.ContainerUtil;
import sqldelight.org.jetbrains.annotations.Contract;
import sqldelight.org.jetbrains.annotations.NotNull;
import sqldelight.org.jetbrains.annotations.Nullable;

public class LambdaUtil {
    private static final Logger LOG = Logger.getInstance(LambdaUtil.class);

    @Nullable
    public static PsiType getFunctionalInterfaceReturnType(PsiFunctionalExpression expr) {
        return LambdaUtil.getFunctionalInterfaceReturnType(expr.getFunctionalInterfaceType());
    }

    @Nullable
    public static PsiType getFunctionalInterfaceReturnType(@Nullable PsiType functionalInterfaceType) {
        MethodSignature methodSignature;
        PsiClassType.ClassResolveResult resolveResult = PsiUtil.resolveGenericsClassInType(functionalInterfaceType);
        PsiClass psiClass = resolveResult.getElement();
        if (psiClass != null && (methodSignature = LambdaUtil.getFunction(psiClass)) != null) {
            PsiType returnType = LambdaUtil.getReturnType(psiClass, methodSignature);
            return resolveResult.getSubstitutor().substitute(returnType);
        }
        return null;
    }

    @Contract(value="null -> null")
    @Nullable
    public static PsiMethod getFunctionalInterfaceMethod(@Nullable PsiType functionalInterfaceType) {
        return LambdaUtil.getFunctionalInterfaceMethod(PsiUtil.resolveGenericsClassInType(functionalInterfaceType));
    }

    public static PsiMethod getFunctionalInterfaceMethod(@Nullable PsiElement element) {
        if (element instanceof PsiFunctionalExpression) {
            PsiType samType = ((PsiFunctionalExpression)element).getFunctionalInterfaceType();
            return LambdaUtil.getFunctionalInterfaceMethod(samType);
        }
        return null;
    }

    @Nullable
    public static PsiMethod getFunctionalInterfaceMethod(@NotNull PsiClassType.ClassResolveResult result) {
        if (result == null) {
            LambdaUtil.$$$reportNull$$$0(0);
        }
        return LambdaUtil.getFunctionalInterfaceMethod(result.getElement());
    }

    @Contract(value="null -> null")
    @Nullable
    public static PsiMethod getFunctionalInterfaceMethod(PsiClass aClass) {
        MethodSignature methodSignature = LambdaUtil.getFunction(aClass);
        if (methodSignature != null) {
            return LambdaUtil.getMethod(aClass, methodSignature);
        }
        return null;
    }

    public static PsiSubstitutor getSubstitutor(@NotNull PsiMethod method, @NotNull PsiClassType.ClassResolveResult resolveResult) {
        PsiClass derivedClass;
        if (method == null) {
            LambdaUtil.$$$reportNull$$$0(1);
        }
        if (resolveResult == null) {
            LambdaUtil.$$$reportNull$$$0(2);
        }
        LOG.assertTrue((derivedClass = resolveResult.getElement()) != null);
        PsiClass methodContainingClass = method.getContainingClass();
        LOG.assertTrue(methodContainingClass != null);
        PsiSubstitutor initialSubst = resolveResult.getSubstitutor();
        PsiSubstitutor superClassSubstitutor = TypeConversionUtil.getSuperClassSubstitutor(methodContainingClass, derivedClass, PsiSubstitutor.EMPTY);
        for (PsiTypeParameter param : superClassSubstitutor.getSubstitutionMap().keySet()) {
            initialSubst = initialSubst.put(param, initialSubst.substitute(superClassSubstitutor.substitute(param)));
        }
        return initialSubst;
    }

    public static boolean isFunctionalType(PsiType type2) {
        if (type2 instanceof PsiIntersectionType) {
            return LambdaUtil.extractFunctionalConjunct((PsiIntersectionType)type2) != null;
        }
        return LambdaUtil.isFunctionalClass(PsiUtil.resolveClassInClassTypeOnly(type2));
    }

    @Contract(value="null -> false")
    public static boolean isFunctionalClass(PsiClass aClass) {
        if (aClass != null) {
            if (aClass instanceof PsiTypeParameter) {
                return false;
            }
            return LambdaUtil.getFunction(aClass) != null;
        }
        return false;
    }

    @Contract(value="null -> false")
    public static boolean isValidLambdaContext(@Nullable PsiElement context) {
        PsiSwitchBlock switchBlock;
        PsiElement parent;
        PsiSwitchExpression switchExpression;
        if (LambdaUtil.isAssignmentOrInvocationContext(context = PsiUtil.skipParenthesizedExprUp(context)) || context instanceof PsiTypeCastExpression) {
            return true;
        }
        if (context instanceof PsiConditionalExpression) {
            PsiElement parentContext = PsiUtil.skipParenthesizedExprUp(context.getParent());
            if (LambdaUtil.isAssignmentOrInvocationContext(parentContext)) {
                return true;
            }
            if (parentContext instanceof PsiConditionalExpression) {
                return LambdaUtil.isValidLambdaContext(parentContext);
            }
        }
        if (context instanceof PsiYieldStatement && (switchExpression = ((PsiYieldStatement)context).findEnclosingExpression()) != null) {
            return LambdaUtil.isValidLambdaContext(switchExpression.getParent());
        }
        if (context instanceof PsiExpressionStatement && (parent = context.getParent()) instanceof PsiSwitchLabeledRuleStatement && (switchBlock = ((PsiSwitchLabeledRuleStatement)parent).getEnclosingSwitchBlock()) != null) {
            return LambdaUtil.isValidLambdaContext(switchBlock.getParent());
        }
        return false;
    }

    @Contract(value="null -> false")
    private static boolean isAssignmentOrInvocationContext(PsiElement context) {
        return LambdaUtil.isAssignmentContext(context) || LambdaUtil.isInvocationContext(context);
    }

    private static boolean isInvocationContext(@Nullable PsiElement context) {
        return context instanceof PsiExpressionList;
    }

    private static boolean isAssignmentContext(PsiElement context) {
        return context instanceof PsiLambdaExpression || context instanceof PsiReturnStatement || context instanceof PsiAssignmentExpression || context instanceof PsiVariable && !LambdaUtil.withInferredType((PsiVariable)context) || context instanceof PsiArrayInitializerExpression;
    }

    private static boolean withInferredType(PsiVariable variable) {
        PsiTypeElement typeElement = variable.getTypeElement();
        return typeElement != null && typeElement.isInferredType();
    }

    @Contract(value="null -> null")
    @Nullable
    public static MethodSignature getFunction(PsiClass psiClass) {
        if (LambdaUtil.isPlainInterface(psiClass)) {
            return CachedValuesManager.getProjectPsiDependentCache(psiClass, LambdaUtil::calcFunction);
        }
        return null;
    }

    private static boolean isPlainInterface(PsiClass psiClass) {
        return psiClass != null && psiClass.isInterface() && !psiClass.isAnnotationType();
    }

    @Nullable
    private static MethodSignature calcFunction(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            LambdaUtil.$$$reportNull$$$0(3);
        }
        if (LambdaUtil.hasManyOwnAbstractMethods(psiClass) || LambdaUtil.hasManyInheritedAbstractMethods(psiClass)) {
            return null;
        }
        List<HierarchicalMethodSignature> functions = LambdaUtil.findFunctionCandidates(psiClass);
        return functions != null && functions.size() == 1 ? (MethodSignature)functions.get(0) : null;
    }

    private static boolean hasManyOwnAbstractMethods(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            LambdaUtil.$$$reportNull$$$0(4);
        }
        int abstractCount = 0;
        for (PsiMethod method : psiClass.getMethods()) {
            if (!LambdaUtil.isDefinitelyAbstractInterfaceMethod(method) || ++abstractCount <= 1) continue;
            return true;
        }
        return false;
    }

    private static boolean isDefinitelyAbstractInterfaceMethod(PsiMethod method) {
        return method.hasModifierProperty("abstract") && !LambdaUtil.isPublicObjectMethod(method.getName());
    }

    private static boolean isPublicObjectMethod(String methodName) {
        return "equals".equals(methodName) || "hashCode".equals(methodName) || "toString".equals(methodName);
    }

    private static boolean hasManyInheritedAbstractMethods(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            LambdaUtil.$$$reportNull$$$0(5);
        }
        HashSet abstractNames = new HashSet();
        HashSet defaultNames = new HashSet();
        InheritanceUtil.processSupers(psiClass, true, psiClass1 -> {
            for (PsiMethod method : psiClass1.getMethods()) {
                if (LambdaUtil.isDefinitelyAbstractInterfaceMethod(method)) {
                    abstractNames.add(method.getName());
                    continue;
                }
                if (!method.hasModifierProperty("default")) continue;
                defaultNames.add(method.getName());
            }
            return true;
        });
        abstractNames.removeAll(defaultNames);
        return abstractNames.size() > 1;
    }

    private static boolean overridesPublicObjectMethod(HierarchicalMethodSignature psiMethod) {
        PsiMethod method;
        PsiClass containingClass;
        List<HierarchicalMethodSignature> signatures = psiMethod.getSuperSignatures();
        if (signatures.isEmpty() && (containingClass = (method = psiMethod.getMethod()).getContainingClass()) != null && "java.lang.Object".equals(containingClass.getQualifiedName()) && method.hasModifierProperty("public")) {
            return true;
        }
        for (HierarchicalMethodSignature superMethod : signatures) {
            if (!LambdaUtil.overridesPublicObjectMethod(superMethod)) continue;
            return true;
        }
        return false;
    }

    private static MethodSignature getMethodSignature(PsiMethod method, PsiClass psiClass, PsiClass containingClass) {
        MethodSignature methodSignature = containingClass != null && containingClass != psiClass ? method.getSignature(TypeConversionUtil.getSuperClassSubstitutor(containingClass, psiClass, PsiSubstitutor.EMPTY)) : method.getSignature(PsiSubstitutor.EMPTY);
        return methodSignature;
    }

    @NotNull
    private static List<HierarchicalMethodSignature> hasSubSignature(List<HierarchicalMethodSignature> signatures) {
        for (HierarchicalMethodSignature signature : signatures) {
            boolean subSignature = true;
            for (HierarchicalMethodSignature methodSignature : signatures) {
                if (signature.equals(methodSignature) || LambdaUtil.skipMethod(signature, methodSignature)) continue;
                subSignature = false;
                break;
            }
            if (!subSignature) continue;
            List<HierarchicalMethodSignature> list = Collections.singletonList(signature);
            if (list == null) {
                LambdaUtil.$$$reportNull$$$0(6);
            }
            return list;
        }
        List<HierarchicalMethodSignature> list = signatures;
        if (list == null) {
            LambdaUtil.$$$reportNull$$$0(7);
        }
        return list;
    }

    private static boolean skipMethod(HierarchicalMethodSignature signature, HierarchicalMethodSignature methodSignature) {
        if (methodSignature.getTypeParameters().length == 0) {
            return false;
        }
        return signature.getMethod().getContainingClass() != methodSignature.getMethod().getContainingClass();
    }

    @Contract(value="null -> null")
    @Nullable
    public static List<HierarchicalMethodSignature> findFunctionCandidates(@Nullable PsiClass psiClass) {
        if (!LambdaUtil.isPlainInterface(psiClass)) {
            return null;
        }
        ArrayList<HierarchicalMethodSignature> methods = new ArrayList<HierarchicalMethodSignature>();
        Map<MethodSignature, Set<PsiMethod>> overrideEquivalents = PsiSuperMethodUtil.collectOverrideEquivalents(psiClass);
        Collection<HierarchicalMethodSignature> visibleSignatures = psiClass.getVisibleSignatures();
        for (HierarchicalMethodSignature signature : visibleSignatures) {
            PsiMethod psiMethod = signature.getMethod();
            if (!psiMethod.hasModifierProperty("abstract") || psiMethod.hasModifierProperty("static")) continue;
            Set<PsiMethod> equivalentMethods = overrideEquivalents.get(signature);
            if (equivalentMethods != null && equivalentMethods.size() > 1) {
                boolean hasNonAbstractOverrideEquivalent = false;
                for (PsiMethod method : equivalentMethods) {
                    if (method.hasModifierProperty("abstract") || MethodSignatureUtil.isSuperMethod(method, psiMethod)) continue;
                    hasNonAbstractOverrideEquivalent = true;
                    break;
                }
                if (hasNonAbstractOverrideEquivalent) continue;
            }
            if (LambdaUtil.overridesPublicObjectMethod(signature)) continue;
            methods.add(signature);
        }
        return LambdaUtil.hasSubSignature(methods);
    }

    @Nullable
    private static PsiType getReturnType(PsiClass psiClass, MethodSignature methodSignature) {
        PsiMethod method = LambdaUtil.getMethod(psiClass, methodSignature);
        if (method != null) {
            PsiClass containingClass = method.getContainingClass();
            if (containingClass == null) {
                return null;
            }
            return TypeConversionUtil.getSuperClassSubstitutor(containingClass, psiClass, PsiSubstitutor.EMPTY).substitute(method.getReturnType());
        }
        return null;
    }

    @Nullable
    private static PsiMethod getMethod(PsiClass psiClass, MethodSignature methodSignature) {
        PsiMethod[] methodsByName;
        if (methodSignature instanceof MethodSignatureBackedByPsiMethod) {
            return ((MethodSignatureBackedByPsiMethod)methodSignature).getMethod();
        }
        for (PsiMethod psiMethod : methodsByName = psiClass.findMethodsByName(methodSignature.getName(), true)) {
            if (!MethodSignatureUtil.areSignaturesEqual(LambdaUtil.getMethodSignature(psiMethod, psiClass, psiMethod.getContainingClass()), methodSignature)) continue;
            return psiMethod;
        }
        return null;
    }

    public static int getLambdaIdx(PsiExpressionList expressionList, PsiElement element) {
        PsiExpression[] expressions = expressionList.getExpressions();
        for (int i = 0; i < expressions.length; ++i) {
            PsiExpression expression = expressions[i];
            if (!PsiTreeUtil.isAncestor(expression, element, false)) continue;
            return i;
        }
        return -1;
    }

    @Nullable
    public static PsiType getFunctionalInterfaceType(PsiElement expression, boolean tryToSubstitute) {
        PsiSwitchExpression switchExpression;
        PsiElement parent = expression.getParent();
        PsiElement element = expression;
        while (parent instanceof PsiParenthesizedExpression || parent instanceof PsiConditionalExpression) {
            if (parent instanceof PsiConditionalExpression && ((PsiConditionalExpression)parent).getCondition() == element) {
                return PsiType.BOOLEAN;
            }
            element = parent;
            parent = parent.getParent();
        }
        PsiType type2 = ThreadLocalTypes.getElementType(expression);
        if (type2 == null) {
            type2 = ThreadLocalTypes.getElementType(element);
        }
        if (type2 != null) {
            return type2;
        }
        if (parent instanceof PsiArrayInitializerExpression) {
            PsiType psiType = ((PsiArrayInitializerExpression)parent).getType();
            if (psiType instanceof PsiArrayType) {
                return ((PsiArrayType)psiType).getComponentType();
            }
        } else {
            if (parent instanceof PsiTypeCastExpression) {
                PsiType conjunct;
                PsiType castType;
                PsiTypeElement castTypeElement = ((PsiTypeCastExpression)parent).getCastType();
                PsiType psiType = castType = castTypeElement != null ? castTypeElement.getType() : null;
                if (castType instanceof PsiIntersectionType && (conjunct = LambdaUtil.extractFunctionalConjunct((PsiIntersectionType)castType)) != null) {
                    return conjunct;
                }
                return castType;
            }
            if (parent instanceof PsiVariable) {
                return ((PsiVariable)parent).getType();
            }
            if (parent instanceof PsiAssignmentExpression && expression instanceof PsiExpression && !PsiUtil.isOnAssignmentLeftHand((PsiExpression)expression)) {
                PsiExpression lExpression = ((PsiAssignmentExpression)parent).getLExpression();
                return lExpression.getType();
            }
            if (parent instanceof PsiExpressionList) {
                PsiExpressionList expressionList = (PsiExpressionList)parent;
                int lambdaIdx = LambdaUtil.getLambdaIdx(expressionList, expression);
                if (lambdaIdx >= 0) {
                    PsiElement gParent = expressionList.getParent();
                    if (gParent instanceof PsiAnonymousClass) {
                        gParent = gParent.getParent();
                    }
                    if (gParent instanceof PsiCall) {
                        PsiCall contextCall = (PsiCall)gParent;
                        JavaResolveResult resolveResult = PsiDiamondType.getDiamondsAwareResolveResult(contextCall);
                        PsiElement resultElement = resolveResult.getElement();
                        LOG.assertTrue(!MethodCandidateInfo.isOverloadCheck(contextCall.getArgumentList()) || !(resultElement instanceof PsiMethod) || !((PsiMethod)resultElement).hasTypeParameters());
                        return LambdaUtil.getSubstitutedType(expression, tryToSubstitute, lambdaIdx, resolveResult);
                    }
                }
            } else {
                if (parent instanceof PsiReturnStatement) {
                    return PsiTypesUtil.getMethodReturnType(parent);
                }
                if (parent instanceof PsiLambdaExpression) {
                    return LambdaUtil.getFunctionalInterfaceTypeByContainingLambda((PsiLambdaExpression)parent);
                }
            }
        }
        if ((switchExpression = PsiTreeUtil.getParentOfType(element, PsiSwitchExpression.class)) != null && PsiUtil.getSwitchResultExpressions(switchExpression).contains(element)) {
            return LambdaUtil.getFunctionalInterfaceType(switchExpression, tryToSubstitute);
        }
        return null;
    }

    @Nullable
    private static PsiType getSubstitutedType(PsiElement expression, boolean tryToSubstitute, int lambdaIdx, JavaResolveResult resolveResult) {
        PsiParameter[] parameters2;
        int finalLambdaIdx;
        PsiElement resolve = resolveResult.getElement();
        if (resolve instanceof PsiMethod && (finalLambdaIdx = LambdaUtil.adjustLambdaIdx(lambdaIdx, (PsiMethod)resolve, parameters2 = ((PsiMethod)resolve).getParameterList().getParameters())) < parameters2.length) {
            if (!tryToSubstitute) {
                return LambdaUtil.getNormalizedType(parameters2[finalLambdaIdx]);
            }
            return PsiResolveHelper.ourGraphGuard.doPreventingRecursion(expression, !MethodCandidateInfo.isOverloadCheck(), () -> {
                PsiType normalizedType = LambdaUtil.getNormalizedType(parameters2[finalLambdaIdx]);
                if (resolveResult instanceof MethodCandidateInfo && ((MethodCandidateInfo)resolveResult).isRawSubstitution()) {
                    return TypeConversionUtil.erasure(normalizedType);
                }
                return resolveResult.getSubstitutor().substitute(normalizedType);
            });
        }
        return null;
    }

    public static boolean processParentOverloads(PsiFunctionalExpression functionalExpression, Consumer<? super PsiType> overloadProcessor) {
        PsiExpressionList expressionList;
        int lambdaIdx;
        LOG.assertTrue(PsiTypesUtil.getExpectedTypeByParent(functionalExpression) == null);
        PsiElement parent = functionalExpression.getParent();
        PsiElement expr = functionalExpression;
        while (!(!(parent instanceof PsiParenthesizedExpression) && !(parent instanceof PsiConditionalExpression) || parent instanceof PsiConditionalExpression && ((PsiConditionalExpression)parent).getThenExpression() != expr && ((PsiConditionalExpression)parent).getElseExpression() != expr)) {
            expr = parent;
            parent = parent.getParent();
        }
        if (parent instanceof PsiExpressionList && (lambdaIdx = LambdaUtil.getLambdaIdx(expressionList = (PsiExpressionList)parent, functionalExpression)) > -1) {
            PsiElement gParent = expressionList.getParent();
            if (gParent instanceof PsiAnonymousClass) {
                gParent = gParent.getParent();
            }
            JavaResolveResult[] results = null;
            if (gParent instanceof PsiMethodCallExpression) {
                results = ((PsiMethodCallExpression)gParent).getMethodExpression().multiResolve(true);
            } else if (gParent instanceof PsiConstructorCall) {
                results = LambdaUtil.getConstructorCandidates((PsiConstructorCall)gParent);
            }
            if (results != null) {
                HashSet<PsiType> types = new HashSet<PsiType>();
                for (JavaResolveResult result : results) {
                    PsiType functionalExpressionType = MethodCandidateInfo.ourOverloadGuard.doPreventingRecursion(functionalExpression, false, () -> LambdaUtil.getSubstitutedType(functionalExpression, true, lambdaIdx, result));
                    if (functionalExpressionType == null || !types.add(functionalExpressionType)) continue;
                    overloadProcessor.consume(functionalExpressionType);
                }
                return true;
            }
        }
        return false;
    }

    private static JavaResolveResult @Nullable [] getConstructorCandidates(PsiConstructorCall parentCall) {
        JavaPsiFacade facade = JavaPsiFacade.getInstance(parentCall.getProject());
        PsiExpressionList argumentList = parentCall.getArgumentList();
        if (argumentList != null) {
            PsiClassType classType = null;
            if (parentCall instanceof PsiNewExpression) {
                PsiJavaCodeReferenceElement ref = ((PsiNewExpression)parentCall).getClassReference();
                classType = ref != null ? facade.getElementFactory().createType(ref) : null;
            } else if (parentCall instanceof PsiEnumConstant) {
                PsiClass containingClass = ((PsiEnumConstant)parentCall).getContainingClass();
                PsiClassType psiClassType = classType = containingClass != null ? facade.getElementFactory().createType(containingClass) : null;
            }
            if (classType != null) {
                return facade.getResolveHelper().multiResolveConstructor(classType, argumentList, parentCall);
            }
        }
        return null;
    }

    @Nullable
    private static PsiType extractFunctionalConjunct(PsiIntersectionType type2) {
        PsiType conjunct = null;
        MethodSignature commonSignature = null;
        for (PsiType psiType : type2.getConjuncts()) {
            MethodSignature signature;
            PsiClass aClass = PsiUtil.resolveClassInClassTypeOnly(psiType);
            if (aClass instanceof PsiTypeParameter || (signature = LambdaUtil.getFunction(aClass)) == null) continue;
            if (commonSignature == null) {
                commonSignature = signature;
            } else if (!MethodSignatureUtil.areSignaturesEqual(commonSignature, signature)) {
                return null;
            }
            conjunct = psiType;
        }
        return conjunct;
    }

    private static PsiType getFunctionalInterfaceTypeByContainingLambda(@NotNull PsiLambdaExpression parentLambda) {
        PsiType parentInterfaceType;
        if (parentLambda == null) {
            LambdaUtil.$$$reportNull$$$0(8);
        }
        return (parentInterfaceType = parentLambda.getFunctionalInterfaceType()) != null ? LambdaUtil.getFunctionalInterfaceReturnType(parentInterfaceType) : null;
    }

    private static int adjustLambdaIdx(int lambdaIdx, PsiMethod resolve, PsiParameter[] parameters2) {
        int finalLambdaIdx = resolve.isVarArgs() && lambdaIdx >= parameters2.length ? parameters2.length - 1 : lambdaIdx;
        return finalLambdaIdx;
    }

    private static PsiType getNormalizedType(PsiParameter parameter) {
        PsiType type2 = parameter.getType();
        if (type2 instanceof PsiEllipsisType) {
            return ((PsiEllipsisType)type2).getComponentType();
        }
        return type2;
    }

    @Contract(value="null -> false", pure=true)
    public static boolean notInferredType(PsiType typeByExpression) {
        return typeByExpression instanceof PsiMethodReferenceType || typeByExpression instanceof PsiLambdaExpressionType || typeByExpression instanceof PsiLambdaParameterType;
    }

    public static PsiReturnStatement @NotNull [] getReturnStatements(PsiLambdaExpression lambdaExpression) {
        PsiElement body = lambdaExpression.getBody();
        PsiReturnStatement[] psiReturnStatementArray = body instanceof PsiCodeBlock ? PsiUtil.findReturnStatements((PsiCodeBlock)body) : PsiReturnStatement.EMPTY_ARRAY;
        if (psiReturnStatementArray == null) {
            LambdaUtil.$$$reportNull$$$0(9);
        }
        return psiReturnStatementArray;
    }

    public static List<PsiExpression> getReturnExpressions(PsiLambdaExpression lambdaExpression) {
        PsiElement body = lambdaExpression.getBody();
        if (body instanceof PsiExpression) {
            return Collections.singletonList((PsiExpression)body);
        }
        ArrayList<PsiExpression> result = new ArrayList<PsiExpression>();
        for (PsiReturnStatement returnStatement : LambdaUtil.getReturnStatements(lambdaExpression)) {
            PsiExpression returnValue = returnStatement.getReturnValue();
            if (returnValue == null) continue;
            result.add(returnValue);
        }
        return result;
    }

    @Contract(value="null -> false")
    public static boolean isExpressionStatementExpression(PsiElement body) {
        return body instanceof PsiAssignmentExpression || PsiUtil.isIncrementDecrementOperation(body) || body instanceof PsiMethodCallExpression || body instanceof PsiNewExpression && !((PsiNewExpression)body).isArrayCreation() || body instanceof PsiReferenceExpression && !body.isPhysical();
    }

    public static PsiExpression extractSingleExpressionFromBody(PsiElement body) {
        PsiExpression expression = null;
        if (body instanceof PsiExpression) {
            expression = (PsiExpression)body;
        } else if (body instanceof PsiCodeBlock) {
            PsiStatement[] statements = ((PsiCodeBlock)body).getStatements();
            if (statements.length == 1) {
                if (statements[0] instanceof PsiReturnStatement) {
                    expression = ((PsiReturnStatement)statements[0]).getReturnValue();
                } else if (statements[0] instanceof PsiExpressionStatement) {
                    expression = ((PsiExpressionStatement)statements[0]).getExpression();
                } else if (statements[0] instanceof PsiBlockStatement) {
                    return LambdaUtil.extractSingleExpressionFromBody(((PsiBlockStatement)statements[0]).getCodeBlock());
                }
            }
        } else {
            if (body instanceof PsiBlockStatement) {
                return LambdaUtil.extractSingleExpressionFromBody(((PsiBlockStatement)body).getCodeBlock());
            }
            if (body instanceof PsiExpressionStatement) {
                expression = ((PsiExpressionStatement)body).getExpression();
            }
        }
        return expression;
    }

    public static boolean isPotentiallyCompatibleWithTypeParameter(PsiFunctionalExpression expression, PsiExpressionList argsList, PsiMethod method) {
        PsiParameter[] parameters2;
        PsiParameter lambdaParameter;
        PsiClass paramClass;
        PsiCallExpression callExpression;
        if (!(Registry.is("JDK8042508.bug.fixed", false) || (callExpression = PsiTreeUtil.getParentOfType((PsiElement)argsList, PsiCallExpression.class)) != null && callExpression.getTypeArguments().length <= 0)) {
            return false;
        }
        int lambdaIdx = LambdaUtil.getLambdaIdx(argsList, expression);
        return lambdaIdx >= 0 && (paramClass = PsiUtil.resolveClassInType((lambdaParameter = (parameters2 = method.getParameterList().getParameters())[Math.min(lambdaIdx, parameters2.length - 1)]).getType())) instanceof PsiTypeParameter && ((PsiTypeParameter)paramClass).getOwner() == method;
    }

    public static Map<PsiElement, String> checkReturnTypeCompatible(PsiLambdaExpression lambdaExpression, PsiType functionalInterfaceReturnType) {
        LinkedHashMap<PsiElement, String> errors;
        block15: {
            errors = new LinkedHashMap<PsiElement, String>();
            if (PsiType.VOID.equals(functionalInterfaceReturnType)) {
                PsiElement body = lambdaExpression.getBody();
                if (body instanceof PsiCodeBlock) {
                    for (PsiExpression expression : LambdaUtil.getReturnExpressions(lambdaExpression)) {
                        errors.put(expression, JavaPsiBundle.message("unexpected.return.value", new Object[0]));
                    }
                } else if (body instanceof PsiExpression) {
                    try {
                        if (PsiUtil.isStatement(JavaPsiFacade.getElementFactory(body.getProject()).createStatementFromText(body.getText(), body))) break block15;
                        PsiType type2 = ((PsiExpression)body).getType();
                        if (PsiType.VOID.equals(type2)) {
                            errors.put(body, JavaPsiBundle.message("lambda.body.must.be.a.statement.expression", new Object[0]));
                            break block15;
                        }
                        errors.put(body, JavaPsiBundle.message("bad.return.type.in.lambda.expression1", type2 == PsiType.NULL || type2 == null ? "<null>" : type2.getPresentableText()));
                    }
                    catch (IncorrectOperationException type2) {}
                }
            } else if (functionalInterfaceReturnType != null) {
                List<PsiExpression> returnExpressions = LambdaUtil.getReturnExpressions(lambdaExpression);
                for (PsiExpression expression : returnExpressions) {
                    PsiType expressionType = PsiResolveHelper.ourGraphGuard.doPreventingRecursion(expression, true, expression::getType);
                    if (expressionType == null || functionalInterfaceReturnType.isAssignableFrom(expressionType)) continue;
                    errors.put(expression, JavaPsiBundle.message("bad.return.type.in.lambda.expression", expressionType.getPresentableText(), functionalInterfaceReturnType.getPresentableText()));
                }
                PsiReturnStatement[] returnStatements = LambdaUtil.getReturnStatements(lambdaExpression);
                if (returnStatements.length > returnExpressions.size()) {
                    for (PsiReturnStatement statement : returnStatements) {
                        PsiExpression value = statement.getReturnValue();
                        if (value != null) continue;
                        errors.put(statement, JavaPsiBundle.message("missing.return.value.lambda", new Object[0]));
                    }
                } else if (returnExpressions.isEmpty() && !lambdaExpression.isVoidCompatible()) {
                    errors.put(lambdaExpression, JavaPsiBundle.message("missing.return.value.lambda", new Object[0]));
                }
            }
        }
        return errors.isEmpty() ? null : errors;
    }

    @Nullable
    public static PsiType getLambdaParameterFromType(PsiType functionalInterfaceType, int parameterIndex) {
        PsiParameter[] parameters2;
        PsiClassType.ClassResolveResult resolveResult = PsiUtil.resolveGenericsClassInType(functionalInterfaceType);
        PsiMethod method = LambdaUtil.getFunctionalInterfaceMethod(functionalInterfaceType);
        if (method != null && parameterIndex < (parameters2 = method.getParameterList().getParameters()).length) {
            return LambdaUtil.getSubstitutor(method, resolveResult).substitute(parameters2[parameterIndex].getType());
        }
        return null;
    }

    @Nullable
    public static PsiCall treeWalkUp(PsiElement context) {
        PsiCall top = null;
        Object parent = PsiTreeUtil.getParentOfType(context, PsiExpressionList.class, PsiLambdaExpression.class, PsiConditionalExpression.class, PsiSwitchExpression.class, PsiAssignmentExpression.class, PsiCodeBlock.class, PsiCall.class);
        while (!(parent instanceof PsiCall) && !(parent instanceof PsiAssignmentExpression)) {
            PsiCall psiCall;
            PsiLambdaExpression lambdaExpression = PsiTreeUtil.getParentOfType(parent, PsiLambdaExpression.class);
            if (parent instanceof PsiCodeBlock) {
                if (lambdaExpression == null) break;
                boolean inReturnExpressions = false;
                for (PsiExpression expression : LambdaUtil.getReturnExpressions(lambdaExpression)) {
                    inReturnExpressions |= PsiTreeUtil.isAncestor(expression, context, false);
                }
                if (!inReturnExpressions || ThreadLocalTypes.hasBindingFor(lambdaExpression)) break;
            }
            if ((parent instanceof PsiConditionalExpression || parent instanceof PsiSwitchExpression) && !PsiPolyExpressionUtil.isPolyExpression((PsiExpression)parent) || parent instanceof PsiLambdaExpression && ThreadLocalTypes.hasBindingFor(parent) || (psiCall = PsiTreeUtil.getParentOfType(parent, PsiCall.class, false, new Class[]{PsiMember.class, PsiVariable.class, PsiAssignmentExpression.class, PsiTypeCastExpression.class})) == null || MethodCandidateInfo.isOverloadCheck(psiCall.getArgumentList()) || lambdaExpression != null && ThreadLocalTypes.hasBindingFor(lambdaExpression) || !((top = psiCall) instanceof PsiExpression) || !PsiPolyExpressionUtil.isPolyExpression((PsiExpression)((Object)top))) break;
            parent = PsiTreeUtil.getParentOfType(parent.getParent(), PsiExpressionList.class, PsiLambdaExpression.class, PsiAssignmentExpression.class, PsiCodeBlock.class);
        }
        if (top == null) {
            return null;
        }
        PsiExpressionList argumentList = top.getArgumentList();
        if (argumentList == null) {
            return null;
        }
        LOG.assertTrue(!MethodCandidateInfo.isOverloadCheck(argumentList));
        return top;
    }

    public static PsiCall copyTopLevelCall(@NotNull PsiCall call) {
        PsiElement parent;
        if (call == null) {
            LambdaUtil.$$$reportNull$$$0(10);
        }
        if (call instanceof PsiEnumConstant) {
            PsiClass containingClass = ((PsiEnumConstant)call).getContainingClass();
            if (containingClass == null) {
                return null;
            }
            String enumName = containingClass.getName();
            if (enumName == null) {
                return null;
            }
            PsiMethod resolveMethod = call.resolveMethod();
            if (resolveMethod == null) {
                return null;
            }
            PsiElement contextFile = call.getContainingFile().copy();
            PsiClass anEnum = (PsiClass)contextFile.add(JavaPsiFacade.getElementFactory(call.getProject()).createEnum(enumName));
            anEnum.add(resolveMethod);
            return (PsiCall)anEnum.add(call);
        }
        PsiElement expressionForType = call;
        while ((parent = PsiUtil.skipParenthesizedExprUp(expressionForType.getParent())) instanceof PsiConditionalExpression && !PsiTreeUtil.isAncestor(((PsiConditionalExpression)parent).getCondition(), expressionForType, false)) {
            expressionForType = parent;
        }
        PsiType type2 = PsiTypesUtil.getExpectedTypeByParent(expressionForType);
        if (PsiTypesUtil.isDenotableType(type2, call)) {
            return (PsiCall)LambdaUtil.copyWithExpectedType(call, type2);
        }
        return (PsiCall)call.copy();
    }

    public static <T> T performWithSubstitutedParameterBounds(PsiTypeParameter[] typeParameters, PsiSubstitutor substitutor, Supplier<? extends T> producer) {
        return (T)ThreadLocalTypes.performWithTypes(map -> {
            for (PsiTypeParameter parameter : typeParameters) {
                PsiClassType[] types = parameter.getExtendsListTypes();
                if (types.length <= 0) continue;
                List<PsiType> conjuncts = ContainerUtil.map(types, substitutor::substitute);
                PsiType upperBound = PsiIntersectionType.createIntersection(false, conjuncts.toArray(PsiType.EMPTY_ARRAY));
                map.forceType(parameter, upperBound);
            }
            return producer.get();
        });
    }

    public static <T> T performWithTargetType(@NotNull PsiElement element, @NotNull PsiType targetType, @NotNull Supplier<? extends T> producer) {
        if (element == null) {
            LambdaUtil.$$$reportNull$$$0(11);
        }
        if (targetType == null) {
            LambdaUtil.$$$reportNull$$$0(12);
        }
        if (producer == null) {
            LambdaUtil.$$$reportNull$$$0(13);
        }
        return (T)ThreadLocalTypes.performWithTypes(types -> {
            types.forceType(element, targetType);
            return producer.get();
        });
    }

    public static String createLambda(@NotNull PsiVariable variable, @NotNull PsiExpression expression) {
        if (variable == null) {
            LambdaUtil.$$$reportNull$$$0(14);
        }
        if (expression == null) {
            LambdaUtil.$$$reportNull$$$0(15);
        }
        return variable.getName() + " -> " + expression.getText();
    }

    public static boolean isIdentityLambda(PsiLambdaExpression lambda2) {
        PsiParameterList parameters2 = lambda2.getParameterList();
        if (parameters2.getParametersCount() != 1) {
            return false;
        }
        PsiExpression expression = PsiUtil.skipParenthesizedExprDown(LambdaUtil.extractSingleExpressionFromBody(lambda2.getBody()));
        return expression instanceof PsiReferenceExpression && ((PsiReferenceExpression)expression).isReferenceTo(parameters2.getParameters()[0]);
    }

    private static boolean isSafeLambdaReplacement(@NotNull PsiLambdaExpression lambda2, @NotNull Function<? super PsiLambdaExpression, ? extends PsiExpression> replacer) {
        JavaResolveResult result;
        PsiElement oldTarget;
        PsiElement body;
        if (lambda2 == null) {
            LambdaUtil.$$$reportNull$$$0(16);
        }
        if (replacer == null) {
            LambdaUtil.$$$reportNull$$$0(17);
        }
        if ((body = lambda2.getBody()) == null) {
            return false;
        }
        PsiCall call = LambdaUtil.treeWalkUp(body);
        if (call != null && (oldTarget = (result = call.resolveMethodGenerics()).getElement()) != null) {
            PsiExpression expressionFromBody;
            String copyMessage;
            String origErrorMessage = result instanceof MethodCandidateInfo ? ((MethodCandidateInfo)result).getInferenceErrorMessage() : null;
            Object marker = new Object();
            PsiTreeUtil.mark(lambda2, marker);
            PsiType origType = call instanceof PsiExpression ? ((PsiExpression)((Object)call)).getType() : null;
            PsiCall copyCall = LambdaUtil.copyTopLevelCall(call);
            if (copyCall == null) {
                return false;
            }
            PsiLambdaExpression lambdaCopy = ObjectUtils.tryCast(PsiTreeUtil.releaseMark(copyCall, marker), PsiLambdaExpression.class);
            if (lambdaCopy == null) {
                return false;
            }
            PsiExpression function = replacer.apply(lambdaCopy);
            if (function == null) {
                return false;
            }
            JavaResolveResult resultCopy = copyCall.resolveMethodGenerics();
            if (resultCopy.getElement() != oldTarget) {
                return false;
            }
            String string = copyMessage = resultCopy instanceof MethodCandidateInfo ? ((MethodCandidateInfo)resultCopy).getInferenceErrorMessage() : null;
            if (!Objects.equals(origErrorMessage, copyMessage)) {
                return false;
            }
            if (function instanceof PsiFunctionalExpression && ((PsiFunctionalExpression)function).getFunctionalInterfaceType() == null) {
                return false;
            }
            if (origType instanceof PsiClassType && !((PsiClassType)origType).isRaw() && !lambda2.hasFormalParameterTypes() && (expressionFromBody = LambdaUtil.extractSingleExpressionFromBody(body)) instanceof PsiMethodCallExpression && PsiTypesUtil.isUncheckedCall(((PsiMethodCallExpression)expressionFromBody).resolveMethodGenerics())) {
                return false;
            }
        }
        return true;
    }

    public static boolean isSafeLambdaReplacement(@NotNull PsiLambdaExpression lambda2, @NotNull Supplier<? extends PsiExpression> newFunctionSupplier) {
        if (lambda2 == null) {
            LambdaUtil.$$$reportNull$$$0(18);
        }
        if (newFunctionSupplier == null) {
            LambdaUtil.$$$reportNull$$$0(19);
        }
        return LambdaUtil.isSafeLambdaReplacement(lambda2, (? super PsiLambdaExpression l) -> {
            PsiExpression replacement = (PsiExpression)newFunctionSupplier.get();
            return replacement == null ? null : (PsiExpression)l.replace(replacement);
        });
    }

    public static boolean isSafeLambdaReplacement(@NotNull PsiLambdaExpression lambda2, @NotNull String replacementText) {
        if (lambda2 == null) {
            LambdaUtil.$$$reportNull$$$0(20);
        }
        if (replacementText == null) {
            LambdaUtil.$$$reportNull$$$0(21);
        }
        return LambdaUtil.isSafeLambdaReplacement(lambda2, () -> JavaPsiFacade.getElementFactory(lambda2.getProject()).createExpressionFromText(replacementText, lambda2.getParent()));
    }

    public static boolean isSafeLambdaBodyReplacement(@NotNull PsiLambdaExpression lambda2, @NotNull Supplier<? extends PsiElement> newBodySupplier) {
        if (lambda2 == null) {
            LambdaUtil.$$$reportNull$$$0(22);
        }
        if (newBodySupplier == null) {
            LambdaUtil.$$$reportNull$$$0(23);
        }
        return LambdaUtil.isSafeLambdaReplacement(lambda2, (? super PsiLambdaExpression l) -> {
            PsiElement oldBody = l.getBody();
            PsiElement newBody = (PsiElement)newBodySupplier.get();
            if (oldBody == null || newBody == null) {
                return null;
            }
            oldBody.replace(newBody);
            return l;
        });
    }

    public static boolean isSafeLambdaReturnValueReplacement(@NotNull PsiExpression lambdaReturnExpression, @NotNull PsiExpression replacement) {
        PsiLambdaExpression lambdaExpression;
        if (lambdaReturnExpression == null) {
            LambdaUtil.$$$reportNull$$$0(24);
        }
        if (replacement == null) {
            LambdaUtil.$$$reportNull$$$0(25);
        }
        return !(lambdaReturnExpression.getParent() instanceof PsiReturnStatement) && !(lambdaReturnExpression.getParent() instanceof PsiLambdaExpression) || (lambdaExpression = PsiTreeUtil.getParentOfType((PsiElement)lambdaReturnExpression, PsiLambdaExpression.class, true, PsiMethod.class)) == null || LambdaUtil.isSafeLambdaBodyReplacement(lambdaExpression, () -> {
            PsiLambdaExpression lambdaExpression1 = PsiTreeUtil.getParentOfType((PsiElement)lambdaReturnExpression, PsiLambdaExpression.class);
            if (lambdaExpression1 == null) {
                return null;
            }
            PsiElement body = lambdaExpression1.getBody();
            if (body == null) {
                return null;
            }
            Object marker = new Object();
            PsiTreeUtil.mark(lambdaReturnExpression, marker);
            PsiElement copy = body.copy();
            PsiElement exprInReturn = PsiTreeUtil.releaseMark(copy, marker);
            if (exprInReturn == null) {
                return null;
            }
            if (exprInReturn == copy) {
                return exprInReturn.replace(replacement);
            }
            exprInReturn.replace(replacement);
            return copy;
        });
    }

    @NotNull
    public static PsiElement copyWithExpectedType(PsiElement expression, PsiType type2) {
        String canonicalText = type2.getCanonicalText();
        if (!PsiUtil.isLanguageLevel8OrHigher(expression)) {
            String arrayInitializer = "new " + canonicalText + "[]{0}";
            PsiNewExpression newExpr = (PsiNewExpression)LambdaUtil.createExpressionFromText(arrayInitializer, expression);
            PsiArrayInitializerExpression initializer2 = newExpr.getArrayInitializer();
            LOG.assertTrue(initializer2 != null);
            PsiElement psiElement = initializer2.getInitializers()[0].replace(expression);
            if (psiElement == null) {
                LambdaUtil.$$$reportNull$$$0(26);
            }
            return psiElement;
        }
        String callableWithExpectedType = "(java.util.concurrent.Callable<" + canonicalText + ">)() -> x";
        PsiTypeCastExpression typeCastExpr = (PsiTypeCastExpression)LambdaUtil.createExpressionFromText(callableWithExpectedType, expression);
        PsiLambdaExpression lambdaExpression = (PsiLambdaExpression)typeCastExpr.getOperand();
        LOG.assertTrue(lambdaExpression != null);
        PsiElement body = lambdaExpression.getBody();
        LOG.assertTrue(body instanceof PsiExpression);
        PsiElement psiElement = body.replace(expression);
        if (psiElement == null) {
            LambdaUtil.$$$reportNull$$$0(27);
        }
        return psiElement;
    }

    private static PsiExpression createExpressionFromText(String exprText, PsiElement context) {
        PsiExpression expr = JavaPsiFacade.getElementFactory(context.getProject()).createExpressionFromText(exprText, context);
        return (PsiExpression)JavaCodeStyleManager.getInstance(context.getProject()).shortenClassReferences(expr);
    }

    public static boolean isCapturingLambda(PsiLambdaExpression lambda2) {
        PsiElement body = lambda2.getBody();
        if (body == null) {
            return false;
        }
        class CapturingLambdaVisitor
        extends JavaRecursiveElementWalkingVisitor {
            boolean capturing;
            final /* synthetic */ PsiLambdaExpression val$lambda;

            CapturingLambdaVisitor(PsiLambdaExpression psiLambdaExpression) {
                this.val$lambda = psiLambdaExpression;
            }

            @Override
            public void visitReferenceExpression(PsiReferenceExpression expression) {
                super.visitReferenceExpression(expression);
                if (expression instanceof PsiMethodReferenceExpression) {
                    return;
                }
                if (expression.getParent() instanceof PsiMethodCallExpression && expression.getQualifierExpression() != null) {
                    return;
                }
                PsiElement target = expression.resolve();
                if (target instanceof PsiModifierListOwner && !((PsiModifierListOwner)target).hasModifierProperty("static") && !PsiTreeUtil.isAncestor(this.val$lambda, target, true)) {
                    if (target instanceof PsiClass && ((PsiClass)target).getContainingClass() == null) {
                        return;
                    }
                    this.capturing = true;
                    this.stopWalking();
                }
            }

            @Override
            public void visitSuperExpression(PsiSuperExpression expression) {
                this.capturing = true;
                this.stopWalking();
            }

            @Override
            public void visitThisExpression(PsiThisExpression expression) {
                this.capturing = true;
                this.stopWalking();
            }
        }
        CapturingLambdaVisitor visitor = new CapturingLambdaVisitor(lambda2);
        body.accept(visitor);
        return visitor.capturing;
    }

    @Nullable
    public static PsiClass resolveFunctionalInterfaceClass(@NotNull PsiFunctionalExpression expression) {
        PsiType type2;
        PsiClass actualClass;
        if (expression == null) {
            LambdaUtil.$$$reportNull$$$0(28);
        }
        if ((actualClass = PsiUtil.resolveClassInClassTypeOnly(type2 = expression.getGroundTargetType(LambdaUtil.getFunctionalInterfaceType(expression, false)))) instanceof PsiTypeParameter) {
            return PsiUtil.resolveClassInClassTypeOnly(expression.getFunctionalInterfaceType());
        }
        return actualClass;
    }

    @Nullable
    public static String createLambdaParameterListWithFormalTypes(PsiType functionalInterfaceType, PsiLambdaExpression lambdaExpression, boolean checkApplicability) {
        PsiParameter[] lambdaParameters;
        PsiClassType.ClassResolveResult resolveResult = PsiUtil.resolveGenericsClassInType(functionalInterfaceType);
        StringBuilder buf = new StringBuilder();
        buf.append("(");
        PsiMethod interfaceMethod = LambdaUtil.getFunctionalInterfaceMethod(functionalInterfaceType);
        if (interfaceMethod == null) {
            return null;
        }
        PsiParameter[] parameters2 = interfaceMethod.getParameterList().getParameters();
        if (parameters2.length != (lambdaParameters = lambdaExpression.getParameterList().getParameters()).length) {
            return null;
        }
        PsiSubstitutor substitutor = LambdaUtil.getSubstitutor(interfaceMethod, resolveResult);
        for (int i = 0; i < parameters2.length; ++i) {
            PsiAnnotation[] annotations;
            PsiType psiType;
            PsiParameter lambdaParameter = lambdaParameters[i];
            PsiTypeElement origTypeElement = lambdaParameter.getTypeElement();
            if (origTypeElement != null && !origTypeElement.isInferredType()) {
                psiType = origTypeElement.getType();
            } else {
                psiType = substitutor.substitute(parameters2[i].getType());
                if (psiType == null || !PsiTypesUtil.isDenotableType(psiType, lambdaExpression)) {
                    return null;
                }
            }
            for (PsiAnnotation annotation : annotations = lambdaParameter.getAnnotations()) {
                if (AnnotationTargetUtil.isTypeAnnotation(annotation)) continue;
                buf.append(annotation.getText()).append(' ');
            }
            buf.append(checkApplicability ? psiType.getPresentableText(true) : psiType.getCanonicalText(true)).append(" ").append(lambdaParameter.getName());
            if (i >= parameters2.length - 1) continue;
            buf.append(", ");
        }
        buf.append(")");
        return buf.toString();
    }

    @Nullable
    public static PsiParameterList specifyLambdaParameterTypes(PsiLambdaExpression lambdaExpression) {
        return LambdaUtil.specifyLambdaParameterTypes(lambdaExpression.getFunctionalInterfaceType(), lambdaExpression);
    }

    @Nullable
    public static PsiParameterList specifyLambdaParameterTypes(PsiType functionalInterfaceType, @NotNull PsiLambdaExpression lambdaExpression) {
        String typedParamList;
        if (lambdaExpression == null) {
            LambdaUtil.$$$reportNull$$$0(29);
        }
        if ((typedParamList = LambdaUtil.createLambdaParameterListWithFormalTypes(functionalInterfaceType, lambdaExpression, false)) != null) {
            PsiParameterList paramListWithFormalTypes = JavaPsiFacade.getElementFactory(lambdaExpression.getProject()).createMethodFromText("void foo" + typedParamList, lambdaExpression).getParameterList();
            return (PsiParameterList)JavaCodeStyleManager.getInstance(lambdaExpression.getProject()).shortenClassReferences(lambdaExpression.getParameterList().replace(paramListWithFormalTypes));
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 7: 
            case 9: 
            case 26: 
            case 27: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 7: 
            case 9: 
            case 26: 
            case 27: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolveResult";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 6: 
            case 7: 
            case 9: 
            case 26: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sqldelight/com/intellij/psi/LambdaUtil";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentLambda";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "call";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetType";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "producer";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variable";
                break;
            }
            case 15: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expression";
                break;
            }
            case 16: 
            case 18: 
            case 20: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lambda";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "replacer";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newFunctionSupplier";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "replacementText";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newBodySupplier";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lambdaReturnExpression";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "replacement";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lambdaExpression";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "sqldelight/com/intellij/psi/LambdaUtil";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "hasSubSignature";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getReturnStatements";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "copyWithExpectedType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getFunctionalInterfaceMethod";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getSubstitutor";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "calcFunction";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "hasManyOwnAbstractMethods";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "hasManyInheritedAbstractMethods";
                break;
            }
            case 6: 
            case 7: 
            case 9: 
            case 26: 
            case 27: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getFunctionalInterfaceTypeByContainingLambda";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "copyTopLevelCall";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "performWithTargetType";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "createLambda";
                break;
            }
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "isSafeLambdaReplacement";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "isSafeLambdaBodyReplacement";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "isSafeLambdaReturnValueReplacement";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "resolveFunctionalInterfaceClass";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "specifyLambdaParameterTypes";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 7: 
            case 9: 
            case 26: 
            case 27: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

