/*
 * Decompiled with CFR 0.152.
 */
package sqldelight.com.intellij.psi.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import sqldelight.com.intellij.lang.Language;
import sqldelight.com.intellij.openapi.diagnostic.Logger;
import sqldelight.com.intellij.openapi.util.TextRange;
import sqldelight.com.intellij.psi.FileViewProvider;
import sqldelight.com.intellij.psi.HintedReferenceHost;
import sqldelight.com.intellij.psi.PsiElement;
import sqldelight.com.intellij.psi.PsiFile;
import sqldelight.com.intellij.psi.PsiReference;
import sqldelight.com.intellij.psi.PsiReferenceService;
import sqldelight.com.intellij.psi.ReferenceRange;
import sqldelight.com.intellij.psi.impl.source.resolve.reference.impl.PsiMultiReference;
import sqldelight.com.intellij.psi.templateLanguages.OuterLanguageElement;
import sqldelight.org.jetbrains.annotations.NotNull;
import sqldelight.org.jetbrains.annotations.Nullable;

public final class SharedPsiElementImplUtil {
    private static final Logger LOG = Logger.getInstance(SharedPsiElementImplUtil.class);

    private SharedPsiElementImplUtil() {
    }

    @Nullable
    public static PsiReference findReferenceAt(PsiElement thisElement, int offset, @Nullable Language lang) {
        PsiElement element;
        if (thisElement == null) {
            return null;
        }
        PsiElement psiElement = element = lang != null ? thisElement.getContainingFile().getViewProvider().findElementAt(offset, lang) : thisElement.findElementAt(offset);
        if (element == null || element instanceof OuterLanguageElement) {
            return null;
        }
        offset = thisElement.getTextRange().getStartOffset() + offset - element.getTextRange().getStartOffset();
        ArrayList referencesList = new ArrayList();
        while (element != null) {
            SharedPsiElementImplUtil.addReferences(offset, element, referencesList);
            if (element instanceof PsiFile || element instanceof HintedReferenceHost && !((HintedReferenceHost)element).shouldAskParentForReferences(new PsiReferenceService.Hints(null, offset))) break;
            offset = element.getStartOffsetInParent() + offset;
            element = element.getParent();
        }
        if (referencesList.isEmpty()) {
            return null;
        }
        if (referencesList.size() == 1) {
            return (PsiReference)referencesList.get(0);
        }
        return new PsiMultiReference(referencesList.toArray(PsiReference.EMPTY_ARRAY), ((PsiReference)referencesList.get(referencesList.size() - 1)).getElement());
    }

    @Nullable
    public static PsiReference findReferenceAt(PsiElement thisElement, int offset) {
        return SharedPsiElementImplUtil.findReferenceAt(thisElement, offset, null);
    }

    private static void addReferences(int offset, PsiElement element, Collection<? super PsiReference> outReferences) {
        PsiReference[] references = element instanceof HintedReferenceHost ? ((HintedReferenceHost)element).getReferences(new PsiReferenceService.Hints(null, offset)) : element.getReferences();
        for (PsiReference reference : references) {
            if (reference == null) {
                LOG.error("Null reference returned from " + element + " of " + element.getClass());
                continue;
            }
            for (TextRange range : ReferenceRange.getRanges(reference)) {
                LOG.assertTrue(range != null, reference);
                if (!range.containsOffset(offset)) continue;
                outReferences.add(reference);
            }
        }
    }

    public static PsiReference @NotNull [] getReferences(PsiElement thisElement) {
        PsiReference[] psiReferenceArray;
        PsiReference ref = thisElement.getReference();
        if (ref != null) {
            PsiReference[] psiReferenceArray2 = new PsiReference[1];
            psiReferenceArray = psiReferenceArray2;
            psiReferenceArray2[0] = ref;
        } else {
            psiReferenceArray = PsiReference.EMPTY_ARRAY;
        }
        if (psiReferenceArray == null) {
            SharedPsiElementImplUtil.$$$reportNull$$$0(0);
        }
        return psiReferenceArray;
    }

    @Nullable
    public static PsiElement getNextSibling(PsiElement element) {
        if (element instanceof PsiFile) {
            FileViewProvider viewProvider = ((PsiFile)element).getViewProvider();
            element = viewProvider.getPsi(viewProvider.getBaseLanguage());
        }
        if (element == null) {
            return null;
        }
        PsiElement parent = element.getParent();
        if (parent == null) {
            return null;
        }
        PsiElement[] children2 = parent.getChildren();
        int index = SharedPsiElementImplUtil.getChildIndex(children2, element);
        return 0 <= index && index < children2.length - 1 ? children2[index + 1] : null;
    }

    @Nullable
    public static PsiElement getPrevSibling(PsiElement element) {
        if (element instanceof PsiFile) {
            FileViewProvider viewProvider = ((PsiFile)element).getViewProvider();
            element = viewProvider.getPsi(viewProvider.getBaseLanguage());
        }
        if (element == null) {
            return null;
        }
        PsiElement parent = element.getParent();
        if (parent == null) {
            return null;
        }
        PsiElement[] children2 = parent.getChildren();
        int index = SharedPsiElementImplUtil.getChildIndex(children2, element);
        return index > 0 ? children2[index - 1] : null;
    }

    private static int getChildIndex(PsiElement[] children2, PsiElement child) {
        for (int i = 0; i < children2.length; ++i) {
            PsiElement candidate = children2[i];
            if (candidate != child) continue;
            return i;
        }
        LOG.error("Cannot find element among its parent' children. element: '" + child + "'; parent: '" + child.getParent() + "'; children: " + Arrays.asList(children2) + ";  file:" + child.getContainingFile());
        return -1;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "sqldelight/com/intellij/psi/impl/SharedPsiElementImplUtil", "getReferences"));
    }
}

