/*
 * Decompiled with CFR 0.152.
 */
package sqldelight.com.intellij.psi.stubs;

import java.io.IOException;
import sqldelight.com.intellij.lang.Language;
import sqldelight.com.intellij.lang.LanguageParserDefinitions;
import sqldelight.com.intellij.lang.ParserDefinition;
import sqldelight.com.intellij.openapi.fileTypes.FileType;
import sqldelight.com.intellij.openapi.fileTypes.LanguageFileType;
import sqldelight.com.intellij.openapi.project.Project;
import sqldelight.com.intellij.openapi.vfs.VirtualFile;
import sqldelight.com.intellij.psi.PsiFile;
import sqldelight.com.intellij.psi.stubs.BinaryFileStubBuilder;
import sqldelight.com.intellij.psi.stubs.BinaryFileStubBuilders;
import sqldelight.com.intellij.psi.stubs.ObjectStubTree;
import sqldelight.com.intellij.psi.stubs.PsiFileStub;
import sqldelight.com.intellij.psi.stubs.Stub;
import sqldelight.com.intellij.psi.stubs.StubTree;
import sqldelight.com.intellij.psi.stubs.StubTreeBuilder;
import sqldelight.com.intellij.psi.stubs.StubTreeLoader;
import sqldelight.com.intellij.psi.tree.IFileElementType;
import sqldelight.com.intellij.psi.tree.IStubFileElementType;
import sqldelight.com.intellij.util.indexing.FileContent;
import sqldelight.com.intellij.util.indexing.FileContentImpl;
import sqldelight.org.jetbrains.annotations.NotNull;
import sqldelight.org.jetbrains.annotations.Nullable;

public class CoreStubTreeLoader
extends StubTreeLoader {
    @Override
    public ObjectStubTree readOrBuild(Project project, VirtualFile vFile, @Nullable PsiFile psiFile) {
        if (!this.canHaveStub(vFile)) {
            return null;
        }
        try {
            FileContent fc = FileContentImpl.createByFile(vFile, project);
            Stub element = StubTreeBuilder.buildStubTree(fc);
            if (element instanceof PsiFileStub) {
                return new StubTree((PsiFileStub)element);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return null;
    }

    @Override
    public ObjectStubTree readFromVFile(Project project, VirtualFile vFile) {
        return null;
    }

    @Override
    public void rebuildStubTree(VirtualFile virtualFile) {
    }

    @Override
    public boolean canHaveStub(VirtualFile file) {
        FileType fileType = file.getFileType();
        if (fileType instanceof LanguageFileType) {
            Language l = ((LanguageFileType)fileType).getLanguage();
            ParserDefinition parserDefinition = (ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(l);
            if (parserDefinition == null) {
                return false;
            }
            IFileElementType elementType = parserDefinition.getFileNodeType();
            return elementType instanceof IStubFileElementType && ((IStubFileElementType)elementType).shouldBuildStubFor(file);
        }
        if (fileType.isBinary()) {
            BinaryFileStubBuilder builder = (BinaryFileStubBuilder)BinaryFileStubBuilders.INSTANCE.forFileType(fileType);
            return builder != null && builder.acceptsFile(file);
        }
        return false;
    }

    @Override
    protected boolean isPrebuilt(@NotNull VirtualFile virtualFile) {
        if (virtualFile == null) {
            CoreStubTreeLoader.$$$reportNull$$$0(0);
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFile", "sqldelight/com/intellij/psi/stubs/CoreStubTreeLoader", "isPrebuilt"));
    }
}

