/*
 * Decompiled with CFR 0.152.
 */
package sqldelight.com.intellij.ui.scale;

import java.util.EnumSet;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import sqldelight.com.intellij.openapi.util.Pair;
import sqldelight.com.intellij.ui.scale.DerivedScaleType;
import sqldelight.com.intellij.ui.scale.JBUIScale;
import sqldelight.com.intellij.ui.scale.Scale;
import sqldelight.com.intellij.ui.scale.ScaleType;
import sqldelight.com.intellij.util.SmartList;
import sqldelight.org.jetbrains.annotations.NotNull;
import sqldelight.org.jetbrains.annotations.Nullable;

public class UserScaleContext {
    protected Scale usrScale = ScaleType.USR_SCALE.of(JBUIScale.scale(1.0f));
    protected Scale objScale = ScaleType.OBJ_SCALE.of(1.0);
    protected double pixScale;
    private List<UpdateListener> listeners;
    private EnumSet<ScaleType> overriddenScales;

    protected UserScaleContext() {
        this.pixScale = this.usrScale.value;
    }

    @NotNull
    public static UserScaleContext createIdentity() {
        return UserScaleContext.create(ScaleType.USR_SCALE.of(1.0));
    }

    @NotNull
    public static UserScaleContext create(Scale ... scales) {
        if (scales == null) {
            UserScaleContext.$$$reportNull$$$0(0);
        }
        UserScaleContext ctx = UserScaleContext.create();
        for (Scale s : scales) {
            ctx.setScale(s);
        }
        UserScaleContext userScaleContext = ctx;
        if (userScaleContext == null) {
            UserScaleContext.$$$reportNull$$$0(1);
        }
        return userScaleContext;
    }

    @NotNull
    public static UserScaleContext create() {
        return new UserScaleContext();
    }

    @NotNull
    public static UserScaleContext create(@Nullable UserScaleContext ctx) {
        UserScaleContext c = UserScaleContext.createIdentity();
        c.update(ctx);
        UserScaleContext userScaleContext = c;
        if (userScaleContext == null) {
            UserScaleContext.$$$reportNull$$$0(2);
        }
        return userScaleContext;
    }

    protected double derivePixScale() {
        return this.usrScale.value * this.objScale.value;
    }

    public boolean overrideScale(@NotNull Scale scale) {
        if (scale == null) {
            UserScaleContext.$$$reportNull$$$0(3);
        }
        if (this.overriddenScales != null) {
            this.overriddenScales.remove((Object)scale.type);
        }
        boolean updated = this.setScale(scale);
        if (this.overriddenScales == null) {
            this.overriddenScales = EnumSet.of(scale.type);
        } else {
            this.overriddenScales.add(scale.type);
        }
        return updated;
    }

    protected boolean isScaleOverridden(@NotNull Scale scale) {
        if (scale == null) {
            UserScaleContext.$$$reportNull$$$0(4);
        }
        return this.overriddenScales != null && this.overriddenScales.contains((Object)scale.type);
    }

    public boolean setScale(@NotNull Scale scale) {
        if (scale == null) {
            UserScaleContext.$$$reportNull$$$0(5);
        }
        if (this.isScaleOverridden(scale)) {
            return false;
        }
        boolean updated = false;
        switch (scale.type) {
            case USR_SCALE: {
                updated = !this.usrScale.equals(scale);
                this.usrScale = scale;
                break;
            }
            case OBJ_SCALE: {
                updated = !this.objScale.equals(scale);
                this.objScale = scale;
                break;
            }
            case SYS_SCALE: {
                return false;
            }
        }
        return this.onUpdated(updated);
    }

    public double getScale(@NotNull ScaleType type2) {
        if (type2 == null) {
            UserScaleContext.$$$reportNull$$$0(6);
        }
        switch (type2) {
            case USR_SCALE: {
                return this.usrScale.value;
            }
            case SYS_SCALE: {
                return 1.0;
            }
            case OBJ_SCALE: {
                return this.objScale.value;
            }
        }
        return 1.0;
    }

    public double getScale(@NotNull DerivedScaleType type2) {
        if (type2 == null) {
            UserScaleContext.$$$reportNull$$$0(7);
        }
        switch (type2) {
            case DEV_SCALE: {
                return 1.0;
            }
            case PIX_SCALE: 
            case EFF_USR_SCALE: {
                return this.pixScale;
            }
        }
        return 1.0;
    }

    public double apply(double value, DerivedScaleType type2) {
        return value * this.getScale(type2);
    }

    public double apply(double value, ScaleType type2) {
        return value * this.getScale(type2);
    }

    protected boolean onUpdated(boolean updated) {
        if (updated) {
            this.pixScale = this.derivePixScale();
            this.notifyUpdateListeners();
        }
        return updated;
    }

    public boolean update() {
        return this.onUpdated(this.setScale(ScaleType.USR_SCALE.of(JBUIScale.scale(1.0f))));
    }

    public boolean update(@Nullable UserScaleContext ctx) {
        if (ctx == null) {
            return this.update();
        }
        return this.onUpdated(this.updateAll(ctx));
    }

    protected <T extends UserScaleContext> boolean updateAll(@NotNull T ctx) {
        if (ctx == null) {
            UserScaleContext.$$$reportNull$$$0(8);
        }
        boolean updated = this.setScale(ctx.usrScale);
        return this.setScale(ctx.objScale) || updated;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof UserScaleContext)) {
            return false;
        }
        UserScaleContext that = (UserScaleContext)obj;
        return that.usrScale.value == this.usrScale.value && that.objScale.value == this.objScale.value;
    }

    public int hashCode() {
        return Double.hashCode(this.usrScale.value) * 31 + Double.hashCode(this.objScale.value);
    }

    public void dispose() {
        this.listeners = null;
    }

    public void addUpdateListener(@NotNull UpdateListener l) {
        if (l == null) {
            UserScaleContext.$$$reportNull$$$0(9);
        }
        if (this.listeners == null) {
            this.listeners = new SmartList<UpdateListener>(l);
        } else {
            this.listeners.add(l);
        }
    }

    public void removeUpdateListener(@NotNull UpdateListener l) {
        if (l == null) {
            UserScaleContext.$$$reportNull$$$0(10);
        }
        if (this.listeners != null) {
            this.listeners.remove(l);
        }
    }

    protected void notifyUpdateListeners() {
        if (this.listeners != null) {
            this.listeners.forEach(UpdateListener::contextUpdated);
        }
    }

    @NotNull
    public <T extends UserScaleContext> T copy() {
        UserScaleContext ctx = UserScaleContext.createIdentity();
        ctx.updateAll(this);
        UserScaleContext userScaleContext = ctx;
        if (userScaleContext == null) {
            UserScaleContext.$$$reportNull$$$0(11);
        }
        return (T)userScaleContext;
    }

    public String toString() {
        return this.usrScale + ", " + this.objScale + ", " + this.pixScale;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scales";
                break;
            }
            case 1: 
            case 2: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sqldelight/com/intellij/ui/scale/UserScaleContext";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scale";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ctx";
                break;
            }
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "l";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "sqldelight/com/intellij/ui/scale/UserScaleContext";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "create";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "copy";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 1: 
            case 2: 
            case 11: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "overrideScale";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isScaleOverridden";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setScale";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getScale";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "updateAll";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "addUpdateListener";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "removeUpdateListener";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class Cache<D, S extends UserScaleContext> {
        private final Function<? super S, ? extends D> myDataProvider;
        private final AtomicReference<Pair<Double, D>> myData;

        public Cache(@NotNull Function<? super S, ? extends D> dataProvider) {
            if (dataProvider == null) {
                Cache.$$$reportNull$$$0(0);
            }
            this.myData = new AtomicReference<Object>(null);
            this.myDataProvider = dataProvider;
        }

        @Nullable
        public D getOrProvide(@NotNull S ctx) {
            if (ctx == null) {
                Cache.$$$reportNull$$$0(1);
            }
            Pair<Double, D> data = this.myData.get();
            double scale = ((UserScaleContext)ctx).getScale(DerivedScaleType.PIX_SCALE);
            if (data == null || Double.compare(scale, (Double)data.first) != 0) {
                data = Pair.create(scale, this.myDataProvider.apply(ctx));
                this.myData.set(data);
            }
            return (D)data.second;
        }

        public void clear() {
            this.myData.set(null);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dataProvider";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "ctx";
                    break;
                }
            }
            objectArray2[1] = "sqldelight/com/intellij/ui/scale/UserScaleContext$Cache";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "getOrProvide";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static interface UpdateListener {
        public void contextUpdated();
    }
}

