/*
 * Decompiled with CFR 0.152.
 */
package sqldelight.com.intellij.util.containers;

import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import sqldelight.com.intellij.openapi.util.SystemInfoRt;
import sqldelight.com.intellij.openapi.util.io.FileUtil;
import sqldelight.com.intellij.util.containers.CaseInsensitiveStringHashingStrategy;
import sqldelight.com.intellij.util.containers.CharSequenceHashingStrategy;
import sqldelight.com.intellij.util.containers.ConcurrentWeakHashMap;
import sqldelight.com.intellij.util.containers.ContainerUtil;
import sqldelight.gnu.trove.TObjectHashingStrategy;
import sqldelight.it.unimi.dsi.fastutil.Hash;
import sqldelight.it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenCustomHashMap;
import sqldelight.it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import sqldelight.it.unimi.dsi.fastutil.objects.Object2ObjectOpenCustomHashMap;
import sqldelight.it.unimi.dsi.fastutil.objects.ObjectLinkedOpenCustomHashSet;
import sqldelight.it.unimi.dsi.fastutil.objects.ObjectLinkedOpenHashSet;
import sqldelight.it.unimi.dsi.fastutil.objects.ObjectOpenCustomHashSet;
import sqldelight.org.jetbrains.annotations.Contract;
import sqldelight.org.jetbrains.annotations.NotNull;

public final class CollectionFactory {
    private static final Hash.Strategy<File> FILE_HASH_STRATEGY = new Hash.Strategy<File>(){

        @Override
        public int hashCode(File o) {
            return FileUtil.fileHashCode(o);
        }

        @Override
        public boolean equals(File a, File b) {
            return FileUtil.filesEqual(a, b);
        }
    };

    @Contract(value=" -> new", pure=true)
    @NotNull
    public static <K, V> ConcurrentMap<K, V> createConcurrentWeakMap() {
        return new ConcurrentWeakHashMap(0.75f);
    }

    @Contract(value=" -> new", pure=true)
    @NotNull
    public static <K, V> ConcurrentMap<K, V> createConcurrentWeakIdentityMap() {
        return new ConcurrentWeakHashMap(TObjectHashingStrategy.IDENTITY);
    }

    @Contract(value=" -> new", pure=true)
    @NotNull
    public static <K, V> Map<K, V> createWeakMap() {
        Map map = ContainerUtil.createWeakMap();
        if (map == null) {
            CollectionFactory.$$$reportNull$$$0(0);
        }
        return map;
    }

    @Contract(value=" -> new", pure=true)
    @NotNull
    public static <K, V> ConcurrentMap<K, V> createConcurrentWeakKeyWeakValueMap() {
        ConcurrentMap concurrentMap = ContainerUtil.createConcurrentWeakKeyWeakValueMap(ContainerUtil.canonicalStrategy());
        if (concurrentMap == null) {
            CollectionFactory.$$$reportNull$$$0(1);
        }
        return concurrentMap;
    }

    @Contract(value="_,_,_ -> new", pure=true)
    @NotNull
    public static <K, V> ConcurrentMap<K, V> createConcurrentWeakMap(int initialCapacity, float loadFactor, int concurrencyLevel) {
        return new ConcurrentWeakHashMap(initialCapacity, loadFactor, concurrencyLevel, ContainerUtil.canonicalStrategy());
    }

    @NotNull
    public static <T> Map<CharSequence, T> createCharSequenceMap(boolean caseSensitive, int expectedSize, float loadFactor) {
        return new Object2ObjectOpenCustomHashMap(expectedSize, loadFactor, caseSensitive ? CharSequenceHashingStrategy.CASE_SENSITIVE : CharSequenceHashingStrategy.CASE_INSENSITIVE);
    }

    @NotNull
    public static Set<CharSequence> createCharSequenceSet(boolean caseSensitive, int expectedSize, float loadFactor) {
        return new ObjectOpenCustomHashSet<CharSequence>(expectedSize, loadFactor, caseSensitive ? CharSequenceHashingStrategy.CASE_SENSITIVE : CharSequenceHashingStrategy.CASE_INSENSITIVE);
    }

    @NotNull
    public static <T> Map<CharSequence, T> createCharSequenceMap(boolean caseSensitive) {
        return new Object2ObjectOpenCustomHashMap(caseSensitive ? CharSequenceHashingStrategy.CASE_SENSITIVE : CharSequenceHashingStrategy.CASE_INSENSITIVE);
    }

    @NotNull
    public static Set<String> createCaseInsensitiveStringSet() {
        return new ObjectOpenCustomHashSet<String>(CaseInsensitiveStringHashingStrategy.INSTANCE);
    }

    @NotNull
    public static <V> Map<String, V> createCaseInsensitiveStringMap() {
        return new Object2ObjectOpenCustomHashMap(CaseInsensitiveStringHashingStrategy.INSTANCE);
    }

    @NotNull
    public static Set<String> createFilePathSet() {
        if (SystemInfoRt.isFileSystemCaseSensitive) {
            return new HashSet<String>();
        }
        return CollectionFactory.createCaseInsensitiveStringSet();
    }

    @NotNull
    public static Set<String> createFilePathSet(int expectedSize) {
        return CollectionFactory.createFilePathSet(expectedSize, SystemInfoRt.isFileSystemCaseSensitive);
    }

    @NotNull
    public static Set<String> createFilePathSet(int expectedSize, boolean isFileSystemCaseSensitive) {
        if (isFileSystemCaseSensitive) {
            return new HashSet<String>(expectedSize);
        }
        return new ObjectOpenCustomHashSet<String>(expectedSize, CaseInsensitiveStringHashingStrategy.INSTANCE);
    }

    @NotNull
    public static Set<String> createFilePathSet(@NotNull Collection<String> paths, boolean isFileSystemCaseSensitive) {
        if (paths == null) {
            CollectionFactory.$$$reportNull$$$0(2);
        }
        if (isFileSystemCaseSensitive) {
            return new HashSet<String>(paths);
        }
        return new ObjectOpenCustomHashSet<String>(paths, CaseInsensitiveStringHashingStrategy.INSTANCE);
    }

    @NotNull
    public static <V> Map<String, V> createFilePathMap() {
        if (SystemInfoRt.isFileSystemCaseSensitive) {
            return new HashMap();
        }
        return CollectionFactory.createCaseInsensitiveStringMap();
    }

    @NotNull
    public static <V> Map<String, V> createFilePathMap(int expectedSize) {
        return CollectionFactory.createFilePathMap(expectedSize, SystemInfoRt.isFileSystemCaseSensitive);
    }

    @NotNull
    public static <V> Map<String, V> createFilePathMap(int expectedSize, boolean isFileSystemCaseSensitive) {
        if (isFileSystemCaseSensitive) {
            return new HashMap(expectedSize);
        }
        return new Object2ObjectOpenCustomHashMap(expectedSize, CaseInsensitiveStringHashingStrategy.INSTANCE);
    }

    @NotNull
    public static <V> Map<File, V> createFileMap() {
        return new Object2ObjectOpenCustomHashMap(FILE_HASH_STRATEGY);
    }

    @NotNull
    public static Set<File> createFileSet() {
        return new ObjectOpenCustomHashSet<File>(FILE_HASH_STRATEGY);
    }

    @NotNull
    public static Set<File> createFileLinkedSet() {
        return new ObjectLinkedOpenCustomHashSet<File>(FILE_HASH_STRATEGY);
    }

    @NotNull
    public static Set<String> createFilePathLinkedSet() {
        if (SystemInfoRt.isFileSystemCaseSensitive) {
            return new ObjectLinkedOpenHashSet<String>();
        }
        return new ObjectLinkedOpenCustomHashSet<String>(CaseInsensitiveStringHashingStrategy.INSTANCE);
    }

    @NotNull
    public static <V> Map<String, V> createFilePathLinkedMap() {
        if (SystemInfoRt.isFileSystemCaseSensitive) {
            return new Object2ObjectLinkedOpenHashMap();
        }
        return new Object2ObjectLinkedOpenCustomHashMap(CaseInsensitiveStringHashingStrategy.INSTANCE);
    }

    @NotNull
    public static <V> Map<String, V> createCanonicalFilePathLinkedMap() {
        return new Object2ObjectLinkedOpenCustomHashMap(new Hash.Strategy<String>(){

            @Override
            public int hashCode(String value) {
                return FileUtil.pathHashCode(value);
            }

            @Override
            public boolean equals(String val1, String val2) {
                return FileUtil.pathsEqual(val1, val2);
            }
        });
    }

    @NotNull
    public static <V> Map<File, V> createCanonicalFileMap() {
        return new Object2ObjectOpenCustomHashMap(new Hash.Strategy<File>(){

            @Override
            public int hashCode(File value) {
                return FileUtil.fileHashCode(value);
            }

            @Override
            public boolean equals(File val1, File val2) {
                return FileUtil.filesEqual(val1, val2);
            }
        });
    }

    @NotNull
    public static Set<String> createFilePathSet(@NotNull Collection<String> paths) {
        if (paths == null) {
            CollectionFactory.$$$reportNull$$$0(3);
        }
        if (SystemInfoRt.isFileSystemCaseSensitive) {
            return new HashSet<String>(paths);
        }
        return new ObjectOpenCustomHashSet<String>(paths, CaseInsensitiveStringHashingStrategy.INSTANCE);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sqldelight/com/intellij/util/containers/CollectionFactory";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "paths";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createWeakMap";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createConcurrentWeakKeyWeakValueMap";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "sqldelight/com/intellij/util/containers/CollectionFactory";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createFilePathSet";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

