/*
 * Decompiled with CFR 0.152.
 */
package sqldelight.com.intellij.util.containers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.RandomAccess;
import java.util.Set;
import sqldelight.com.intellij.util.IncorrectOperationException;
import sqldelight.com.intellij.util.containers.ContainerUtil;
import sqldelight.com.intellij.util.containers.OpenTHashSet;
import sqldelight.gnu.trove.TObjectHashingStrategy;
import sqldelight.org.jetbrains.annotations.NotNull;

public class OrderedSet<T>
extends ArrayList<T>
implements Set<T>,
RandomAccess {
    private final OpenTHashSet<T> myHashSet;

    public OrderedSet() {
        this(ContainerUtil.canonicalStrategy());
    }

    public OrderedSet(@NotNull Collection<? extends T> set) {
        if (set == null) {
            OrderedSet.$$$reportNull$$$0(0);
        }
        super(set.size());
        this.myHashSet = new OpenTHashSet(set.size());
        this.addAll((Collection<? extends T>)set);
    }

    public OrderedSet(@NotNull TObjectHashingStrategy<T> hashingStrategy) {
        if (hashingStrategy == null) {
            OrderedSet.$$$reportNull$$$0(1);
        }
        this(hashingStrategy, 4);
    }

    public OrderedSet(@NotNull TObjectHashingStrategy<T> hashingStrategy, int capacity) {
        if (hashingStrategy == null) {
            OrderedSet.$$$reportNull$$$0(2);
        }
        super(capacity);
        this.myHashSet = new OpenTHashSet<T>(capacity, hashingStrategy);
    }

    public OrderedSet(int capacity) {
        this(ContainerUtil.canonicalStrategy(), capacity);
    }

    @Override
    public boolean removeAll(@NotNull Collection<?> c) {
        if (c == null) {
            OrderedSet.$$$reportNull$$$0(3);
        }
        boolean removed = false;
        for (Object o : c) {
            removed |= this.remove(o);
        }
        return removed;
    }

    @Override
    public boolean retainAll(@NotNull Collection<?> c) {
        if (c == null) {
            OrderedSet.$$$reportNull$$$0(4);
        }
        boolean removed = false;
        for (int i = this.size() - 1; i >= 0; --i) {
            Object o = this.get(i);
            if (c.contains(o)) continue;
            removed |= this.remove(o);
        }
        return removed;
    }

    @Override
    @NotNull
    public List<T> subList(int fromIndex, int toIndex) {
        throw new IncorrectOperationException();
    }

    @Override
    public boolean contains(Object o) {
        return this.myHashSet.contains(o);
    }

    @Override
    public boolean addAll(@NotNull Collection<? extends T> c) {
        if (c == null) {
            OrderedSet.$$$reportNull$$$0(5);
        }
        boolean result = false;
        for (T t : c) {
            result |= this.add(t);
        }
        return result;
    }

    @Override
    public boolean add(T o) {
        if (this.myHashSet.add(o)) {
            super.add(o);
            return true;
        }
        return false;
    }

    @Override
    public boolean remove(Object o) {
        if (this.myHashSet.remove(o)) {
            super.remove(o);
            return true;
        }
        return false;
    }

    @Override
    public void clear() {
        this.myHashSet.clear();
        super.clear();
    }

    @Override
    public boolean addAll(int index, @NotNull Collection<? extends T> c) {
        if (c == null) {
            OrderedSet.$$$reportNull$$$0(6);
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public T set(int index, @NotNull T element) {
        if (element == null) {
            OrderedSet.$$$reportNull$$$0(7);
        }
        T removed = this.remove(index);
        this.add(index, element);
        return removed;
    }

    @Override
    public void add(int index, @NotNull T element) {
        if (element == null) {
            OrderedSet.$$$reportNull$$$0(8);
        }
        if (this.myHashSet.add(element)) {
            super.add(index, element);
        }
    }

    @Override
    public T remove(int index) {
        Object t = super.remove(index);
        this.myHashSet.remove(t);
        return (T)t;
    }

    @Override
    public int indexOf(Object o) {
        Object t = o;
        int index = this.myHashSet.index(t);
        return index >= 0 ? super.indexOf(this.myHashSet.get(index)) : -1;
    }

    @Override
    public int lastIndexOf(Object o) {
        Object t = o;
        int index = this.myHashSet.index(t);
        return index >= 0 ? super.lastIndexOf(this.myHashSet.get(index)) : -1;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "set";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hashingStrategy";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        objectArray2[1] = "sqldelight/com/intellij/util/containers/OrderedSet";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "removeAll";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "retainAll";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "addAll";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "set";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "add";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

