/*
 * Decompiled with CFR 0.152.
 */
package sqldelight.com.intellij.util.ui;

import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import sqldelight.com.intellij.openapi.diagnostic.Logger;
import sqldelight.com.intellij.openapi.util.IconLoader;
import sqldelight.com.intellij.openapi.util.SystemInfoRt;
import sqldelight.com.intellij.ui.scale.ScaleContext;
import sqldelight.com.intellij.util.JBHiDPIScaledImage;
import sqldelight.com.intellij.util.MethodInvocator;
import sqldelight.com.intellij.util.ui.ImageUtil;
import sqldelight.com.intellij.util.ui.JBImageIcon;
import sqldelight.org.imgscalr.Scalr;
import sqldelight.org.jetbrains.annotations.Contract;
import sqldelight.org.jetbrains.annotations.Nullable;

public final class MultiResolutionImageProvider {
    public static boolean isMultiResolutionImage(@Nullable Image image) {
        return image != null && Accessor.MRI_CLASS != null && Accessor.MRI_CLASS.isInstance(image);
    }

    public static boolean isMultiResolutionImageAvailable() {
        return Accessor.MRI_CLASS != null;
    }

    public static Image convertFromJBImage(@Nullable Image jbImage) {
        if (jbImage == null) {
            return null;
        }
        if (!MultiResolutionImageProvider.checkSize(jbImage)) {
            new IllegalArgumentException("the image has illegal size 0x0").printStackTrace();
        }
        return Converter.convert(jbImage);
    }

    @Contract(value="null, _ -> null; !null, _ -> !null")
    public static Icon convertFromJBIcon(@Nullable Icon jbIcon, @Nullable ScaleContext ctx) {
        if (jbIcon == null) {
            return null;
        }
        Image image = IconLoader.toImage(jbIcon, ctx);
        if (image == null) {
            return jbIcon;
        }
        Image newImage = MultiResolutionImageProvider.convertFromJBImage(image);
        if (newImage == image) {
            return jbIcon;
        }
        return new ImageIcon(newImage);
    }

    @Contract(value="null -> null; !null -> !null")
    public static Image getMaxSizeResolutionVariant(@Nullable Image mrImage) {
        if (MultiResolutionImageProvider.isMultiResolutionImage(mrImage)) {
            List<Image> variants = MultiResolutionImageProvider.getAccessor(mrImage).getResolutionVariants();
            int width = mrImage.getWidth(null);
            for (Image img : variants) {
                if (img.getWidth(null) < width) continue;
                mrImage = img;
            }
        }
        return mrImage;
    }

    @Contract(value="null, _ -> null; !null, _ -> !null")
    public static Icon convertFromMRIcon(@Nullable Icon mrIcon, @Nullable ScaleContext ctx) {
        Image image;
        if (mrIcon == null) {
            return null;
        }
        if (ctx == null) {
            ctx = ScaleContext.create();
        }
        if (MultiResolutionImageProvider.isMultiResolutionImage(image = Objects.requireNonNull(IconLoader.toImage(mrIcon, ctx)))) {
            return mrIcon;
        }
        image = MultiResolutionImageProvider.getMaxSizeResolutionVariant(image);
        image = ImageUtil.ensureHiDPI(image, ctx);
        return new JBImageIcon(image);
    }

    @Contract(value="null -> null; !null -> !null")
    public static Accessor getAccessor(@Nullable Image mrImage) {
        if (mrImage == null) {
            return null;
        }
        if (!MultiResolutionImageProvider.checkSize(mrImage)) {
            new IllegalArgumentException("the image has illegal size 0x0").printStackTrace();
        }
        return new Accessor(mrImage);
    }

    private static boolean checkSize(Image image) {
        return image.getWidth(null) != 0 && image.getHeight(null) != 0;
    }

    private static final class Converter {
        private static final Constructor<?> BMRI_CLASS_CTOR;

        private Converter() {
        }

        @Nullable
        public static Image convert(Image jbImage) {
            if (BMRI_CLASS_CTOR == null) {
                return null;
            }
            if (jbImage instanceof JBHiDPIScaledImage) {
                JBHiDPIScaledImage scaledImage = (JBHiDPIScaledImage)jbImage;
                BufferedImage lowResImage = ImageUtil.toBufferedImage(scaledImage, true);
                BufferedImage highResImage = ImageUtil.toBufferedImage(scaledImage);
                Image[] variants = new Image[]{lowResImage, highResImage};
                try {
                    return (Image)BMRI_CLASS_CTOR.newInstance(new Object[]{variants});
                }
                catch (IllegalAccessException | InstantiationException | InvocationTargetException ex) {
                    Logger.getInstance(MultiResolutionImageProvider.class).error("could not create java.awt.image.BaseMultiResolutionImage", ex);
                }
            }
            return jbImage;
        }

        static {
            Class<?> cls = null;
            Constructor<?> ctor = null;
            if (SystemInfoRt.IS_AT_LEAST_JAVA9) {
                try {
                    cls = Class.forName("java.awt.image.BaseMultiResolutionImage");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
                if (cls != null) {
                    try {
                        ctor = cls.getConstructor(Image[].class);
                        ctor.setAccessible(true);
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        // empty catch block
                    }
                }
            }
            BMRI_CLASS_CTOR = ctor;
        }
    }

    public static class Accessor {
        private static final Class<?> MRI_CLASS;
        private static final MethodInvocator GET_RESOLUTION_VARIANTS_METHOD;
        private static final MethodInvocator GET_RESOLUTION_VARIANT_METHOD;
        private final Image myMRImage;

        private Accessor(Image mrImage) {
            this.myMRImage = mrImage;
        }

        public List<Image> getResolutionVariants() {
            if (!MultiResolutionImageProvider.isMultiResolutionImage(this.myMRImage)) {
                return Collections.singletonList(this.myMRImage);
            }
            return (List)GET_RESOLUTION_VARIANTS_METHOD.invoke(this.myMRImage, new Object[0]);
        }

        public Image getResolutionVariant(double width, double height) {
            if (!MultiResolutionImageProvider.isMultiResolutionImage(this.myMRImage)) {
                if (!MultiResolutionImageProvider.checkSize(this.myMRImage)) {
                    return this.myMRImage;
                }
                return Scalr.resize(ImageUtil.toBufferedImage(this.myMRImage), Scalr.Method.QUALITY, Scalr.Mode.FIT_EXACT, (int)width, (int)height, (BufferedImageOp[])null);
            }
            return (Image)GET_RESOLUTION_VARIANT_METHOD.invoke(this.myMRImage, width, height);
        }

        static {
            Class<?> cls = null;
            MethodInvocator m1 = null;
            MethodInvocator m2 = null;
            if (SystemInfoRt.IS_AT_LEAST_JAVA9) {
                try {
                    cls = Class.forName("java.awt.image.MultiResolutionImage");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
                if (cls != null) {
                    m1 = new MethodInvocator(cls, "getResolutionVariants", new Class[0]);
                    m2 = new MethodInvocator(cls, "getResolutionVariant", Double.TYPE, Double.TYPE);
                }
            }
            MRI_CLASS = cls;
            GET_RESOLUTION_VARIANTS_METHOD = m1;
            GET_RESOLUTION_VARIANT_METHOD = m2;
        }
    }
}

