/*
 * Decompiled with CFR 0.152.
 */
package sqldelight.gnu.trove;

import sqldelight.gnu.trove.THash;

public abstract class TPrimitiveHash
extends THash {
    protected transient byte[] _states;
    protected static final byte FREE = 0;
    protected static final byte FULL = 1;
    protected static final byte REMOVED = 2;

    public TPrimitiveHash() {
    }

    public TPrimitiveHash(int initialCapacity) {
        this(initialCapacity, 0.8f);
    }

    public TPrimitiveHash(int initialCapacity, float loadFactor) {
        super(initialCapacity, loadFactor);
    }

    public Object clone() {
        TPrimitiveHash h = (TPrimitiveHash)super.clone();
        h._states = this._states == null ? null : (byte[])this._states.clone();
        return h;
    }

    protected int capacity() {
        return this._states == null ? 0 : this._states.length;
    }

    protected void removeAt(int index) {
        this._states[index] = 2;
        super.removeAt(index);
    }

    protected int setUp(int initialCapacity) {
        int capacity = super.setUp(initialCapacity);
        this._states = initialCapacity == -1 ? null : new byte[capacity];
        return capacity;
    }
}

