/*
 * Decompiled with CFR 0.152.
 */
package sqldelight.org.apache.batik.anim.dom;

import sqldelight.org.apache.batik.anim.dom.AbstractSVGLength;
import sqldelight.org.apache.batik.anim.dom.SVGOMElement;
import sqldelight.org.apache.batik.dom.svg.AbstractSVGList;
import sqldelight.org.apache.batik.dom.svg.ListHandler;
import sqldelight.org.apache.batik.dom.svg.SVGItem;
import sqldelight.org.apache.batik.parser.LengthListHandler;
import sqldelight.org.apache.batik.parser.LengthListParser;
import sqldelight.org.apache.batik.parser.ParseException;
import sqldelight.org.w3c.dom.DOMException;
import sqldelight.org.w3c.dom.Element;
import sqldelight.org.w3c.dom.svg.SVGException;
import sqldelight.org.w3c.dom.svg.SVGLength;
import sqldelight.org.w3c.dom.svg.SVGLengthList;

public abstract class AbstractSVGLengthList
extends AbstractSVGList
implements SVGLengthList {
    protected short direction;
    public static final String SVG_LENGTH_LIST_SEPARATOR = " ";

    @Override
    protected String getItemSeparator() {
        return SVG_LENGTH_LIST_SEPARATOR;
    }

    protected abstract SVGException createSVGException(short var1, String var2, Object[] var3);

    protected abstract Element getElement();

    protected AbstractSVGLengthList(short direction) {
        this.direction = direction;
    }

    @Override
    public SVGLength initialize(SVGLength newItem) throws DOMException, SVGException {
        return (SVGLength)((Object)this.initializeImpl(newItem));
    }

    @Override
    public SVGLength getItem(int index) throws DOMException {
        return (SVGLength)((Object)this.getItemImpl(index));
    }

    @Override
    public SVGLength insertItemBefore(SVGLength newItem, int index) throws DOMException, SVGException {
        return (SVGLength)((Object)this.insertItemBeforeImpl(newItem, index));
    }

    @Override
    public SVGLength replaceItem(SVGLength newItem, int index) throws DOMException, SVGException {
        return (SVGLength)((Object)this.replaceItemImpl(newItem, index));
    }

    @Override
    public SVGLength removeItem(int index) throws DOMException {
        return (SVGLength)((Object)this.removeItemImpl(index));
    }

    @Override
    public SVGLength appendItem(SVGLength newItem) throws DOMException, SVGException {
        return (SVGLength)((Object)this.appendItemImpl(newItem));
    }

    @Override
    protected SVGItem createSVGItem(Object newItem) {
        SVGLength l = (SVGLength)newItem;
        return new SVGLengthItem(l.getUnitType(), l.getValueInSpecifiedUnits(), this.direction);
    }

    @Override
    protected void doParse(String value, ListHandler handler) throws ParseException {
        LengthListParser lengthListParser = new LengthListParser();
        LengthListBuilder builder = new LengthListBuilder(handler);
        lengthListParser.setLengthListHandler(builder);
        lengthListParser.parse(value);
    }

    @Override
    protected void checkItemType(Object newItem) throws SVGException {
        if (!(newItem instanceof SVGLength)) {
            this.createSVGException((short)0, "expected.length", null);
        }
    }

    protected class LengthListBuilder
    implements LengthListHandler {
        protected ListHandler listHandler;
        protected float currentValue;
        protected short currentType;

        public LengthListBuilder(ListHandler listHandler) {
            this.listHandler = listHandler;
        }

        @Override
        public void startLengthList() throws ParseException {
            this.listHandler.startList();
        }

        @Override
        public void startLength() throws ParseException {
            this.currentType = 1;
            this.currentValue = 0.0f;
        }

        @Override
        public void lengthValue(float v) throws ParseException {
            this.currentValue = v;
        }

        @Override
        public void em() throws ParseException {
            this.currentType = (short)3;
        }

        @Override
        public void ex() throws ParseException {
            this.currentType = (short)4;
        }

        @Override
        public void in() throws ParseException {
            this.currentType = (short)8;
        }

        @Override
        public void cm() throws ParseException {
            this.currentType = (short)6;
        }

        @Override
        public void mm() throws ParseException {
            this.currentType = (short)7;
        }

        @Override
        public void pc() throws ParseException {
            this.currentType = (short)10;
        }

        @Override
        public void pt() throws ParseException {
            this.currentType = (short)3;
        }

        @Override
        public void px() throws ParseException {
            this.currentType = (short)5;
        }

        @Override
        public void percentage() throws ParseException {
            this.currentType = (short)2;
        }

        @Override
        public void endLength() throws ParseException {
            this.listHandler.item(new SVGLengthItem(this.currentType, this.currentValue, AbstractSVGLengthList.this.direction));
        }

        @Override
        public void endLengthList() throws ParseException {
            this.listHandler.endList();
        }
    }

    protected class SVGLengthItem
    extends AbstractSVGLength
    implements SVGItem {
        protected AbstractSVGList parentList;

        public SVGLengthItem(short type2, float value, short direction) {
            super(direction);
            this.unitType = type2;
            this.value = value;
        }

        @Override
        protected SVGOMElement getAssociatedElement() {
            return (SVGOMElement)AbstractSVGLengthList.this.getElement();
        }

        @Override
        public void setParent(AbstractSVGList list) {
            this.parentList = list;
        }

        @Override
        public AbstractSVGList getParent() {
            return this.parentList;
        }

        @Override
        protected void reset() {
            if (this.parentList != null) {
                this.parentList.itemChanged();
            }
        }
    }
}

