/*
 * Decompiled with CFR 0.152.
 */
package sqldelight.org.apache.batik.bridge;

import java.util.Calendar;
import sqldelight.org.apache.batik.anim.dom.SVGOMAnimationElement;
import sqldelight.org.apache.batik.anim.timing.TimedElement;
import sqldelight.org.apache.batik.bridge.SVGAnimationElementBridge;
import sqldelight.org.apache.batik.dom.events.DOMTimeEvent;
import sqldelight.org.apache.batik.dom.svg.IdContainer;
import sqldelight.org.apache.batik.dom.svg.SVGOMUseShadowRoot;
import sqldelight.org.w3c.dom.Element;
import sqldelight.org.w3c.dom.Node;
import sqldelight.org.w3c.dom.events.DocumentEvent;
import sqldelight.org.w3c.dom.events.Event;
import sqldelight.org.w3c.dom.events.EventTarget;

public abstract class AnimationSupport {
    public static void fireTimeEvent(EventTarget target, String eventType, Calendar time, int detail) {
        DocumentEvent de = (DocumentEvent)((Node)target).getOwnerDocument();
        DOMTimeEvent evt = (DOMTimeEvent)de.createEvent("TimeEvent");
        evt.initTimeEventNS("http://www.w3.org/2001/xml-events", eventType, null, detail);
        evt.setTimestamp(time.getTime().getTime());
        target.dispatchEvent((Event)evt);
    }

    public static TimedElement getTimedElementById(String id, Node n) {
        Element e = AnimationSupport.getElementById(id, n);
        if (e instanceof SVGOMAnimationElement) {
            SVGAnimationElementBridge b = (SVGAnimationElementBridge)((SVGOMAnimationElement)e).getSVGContext();
            return b.getTimedElement();
        }
        return null;
    }

    public static EventTarget getEventTargetById(String id, Node n) {
        return (EventTarget)AnimationSupport.getElementById(id, n);
    }

    protected static Element getElementById(String id, Node n) {
        Node p = n.getParentNode();
        while (p != null) {
            n = p;
            if (n instanceof SVGOMUseShadowRoot) {
                p = ((SVGOMUseShadowRoot)n).getCSSParentNode();
                continue;
            }
            p = n.getParentNode();
        }
        if (n instanceof IdContainer) {
            return ((IdContainer)n).getElementById(id);
        }
        return null;
    }
}

