/*
 * Decompiled with CFR 0.152.
 */
package sqldelight.org.jdom.input.sax;

import sqldelight.org.jdom.JDOMException;
import sqldelight.org.jdom.input.sax.XMLReaderJDOMFactory;
import sqldelight.org.xml.sax.SAXException;
import sqldelight.org.xml.sax.XMLReader;
import sqldelight.org.xml.sax.helpers.XMLReaderFactory;

public class XMLReaderSAX2Factory
implements XMLReaderJDOMFactory {
    private final boolean validate;
    private final String saxdriver;

    public XMLReaderSAX2Factory(boolean validate) {
        this(validate, null);
    }

    public XMLReaderSAX2Factory(boolean validate, String saxdriver) {
        this.validate = validate;
        this.saxdriver = saxdriver;
    }

    @Override
    public XMLReader createXMLReader() throws JDOMException {
        try {
            XMLReader reader = this.saxdriver == null ? XMLReaderFactory.createXMLReader() : XMLReaderFactory.createXMLReader((String)this.saxdriver);
            reader.setFeature("http://xml.org/sax/features/validation", this.validate);
            reader.setFeature("http://xml.org/sax/features/namespaces", true);
            reader.setFeature("http://xml.org/sax/features/namespace-prefixes", true);
            return reader;
        }
        catch (SAXException e) {
            throw new JDOMException("Unable to create SAX2 XMLReader.", e);
        }
    }

    public String getDriverClassName() {
        return this.saxdriver;
    }

    @Override
    public boolean isValidating() {
        return this.validate;
    }
}

