/*
 * Decompiled with CFR 0.152.
 */
package sqldelight.org.jetbrains.jps.model.serialization;

import java.io.File;
import java.util.Map;
import sqldelight.com.intellij.openapi.components.ExpandMacroToPathMap;
import sqldelight.com.intellij.openapi.util.io.FileUtil;
import sqldelight.com.intellij.openapi.util.text.StringUtil;
import sqldelight.org.jdom.Element;
import sqldelight.org.jetbrains.annotations.NotNull;
import sqldelight.org.jetbrains.annotations.Nullable;

public class JpsMacroExpander {
    private final ExpandMacroToPathMap myExpandMacroMap = new ExpandMacroToPathMap();

    public JpsMacroExpander(Map<String, String> pathVariables) {
        for (Map.Entry<String, String> entry : pathVariables.entrySet()) {
            this.addMacro(entry.getKey(), entry.getValue());
        }
    }

    public void addFileHierarchyReplacements(String macroName, File file) {
        this.doAddFileHierarchyReplacements("$" + macroName + "$", file);
    }

    protected void addMacro(String macroName, String path) {
        this.myExpandMacroMap.addMacroExpand(macroName, path);
    }

    private void doAddFileHierarchyReplacements(String macro, @Nullable File file) {
        if (file == null) {
            return;
        }
        this.doAddFileHierarchyReplacements(macro + "/..", file.getParentFile());
        String path = FileUtil.toSystemIndependentName(file.getPath());
        if (StringUtil.endsWithChar(path, '/')) {
            this.myExpandMacroMap.put(macro + "/", path);
            this.myExpandMacroMap.put(macro, path.substring(0, path.length() - 1));
        } else {
            this.myExpandMacroMap.put(macro, path);
        }
    }

    public void substitute(@NotNull Element element, boolean caseSensitive) {
        if (element == null) {
            JpsMacroExpander.$$$reportNull$$$0(0);
        }
        this.myExpandMacroMap.substitute(element, caseSensitive);
    }

    public ExpandMacroToPathMap getExpandMacroMap() {
        return this.myExpandMacroMap;
    }

    public String substitute(@NotNull String element, boolean caseSensitive) {
        if (element == null) {
            JpsMacroExpander.$$$reportNull$$$0(1);
        }
        return this.myExpandMacroMap.substitute(element, caseSensitive);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "sqldelight/org/jetbrains/jps/model/serialization/JpsMacroExpander", "substitute"));
    }
}

