/*
 * Decompiled with CFR 0.152.
 */
package sqldelight.org.tukaani.xz;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import sqldelight.org.tukaani.xz.ArrayCache;
import sqldelight.org.tukaani.xz.BlockInputStream;
import sqldelight.org.tukaani.xz.CorruptedInputException;
import sqldelight.org.tukaani.xz.IndexIndicatorException;
import sqldelight.org.tukaani.xz.XZIOException;
import sqldelight.org.tukaani.xz.check.Check;
import sqldelight.org.tukaani.xz.common.DecoderUtil;
import sqldelight.org.tukaani.xz.common.StreamFlags;
import sqldelight.org.tukaani.xz.index.IndexHash;

public class SingleXZInputStream
extends InputStream {
    private InputStream in;
    private final ArrayCache arrayCache;
    private final int memoryLimit;
    private final StreamFlags streamHeaderFlags;
    private final Check check;
    private final boolean verifyCheck;
    private BlockInputStream blockDecoder = null;
    private final IndexHash indexHash = new IndexHash();
    private boolean endReached = false;
    private IOException exception = null;
    private final byte[] tempBuf = new byte[1];

    private static byte[] readStreamHeader(InputStream inputStream) throws IOException {
        byte[] byArray = new byte[12];
        new DataInputStream(inputStream).readFully(byArray);
        return byArray;
    }

    public SingleXZInputStream(InputStream inputStream) throws IOException {
        this(inputStream, -1);
    }

    public SingleXZInputStream(InputStream inputStream, ArrayCache arrayCache) throws IOException {
        this(inputStream, -1, arrayCache);
    }

    public SingleXZInputStream(InputStream inputStream, int n) throws IOException {
        this(inputStream, n, true);
    }

    public SingleXZInputStream(InputStream inputStream, int n, ArrayCache arrayCache) throws IOException {
        this(inputStream, n, true, arrayCache);
    }

    public SingleXZInputStream(InputStream inputStream, int n, boolean bl) throws IOException {
        this(inputStream, n, bl, ArrayCache.getDefaultCache());
    }

    public SingleXZInputStream(InputStream inputStream, int n, boolean bl, ArrayCache arrayCache) throws IOException {
        this(inputStream, n, bl, SingleXZInputStream.readStreamHeader(inputStream), arrayCache);
    }

    SingleXZInputStream(InputStream inputStream, int n, boolean bl, byte[] byArray, ArrayCache arrayCache) throws IOException {
        this.arrayCache = arrayCache;
        this.in = inputStream;
        this.memoryLimit = n;
        this.verifyCheck = bl;
        this.streamHeaderFlags = DecoderUtil.decodeStreamHeader(byArray);
        this.check = Check.getInstance(this.streamHeaderFlags.checkType);
    }

    public int getCheckType() {
        return this.streamHeaderFlags.checkType;
    }

    public String getCheckName() {
        return this.check.getName();
    }

    public int read() throws IOException {
        return this.read(this.tempBuf, 0, 1) == -1 ? -1 : this.tempBuf[0] & 0xFF;
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3;
        block12: {
            if (n < 0 || n2 < 0 || n + n2 < 0 || n + n2 > byArray.length) {
                throw new IndexOutOfBoundsException();
            }
            if (n2 == 0) {
                return 0;
            }
            if (this.in == null) {
                throw new XZIOException("Stream closed");
            }
            if (this.exception != null) {
                throw this.exception;
            }
            if (this.endReached) {
                return -1;
            }
            n3 = 0;
            try {
                while (n2 > 0) {
                    int n4;
                    if (this.blockDecoder == null) {
                        try {
                            this.blockDecoder = new BlockInputStream(this.in, this.check, this.verifyCheck, this.memoryLimit, -1L, -1L, this.arrayCache);
                        }
                        catch (IndexIndicatorException indexIndicatorException) {
                            this.indexHash.validate(this.in);
                            this.validateStreamFooter();
                            this.endReached = true;
                            return n3 > 0 ? n3 : -1;
                        }
                    }
                    if ((n4 = this.blockDecoder.read(byArray, n, n2)) > 0) {
                        n3 += n4;
                        n += n4;
                        n2 -= n4;
                        continue;
                    }
                    if (n4 != -1) continue;
                    this.indexHash.add(this.blockDecoder.getUnpaddedSize(), this.blockDecoder.getUncompressedSize());
                    this.blockDecoder = null;
                }
            }
            catch (IOException iOException) {
                this.exception = iOException;
                if (n3 != 0) break block12;
                throw iOException;
            }
        }
        return n3;
    }

    private void validateStreamFooter() throws IOException {
        byte[] byArray = new byte[12];
        new DataInputStream(this.in).readFully(byArray);
        StreamFlags streamFlags = DecoderUtil.decodeStreamFooter(byArray);
        if (!DecoderUtil.areStreamFlagsEqual(this.streamHeaderFlags, streamFlags) || this.indexHash.getIndexSize() != streamFlags.backwardSize) {
            throw new CorruptedInputException("XZ Stream Footer does not match Stream Header");
        }
    }

    public int available() throws IOException {
        if (this.in == null) {
            throw new XZIOException("Stream closed");
        }
        if (this.exception != null) {
            throw this.exception;
        }
        return this.blockDecoder == null ? 0 : this.blockDecoder.available();
    }

    public void close() throws IOException {
        this.close(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close(boolean bl) throws IOException {
        if (this.in != null) {
            if (this.blockDecoder != null) {
                this.blockDecoder.close();
                this.blockDecoder = null;
            }
            try {
                if (bl) {
                    this.in.close();
                }
            }
            finally {
                this.in = null;
            }
        }
    }
}

