/*
 * Decompiled with CFR 0.152.
 */
package sqldelight.org.tukaani.xz;

import java.io.IOException;
import java.io.OutputStream;
import sqldelight.org.tukaani.xz.ArrayCache;
import sqldelight.org.tukaani.xz.BlockOutputStream;
import sqldelight.org.tukaani.xz.FilterCoder;
import sqldelight.org.tukaani.xz.FilterEncoder;
import sqldelight.org.tukaani.xz.FilterOptions;
import sqldelight.org.tukaani.xz.FinishableOutputStream;
import sqldelight.org.tukaani.xz.RawCoder;
import sqldelight.org.tukaani.xz.UnsupportedOptionsException;
import sqldelight.org.tukaani.xz.XZ;
import sqldelight.org.tukaani.xz.XZIOException;
import sqldelight.org.tukaani.xz.check.Check;
import sqldelight.org.tukaani.xz.common.EncoderUtil;
import sqldelight.org.tukaani.xz.common.StreamFlags;
import sqldelight.org.tukaani.xz.index.IndexEncoder;

public class XZOutputStream
extends FinishableOutputStream {
    private final ArrayCache arrayCache;
    private OutputStream out;
    private final StreamFlags streamFlags = new StreamFlags();
    private final Check check;
    private final IndexEncoder index = new IndexEncoder();
    private BlockOutputStream blockEncoder = null;
    private FilterEncoder[] filters;
    private boolean filtersSupportFlushing;
    private IOException exception = null;
    private boolean finished = false;
    private final byte[] tempBuf = new byte[1];

    public XZOutputStream(OutputStream outputStream, FilterOptions filterOptions) throws IOException {
        this(outputStream, filterOptions, 4);
    }

    public XZOutputStream(OutputStream outputStream, FilterOptions filterOptions, ArrayCache arrayCache) throws IOException {
        this(outputStream, filterOptions, 4, arrayCache);
    }

    public XZOutputStream(OutputStream outputStream, FilterOptions filterOptions, int n) throws IOException {
        this(outputStream, new FilterOptions[]{filterOptions}, n);
    }

    public XZOutputStream(OutputStream outputStream, FilterOptions filterOptions, int n, ArrayCache arrayCache) throws IOException {
        this(outputStream, new FilterOptions[]{filterOptions}, n, arrayCache);
    }

    public XZOutputStream(OutputStream outputStream, FilterOptions[] filterOptionsArray) throws IOException {
        this(outputStream, filterOptionsArray, 4);
    }

    public XZOutputStream(OutputStream outputStream, FilterOptions[] filterOptionsArray, ArrayCache arrayCache) throws IOException {
        this(outputStream, filterOptionsArray, 4, arrayCache);
    }

    public XZOutputStream(OutputStream outputStream, FilterOptions[] filterOptionsArray, int n) throws IOException {
        this(outputStream, filterOptionsArray, n, ArrayCache.getDefaultCache());
    }

    public XZOutputStream(OutputStream outputStream, FilterOptions[] filterOptionsArray, int n, ArrayCache arrayCache) throws IOException {
        this.arrayCache = arrayCache;
        this.out = outputStream;
        this.updateFilters(filterOptionsArray);
        this.streamFlags.checkType = n;
        this.check = Check.getInstance(n);
        this.encodeStreamHeader();
    }

    public void updateFilters(FilterOptions filterOptions) throws XZIOException {
        FilterOptions[] filterOptionsArray = new FilterOptions[]{filterOptions};
        this.updateFilters(filterOptionsArray);
    }

    public void updateFilters(FilterOptions[] filterOptionsArray) throws XZIOException {
        if (this.blockEncoder != null) {
            throw new UnsupportedOptionsException("Changing filter options in the middle of a XZ Block not implemented");
        }
        if (filterOptionsArray.length < 1 || filterOptionsArray.length > 4) {
            throw new UnsupportedOptionsException("XZ filter chain must be 1-4 filters");
        }
        this.filtersSupportFlushing = true;
        FilterCoder[] filterCoderArray = new FilterEncoder[filterOptionsArray.length];
        for (int i = 0; i < filterOptionsArray.length; ++i) {
            filterCoderArray[i] = filterOptionsArray[i].getFilterEncoder();
            this.filtersSupportFlushing &= filterCoderArray[i].supportsFlushing();
        }
        RawCoder.validate(filterCoderArray);
        this.filters = filterCoderArray;
    }

    public void write(int n) throws IOException {
        this.tempBuf[0] = (byte)n;
        this.write(this.tempBuf, 0, 1);
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        if (n < 0 || n2 < 0 || n + n2 < 0 || n + n2 > byArray.length) {
            throw new IndexOutOfBoundsException();
        }
        if (this.exception != null) {
            throw this.exception;
        }
        if (this.finished) {
            throw new XZIOException("Stream finished or closed");
        }
        try {
            if (this.blockEncoder == null) {
                this.blockEncoder = new BlockOutputStream(this.out, this.filters, this.check, this.arrayCache);
            }
            this.blockEncoder.write(byArray, n, n2);
        }
        catch (IOException iOException) {
            this.exception = iOException;
            throw iOException;
        }
    }

    public void endBlock() throws IOException {
        if (this.exception != null) {
            throw this.exception;
        }
        if (this.finished) {
            throw new XZIOException("Stream finished or closed");
        }
        if (this.blockEncoder != null) {
            try {
                this.blockEncoder.finish();
                this.index.add(this.blockEncoder.getUnpaddedSize(), this.blockEncoder.getUncompressedSize());
                this.blockEncoder = null;
            }
            catch (IOException iOException) {
                this.exception = iOException;
                throw iOException;
            }
        }
    }

    public void flush() throws IOException {
        if (this.exception != null) {
            throw this.exception;
        }
        if (this.finished) {
            throw new XZIOException("Stream finished or closed");
        }
        try {
            if (this.blockEncoder != null) {
                if (this.filtersSupportFlushing) {
                    this.blockEncoder.flush();
                } else {
                    this.endBlock();
                    this.out.flush();
                }
            } else {
                this.out.flush();
            }
        }
        catch (IOException iOException) {
            this.exception = iOException;
            throw iOException;
        }
    }

    public void finish() throws IOException {
        if (!this.finished) {
            this.endBlock();
            try {
                this.index.encode(this.out);
                this.encodeStreamFooter();
            }
            catch (IOException iOException) {
                this.exception = iOException;
                throw iOException;
            }
            this.finished = true;
        }
    }

    public void close() throws IOException {
        if (this.out != null) {
            block6: {
                try {
                    this.finish();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                try {
                    this.out.close();
                }
                catch (IOException iOException) {
                    if (this.exception != null) break block6;
                    this.exception = iOException;
                }
            }
            this.out = null;
        }
        if (this.exception != null) {
            throw this.exception;
        }
    }

    private void encodeStreamFlags(byte[] byArray, int n) {
        byArray[n] = 0;
        byArray[n + 1] = (byte)this.streamFlags.checkType;
    }

    private void encodeStreamHeader() throws IOException {
        this.out.write(XZ.HEADER_MAGIC);
        byte[] byArray = new byte[2];
        this.encodeStreamFlags(byArray, 0);
        this.out.write(byArray);
        EncoderUtil.writeCRC32(this.out, byArray);
    }

    private void encodeStreamFooter() throws IOException {
        byte[] byArray = new byte[6];
        long l = this.index.getIndexSize() / 4L - 1L;
        for (int i = 0; i < 4; ++i) {
            byArray[i] = (byte)(l >>> i * 8);
        }
        this.encodeStreamFlags(byArray, 4);
        EncoderUtil.writeCRC32(this.out, byArray);
        this.out.write(byArray);
        this.out.write(XZ.FOOTER_MAGIC);
    }
}

