/*
 * Decompiled with CFR 0.152.
 */
package sqldelight.com.intellij.codeInsight.lookup;

import java.awt.Color;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import javax.swing.Icon;
import sqldelight.com.intellij.codeInsight.completion.InsertHandler;
import sqldelight.com.intellij.codeInsight.completion.InsertionContext;
import sqldelight.com.intellij.codeInsight.lookup.AutoCompletionPolicy;
import sqldelight.com.intellij.codeInsight.lookup.LookupElement;
import sqldelight.com.intellij.codeInsight.lookup.LookupElementPresentation;
import sqldelight.com.intellij.codeInsight.lookup.LookupElementRenderer;
import sqldelight.com.intellij.openapi.util.text.StringUtil;
import sqldelight.com.intellij.psi.PsiElement;
import sqldelight.com.intellij.psi.PsiNamedElement;
import sqldelight.com.intellij.psi.SmartPointerManager;
import sqldelight.com.intellij.psi.SmartPsiElementPointer;
import sqldelight.com.intellij.psi.util.PsiUtilCore;
import sqldelight.gnu.trove.THashSet;
import sqldelight.org.jetbrains.annotations.Contract;
import sqldelight.org.jetbrains.annotations.NotNull;
import sqldelight.org.jetbrains.annotations.Nullable;

public final class LookupElementBuilder
extends LookupElement {
    @NotNull
    private final String myLookupString;
    @NotNull
    private final Object myObject;
    @Nullable
    private final SmartPsiElementPointer<?> myPsiElement;
    private final boolean myCaseSensitive;
    @Nullable
    private final InsertHandler<LookupElement> myInsertHandler;
    @Nullable
    private final LookupElementRenderer<LookupElement> myRenderer;
    @Nullable
    private final LookupElementRenderer<LookupElement> myExpensiveRenderer;
    @Nullable
    private final LookupElementPresentation myHardcodedPresentation;
    @NotNull
    private final Set<String> myAllLookupStrings;

    private LookupElementBuilder(@NotNull String lookupString, @NotNull Object object, @Nullable InsertHandler<LookupElement> insertHandler, @Nullable LookupElementRenderer<LookupElement> renderer, @Nullable LookupElementRenderer<LookupElement> expensiveRenderer, @Nullable LookupElementPresentation hardcodedPresentation, @Nullable SmartPsiElementPointer<?> psiElement, @NotNull Set<String> allLookupStrings, boolean caseSensitive) {
        if (lookupString == null) {
            LookupElementBuilder.$$$reportNull$$$0(0);
        }
        if (object == null) {
            LookupElementBuilder.$$$reportNull$$$0(1);
        }
        if (allLookupStrings == null) {
            LookupElementBuilder.$$$reportNull$$$0(2);
        }
        this.myLookupString = lookupString;
        this.myObject = object;
        this.myInsertHandler = insertHandler;
        this.myRenderer = renderer;
        this.myExpensiveRenderer = expensiveRenderer;
        this.myHardcodedPresentation = hardcodedPresentation;
        this.myPsiElement = psiElement;
        this.myAllLookupStrings = Collections.unmodifiableSet(allLookupStrings);
        this.myCaseSensitive = caseSensitive;
    }

    private LookupElementBuilder(@NotNull String lookupString, @NotNull Object object) {
        if (lookupString == null) {
            LookupElementBuilder.$$$reportNull$$$0(3);
        }
        if (object == null) {
            LookupElementBuilder.$$$reportNull$$$0(4);
        }
        this(lookupString, object, null, null, null, null, null, Collections.singleton(lookupString), true);
    }

    @NotNull
    public static LookupElementBuilder create(@NotNull String lookupString) {
        if (lookupString == null) {
            LookupElementBuilder.$$$reportNull$$$0(5);
        }
        return new LookupElementBuilder(lookupString, lookupString);
    }

    public static LookupElementBuilder create(@NotNull Object object) {
        if (object == null) {
            LookupElementBuilder.$$$reportNull$$$0(6);
        }
        return new LookupElementBuilder(object.toString(), object);
    }

    public static LookupElementBuilder createWithSmartPointer(@NotNull String lookupString, @NotNull PsiElement element) {
        if (lookupString == null) {
            LookupElementBuilder.$$$reportNull$$$0(7);
        }
        if (element == null) {
            LookupElementBuilder.$$$reportNull$$$0(8);
        }
        PsiUtilCore.ensureValid(element);
        return new LookupElementBuilder(lookupString, SmartPointerManager.getInstance(element.getProject()).createSmartPsiElementPointer(element));
    }

    public static LookupElementBuilder create(@NotNull PsiNamedElement element) {
        if (element == null) {
            LookupElementBuilder.$$$reportNull$$$0(9);
        }
        PsiUtilCore.ensureValid(element);
        return new LookupElementBuilder(StringUtil.notNullize(element.getName()), element);
    }

    public static LookupElementBuilder createWithIcon(@NotNull PsiNamedElement element) {
        if (element == null) {
            LookupElementBuilder.$$$reportNull$$$0(10);
        }
        PsiUtilCore.ensureValid(element);
        return LookupElementBuilder.create(element).withIcon(element.getIcon(0));
    }

    public static LookupElementBuilder create(@NotNull Object lookupObject, @NotNull String lookupString) {
        if (lookupObject == null) {
            LookupElementBuilder.$$$reportNull$$$0(11);
        }
        if (lookupString == null) {
            LookupElementBuilder.$$$reportNull$$$0(12);
        }
        if (lookupObject instanceof PsiElement) {
            PsiUtilCore.ensureValid((PsiElement)lookupObject);
        }
        return new LookupElementBuilder(lookupString, lookupObject);
    }

    private LookupElementBuilder cloneWithUserData(@NotNull String lookupString, @NotNull Object object, @Nullable InsertHandler<LookupElement> insertHandler, @Nullable LookupElementRenderer<LookupElement> renderer, @Nullable LookupElementRenderer<LookupElement> expensiveRenderer, @Nullable LookupElementPresentation hardcodedPresentation, @Nullable SmartPsiElementPointer<?> psiElement, @NotNull Set<String> allLookupStrings, boolean caseSensitive) {
        if (lookupString == null) {
            LookupElementBuilder.$$$reportNull$$$0(13);
        }
        if (object == null) {
            LookupElementBuilder.$$$reportNull$$$0(14);
        }
        if (allLookupStrings == null) {
            LookupElementBuilder.$$$reportNull$$$0(15);
        }
        LookupElementBuilder result = new LookupElementBuilder(lookupString, object, insertHandler, renderer, expensiveRenderer, hardcodedPresentation, psiElement, allLookupStrings, caseSensitive);
        this.copyUserDataTo(result);
        return result;
    }

    @Deprecated
    @Contract(pure=true)
    public LookupElementBuilder setInsertHandler(@Nullable InsertHandler<LookupElement> insertHandler) {
        return this.withInsertHandler(insertHandler);
    }

    @Contract(pure=true)
    public LookupElementBuilder withInsertHandler(@Nullable InsertHandler<LookupElement> insertHandler) {
        return this.cloneWithUserData(this.myLookupString, this.myObject, insertHandler, this.myRenderer, this.myExpensiveRenderer, this.myHardcodedPresentation, this.myPsiElement, this.myAllLookupStrings, this.myCaseSensitive);
    }

    @Deprecated
    @Contract(pure=true)
    public LookupElementBuilder setRenderer(@Nullable LookupElementRenderer<LookupElement> renderer) {
        return this.withRenderer(renderer);
    }

    @Contract(pure=true)
    public LookupElementBuilder withRenderer(@Nullable LookupElementRenderer<LookupElement> renderer) {
        return this.cloneWithUserData(this.myLookupString, this.myObject, this.myInsertHandler, renderer, this.myExpensiveRenderer, this.myHardcodedPresentation, this.myPsiElement, this.myAllLookupStrings, this.myCaseSensitive);
    }

    @Contract(pure=true)
    public LookupElementBuilder withExpensiveRenderer(@Nullable LookupElementRenderer<LookupElement> expensiveRenderer) {
        return this.cloneWithUserData(this.myLookupString, this.myObject, this.myInsertHandler, this.myRenderer, expensiveRenderer, this.myHardcodedPresentation, this.myPsiElement, this.myAllLookupStrings, this.myCaseSensitive);
    }

    @Override
    @NotNull
    public Set<String> getAllLookupStrings() {
        Set<String> set = this.myAllLookupStrings;
        if (set == null) {
            LookupElementBuilder.$$$reportNull$$$0(16);
        }
        return set;
    }

    @Deprecated
    @Contract(pure=true)
    public LookupElementBuilder setIcon(@Nullable Icon icon) {
        return this.withIcon(icon);
    }

    @Contract(pure=true)
    public LookupElementBuilder withIcon(@Nullable Icon icon) {
        LookupElementPresentation presentation = this.copyPresentation();
        presentation.setIcon(icon);
        return this.cloneWithUserData(this.myLookupString, this.myObject, this.myInsertHandler, null, this.myExpensiveRenderer, presentation, this.myPsiElement, this.myAllLookupStrings, this.myCaseSensitive);
    }

    @NotNull
    private LookupElementPresentation copyPresentation() {
        LookupElementPresentation presentation = new LookupElementPresentation();
        if (this.myHardcodedPresentation != null) {
            presentation.copyFrom(this.myHardcodedPresentation);
        } else {
            presentation.setItemText(this.myLookupString);
        }
        LookupElementPresentation lookupElementPresentation = presentation;
        if (lookupElementPresentation == null) {
            LookupElementBuilder.$$$reportNull$$$0(17);
        }
        return lookupElementPresentation;
    }

    @Deprecated
    @Contract(pure=true)
    public LookupElementBuilder addLookupString(@NotNull String another) {
        if (another == null) {
            LookupElementBuilder.$$$reportNull$$$0(18);
        }
        return this.withLookupString(another);
    }

    @Contract(pure=true)
    public LookupElementBuilder withLookupString(@NotNull String another) {
        if (another == null) {
            LookupElementBuilder.$$$reportNull$$$0(19);
        }
        THashSet<String> set = new THashSet<String>(this.myAllLookupStrings);
        set.add(another);
        return this.cloneWithUserData(this.myLookupString, this.myObject, this.myInsertHandler, this.myRenderer, this.myExpensiveRenderer, this.myHardcodedPresentation, this.myPsiElement, Collections.unmodifiableSet(set), this.myCaseSensitive);
    }

    @Contract(pure=true)
    public LookupElementBuilder withLookupStrings(@NotNull Collection<String> another) {
        if (another == null) {
            LookupElementBuilder.$$$reportNull$$$0(20);
        }
        THashSet<String> set = new THashSet<String>(this.myAllLookupStrings);
        set.addAll(another);
        return this.cloneWithUserData(this.myLookupString, this.myObject, this.myInsertHandler, this.myRenderer, this.myExpensiveRenderer, this.myHardcodedPresentation, this.myPsiElement, Collections.unmodifiableSet(set), this.myCaseSensitive);
    }

    @Override
    public boolean isCaseSensitive() {
        return this.myCaseSensitive;
    }

    @Deprecated
    @Contract(pure=true)
    public LookupElementBuilder setCaseSensitive(boolean caseSensitive) {
        return this.withCaseSensitivity(caseSensitive);
    }

    @Contract(pure=true)
    public LookupElementBuilder withCaseSensitivity(boolean caseSensitive) {
        return this.cloneWithUserData(this.myLookupString, this.myObject, this.myInsertHandler, this.myRenderer, this.myExpensiveRenderer, this.myHardcodedPresentation, this.myPsiElement, this.myAllLookupStrings, caseSensitive);
    }

    @Contract(pure=true)
    public LookupElementBuilder withPsiElement(@Nullable PsiElement psi) {
        return this.cloneWithUserData(this.myLookupString, this.myObject, this.myInsertHandler, this.myRenderer, this.myExpensiveRenderer, this.myHardcodedPresentation, psi == null ? null : SmartPointerManager.createPointer(psi), this.myAllLookupStrings, this.myCaseSensitive);
    }

    @Deprecated
    @Contract(pure=true)
    public LookupElementBuilder setItemTextForeground(@NotNull Color itemTextForeground) {
        if (itemTextForeground == null) {
            LookupElementBuilder.$$$reportNull$$$0(21);
        }
        return this.withItemTextForeground(itemTextForeground);
    }

    @Contract(pure=true)
    public LookupElementBuilder withItemTextForeground(@NotNull Color itemTextForeground) {
        if (itemTextForeground == null) {
            LookupElementBuilder.$$$reportNull$$$0(22);
        }
        LookupElementPresentation presentation = this.copyPresentation();
        presentation.setItemTextForeground(itemTextForeground);
        return this.cloneWithUserData(this.myLookupString, this.myObject, this.myInsertHandler, null, this.myExpensiveRenderer, presentation, this.myPsiElement, this.myAllLookupStrings, this.myCaseSensitive);
    }

    @Deprecated
    @Contract(pure=true)
    public LookupElementBuilder setItemTextUnderlined(boolean underlined) {
        return this.withItemTextUnderlined(underlined);
    }

    @Contract(pure=true)
    public LookupElementBuilder withItemTextUnderlined(boolean underlined) {
        LookupElementPresentation presentation = this.copyPresentation();
        presentation.setItemTextUnderlined(underlined);
        return this.cloneWithUserData(this.myLookupString, this.myObject, this.myInsertHandler, null, this.myExpensiveRenderer, presentation, this.myPsiElement, this.myAllLookupStrings, this.myCaseSensitive);
    }

    @Contract(pure=true)
    public LookupElementBuilder withItemTextItalic(boolean italic) {
        LookupElementPresentation presentation = this.copyPresentation();
        presentation.setItemTextItalic(italic);
        return this.cloneWithUserData(this.myLookupString, this.myObject, this.myInsertHandler, null, this.myExpensiveRenderer, presentation, this.myPsiElement, this.myAllLookupStrings, this.myCaseSensitive);
    }

    @Deprecated
    @Contract(pure=true)
    public LookupElementBuilder setTypeText(@Nullable String typeText) {
        return this.withTypeText(typeText);
    }

    @Contract(pure=true)
    public LookupElementBuilder withTypeText(@Nullable String typeText) {
        return this.withTypeText(typeText, false);
    }

    @Deprecated
    @Contract(pure=true)
    public LookupElementBuilder setTypeText(@Nullable String typeText, boolean grayed) {
        return this.withTypeText(typeText, grayed);
    }

    @Contract(pure=true)
    public LookupElementBuilder withTypeText(@Nullable String typeText, boolean grayed) {
        return this.withTypeText(typeText, null, grayed);
    }

    @Contract(pure=true)
    public LookupElementBuilder withTypeText(@Nullable String typeText, @Nullable Icon typeIcon, boolean grayed) {
        LookupElementPresentation presentation = this.copyPresentation();
        presentation.setTypeText(typeText, typeIcon);
        presentation.setTypeGrayed(grayed);
        return this.cloneWithUserData(this.myLookupString, this.myObject, this.myInsertHandler, null, this.myExpensiveRenderer, presentation, this.myPsiElement, this.myAllLookupStrings, this.myCaseSensitive);
    }

    public LookupElementBuilder withTypeIconRightAligned(boolean typeIconRightAligned) {
        LookupElementPresentation presentation = this.copyPresentation();
        presentation.setTypeIconRightAligned(typeIconRightAligned);
        return this.cloneWithUserData(this.myLookupString, this.myObject, this.myInsertHandler, null, this.myExpensiveRenderer, presentation, this.myPsiElement, this.myAllLookupStrings, this.myCaseSensitive);
    }

    @Deprecated
    @Contract(pure=true)
    public LookupElementBuilder setPresentableText(@NotNull String presentableText) {
        if (presentableText == null) {
            LookupElementBuilder.$$$reportNull$$$0(23);
        }
        return this.withPresentableText(presentableText);
    }

    @Contract(pure=true)
    public LookupElementBuilder withPresentableText(@NotNull String presentableText) {
        if (presentableText == null) {
            LookupElementBuilder.$$$reportNull$$$0(24);
        }
        LookupElementPresentation presentation = this.copyPresentation();
        presentation.setItemText(presentableText);
        return this.cloneWithUserData(this.myLookupString, this.myObject, this.myInsertHandler, null, this.myExpensiveRenderer, presentation, this.myPsiElement, this.myAllLookupStrings, this.myCaseSensitive);
    }

    @Deprecated
    @Contract(pure=true)
    public LookupElementBuilder setBold() {
        return this.bold();
    }

    @Contract(pure=true)
    public LookupElementBuilder bold() {
        return this.withBoldness(true);
    }

    @Deprecated
    @Contract(pure=true)
    public LookupElementBuilder setBold(boolean bold) {
        return this.withBoldness(bold);
    }

    @Contract(pure=true)
    public LookupElementBuilder withBoldness(boolean bold) {
        LookupElementPresentation presentation = this.copyPresentation();
        presentation.setItemTextBold(bold);
        return this.cloneWithUserData(this.myLookupString, this.myObject, this.myInsertHandler, null, this.myExpensiveRenderer, presentation, this.myPsiElement, this.myAllLookupStrings, this.myCaseSensitive);
    }

    @Deprecated
    @Contract(pure=true)
    public LookupElementBuilder setStrikeout() {
        return this.strikeout();
    }

    @Contract(pure=true)
    public LookupElementBuilder strikeout() {
        return this.withStrikeoutness(true);
    }

    @Deprecated
    @Contract(pure=true)
    public LookupElementBuilder setStrikeout(boolean strikeout) {
        return this.withStrikeoutness(strikeout);
    }

    @Contract(pure=true)
    public LookupElementBuilder withStrikeoutness(boolean strikeout) {
        LookupElementPresentation presentation = this.copyPresentation();
        presentation.setStrikeout(strikeout);
        return this.cloneWithUserData(this.myLookupString, this.myObject, this.myInsertHandler, null, this.myExpensiveRenderer, presentation, this.myPsiElement, this.myAllLookupStrings, this.myCaseSensitive);
    }

    @Deprecated
    @Contract(pure=true)
    public LookupElementBuilder setTailText(@Nullable String tailText) {
        return this.withTailText(tailText);
    }

    @Contract(pure=true)
    public LookupElementBuilder withTailText(@Nullable String tailText) {
        return this.withTailText(tailText, false);
    }

    @Deprecated
    @Contract(pure=true)
    public LookupElementBuilder setTailText(@Nullable String tailText, boolean grayed) {
        return this.withTailText(tailText, grayed);
    }

    @Contract(pure=true)
    public LookupElementBuilder withTailText(@Nullable String tailText, boolean grayed) {
        LookupElementPresentation presentation = this.copyPresentation();
        presentation.setTailText(tailText, grayed);
        return this.cloneWithUserData(this.myLookupString, this.myObject, this.myInsertHandler, null, this.myExpensiveRenderer, presentation, this.myPsiElement, this.myAllLookupStrings, this.myCaseSensitive);
    }

    @Contract(pure=true)
    public LookupElementBuilder appendTailText(@NotNull String tailText, boolean grayed) {
        if (tailText == null) {
            LookupElementBuilder.$$$reportNull$$$0(25);
        }
        LookupElementPresentation presentation = this.copyPresentation();
        presentation.appendTailText(tailText, grayed);
        return this.cloneWithUserData(this.myLookupString, this.myObject, this.myInsertHandler, null, this.myExpensiveRenderer, presentation, this.myPsiElement, this.myAllLookupStrings, this.myCaseSensitive);
    }

    @Contract(pure=true)
    public LookupElement withAutoCompletionPolicy(AutoCompletionPolicy policy) {
        return policy.applyPolicy(this);
    }

    @Override
    @NotNull
    public String getLookupString() {
        String string = this.myLookupString;
        if (string == null) {
            LookupElementBuilder.$$$reportNull$$$0(26);
        }
        return string;
    }

    @Nullable
    public InsertHandler<LookupElement> getInsertHandler() {
        return this.myInsertHandler;
    }

    @Nullable
    public LookupElementRenderer<LookupElement> getRenderer() {
        return this.myRenderer;
    }

    @Override
    @Nullable
    public LookupElementRenderer<? extends LookupElement> getExpensiveRenderer() {
        return this.myExpensiveRenderer;
    }

    @Override
    @NotNull
    public Object getObject() {
        Object object = this.myObject;
        if (object == null) {
            LookupElementBuilder.$$$reportNull$$$0(27);
        }
        return object;
    }

    @Override
    @Nullable
    public PsiElement getPsiElement() {
        if (this.myPsiElement != null) {
            return this.myPsiElement.getElement();
        }
        return super.getPsiElement();
    }

    @Override
    public void handleInsert(@NotNull InsertionContext context) {
        if (context == null) {
            LookupElementBuilder.$$$reportNull$$$0(28);
        }
        if (this.myInsertHandler != null) {
            this.myInsertHandler.handleInsert(context, this);
        }
    }

    @Override
    public void renderElement(LookupElementPresentation presentation) {
        if (this.myRenderer != null) {
            this.myRenderer.renderElement(this, presentation);
        } else if (this.myHardcodedPresentation != null) {
            presentation.copyFrom(this.myHardcodedPresentation);
        } else {
            presentation.setItemText(this.myLookupString);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LookupElementBuilder that = (LookupElementBuilder)o;
        InsertHandler<LookupElement> insertHandler = that.myInsertHandler;
        if (this.myInsertHandler != null && insertHandler != null ? !this.myInsertHandler.getClass().equals(insertHandler.getClass()) : this.myInsertHandler != insertHandler) {
            return false;
        }
        if (!this.myLookupString.equals(that.myLookupString)) {
            return false;
        }
        if (!this.myObject.equals(that.myObject)) {
            return false;
        }
        LookupElementRenderer<LookupElement> renderer = that.myRenderer;
        return !(this.myRenderer != null && renderer != null ? !this.myRenderer.getClass().equals(renderer.getClass()) : this.myRenderer != renderer);
    }

    @Override
    public String toString() {
        return "LookupElementBuilder: string=" + this.getLookupString() + "; handler=" + this.myInsertHandler;
    }

    public int hashCode() {
        int result = 0;
        result = 31 * result + (this.myInsertHandler != null ? this.myInsertHandler.getClass().hashCode() : 0);
        result = 31 * result + this.myLookupString.hashCode();
        result = 31 * result + this.myObject.hashCode();
        result = 31 * result + (this.myRenderer != null ? this.myRenderer.getClass().hashCode() : 0);
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 16: 
            case 17: 
            case 26: 
            case 27: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 16: 
            case 17: 
            case 26: 
            case 27: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lookupString";
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "object";
                break;
            }
            case 2: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "allLookupStrings";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "lookupObject";
                break;
            }
            case 16: 
            case 17: 
            case 26: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sqldelight/com/intellij/codeInsight/lookup/LookupElementBuilder";
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "another";
                break;
            }
            case 21: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "itemTextForeground";
                break;
            }
            case 23: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentableText";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tailText";
                break;
            }
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "sqldelight/com/intellij/codeInsight/lookup/LookupElementBuilder";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllLookupStrings";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "copyPresentation";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getLookupString";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "getObject";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: 
            case 6: 
            case 9: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "create";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "createWithSmartPointer";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "createWithIcon";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "cloneWithUserData";
                break;
            }
            case 16: 
            case 17: 
            case 26: 
            case 27: {
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "addLookupString";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "withLookupString";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "withLookupStrings";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "setItemTextForeground";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "withItemTextForeground";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "setPresentableText";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "withPresentableText";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "appendTailText";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "handleInsert";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 16: 
            case 17: 
            case 26: 
            case 27: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

