/*
 * Decompiled with CFR 0.152.
 */
package sqldelight.com.intellij.ide.plugins;

import java.io.IOException;
import java.lang.reflect.Method;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import sqldelight.com.intellij.ide.plugins.DescriptorListLoadingContext;
import sqldelight.com.intellij.ide.plugins.DescriptorLoadingContext;
import sqldelight.com.intellij.ide.plugins.DisabledPluginsState;
import sqldelight.com.intellij.ide.plugins.IdeaPluginDescriptor;
import sqldelight.com.intellij.ide.plugins.IdeaPluginDescriptorImpl;
import sqldelight.com.intellij.ide.plugins.PathBasedJdomXIncluder;
import sqldelight.com.intellij.ide.plugins.PluginDescriptorLoader;
import sqldelight.com.intellij.ide.plugins.PluginManagerCore;
import sqldelight.com.intellij.openapi.application.ApplicationManager;
import sqldelight.com.intellij.openapi.application.PathManager;
import sqldelight.com.intellij.openapi.components.Service;
import sqldelight.com.intellij.openapi.diagnostic.Logger;
import sqldelight.com.intellij.openapi.extensions.PluginDescriptor;
import sqldelight.com.intellij.openapi.extensions.PluginId;
import sqldelight.com.intellij.openapi.util.JDOMUtil;
import sqldelight.com.intellij.openapi.util.SafeJdomFactory;
import sqldelight.com.intellij.openapi.util.registry.Registry;
import sqldelight.com.intellij.openapi.util.text.StringUtil;
import sqldelight.com.intellij.util.containers.ContainerUtil;
import sqldelight.org.jdom.JDOMException;
import sqldelight.org.jetbrains.annotations.ApiStatus;
import sqldelight.org.jetbrains.annotations.NotNull;
import sqldelight.org.jetbrains.annotations.Nullable;

@Service
public final class PluginManager {
    public static final String INSTALLED_TXT = "installed.txt";
    private final List<Runnable> disabledPluginListeners = new CopyOnWriteArrayList<Runnable>();

    @NotNull
    public static PluginManager getInstance() {
        PluginManager pluginManager = ApplicationManager.getApplication().getService(PluginManager.class);
        if (pluginManager == null) {
            PluginManager.$$$reportNull$$$0(0);
        }
        return pluginManager;
    }

    private PluginManager() {
        DisabledPluginsState.setDisabledPluginListener(() -> {
            for (Runnable listener : this.disabledPluginListeners) {
                listener.run();
            }
        });
    }

    public void addDisablePluginListener(@NotNull Runnable listener) {
        if (listener == null) {
            PluginManager.$$$reportNull$$$0(1);
        }
        this.disabledPluginListeners.add(listener);
    }

    public void removeDisablePluginListener(@NotNull Runnable listener) {
        if (listener == null) {
            PluginManager.$$$reportNull$$$0(2);
        }
        this.disabledPluginListeners.remove(listener);
    }

    @Nullable
    public static Path getOnceInstalledIfExists() {
        Path onceInstalledFile = PathManager.getConfigDir().resolve(INSTALLED_TXT);
        return Files.isRegularFile(onceInstalledFile, new LinkOption[0]) ? onceInstalledFile : null;
    }

    @Nullable
    public static IdeaPluginDescriptorImpl loadDescriptor(@NotNull Path file, @NotNull String fileName) {
        if (file == null) {
            PluginManager.$$$reportNull$$$0(3);
        }
        if (fileName == null) {
            PluginManager.$$$reportNull$$$0(4);
        }
        return PluginManager.loadDescriptor(file, fileName, DisabledPluginsState.disabledPlugins(), false, PathBasedJdomXIncluder.DEFAULT_PATH_RESOLVER);
    }

    @Nullable
    public static IdeaPluginDescriptorImpl loadDescriptor(@NotNull Path file, @NotNull String fileName, @NotNull Set<PluginId> disabledPlugins, boolean bundled, PathBasedJdomXIncluder.PathResolver<?> pathResolver) {
        if (file == null) {
            PluginManager.$$$reportNull$$$0(5);
        }
        if (fileName == null) {
            PluginManager.$$$reportNull$$$0(6);
        }
        if (disabledPlugins == null) {
            PluginManager.$$$reportNull$$$0(7);
        }
        DescriptorListLoadingContext parentContext = DescriptorListLoadingContext.createSingleDescriptorContext(disabledPlugins);
        try (DescriptorLoadingContext context = new DescriptorLoadingContext(parentContext, bundled, false, pathResolver);){
            IdeaPluginDescriptorImpl ideaPluginDescriptorImpl = PluginDescriptorLoader.loadDescriptorFromFileOrDir(file, fileName, context, Files.isDirectory(file, new LinkOption[0]));
            return ideaPluginDescriptorImpl;
        }
    }

    @Deprecated
    public static void processException(@NotNull Throwable t) {
        if (t == null) {
            PluginManager.$$$reportNull$$$0(8);
        }
        try {
            Class<?> aClass = PluginManager.class.getClassLoader().loadClass("sqldelight.com.intellij.ide.plugins.StartupAbortedException");
            Method method = aClass.getMethod("processException", Throwable.class);
            method.setAccessible(true);
            method.invoke(null, t);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }

    @Deprecated
    @Nullable
    public static IdeaPluginDescriptor getPlugin(@Nullable PluginId id) {
        return PluginManagerCore.getPlugin(id);
    }

    public static IdeaPluginDescriptor @NotNull [] getPlugins() {
        IdeaPluginDescriptor[] ideaPluginDescriptorArray = PluginManagerCore.getPlugins();
        if (ideaPluginDescriptorArray == null) {
            PluginManager.$$$reportNull$$$0(9);
        }
        return ideaPluginDescriptorArray;
    }

    public static boolean isPluginInstalled(PluginId id) {
        return PluginManagerCore.isPluginInstalled(id);
    }

    @Nullable
    public static PluginId getPluginByClassName(@NotNull String className) {
        if (className == null) {
            PluginManager.$$$reportNull$$$0(10);
        }
        return PluginManagerCore.getPluginByClassName(className);
    }

    @NotNull
    public static List<? extends IdeaPluginDescriptor> getLoadedPlugins() {
        List<? extends IdeaPluginDescriptor> list = PluginManagerCore.getLoadedPlugins();
        if (list == null) {
            PluginManager.$$$reportNull$$$0(11);
        }
        return list;
    }

    @Nullable
    public PluginId getPluginOrPlatformByClassName(@NotNull String className) {
        if (className == null) {
            PluginManager.$$$reportNull$$$0(12);
        }
        return PluginManagerCore.getPluginOrPlatformByClassName(className);
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2020.2")
    @NotNull
    public static List<String> getDisabledPlugins() {
        List<String> list = DisabledPluginsState.getDisabledPlugins();
        if (list == null) {
            PluginManager.$$$reportNull$$$0(13);
        }
        return list;
    }

    @Deprecated
    public static void saveDisabledPlugins(@NotNull Collection<String> ids, boolean append) throws IOException {
        if (ids == null) {
            PluginManager.$$$reportNull$$$0(14);
        }
        DisabledPluginsState.saveDisabledPlugins(ContainerUtil.map(ids, PluginId::getId), append);
    }

    public static boolean disablePlugin(@NotNull String id) {
        if (id == null) {
            PluginManager.$$$reportNull$$$0(15);
        }
        return PluginManagerCore.disablePlugin(PluginId.getId(id));
    }

    @Deprecated
    public static boolean enablePlugin(@NotNull String id) {
        if (id == null) {
            PluginManager.$$$reportNull$$$0(16);
        }
        return PluginManagerCore.enablePlugin(PluginId.getId(id));
    }

    public boolean enablePlugin(@NotNull PluginId id) {
        if (id == null) {
            PluginManager.$$$reportNull$$$0(17);
        }
        return PluginManagerCore.enablePlugin(id);
    }

    @ApiStatus.Internal
    @NotNull
    public static Logger getLogger() {
        Logger logger2 = PluginManagerCore.getLogger();
        if (logger2 == null) {
            PluginManager.$$$reportNull$$$0(18);
        }
        return logger2;
    }

    @ApiStatus.Internal
    public static void loadDescriptorFromFile(@NotNull IdeaPluginDescriptorImpl descriptor, @NotNull Path file, @Nullable SafeJdomFactory factory, @NotNull Set<PluginId> disabledPlugins) throws IOException, JDOMException {
        if (descriptor == null) {
            PluginManager.$$$reportNull$$$0(19);
        }
        if (file == null) {
            PluginManager.$$$reportNull$$$0(20);
        }
        if (disabledPlugins == null) {
            PluginManager.$$$reportNull$$$0(21);
        }
        int flags = 6;
        DescriptorListLoadingContext parentContext = new DescriptorListLoadingContext(flags, disabledPlugins, PluginManagerCore.createLoadingResult(null));
        descriptor.readExternal(JDOMUtil.load(file, factory), PathBasedJdomXIncluder.DEFAULT_PATH_RESOLVER, parentContext, descriptor);
    }

    public boolean isDevelopedByJetBrains(@NotNull PluginDescriptor plugin) {
        if (plugin == null) {
            PluginManager.$$$reportNull$$$0(22);
        }
        return this.isDevelopedByJetBrains(plugin.getVendor());
    }

    public boolean isDevelopedByJetBrains(@Nullable String vendorString) {
        if (vendorString == null) {
            return false;
        }
        if (vendorString.equals("JetBrains")) {
            return true;
        }
        for (String vendor : StringUtil.split(vendorString, ",")) {
            if (!"JetBrains".equals(vendor.trim())) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public IdeaPluginDescriptor findEnabledPlugin(@NotNull PluginId id) {
        List<IdeaPluginDescriptorImpl> result;
        if (id == null) {
            PluginManager.$$$reportNull$$$0(23);
        }
        if ((result = PluginManagerCore.ourLoadedPlugins) == null) {
            return null;
        }
        for (IdeaPluginDescriptor ideaPluginDescriptor : result) {
            if (id != ideaPluginDescriptor.getPluginId()) continue;
            return ideaPluginDescriptor;
        }
        return null;
    }

    public boolean hideImplementationDetails() {
        return !Registry.is("plugins.show.implementation.details");
    }

    @ApiStatus.Internal
    public void setPlugins(@NotNull List<IdeaPluginDescriptor> descriptors) {
        if (descriptors == null) {
            PluginManager.$$$reportNull$$$0(24);
        }
        IdeaPluginDescriptorImpl[] list = descriptors.toArray(IdeaPluginDescriptorImpl.EMPTY_ARRAY);
        PluginManagerCore.doSetPlugins(list);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sqldelight/com/intellij/ide/plugins/PluginManager";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 3: 
            case 5: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
            case 7: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disabledPlugins";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "t";
                break;
            }
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "className";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ids";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "plugin";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptors";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "sqldelight/com/intellij/ide/plugins/PluginManager";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getPlugins";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getLoadedPlugins";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisabledPlugins";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getLogger";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "addDisablePluginListener";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "removeDisablePluginListener";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "loadDescriptor";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "processException";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getPluginByClassName";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getPluginOrPlatformByClassName";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "saveDisabledPlugins";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "disablePlugin";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "enablePlugin";
                break;
            }
            case 19: 
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "loadDescriptorFromFile";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "isDevelopedByJetBrains";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "findEnabledPlugin";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "setPlugins";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 10: 
            case 12: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

