/*
 * Decompiled with CFR 0.152.
 */
package sqldelight.com.intellij.ide.plugins;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Writer;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import sqldelight.com.intellij.diagnostic.Activity;
import sqldelight.com.intellij.diagnostic.LoadingState;
import sqldelight.com.intellij.diagnostic.PluginException;
import sqldelight.com.intellij.diagnostic.StartUpMeasurer;
import sqldelight.com.intellij.ide.plugins.CachingSemiGraph;
import sqldelight.com.intellij.ide.plugins.ClassPathXmlPathResolver;
import sqldelight.com.intellij.ide.plugins.DescriptorListLoadingContext;
import sqldelight.com.intellij.ide.plugins.DescriptorLoadingContext;
import sqldelight.com.intellij.ide.plugins.DisabledPluginsState;
import sqldelight.com.intellij.ide.plugins.IdeaPluginDescriptor;
import sqldelight.com.intellij.ide.plugins.IdeaPluginDescriptorImpl;
import sqldelight.com.intellij.ide.plugins.PathBasedJdomXIncluder;
import sqldelight.com.intellij.ide.plugins.PluginDependency;
import sqldelight.com.intellij.ide.plugins.PluginDescriptorLoader;
import sqldelight.com.intellij.ide.plugins.PluginError;
import sqldelight.com.intellij.ide.plugins.PluginLoadingResult;
import sqldelight.com.intellij.ide.plugins.PluginManager;
import sqldelight.com.intellij.ide.plugins.PluginManagerState;
import sqldelight.com.intellij.ide.plugins.PluginXmlPathResolver;
import sqldelight.com.intellij.ide.plugins.cl.PluginClassLoader;
import sqldelight.com.intellij.openapi.application.Application;
import sqldelight.com.intellij.openapi.application.ApplicationManager;
import sqldelight.com.intellij.openapi.application.PathManager;
import sqldelight.com.intellij.openapi.application.impl.ApplicationInfoImpl;
import sqldelight.com.intellij.openapi.diagnostic.Logger;
import sqldelight.com.intellij.openapi.extensions.ExtensionInstantiationException;
import sqldelight.com.intellij.openapi.extensions.ExtensionsArea;
import sqldelight.com.intellij.openapi.extensions.PluginDescriptor;
import sqldelight.com.intellij.openapi.extensions.PluginId;
import sqldelight.com.intellij.openapi.extensions.impl.ExtensionPointImpl;
import sqldelight.com.intellij.openapi.extensions.impl.ExtensionsAreaImpl;
import sqldelight.com.intellij.openapi.util.BuildNumber;
import sqldelight.com.intellij.openapi.util.io.FileUtilRt;
import sqldelight.com.intellij.openapi.util.text.StringUtil;
import sqldelight.com.intellij.util.ArrayUtil;
import sqldelight.com.intellij.util.ArrayUtilRt;
import sqldelight.com.intellij.util.LineSeparator;
import sqldelight.com.intellij.util.PlatformUtils;
import sqldelight.com.intellij.util.ReflectionUtil;
import sqldelight.com.intellij.util.concurrency.AppExecutorUtil;
import sqldelight.com.intellij.util.containers.ContainerUtil;
import sqldelight.com.intellij.util.execution.ParametersListUtil;
import sqldelight.com.intellij.util.graph.DFSTBuilder;
import sqldelight.com.intellij.util.graph.Graph;
import sqldelight.com.intellij.util.graph.GraphAlgorithms;
import sqldelight.com.intellij.util.graph.GraphGenerator;
import sqldelight.com.intellij.util.graph.InboundSemiGraph;
import sqldelight.com.intellij.util.lang.UrlClassLoader;
import sqldelight.org.jetbrains.annotations.ApiStatus;
import sqldelight.org.jetbrains.annotations.NotNull;
import sqldelight.org.jetbrains.annotations.Nullable;

public final class PluginManagerCore {
    public static final String META_INF = "META-INF/";
    public static final String IDEA_IS_INTERNAL_PROPERTY = "idea.is.internal";
    public static final PluginId CORE_ID = PluginId.getId("sqldelight.com.intellij");
    public static final String CORE_PLUGIN_ID = "sqldelight.com.intellij";
    public static final PluginId JAVA_PLUGIN_ID = PluginId.getId("sqldelight.com.intellij.java");
    private static final PluginId JAVA_MODULE_ID = PluginId.getId("sqldelight.com.intellij.modules.java");
    public static final String PLUGIN_XML = "plugin.xml";
    public static final String PLUGIN_XML_PATH = "META-INF/plugin.xml";
    private static final PluginId ALL_MODULES_MARKER = PluginId.getId("sqldelight.com.intellij.modules.all");
    public static final String VENDOR_JETBRAINS = "JetBrains";
    private static final String MODULE_DEPENDENCY_PREFIX = "sqldelight.com.intellij.module";
    private static final PluginId SPECIAL_IDEA_PLUGIN_ID = PluginId.getId("IDEA CORE");
    static final String PROPERTY_PLUGIN_PATH = "plugin.path";
    public static final String DISABLE = "disable";
    public static final String ENABLE = "enable";
    public static final String EDIT = "edit";
    private static Reference<Map<PluginId, Set<String>>> ourBrokenPluginVersions;
    private static volatile IdeaPluginDescriptorImpl[] ourPlugins;
    static volatile List<IdeaPluginDescriptorImpl> ourLoadedPlugins;
    private static List<PluginError> ourLoadingErrors;
    private static Map<String, String[]> ourAdditionalLayoutMap;
    public static volatile boolean isUnitTestMode;
    @ApiStatus.Internal
    static final boolean usePluginClassLoader;
    @ApiStatus.Internal
    public static String ourPluginError;
    @ApiStatus.Internal
    public static Set<PluginId> ourPluginsToDisable;
    @ApiStatus.Internal
    public static Set<PluginId> ourPluginsToEnable;
    @ApiStatus.Internal
    public static boolean ourDisableNonBundledPlugins;
    private static Set<PluginId> ourShadowedBundledPlugins;
    private static Boolean isRunningFromSources;
    private static volatile CompletableFuture<DescriptorListLoadingContext> descriptorListFuture;
    private static BuildNumber ourBuildNumber;

    @ApiStatus.Internal
    @Nullable
    public static String getPluginsCompatibleBuild() {
        return System.getProperty("idea.plugins.compatible.build");
    }

    @NotNull
    public static @NotNull IdeaPluginDescriptor @NotNull [] getPlugins() {
        IdeaPluginDescriptor[] result = ourPlugins;
        if (result == null) {
            PluginManagerCore.loadAndInitializePlugins(null, null);
            if (ourPlugins == null) {
                PluginManagerCore.$$$reportNull$$$0(0);
            }
            return ourPlugins;
        }
        if (result == null) {
            PluginManagerCore.$$$reportNull$$$0(1);
        }
        return result;
    }

    @NotNull
    public static List<? extends IdeaPluginDescriptor> getLoadedPlugins() {
        return PluginManagerCore.getLoadedPlugins(null);
    }

    @ApiStatus.Internal
    @NotNull
    public static List<IdeaPluginDescriptorImpl> getLoadedPlugins(@Nullable ClassLoader coreClassLoader) {
        List<IdeaPluginDescriptorImpl> result = ourLoadedPlugins;
        if (result == null) {
            PluginManagerCore.loadAndInitializePlugins(null, coreClassLoader);
            List<IdeaPluginDescriptorImpl> list = ourLoadedPlugins;
            if (list == null) {
                PluginManagerCore.$$$reportNull$$$0(2);
            }
            return list;
        }
        List<IdeaPluginDescriptorImpl> list = result;
        if (list == null) {
            PluginManagerCore.$$$reportNull$$$0(3);
        }
        return list;
    }

    @ApiStatus.Internal
    public static boolean arePluginsInitialized() {
        return ourPlugins != null;
    }

    @ApiStatus.Internal
    static synchronized void doSetPlugins(@NotNull @NotNull IdeaPluginDescriptorImpl @NotNull [] value) {
        if (value == null) {
            PluginManagerCore.$$$reportNull$$$0(4);
        }
        ourPlugins = value;
        ourLoadedPlugins = Collections.unmodifiableList(PluginManagerCore.getOnlyEnabledPlugins(value));
    }

    public static boolean isDisabled(@NotNull PluginId pluginId) {
        if (pluginId == null) {
            PluginManagerCore.$$$reportNull$$$0(5);
        }
        return DisabledPluginsState.getDisabledIds().contains(pluginId);
    }

    @Deprecated
    public static boolean isDisabled(@NotNull String pluginId) {
        if (pluginId == null) {
            PluginManagerCore.$$$reportNull$$$0(6);
        }
        return DisabledPluginsState.getDisabledIds().contains(PluginId.getId(pluginId));
    }

    public static boolean isBrokenPlugin(@NotNull IdeaPluginDescriptor descriptor) {
        PluginId pluginId;
        if (descriptor == null) {
            PluginManagerCore.$$$reportNull$$$0(7);
        }
        if ((pluginId = descriptor.getPluginId()) == null) {
            return true;
        }
        Set<String> set = PluginManagerCore.getBrokenPluginVersions().get(pluginId);
        return set != null && set.contains(descriptor.getVersion());
    }

    @NotNull
    private static Map<PluginId, Set<String>> getBrokenPluginVersions() {
        Map<PluginId, Set<String>> result = sqldelight.com.intellij.reference.SoftReference.dereference(ourBrokenPluginVersions);
        if (result != null) {
            Map<PluginId, Set<String>> map = result;
            if (map == null) {
                PluginManagerCore.$$$reportNull$$$0(8);
            }
            return map;
        }
        if (System.getProperty("idea.ignore.disabled.plugins") != null) {
            result = Collections.emptyMap();
            ourBrokenPluginVersions = new SoftReference<Map<PluginId, Set<String>>>(result);
            Map<PluginId, Set<String>> map = result;
            if (map == null) {
                PluginManagerCore.$$$reportNull$$$0(9);
            }
            return map;
        }
        result = new HashMap<PluginId, Set<String>>();
        try (InputStream resource = PluginManagerCore.class.getResourceAsStream("/brokenPlugins.txt");
             BufferedReader br = new BufferedReader(new InputStreamReader(resource, StandardCharsets.UTF_8));){
            String s;
            while ((s = br.readLine()) != null) {
                List<String> tokens;
                if ((s = s.trim()).startsWith("//") || (tokens = ParametersListUtil.parse(s)).isEmpty()) continue;
                if (tokens.size() == 1) {
                    throw new RuntimeException("brokenPlugins.txt is broken. The line contains plugin name, but does not contains version: " + s);
                }
                PluginId pluginId = PluginId.getId(tokens.get(0));
                List<String> versions = tokens.subList(1, tokens.size());
                result.computeIfAbsent(pluginId, k -> new HashSet()).addAll(versions);
            }
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to read /brokenPlugins.txt", e);
        }
        ourBrokenPluginVersions = new SoftReference<Map<PluginId, Set<String>>>(result);
        Map<PluginId, Set<String>> map = result;
        if (map == null) {
            PluginManagerCore.$$$reportNull$$$0(10);
        }
        return map;
    }

    public static void savePluginsList(@NotNull Collection<PluginId> ids, @NotNull Path file, boolean append) throws IOException {
        if (ids == null) {
            PluginManagerCore.$$$reportNull$$$0(11);
        }
        if (file == null) {
            PluginManagerCore.$$$reportNull$$$0(12);
        }
        Files.createDirectories(file.getParent(), new FileAttribute[0]);
        try (BufferedWriter writer2 = append ? Files.newBufferedWriter(file, StandardOpenOption.APPEND, StandardOpenOption.CREATE) : Files.newBufferedWriter(file, new OpenOption[0]);){
            PluginManagerCore.writePluginsList(ids, writer2);
        }
    }

    public static void writePluginsList(@NotNull Collection<PluginId> ids, @NotNull Writer writer2) throws IOException {
        if (ids == null) {
            PluginManagerCore.$$$reportNull$$$0(13);
        }
        if (writer2 == null) {
            PluginManagerCore.$$$reportNull$$$0(14);
        }
        ArrayList<PluginId> sortedIds = new ArrayList<PluginId>(ids);
        sortedIds.sort(null);
        String separator = LineSeparator.getSystemLineSeparator().getSeparatorString();
        for (PluginId id : sortedIds) {
            writer2.write(id.getIdString());
            writer2.write(separator);
        }
    }

    @Deprecated
    public static boolean disablePlugin(@NotNull String id) {
        if (id == null) {
            PluginManagerCore.$$$reportNull$$$0(15);
        }
        return PluginManagerCore.disablePlugin(PluginId.getId(id));
    }

    public static boolean disablePlugin(@NotNull PluginId id) {
        if (id == null) {
            PluginManagerCore.$$$reportNull$$$0(16);
        }
        return DisabledPluginsState.disablePlugin(id);
    }

    public static boolean enablePlugin(@NotNull PluginId id) {
        if (id == null) {
            PluginManagerCore.$$$reportNull$$$0(17);
        }
        return DisabledPluginsState.enablePlugin(id);
    }

    @Deprecated
    public static boolean enablePlugin(@NotNull String id) {
        if (id == null) {
            PluginManagerCore.$$$reportNull$$$0(18);
        }
        return PluginManagerCore.enablePlugin(PluginId.getId(id));
    }

    public static boolean isModuleDependency(@NotNull PluginId dependentPluginId) {
        if (dependentPluginId == null) {
            PluginManagerCore.$$$reportNull$$$0(19);
        }
        return dependentPluginId.getIdString().startsWith(MODULE_DEPENDENCY_PREFIX);
    }

    @ApiStatus.Internal
    @NotNull
    public static PluginException createPluginException(@NotNull String errorMessage, @Nullable Throwable cause, @NotNull Class<?> pluginClass) {
        ClassLoader classLoader;
        if (errorMessage == null) {
            PluginManagerCore.$$$reportNull$$$0(20);
        }
        if (pluginClass == null) {
            PluginManagerCore.$$$reportNull$$$0(21);
        }
        PluginId pluginId = (classLoader = pluginClass.getClassLoader()) instanceof PluginClassLoader ? ((PluginClassLoader)classLoader).getPluginId() : PluginManagerCore.getPluginByClassName(pluginClass.getName());
        return new PluginException(errorMessage, cause, pluginId);
    }

    @Nullable
    public static PluginId getPluginByClassName(@NotNull String className) {
        PluginId id;
        if (className == null) {
            PluginManagerCore.$$$reportNull$$$0(22);
        }
        return (id = PluginManagerCore.getPluginOrPlatformByClassName(className)) == null || CORE_ID == id ? null : id;
    }

    @Nullable
    public static PluginId getPluginOrPlatformByClassName(@NotNull String className) {
        PluginDescriptor result;
        if (className == null) {
            PluginManagerCore.$$$reportNull$$$0(23);
        }
        return (result = PluginManagerCore.getPluginDescriptorOrPlatformByClassName(className)) == null ? null : result.getPluginId();
    }

    @ApiStatus.Internal
    @Nullable
    public static PluginDescriptor getPluginDescriptorOrPlatformByClassName(@NotNull String className) {
        List<IdeaPluginDescriptorImpl> loadedPlugins;
        if (className == null) {
            PluginManagerCore.$$$reportNull$$$0(24);
        }
        if ((loadedPlugins = ourLoadedPlugins) == null || className.startsWith("java.") || className.startsWith("javax.") || className.startsWith("kotlin.") || className.startsWith("groovy.")) {
            return null;
        }
        PluginDescriptor result = null;
        for (IdeaPluginDescriptorImpl o : loadedPlugins) {
            ClassLoader classLoader = o.getPluginClassLoader();
            if (classLoader == null || !PluginManagerCore.hasLoadedClass(className, classLoader)) continue;
            result = o;
            break;
        }
        if (result == null) {
            return null;
        }
        if (result.getPluginId() != CORE_ID || className.startsWith("com.jetbrains.") || className.startsWith("org.jetbrains.") || className.startsWith("sqldelight.com.intellij.") || className.startsWith("org.intellij.") || className.startsWith("com.android.") || className.startsWith("git4idea.") || className.startsWith("org.angularjs.")) {
            return result;
        }
        String root = PathManager.getResourceRoot(result.getPluginClassLoader(), "/" + className.replace('.', '/') + ".class");
        if (root == null) {
            return null;
        }
        for (IdeaPluginDescriptorImpl o : loadedPlugins) {
            Path path;
            if (!o.isUseIdeaClassLoader() || !root.startsWith(FileUtilRt.toSystemIndependentName((path = o.getPluginPath()).toString()))) continue;
            result = o;
            break;
        }
        return result;
    }

    private static boolean hasLoadedClass(@NotNull String className, @NotNull ClassLoader loader) {
        if (className == null) {
            PluginManagerCore.$$$reportNull$$$0(25);
        }
        if (loader == null) {
            PluginManagerCore.$$$reportNull$$$0(26);
        }
        if (loader instanceof UrlClassLoader) {
            return ((UrlClassLoader)loader).hasLoadedClass(className);
        }
        Class<?> aClass = loader.getClass();
        if (PluginManagerCore.isInstanceofUrlClassLoader(aClass)) {
            try {
                return (Boolean)aClass.getMethod("hasLoadedClass", String.class).invoke((Object)loader, className);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    private static boolean isInstanceofUrlClassLoader(Class<?> aClass) {
        String urlClassLoaderName = UrlClassLoader.class.getName();
        while (aClass != null) {
            if (aClass.getName().equals(urlClassLoaderName)) {
                return true;
            }
            aClass = aClass.getSuperclass();
        }
        return false;
    }

    @Nullable
    private static IdeaPluginDescriptorImpl getImplicitDependency(@NotNull IdeaPluginDescriptorImpl descriptor, @Nullable IdeaPluginDescriptorImpl javaDep, boolean hasAllModules) {
        if (descriptor == null) {
            PluginManagerCore.$$$reportNull$$$0(27);
        }
        if (descriptor.getPluginId() == CORE_ID || descriptor.getPluginId() == JAVA_PLUGIN_ID || VENDOR_JETBRAINS.equals(descriptor.getVendor()) || !hasAllModules || javaDep == null) {
            return null;
        }
        return PluginManagerCore.hasModuleDependencies(descriptor) ? null : javaDep;
    }

    static boolean hasModuleDependencies(@NotNull IdeaPluginDescriptorImpl descriptor) {
        if (descriptor == null) {
            PluginManagerCore.$$$reportNull$$$0(28);
        }
        if (descriptor.pluginDependencies == null) {
            return false;
        }
        for (PluginDependency dependency : descriptor.pluginDependencies) {
            PluginId depId = dependency.id;
            if (depId != JAVA_PLUGIN_ID && depId != JAVA_MODULE_ID && !PluginManagerCore.isModuleDependency(depId)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    private static ClassLoader createPluginClassLoader(ClassLoader @NotNull [] parentLoaders, @NotNull IdeaPluginDescriptorImpl descriptor, @NotNull UrlClassLoader.Builder urlLoaderBuilder, @NotNull ClassLoader coreLoader, @NotNull Map<String, String[]> additionalLayoutMap) {
        List<Path> classPath;
        if (descriptor == null) {
            PluginManagerCore.$$$reportNull$$$0(29);
        }
        if (urlLoaderBuilder == null) {
            PluginManagerCore.$$$reportNull$$$0(30);
        }
        if (coreLoader == null) {
            PluginManagerCore.$$$reportNull$$$0(31);
        }
        if (additionalLayoutMap == null) {
            PluginManagerCore.$$$reportNull$$$0(32);
        }
        if (parentLoaders == null) {
            PluginManagerCore.$$$reportNull$$$0(33);
        }
        if ((classPath = descriptor.jarFiles) == null) {
            classPath = descriptor.collectClassPath(additionalLayoutMap);
        } else {
            descriptor.jarFiles = null;
        }
        if (descriptor.isUseIdeaClassLoader()) {
            ClassLoader classLoader;
            PluginManagerCore.getLogger().warn(descriptor.getPluginId() + " uses deprecated `use-idea-classloader` attribute");
            ClassLoader loader = PluginManagerCore.class.getClassLoader();
            try {
                Class<?> loaderClass = loader.getClass();
                if (loaderClass.getName().endsWith(".BootstrapClassLoaderUtil$TransformingLoader")) {
                    loaderClass = loaderClass.getSuperclass();
                }
                MethodHandle addURL = MethodHandles.lookup().findVirtual(loaderClass, "addURL", MethodType.methodType(Void.TYPE, URL.class));
                for (Path pathElement : classPath) {
                    addURL.invoke(loader, PluginManagerCore.localFileToUrl(pathElement, descriptor));
                }
                classLoader = loader;
            }
            catch (Throwable t) {
                throw new IllegalStateException("An unexpected core classloader: " + loader.getClass(), t);
            }
            if (classLoader == null) {
                PluginManagerCore.$$$reportNull$$$0(34);
            }
            return classLoader;
        }
        ArrayList<URL> urls = new ArrayList<URL>(classPath.size());
        for (Path pathElement : classPath) {
            urls.add(PluginManagerCore.localFileToUrl(pathElement, descriptor));
        }
        PluginClassLoader loader = new PluginClassLoader(urlLoaderBuilder.urls(urls), parentLoaders, (PluginDescriptor)descriptor, descriptor.getPluginPath());
        if (usePluginClassLoader) {
            loader.setCoreLoader(coreLoader);
        }
        PluginClassLoader pluginClassLoader = loader;
        if (pluginClassLoader == null) {
            PluginManagerCore.$$$reportNull$$$0(35);
        }
        return pluginClassLoader;
    }

    @NotNull
    private static URL localFileToUrl(@NotNull Path file, @NotNull IdeaPluginDescriptor descriptor) {
        URL uRL;
        if (file == null) {
            PluginManagerCore.$$$reportNull$$$0(36);
        }
        if (descriptor == null) {
            PluginManagerCore.$$$reportNull$$$0(37);
        }
        try {
            uRL = file.normalize().toUri().toURL();
        }
        catch (MalformedURLException e) {
            throw new PluginException("Corrupted path element: `" + file + '`', e, descriptor.getPluginId());
        }
        if (uRL == null) {
            PluginManagerCore.$$$reportNull$$$0(38);
        }
        return uRL;
    }

    public static synchronized void invalidatePlugins() {
        ourPlugins = null;
        ourLoadedPlugins = null;
        DisabledPluginsState.invalidate();
        ourShadowedBundledPlugins = null;
    }

    private static void logPlugins(@NotNull @NotNull IdeaPluginDescriptorImpl @NotNull [] plugins) {
        if (plugins == null) {
            PluginManagerCore.$$$reportNull$$$0(39);
        }
        StringBuilder bundled = new StringBuilder();
        StringBuilder disabled = new StringBuilder();
        StringBuilder custom = new StringBuilder();
        for (IdeaPluginDescriptorImpl descriptor : plugins) {
            StringBuilder target = !descriptor.isEnabled() ? disabled : (descriptor.isBundled() || descriptor.getPluginId() == SPECIAL_IDEA_PLUGIN_ID ? bundled : custom);
            if (target.length() > 0) {
                target.append(", ");
            }
            target.append(descriptor.getName());
            String version2 = descriptor.getVersion();
            if (version2 == null) continue;
            target.append(" (").append(version2).append(')');
        }
        Logger logger2 = PluginManagerCore.getLogger();
        logger2.info("Loaded bundled plugins: " + bundled);
        if (custom.length() > 0) {
            logger2.info("Loaded custom plugins: " + custom);
        }
        if (disabled.length() > 0) {
            logger2.info("Disabled plugins: " + disabled);
        }
    }

    public static boolean isRunningFromSources() {
        Boolean result = isRunningFromSources;
        if (result == null) {
            isRunningFromSources = result = Boolean.valueOf(Files.isDirectory(Paths.get(PathManager.getHomePath(), ".idea"), new LinkOption[0]));
        }
        return result;
    }

    private static void prepareLoadingPluginsErrorMessage(@NotNull List<PluginError> errors, @NotNull List<String> actions) {
        if (errors == null) {
            PluginManagerCore.$$$reportNull$$$0(40);
        }
        if (actions == null) {
            PluginManagerCore.$$$reportNull$$$0(41);
        }
        ourLoadingErrors = errors;
        ArrayList<PluginError> errorsToReport = new ArrayList<PluginError>();
        for (PluginError error : errors) {
            if (!error.isNotifyUser()) continue;
            errorsToReport.add(error);
        }
        String message = "Problems found loading plugins:\n  " + errors.stream().map(PluginError::toString).collect(Collectors.joining("\n  "));
        Application app = ApplicationManager.getApplication();
        if (app == null || !app.isHeadlessEnvironment() || isUnitTestMode) {
            if (!errorsToReport.isEmpty()) {
                String errorMessage = Stream.concat(errorsToReport.stream().map(o -> StringUtil.escapeXmlEntities(o.toUserError()) + "."), actions.stream()).collect(Collectors.joining("<p/>"));
                ourPluginError = ourPluginError == null ? errorMessage : ourPluginError + "<p/>\n" + errorMessage;
            }
            if (!errors.isEmpty()) {
                PluginManagerCore.getLogger().warn(message);
            }
        } else if (!errors.isEmpty()) {
            PluginManagerCore.getLogger().error(message);
        }
    }

    @Nullable
    public static String getLoadingError(@NotNull IdeaPluginDescriptor pluginDescriptor) {
        PluginError error;
        if (pluginDescriptor == null) {
            PluginManagerCore.$$$reportNull$$$0(42);
        }
        if ((error = PluginManagerCore.findErrorForPlugin(ourLoadingErrors, pluginDescriptor.getPluginId())) != null) {
            String reason = error.getIncompatibleReason();
            if (reason != null) {
                return "Incompatible (" + reason + ")";
            }
            return error.getMessage();
        }
        return null;
    }

    @Nullable
    public static PluginId getFirstDisabledDependency(@NotNull IdeaPluginDescriptor pluginDescriptor) {
        PluginError error;
        if (pluginDescriptor == null) {
            PluginManagerCore.$$$reportNull$$$0(43);
        }
        if ((error = PluginManagerCore.findErrorForPlugin(ourLoadingErrors, pluginDescriptor.getPluginId())) != null) {
            return error.getDisabledDependency();
        }
        return null;
    }

    @Nullable
    private static PluginError findErrorForPlugin(@Nullable List<PluginError> errors, @NotNull PluginId pluginId) {
        if (pluginId == null) {
            PluginManagerCore.$$$reportNull$$$0(44);
        }
        if (errors == null) {
            return null;
        }
        for (PluginError error : errors) {
            if (error.plugin == null || !error.plugin.getPluginId().equals(pluginId)) continue;
            return error;
        }
        return null;
    }

    @NotNull
    private static CachingSemiGraph<IdeaPluginDescriptorImpl> createPluginIdGraph(@NotNull List<IdeaPluginDescriptorImpl> descriptors, @NotNull Function<PluginId, IdeaPluginDescriptorImpl> idToDescriptorMap, boolean withOptional, boolean hasAllModules) {
        if (descriptors == null) {
            PluginManagerCore.$$$reportNull$$$0(45);
        }
        if (idToDescriptorMap == null) {
            PluginManagerCore.$$$reportNull$$$0(46);
        }
        IdeaPluginDescriptorImpl javaDep = idToDescriptorMap.apply(JAVA_MODULE_ID);
        HashSet uniqueCheck = new HashSet();
        return new CachingSemiGraph<IdeaPluginDescriptorImpl>(descriptors, rootDescriptor -> {
            IdeaPluginDescriptorImpl dep;
            List<PluginDependency> dependencies = rootDescriptor.pluginDependencies;
            List<PluginId> incompatibleModuleIds = ContainerUtil.notNullize(rootDescriptor.incompatibilities);
            if (dependencies == null) {
                dependencies = Collections.emptyList();
            }
            IdeaPluginDescriptorImpl implicitDep = PluginManagerCore.getImplicitDependency(rootDescriptor, javaDep, hasAllModules);
            int capacity = dependencies.size() + incompatibleModuleIds.size();
            if (!withOptional) {
                for (PluginDependency dependency : dependencies) {
                    if (!dependency.isOptional) continue;
                    --capacity;
                }
            }
            if (capacity == 0) {
                return implicitDep == null ? Collections.emptyList() : Collections.singletonList(implicitDep);
            }
            uniqueCheck.clear();
            ArrayList<IdeaPluginDescriptorImpl> plugins = new ArrayList<IdeaPluginDescriptorImpl>(capacity + (implicitDep == null ? 0 : 1));
            if (implicitDep != null) {
                if (rootDescriptor == implicitDep) {
                    PluginManagerCore.getLogger().error("Plugin " + rootDescriptor + " depends on self");
                } else {
                    uniqueCheck.add(implicitDep);
                    plugins.add(implicitDep);
                }
            }
            for (PluginDependency dependency : dependencies) {
                if (!withOptional && dependency.isOptional || (dep = (IdeaPluginDescriptorImpl)idToDescriptorMap.apply(dependency.id)) == null) continue;
                if (rootDescriptor == dep) {
                    if (rootDescriptor.getPluginId() == CORE_ID) continue;
                    PluginManagerCore.getLogger().error("Plugin " + rootDescriptor + " depends on self");
                    continue;
                }
                if (!uniqueCheck.add(dep)) continue;
                plugins.add(dep);
            }
            for (PluginId moduleId : incompatibleModuleIds) {
                dep = (IdeaPluginDescriptorImpl)idToDescriptorMap.apply(moduleId);
                if (dep == null || !uniqueCheck.add(dep)) continue;
                plugins.add(dep);
            }
            return plugins;
        });
    }

    private static void checkPluginCycles(@NotNull List<IdeaPluginDescriptorImpl> descriptors, @NotNull Map<PluginId, IdeaPluginDescriptorImpl> idToDescriptorMap, @NotNull List<PluginError> errors) {
        if (descriptors == null) {
            PluginManagerCore.$$$reportNull$$$0(47);
        }
        if (idToDescriptorMap == null) {
            PluginManagerCore.$$$reportNull$$$0(48);
        }
        if (errors == null) {
            PluginManagerCore.$$$reportNull$$$0(49);
        }
        CachingSemiGraph<IdeaPluginDescriptorImpl> graph = PluginManagerCore.createPluginIdGraph(descriptors, idToDescriptorMap::get, true, idToDescriptorMap.containsKey(ALL_MODULES_MARKER));
        DFSTBuilder<IdeaPluginDescriptorImpl> builder = new DFSTBuilder<IdeaPluginDescriptorImpl>(GraphGenerator.generate(graph));
        if (builder.isAcyclic()) {
            return;
        }
        StringBuilder cyclePresentation = new StringBuilder();
        for (Collection<IdeaPluginDescriptorImpl> component : builder.getComponents()) {
            if (component.size() < 2) continue;
            if (cyclePresentation.length() > 0) {
                cyclePresentation.append(", ");
            }
            String separator = " <-> ";
            for (IdeaPluginDescriptor ideaPluginDescriptor : component) {
                ideaPluginDescriptor.setEnabled(false);
                cyclePresentation.append(ideaPluginDescriptor.getPluginId());
                cyclePresentation.append(separator);
            }
            cyclePresentation.setLength(cyclePresentation.length() - separator.length());
        }
        if (cyclePresentation.length() > 0) {
            errors.add(new PluginError(null, "Plugins should not have cyclic dependencies: " + cyclePresentation, null));
        }
    }

    @Nullable
    static PathBasedJdomXIncluder.PathResolver<Path> createPluginJarsPathResolver(@NotNull Path pluginDir, @NotNull DescriptorLoadingContext context) {
        ArrayList<Path> dirs;
        ArrayList<Path> pluginJarFiles;
        if (pluginDir == null) {
            PluginManagerCore.$$$reportNull$$$0(50);
        }
        if (context == null) {
            PluginManagerCore.$$$reportNull$$$0(51);
        }
        if (!PluginDescriptorLoader.collectPluginDirectoryContents(pluginDir, pluginJarFiles = new ArrayList<Path>(), dirs = new ArrayList<Path>())) {
            return null;
        }
        return new PluginXmlPathResolver(pluginJarFiles, context);
    }

    public static void getDescriptorsToMigrate(@NotNull Path dir, @Nullable BuildNumber compatibleBuildNumber, @Nullable Path bundledPluginsPath, @Nullable Map<PluginId, Set<String>> brokenPluginVersions, List<IdeaPluginDescriptorImpl> pluginsToMigrate, List<IdeaPluginDescriptorImpl> incompatiblePlugins) throws ExecutionException, InterruptedException {
        if (dir == null) {
            PluginManagerCore.$$$reportNull$$$0(52);
        }
        PluginLoadingResult loadingResult = new PluginLoadingResult(brokenPluginVersions != null ? brokenPluginVersions : PluginManagerCore.getBrokenPluginVersions(), () -> compatibleBuildNumber == null ? PluginManagerCore.getBuildNumber() : compatibleBuildNumber);
        int flags = 6;
        DescriptorListLoadingContext context = new DescriptorListLoadingContext(flags, Collections.emptySet(), loadingResult, bundledPluginsPath);
        PluginDescriptorLoader.loadBundledDescriptorsAndDescriptorsFromDir(context, dir);
        for (IdeaPluginDescriptorImpl descriptor : loadingResult.idMap.values()) {
            if (descriptor.isBundled()) continue;
            if (loadingResult.isBroken(descriptor.getPluginId())) {
                incompatiblePlugins.add(descriptor);
                continue;
            }
            pluginsToMigrate.add(descriptor);
        }
        for (IdeaPluginDescriptorImpl descriptor : loadingResult.incompletePlugins.values()) {
            if (descriptor.isBundled()) continue;
            incompatiblePlugins.add(descriptor);
        }
    }

    private static void prepareLoadingPluginsErrorMessage(@NotNull Map<PluginId, String> disabledIds, @NotNull Set<PluginId> disabledRequiredIds, @NotNull Map<PluginId, ? extends IdeaPluginDescriptor> idMap, @NotNull List<PluginError> errors) {
        if (disabledIds == null) {
            PluginManagerCore.$$$reportNull$$$0(53);
        }
        if (disabledRequiredIds == null) {
            PluginManagerCore.$$$reportNull$$$0(54);
        }
        if (idMap == null) {
            PluginManagerCore.$$$reportNull$$$0(55);
        }
        if (errors == null) {
            PluginManagerCore.$$$reportNull$$$0(56);
        }
        ArrayList<String> actions = new ArrayList<String>();
        if (!disabledIds.isEmpty()) {
            String text = "<br><a href=\"disable\">Disable ";
            if (disabledIds.size() == 1) {
                PluginId id = disabledIds.keySet().iterator().next();
                text = text + (idMap.containsKey(id) ? PluginManagerCore.toPresentableName(idMap.get(id)) : PluginManagerCore.toPresentableName(id.getIdString()));
            } else {
                text = text + "not loaded plugins";
            }
            actions.add(text + "</a>");
            if (!disabledRequiredIds.isEmpty()) {
                String name = disabledRequiredIds.size() == 1 ? PluginManagerCore.toPresentableName(idMap.get(disabledRequiredIds.iterator().next())) : "all necessary plugins";
                actions.add("<a href=\"enable\">Enable " + name + "</a>");
            }
            actions.add("<a href=\"edit\">Open plugin manager</a>");
        }
        PluginManagerCore.prepareLoadingPluginsErrorMessage(errors, actions);
    }

    @NotNull
    public static List<? extends IdeaPluginDescriptor> testLoadDescriptorsFromClassPath(@NotNull ClassLoader loader) throws ExecutionException, InterruptedException {
        if (loader == null) {
            PluginManagerCore.$$$reportNull$$$0(57);
        }
        LinkedHashMap<URL, String> urlsFromClassPath = new LinkedHashMap<URL, String>();
        PluginDescriptorLoader.collectPluginFilesInClassPath(loader, urlsFromClassPath);
        BuildNumber buildNumber = BuildNumber.fromString("2042.42");
        DescriptorListLoadingContext context = new DescriptorListLoadingContext(0, Collections.emptySet(), new PluginLoadingResult(Collections.emptyMap(), () -> buildNumber, false));
        try (DescriptorLoadingContext loadingContext = new DescriptorLoadingContext(context, true, true, new ClassPathXmlPathResolver(loader));){
            PluginDescriptorLoader.loadDescriptorsFromClassPath(urlsFromClassPath, loadingContext, null);
        }
        context.result.finishLoading();
        List<IdeaPluginDescriptorImpl> list = context.result.getEnabledPlugins();
        if (list == null) {
            PluginManagerCore.$$$reportNull$$$0(58);
        }
        return list;
    }

    public static void scheduleDescriptorLoading() {
        PluginManagerCore.getOrScheduleLoading();
    }

    @NotNull
    private static synchronized CompletableFuture<DescriptorListLoadingContext> getOrScheduleLoading() {
        CompletableFuture<DescriptorListLoadingContext> future = descriptorListFuture;
        if (future != null) {
            CompletableFuture<DescriptorListLoadingContext> completableFuture = future;
            if (completableFuture == null) {
                PluginManagerCore.$$$reportNull$$$0(59);
            }
            return completableFuture;
        }
        descriptorListFuture = future = CompletableFuture.supplyAsync(() -> {
            Activity activity = StartUpMeasurer.startActivity("plugin descriptor loading");
            DescriptorListLoadingContext context = PluginDescriptorLoader.loadDescriptors();
            activity.end();
            return context;
        }, AppExecutorUtil.getAppExecutorService());
        CompletableFuture<DescriptorListLoadingContext> completableFuture = future;
        if (completableFuture == null) {
            PluginManagerCore.$$$reportNull$$$0(60);
        }
        return completableFuture;
    }

    @ApiStatus.Internal
    @NotNull
    public static List<IdeaPluginDescriptorImpl> getEnabledPluginRawList() {
        List<IdeaPluginDescriptorImpl> list = PluginManagerCore.getOrScheduleLoading().join().result.getEnabledPlugins();
        if (list == null) {
            PluginManagerCore.$$$reportNull$$$0(61);
        }
        return list;
    }

    @ApiStatus.Internal
    @NotNull
    public static CompletionStage<List<IdeaPluginDescriptorImpl>> initPlugins(@NotNull ClassLoader coreClassLoader) {
        CompletableFuture<DescriptorListLoadingContext> future;
        if (coreClassLoader == null) {
            PluginManagerCore.$$$reportNull$$$0(62);
        }
        if ((future = descriptorListFuture) == null) {
            future = CompletableFuture.completedFuture(null);
        }
        CompletionStage completionStage = future.thenApply(context -> {
            PluginManagerCore.loadAndInitializePlugins(context, coreClassLoader);
            return ourLoadedPlugins;
        });
        if (completionStage == null) {
            PluginManagerCore.$$$reportNull$$$0(63);
        }
        return completionStage;
    }

    @NotNull
    static PluginLoadingResult createLoadingResult(@Nullable BuildNumber buildNumber) {
        return new PluginLoadingResult(PluginManagerCore.getBrokenPluginVersions(), () -> buildNumber == null ? PluginManagerCore.getBuildNumber() : buildNumber);
    }

    private static void mergeOptionalConfigs(@NotNull List<IdeaPluginDescriptorImpl> enabledPlugins, @NotNull Map<PluginId, IdeaPluginDescriptorImpl> idMap) {
        if (enabledPlugins == null) {
            PluginManagerCore.$$$reportNull$$$0(64);
        }
        if (idMap == null) {
            PluginManagerCore.$$$reportNull$$$0(65);
        }
        if (PluginManagerCore.isRunningFromSources()) {
            for (IdeaPluginDescriptorImpl descriptor : enabledPlugins) {
                if (!descriptor.isUseCoreClassLoader() || descriptor.pluginDependencies == null) continue;
                for (PluginDependency dependency : descriptor.pluginDependencies) {
                    IdeaPluginDescriptorImpl dependent;
                    if (dependency.subDescriptor == null || (dependent = idMap.get(dependency.id)) == null || dependent.isUseCoreClassLoader()) continue;
                    dependency.subDescriptor = null;
                }
            }
        }
        for (IdeaPluginDescriptorImpl mainDescriptor : enabledPlugins) {
            List<PluginDependency> pluginDependencies = mainDescriptor.pluginDependencies;
            if (pluginDependencies == null) continue;
            PluginManagerCore.mergeOptionalDescriptors(mainDescriptor, pluginDependencies, idMap);
        }
    }

    private static void mergeOptionalDescriptors(@NotNull IdeaPluginDescriptorImpl mergedDescriptor, @NotNull List<PluginDependency> pluginDependencies, @NotNull Map<PluginId, IdeaPluginDescriptorImpl> idMap) {
        if (mergedDescriptor == null) {
            PluginManagerCore.$$$reportNull$$$0(66);
        }
        if (pluginDependencies == null) {
            PluginManagerCore.$$$reportNull$$$0(67);
        }
        if (idMap == null) {
            PluginManagerCore.$$$reportNull$$$0(68);
        }
        block0: for (PluginDependency dependency : pluginDependencies) {
            IdeaPluginDescriptorImpl dependencyDescriptor;
            IdeaPluginDescriptorImpl subDescriptor = dependency.subDescriptor;
            dependency.subDescriptor = null;
            if (subDescriptor == null || dependency.isDisabledOrBroken || (dependencyDescriptor = idMap.get(dependency.id)) == null || !dependencyDescriptor.isEnabled()) continue;
            if (subDescriptor.pluginDependencies != null) {
                for (PluginDependency pluginDependency : subDescriptor.pluginDependencies) {
                    IdeaPluginDescriptorImpl dependentDescriptor;
                    if (pluginDependency.isOptional || !pluginDependency.isDisabledOrBroken && (dependentDescriptor = idMap.get(pluginDependency.id)) != null && dependentDescriptor.isEnabled()) continue;
                    continue block0;
                }
            }
            mergedDescriptor.mergeOptionalConfig(subDescriptor);
            List<PluginDependency> childDependencies = subDescriptor.pluginDependencies;
            if (childDependencies == null) continue;
            PluginManagerCore.mergeOptionalDescriptors(mergedDescriptor, childDependencies, idMap);
        }
    }

    @NotNull
    private static Map<String, String[]> loadAdditionalLayoutMap() {
        Path fileWithLayout;
        Path path = fileWithLayout = usePluginClassLoader ? Paths.get(PathManager.getSystemPath(), PlatformUtils.getPlatformPrefix() + ".txt") : null;
        if (fileWithLayout == null || !Files.exists(fileWithLayout, new LinkOption[0])) {
            Map<String, String[]> map = Collections.emptyMap();
            if (map == null) {
                PluginManagerCore.$$$reportNull$$$0(69);
            }
            return map;
        }
        LinkedHashMap<String, String[]> additionalLayoutMap = new LinkedHashMap<String, String[]>();
        try (BufferedReader bufferedReader = Files.newBufferedReader(fileWithLayout);){
            String line;
            while ((line = bufferedReader.readLine()) != null) {
                List<String> parameters2 = ParametersListUtil.parse(line.trim());
                if (parameters2.size() < 2) continue;
                additionalLayoutMap.put(parameters2.get(0), ArrayUtilRt.toStringArray(parameters2.subList(1, parameters2.size())));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        LinkedHashMap<String, String[]> linkedHashMap = additionalLayoutMap;
        if (linkedHashMap == null) {
            PluginManagerCore.$$$reportNull$$$0(70);
        }
        return linkedHashMap;
    }

    @ApiStatus.Internal
    public static void initClassLoader(@NotNull IdeaPluginDescriptorImpl rootDescriptor) {
        ClassLoader[] classLoaderArray;
        if (rootDescriptor == null) {
            PluginManagerCore.$$$reportNull$$$0(71);
        }
        Map<PluginId, IdeaPluginDescriptorImpl> idMap = PluginManagerCore.buildPluginIdMap(ContainerUtil.concat(PluginManagerCore.getLoadedPlugins(null), Collections.singletonList(rootDescriptor)));
        LinkedHashSet<ClassLoader> loaders = new LinkedHashSet<ClassLoader>();
        PluginManagerCore.processAllDependencies(rootDescriptor, true, idMap, (IdeaPluginDescriptor descriptor) -> {
            ClassLoader loader = descriptor.getPluginClassLoader();
            if (loader == null) {
                PluginManagerCore.getLogger().error(rootDescriptor.formatErrorMessage("requires missing class loader for " + PluginManagerCore.toPresentableName(descriptor)));
            } else {
                loaders.add(loader);
            }
            return FileVisitResult.SKIP_SUBTREE;
        });
        IdeaPluginDescriptorImpl javaDep = idMap.get(JAVA_MODULE_ID);
        boolean hasAllModules = idMap.containsKey(ALL_MODULES_MARKER);
        IdeaPluginDescriptorImpl implicitDependency = PluginManagerCore.getImplicitDependency(rootDescriptor, javaDep, hasAllModules);
        if (implicitDependency != null && implicitDependency.getPluginClassLoader() != null) {
            loaders.add(implicitDependency.getPluginClassLoader());
        }
        if (loaders.isEmpty()) {
            ClassLoader[] classLoaderArray2 = new ClassLoader[1];
            classLoaderArray = classLoaderArray2;
            classLoaderArray2[0] = PluginManagerCore.class.getClassLoader();
        } else {
            classLoaderArray = loaders.toArray(new ClassLoader[0]);
        }
        ClassLoader[] array = classLoaderArray;
        rootDescriptor.setLoader(PluginManagerCore.createPluginClassLoader(array, rootDescriptor, PluginManagerCore.createUrlClassLoaderBuilder(), PluginManagerCore.class.getClassLoader(), ourAdditionalLayoutMap));
    }

    @NotNull
    private static UrlClassLoader.Builder createUrlClassLoaderBuilder() {
        UrlClassLoader.Builder builder = UrlClassLoader.build().allowLock().useCache().urlsInterned();
        if (builder == null) {
            PluginManagerCore.$$$reportNull$$$0(72);
        }
        return builder;
    }

    @NotNull
    static BuildNumber getBuildNumber() {
        BuildNumber result = ourBuildNumber;
        if (result == null) {
            result = BuildNumber.fromString(PluginManagerCore.getPluginsCompatibleBuild());
            if (result == null) {
                if (isUnitTestMode) {
                    result = BuildNumber.currentVersion();
                } else {
                    try {
                        result = ApplicationInfoImpl.getShadowInstance().getApiVersionAsNumber();
                    }
                    catch (RuntimeException ignore) {
                        result = BuildNumber.currentVersion();
                    }
                }
            }
            ourBuildNumber = result;
        }
        BuildNumber buildNumber = result;
        if (buildNumber == null) {
            PluginManagerCore.$$$reportNull$$$0(73);
        }
        return buildNumber;
    }

    private static void disableIncompatiblePlugins(@NotNull List<IdeaPluginDescriptorImpl> descriptors, @NotNull Map<PluginId, IdeaPluginDescriptorImpl> idMap, @NotNull List<PluginError> errors) {
        boolean isNonBundledPluginDisabled;
        if (descriptors == null) {
            PluginManagerCore.$$$reportNull$$$0(74);
        }
        if (idMap == null) {
            PluginManagerCore.$$$reportNull$$$0(75);
        }
        if (errors == null) {
            PluginManagerCore.$$$reportNull$$$0(76);
        }
        if (isNonBundledPluginDisabled = ourDisableNonBundledPlugins) {
            PluginManagerCore.getLogger().info("Running with disableThirdPartyPlugins argument, third-party plugins will be disabled");
        }
        String selectedIds = System.getProperty("idea.load.plugins.id");
        String selectedCategory = System.getProperty("idea.load.plugins.category");
        IdeaPluginDescriptorImpl coreDescriptor = idMap.get(CORE_ID);
        LinkedHashSet<IdeaPluginDescriptorImpl> explicitlyEnabled = null;
        if (selectedIds != null) {
            HashSet set = new HashSet();
            List<String> strings = StringUtil.split(selectedIds, ",");
            for (String it : strings) {
                set.add(PluginId.getId(it));
            }
            set.addAll(((ApplicationInfoImpl)ApplicationInfoImpl.getShadowInstance()).getEssentialPluginsIds());
            explicitlyEnabled = new LinkedHashSet(set.size());
            Iterator<Object> iterator = set.iterator();
            while (iterator.hasNext()) {
                PluginId id2 = (PluginId)iterator.next();
                IdeaPluginDescriptorImpl descriptor = idMap.get(id2);
                if (descriptor == null) continue;
                explicitlyEnabled.add(descriptor);
            }
        } else if (selectedCategory != null) {
            explicitlyEnabled = new LinkedHashSet<IdeaPluginDescriptorImpl>();
            for (IdeaPluginDescriptorImpl descriptor : descriptors) {
                if (!selectedCategory.equals(descriptor.getCategory())) continue;
                explicitlyEnabled.add(descriptor);
            }
        }
        if (explicitlyEnabled != null) {
            LinkedHashSet<IdeaPluginDescriptorImpl> finalExplicitlyEnabled = explicitlyEnabled;
            HashSet<IdeaPluginDescriptor> depProcessed = new HashSet<IdeaPluginDescriptor>();
            for (IdeaPluginDescriptorImpl descriptor : new ArrayList(explicitlyEnabled)) {
                PluginManagerCore.processAllDependencies(descriptor, false, idMap, depProcessed, (id, dependency) -> {
                    finalExplicitlyEnabled.add((IdeaPluginDescriptorImpl)dependency);
                    return FileVisitResult.CONTINUE;
                });
            }
        }
        Map<PluginId, Set<String>> brokenPluginVersions = PluginManagerCore.getBrokenPluginVersions();
        boolean shouldLoadPlugins = Boolean.parseBoolean(System.getProperty("idea.load.plugins", "true"));
        for (IdeaPluginDescriptorImpl descriptor : descriptors) {
            if (descriptor == coreDescriptor) continue;
            Set<String> set = brokenPluginVersions.get(descriptor.getPluginId());
            if (set != null && set.contains(descriptor.getVersion())) {
                descriptor.setEnabled(false);
                errors.add(new PluginError(descriptor, "was marked as broken", "marked as broken"));
                continue;
            }
            if (explicitlyEnabled != null) {
                if (explicitlyEnabled.contains(descriptor)) continue;
                descriptor.setEnabled(false);
                PluginManagerCore.getLogger().info("Plugin " + PluginManagerCore.toPresentableName(descriptor) + " " + (selectedIds != null ? "is not in 'idea.load.plugins.id' system property" : "category doesn't match 'idea.load.plugins.category' system property"));
                continue;
            }
            if (!shouldLoadPlugins) {
                descriptor.setEnabled(false);
                errors.add(new PluginError(descriptor, "is skipped (plugins loading disabled)", null));
                continue;
            }
            if (!isNonBundledPluginDisabled || descriptor.isBundled()) continue;
            descriptor.setEnabled(false);
            errors.add(new PluginError(descriptor, "is skipped (third-party plugins loading disabled)", null, false));
        }
    }

    public static boolean isCompatible(@NotNull IdeaPluginDescriptor descriptor) {
        if (descriptor == null) {
            PluginManagerCore.$$$reportNull$$$0(77);
        }
        return !PluginManagerCore.isIncompatible(descriptor);
    }

    public static boolean isCompatible(@NotNull IdeaPluginDescriptor descriptor, @Nullable BuildNumber buildNumber) {
        if (descriptor == null) {
            PluginManagerCore.$$$reportNull$$$0(78);
        }
        return !PluginManagerCore.isIncompatible(descriptor, buildNumber);
    }

    public static boolean isIncompatible(@NotNull IdeaPluginDescriptor descriptor) {
        if (descriptor == null) {
            PluginManagerCore.$$$reportNull$$$0(79);
        }
        return PluginManagerCore.isIncompatible(descriptor, PluginManagerCore.getBuildNumber());
    }

    public static boolean isIncompatible(@NotNull IdeaPluginDescriptor descriptor, @Nullable BuildNumber buildNumber) {
        if (descriptor == null) {
            PluginManagerCore.$$$reportNull$$$0(80);
        }
        if (buildNumber == null) {
            buildNumber = PluginManagerCore.getBuildNumber();
        }
        return PluginManagerCore.getIncompatibleMessage(buildNumber, descriptor.getSinceBuild(), descriptor.getUntilBuild()) != null;
    }

    @Nullable
    static String getIncompatibleMessage(@NotNull BuildNumber buildNumber, @Nullable String sinceBuild, @Nullable String untilBuild) {
        if (buildNumber == null) {
            PluginManagerCore.$$$reportNull$$$0(81);
        }
        try {
            BuildNumber untilBuildNumber;
            BuildNumber sinceBuildNumber;
            String message = null;
            BuildNumber buildNumber2 = sinceBuildNumber = sinceBuild == null ? null : BuildNumber.fromString(sinceBuild, null, null);
            if (sinceBuildNumber != null && sinceBuildNumber.compareTo(buildNumber) > 0) {
                message = "since build " + sinceBuildNumber + " > " + buildNumber;
            }
            BuildNumber buildNumber3 = untilBuildNumber = untilBuild == null ? null : BuildNumber.fromString(untilBuild, null, null);
            if (untilBuildNumber != null && untilBuildNumber.compareTo(buildNumber) < 0) {
                message = message == null ? "" : message + ", ";
                message = message + "until build " + untilBuildNumber + " < " + buildNumber;
            }
            return message;
        }
        catch (Exception e) {
            PluginManagerCore.getLogger().error(e);
            return "version check failed";
        }
    }

    private static void checkEssentialPluginsAreAvailable(@NotNull Map<PluginId, IdeaPluginDescriptorImpl> idMap) {
        if (idMap == null) {
            PluginManagerCore.$$$reportNull$$$0(82);
        }
        List<PluginId> required = ((ApplicationInfoImpl)ApplicationInfoImpl.getShadowInstance()).getEssentialPluginsIds();
        ArrayList<String> missing = null;
        for (PluginId id : required) {
            IdeaPluginDescriptorImpl descriptor = idMap.get(id);
            if (descriptor != null && descriptor.isEnabled()) continue;
            if (missing == null) {
                missing = new ArrayList<String>();
            }
            missing.add(id.getIdString());
        }
        if (missing != null) {
            throw new EssentialPluginMissingException(missing);
        }
    }

    @NotNull
    static PluginManagerState initializePlugins(@NotNull DescriptorListLoadingContext context, @NotNull ClassLoader coreLoader, boolean checkEssentialPlugins) {
        if (context == null) {
            PluginManagerCore.$$$reportNull$$$0(83);
        }
        if (coreLoader == null) {
            PluginManagerCore.$$$reportNull$$$0(84);
        }
        PluginLoadingResult loadingResult = context.result;
        ArrayList<PluginError> errors = new ArrayList<PluginError>(loadingResult.getErrors());
        if (loadingResult.duplicateModuleMap != null) {
            for (Map.Entry<PluginId, List<IdeaPluginDescriptorImpl>> entry : loadingResult.duplicateModuleMap.entrySet()) {
                errors.add(new PluginError(null, "Module " + entry.getKey() + " is declared by plugins:\n  " + StringUtil.join((Iterable)entry.getValue(), "\n  "), null));
            }
        }
        Map<PluginId, IdeaPluginDescriptorImpl> idMap = loadingResult.idMap;
        IdeaPluginDescriptorImpl coreDescriptor = idMap.get(CORE_ID);
        if (checkEssentialPlugins && coreDescriptor == null) {
            throw new EssentialPluginMissingException(Collections.singletonList(CORE_ID + " (platform prefix: " + System.getProperty("idea.platform.prefix") + ")"));
        }
        List<IdeaPluginDescriptorImpl> descriptors = loadingResult.getEnabledPlugins();
        PluginManagerCore.disableIncompatiblePlugins(descriptors, idMap, errors);
        PluginManagerCore.checkPluginCycles(descriptors, idMap, errors);
        IdeaPluginDescriptorImpl[] sortedRequired = PluginManagerCore.getTopologicallySorted(PluginManagerCore.createPluginIdGraph(descriptors, idMap::get, false, idMap.containsKey(ALL_MODULES_MARKER)));
        LinkedHashSet<PluginId> enabledPluginIds = new LinkedHashSet<PluginId>();
        LinkedHashSet<PluginId> enabledModuleIds = new LinkedHashSet<PluginId>();
        LinkedHashMap<PluginId, String> disabledIds = new LinkedHashMap<PluginId, String>();
        LinkedHashSet<PluginId> disabledRequiredIds = new LinkedHashSet<PluginId>();
        for (IdeaPluginDescriptorImpl descriptor : sortedRequired) {
            boolean wasEnabled = descriptor.isEnabled();
            if (wasEnabled && PluginManagerCore.computePluginEnabled(descriptor, enabledPluginIds, enabledModuleIds, idMap, disabledRequiredIds, context.disabledPlugins, errors)) {
                enabledPluginIds.add(descriptor.getPluginId());
                enabledModuleIds.addAll(descriptor.getModules());
                continue;
            }
            descriptor.setEnabled(false);
            if (!wasEnabled) continue;
            disabledIds.put(descriptor.getPluginId(), descriptor.getName());
        }
        PluginManagerCore.prepareLoadingPluginsErrorMessage(disabledIds, disabledRequiredIds, idMap, errors);
        CachingSemiGraph<IdeaPluginDescriptorImpl> graph = PluginManagerCore.createPluginIdGraph(Arrays.asList(sortedRequired), idMap::get, true, idMap.containsKey(ALL_MODULES_MARKER));
        IdeaPluginDescriptorImpl[] sortedAll = PluginManagerCore.getTopologicallySorted(graph);
        List<IdeaPluginDescriptorImpl> enabledPlugins = PluginManagerCore.getOnlyEnabledPlugins(sortedAll);
        PluginManagerCore.mergeOptionalConfigs(enabledPlugins, idMap);
        Map<String, String[]> additionalLayoutMap = PluginManagerCore.loadAdditionalLayoutMap();
        ourAdditionalLayoutMap = additionalLayoutMap;
        PluginManagerCore.configureClassLoaders(coreLoader, graph, coreDescriptor, enabledPlugins, additionalLayoutMap, context.usePluginClassLoader);
        if (checkEssentialPlugins) {
            PluginManagerCore.checkEssentialPluginsAreAvailable(idMap);
        }
        HashSet<PluginId> effectiveDisabledIds = disabledIds.isEmpty() ? Collections.emptySet() : new HashSet<PluginId>(disabledIds.keySet());
        return new PluginManagerState(sortedAll, enabledPlugins, disabledRequiredIds, effectiveDisabledIds, idMap);
    }

    private static void configureClassLoaders(@NotNull ClassLoader coreLoader, @NotNull CachingSemiGraph<IdeaPluginDescriptorImpl> graph, @Nullable IdeaPluginDescriptor coreDescriptor, @NotNull List<IdeaPluginDescriptorImpl> enabledPlugins, @NotNull Map<String, String[]> additionalLayoutMap, boolean usePluginClassLoader) {
        if (coreLoader == null) {
            PluginManagerCore.$$$reportNull$$$0(85);
        }
        if (graph == null) {
            PluginManagerCore.$$$reportNull$$$0(86);
        }
        if (enabledPlugins == null) {
            PluginManagerCore.$$$reportNull$$$0(87);
        }
        if (additionalLayoutMap == null) {
            PluginManagerCore.$$$reportNull$$$0(88);
        }
        ArrayList<ClassLoader> loaders = new ArrayList<ClassLoader>();
        ClassLoader[] emptyClassLoaderArray = new ClassLoader[]{};
        UrlClassLoader.Builder urlClassLoaderBuilder = PluginManagerCore.createUrlClassLoaderBuilder();
        for (IdeaPluginDescriptorImpl rootDescriptor : enabledPlugins) {
            ClassLoader[] classLoaderArray;
            if (rootDescriptor == coreDescriptor || rootDescriptor.isUseCoreClassLoader()) {
                rootDescriptor.setLoader(coreLoader);
                continue;
            }
            if (!usePluginClassLoader) {
                rootDescriptor.setLoader(null);
                continue;
            }
            loaders.clear();
            List<IdeaPluginDescriptorImpl> dependencies = graph.getInList(rootDescriptor);
            if (!dependencies.isEmpty()) {
                loaders.ensureCapacity(dependencies.size());
                for (IdeaPluginDescriptorImpl descriptor : dependencies) {
                    ClassLoader loader = descriptor.getPluginClassLoader();
                    if (loader == null) {
                        PluginManagerCore.getLogger().error(rootDescriptor.formatErrorMessage("requires missing class loader for " + PluginManagerCore.toPresentableName(descriptor)));
                        continue;
                    }
                    loaders.add(loader);
                }
            }
            if (loaders.isEmpty()) {
                ClassLoader[] classLoaderArray2 = new ClassLoader[1];
                classLoaderArray = classLoaderArray2;
                classLoaderArray2[0] = coreLoader;
            } else {
                classLoaderArray = loaders.toArray(emptyClassLoaderArray);
            }
            ClassLoader[] parentLoaders = classLoaderArray;
            rootDescriptor.setLoader(PluginManagerCore.createPluginClassLoader(parentLoaders, rootDescriptor, urlClassLoaderBuilder, coreLoader, additionalLayoutMap));
        }
    }

    @NotNull
    private static @NotNull IdeaPluginDescriptorImpl @NotNull [] getTopologicallySorted(@NotNull InboundSemiGraph<IdeaPluginDescriptorImpl> graph) {
        if (graph == null) {
            PluginManagerCore.$$$reportNull$$$0(89);
        }
        DFSTBuilder<IdeaPluginDescriptorImpl> requiredOnlyGraph = new DFSTBuilder<IdeaPluginDescriptorImpl>(GraphGenerator.generate(graph));
        IdeaPluginDescriptorImpl[] sortedRequired = graph.getNodes().toArray(IdeaPluginDescriptorImpl.EMPTY_ARRAY);
        Comparator<IdeaPluginDescriptorImpl> comparator = requiredOnlyGraph.comparator();
        Arrays.sort(sortedRequired, (o1, o2) -> {
            if (o1.getPluginId() == CORE_ID) {
                return -1;
            }
            if (o2.getPluginId() == CORE_ID) {
                return 1;
            }
            return comparator.compare((IdeaPluginDescriptorImpl)o1, (IdeaPluginDescriptorImpl)o2);
        });
        if (sortedRequired == null) {
            PluginManagerCore.$$$reportNull$$$0(90);
        }
        return sortedRequired;
    }

    public static List<IdeaPluginDescriptorImpl> getPluginsSortedByDependency(List<IdeaPluginDescriptorImpl> plugins, boolean withOptional) {
        CachingSemiGraph<IdeaPluginDescriptorImpl> graph = PluginManagerCore.createPluginIdGraph(plugins, id -> (IdeaPluginDescriptorImpl)PluginManagerCore.getPlugin(id), withOptional, PluginManagerCore.findPluginByModuleDependency(ALL_MODULES_MARKER) != null);
        IdeaPluginDescriptorImpl[] sortedRequired = PluginManagerCore.getTopologicallySorted(graph);
        return Arrays.asList(sortedRequired);
    }

    @ApiStatus.Internal
    @NotNull
    public static Map<PluginId, IdeaPluginDescriptorImpl> buildPluginIdMap(@NotNull List<IdeaPluginDescriptorImpl> descriptors) {
        if (descriptors == null) {
            PluginManagerCore.$$$reportNull$$$0(91);
        }
        LinkedHashMap<PluginId, IdeaPluginDescriptorImpl> idMap = new LinkedHashMap<PluginId, IdeaPluginDescriptorImpl>(descriptors.size());
        Map<PluginId, List<IdeaPluginDescriptorImpl>> duplicateMap = null;
        for (IdeaPluginDescriptorImpl descriptor : descriptors) {
            Map<PluginId, List<IdeaPluginDescriptorImpl>> newDuplicateMap = PluginManagerCore.checkAndPut(descriptor, descriptor.getPluginId(), idMap, duplicateMap);
            if (newDuplicateMap != null) {
                duplicateMap = newDuplicateMap;
                continue;
            }
            for (PluginId module : descriptor.getModules()) {
                newDuplicateMap = PluginManagerCore.checkAndPut(descriptor, module, idMap, duplicateMap);
                if (newDuplicateMap == null) continue;
                duplicateMap = newDuplicateMap;
            }
        }
        LinkedHashMap<PluginId, IdeaPluginDescriptorImpl> linkedHashMap = idMap;
        if (linkedHashMap == null) {
            PluginManagerCore.$$$reportNull$$$0(92);
        }
        return linkedHashMap;
    }

    @Nullable
    private static Map<PluginId, List<IdeaPluginDescriptorImpl>> checkAndPut(@NotNull IdeaPluginDescriptorImpl descriptor, @NotNull PluginId id, @NotNull Map<PluginId, IdeaPluginDescriptorImpl> idMap, @Nullable Map<PluginId, List<IdeaPluginDescriptorImpl>> duplicateMap) {
        List<IdeaPluginDescriptorImpl> duplicates;
        if (descriptor == null) {
            PluginManagerCore.$$$reportNull$$$0(93);
        }
        if (id == null) {
            PluginManagerCore.$$$reportNull$$$0(94);
        }
        if (idMap == null) {
            PluginManagerCore.$$$reportNull$$$0(95);
        }
        if (duplicateMap != null && (duplicates = duplicateMap.get(id)) != null) {
            duplicates.add(descriptor);
            return duplicateMap;
        }
        IdeaPluginDescriptorImpl existingDescriptor = idMap.put(id, descriptor);
        if (existingDescriptor == null) {
            return null;
        }
        idMap.remove(id);
        if (duplicateMap == null) {
            duplicateMap = new LinkedHashMap<PluginId, List<IdeaPluginDescriptorImpl>>();
        }
        ArrayList<IdeaPluginDescriptorImpl> list = new ArrayList<IdeaPluginDescriptorImpl>();
        list.add(existingDescriptor);
        list.add(descriptor);
        duplicateMap.put(id, list);
        return duplicateMap;
    }

    private static boolean computePluginEnabled(@NotNull IdeaPluginDescriptorImpl descriptor, @NotNull Set<PluginId> loadedPluginIds, @NotNull Set<PluginId> loadedModuleIds, @NotNull Map<PluginId, IdeaPluginDescriptorImpl> idMap, @NotNull Set<PluginId> disabledRequiredIds, @NotNull Set<PluginId> disabledPlugins, @NotNull List<PluginError> errors) {
        if (descriptor == null) {
            PluginManagerCore.$$$reportNull$$$0(96);
        }
        if (loadedPluginIds == null) {
            PluginManagerCore.$$$reportNull$$$0(97);
        }
        if (loadedModuleIds == null) {
            PluginManagerCore.$$$reportNull$$$0(98);
        }
        if (idMap == null) {
            PluginManagerCore.$$$reportNull$$$0(99);
        }
        if (disabledRequiredIds == null) {
            PluginManagerCore.$$$reportNull$$$0(100);
        }
        if (disabledPlugins == null) {
            PluginManagerCore.$$$reportNull$$$0(101);
        }
        if (errors == null) {
            PluginManagerCore.$$$reportNull$$$0(102);
        }
        if (descriptor.getPluginId() == CORE_ID) {
            return true;
        }
        boolean notifyUser = !descriptor.isImplementationDetail();
        boolean result = true;
        for (PluginId incompatibleId : ContainerUtil.notNullize(descriptor.incompatibilities)) {
            if (!loadedModuleIds.contains(incompatibleId) || disabledPlugins.contains(incompatibleId)) continue;
            result = false;
            String presentableName = PluginManagerCore.toPresentableName(incompatibleId.getIdString());
            errors.add(new PluginError(descriptor, "is incompatible with the IDE containing module " + presentableName, "IDE contains module " + presentableName, notifyUser));
        }
        if (descriptor.pluginDependencies == null) {
            return result;
        }
        for (PluginDependency dependency : descriptor.pluginDependencies) {
            String depName;
            PluginId depId = dependency.id;
            if (dependency.isOptional || loadedPluginIds.contains(depId) || loadedModuleIds.contains(depId)) continue;
            result = false;
            IdeaPluginDescriptor dep = idMap.get(depId);
            if (dep != null && disabledPlugins.contains(depId)) {
                disabledRequiredIds.add(dep.getPluginId());
            }
            String string = depName = dep == null ? null : dep.getName();
            if (depName == null) {
                if (PluginManagerCore.findErrorForPlugin(errors, depId) != null) {
                    errors.add(new PluginError(descriptor, "depends on plugin " + PluginManagerCore.toPresentableName(depId.getIdString()) + " that failed to load", null, notifyUser));
                    continue;
                }
                errors.add(new PluginError(descriptor, "requires " + PluginManagerCore.toPresentableName(depId.getIdString()) + " plugin to be installed", null, notifyUser));
                continue;
            }
            PluginError error = new PluginError(descriptor, "requires " + PluginManagerCore.toPresentableName(depName) + " plugin to be enabled", null, notifyUser);
            error.setDisabledDependency(dep.getPluginId());
            errors.add(error);
        }
        return result;
    }

    private static String toPresentableName(@Nullable IdeaPluginDescriptor descriptor) {
        return PluginManagerCore.toPresentableName(descriptor == null ? null : descriptor.getName());
    }

    @NotNull
    private static String toPresentableName(@Nullable String s) {
        String string = "\"" + (s == null ? "" : s) + "\"";
        if (string == null) {
            PluginManagerCore.$$$reportNull$$$0(103);
        }
        return string;
    }

    public static void registerExtensionPointAndExtensions(@NotNull Path pluginRoot, @NotNull String fileName, @NotNull ExtensionsArea area) {
        IdeaPluginDescriptorImpl descriptor;
        if (pluginRoot == null) {
            PluginManagerCore.$$$reportNull$$$0(104);
        }
        if (fileName == null) {
            PluginManagerCore.$$$reportNull$$$0(105);
        }
        if (area == null) {
            PluginManagerCore.$$$reportNull$$$0(106);
        }
        DescriptorListLoadingContext parentContext = DescriptorListLoadingContext.createSingleDescriptorContext(DisabledPluginsState.disabledPlugins());
        try (DescriptorLoadingContext context = new DescriptorLoadingContext(parentContext, true, true, PathBasedJdomXIncluder.DEFAULT_PATH_RESOLVER);){
            descriptor = Files.isDirectory(pluginRoot, new LinkOption[0]) ? PluginDescriptorLoader.loadDescriptorFromDir(pluginRoot, META_INF + fileName, null, context) : PluginDescriptorLoader.loadDescriptorFromJar(pluginRoot, fileName, PathBasedJdomXIncluder.DEFAULT_PATH_RESOLVER, context, null);
        }
        if (descriptor == null) {
            PluginManagerCore.getLogger().error("Cannot load " + fileName + " from " + pluginRoot);
            return;
        }
        List<ExtensionPointImpl<?>> extensionPoints = descriptor.appContainerDescriptor.extensionPoints;
        if (extensionPoints != null) {
            ((ExtensionsAreaImpl)area).registerExtensionPoints(extensionPoints, false);
        }
        descriptor.registerExtensions((ExtensionsAreaImpl)area, descriptor, descriptor.appContainerDescriptor, null);
    }

    private static synchronized void loadAndInitializePlugins(@Nullable DescriptorListLoadingContext context, @Nullable ClassLoader coreLoader) {
        if (coreLoader == null) {
            Class<?> callerClass = ReflectionUtil.findCallerClass(1);
            assert (callerClass != null);
            coreLoader = callerClass.getClassLoader();
        }
        try {
            if (context == null) {
                context = PluginDescriptorLoader.loadDescriptors();
            }
            Activity activity = StartUpMeasurer.startActivity("plugin initialization");
            PluginManagerState initResult = PluginManagerCore.initializePlugins(context, coreLoader, !isUnitTestMode);
            ourPlugins = initResult.sortedPlugins;
            PluginLoadingResult result = context.result;
            if (!result.incompletePlugins.isEmpty()) {
                int oldSize = initResult.sortedPlugins.length;
                IdeaPluginDescriptorImpl[] all = new IdeaPluginDescriptorImpl[oldSize + result.incompletePlugins.size()];
                System.arraycopy(initResult.sortedPlugins, 0, all, 0, oldSize);
                ArrayUtil.copy(result.incompletePlugins.values(), all, oldSize);
                ourPlugins = all;
            }
            ourPluginsToDisable = initResult.effectiveDisabledIds;
            ourPluginsToEnable = initResult.disabledRequiredIds;
            ourLoadedPlugins = initResult.sortedEnabledPlugins;
            ourShadowedBundledPlugins = result.getShadowedBundledIds();
            activity.end();
            activity.setDescription("plugin count: " + ourLoadedPlugins.size());
            PluginManagerCore.logPlugins(initResult.sortedPlugins);
        }
        catch (ExtensionInstantiationException e) {
            throw new PluginException(e, e.getExtensionOwnerId());
        }
        catch (RuntimeException e) {
            PluginManagerCore.getLogger().error(e);
            throw e;
        }
    }

    @NotNull
    public static Logger getLogger() {
        Logger logger2 = Logger.getInstance("#com.intellij.ide.plugins.PluginManager");
        if (logger2 == null) {
            PluginManagerCore.$$$reportNull$$$0(107);
        }
        return logger2;
    }

    @Nullable
    public static IdeaPluginDescriptor getPlugin(@Nullable PluginId id) {
        if (id != null) {
            for (IdeaPluginDescriptor plugin : PluginManagerCore.getPlugins()) {
                if (id != plugin.getPluginId()) continue;
                return plugin;
            }
        }
        return null;
    }

    @Nullable
    public static IdeaPluginDescriptor findPluginByModuleDependency(@NotNull PluginId id) {
        if (id == null) {
            PluginManagerCore.$$$reportNull$$$0(108);
        }
        for (IdeaPluginDescriptor descriptor : PluginManagerCore.getPlugins()) {
            if (!(descriptor instanceof IdeaPluginDescriptorImpl) || !((IdeaPluginDescriptorImpl)descriptor).getModules().contains(id)) continue;
            return descriptor;
        }
        return null;
    }

    public static boolean isPluginInstalled(PluginId id) {
        return PluginManagerCore.getPlugin(id) != null;
    }

    @ApiStatus.Internal
    @NotNull
    public static Map<PluginId, IdeaPluginDescriptorImpl> buildPluginIdMap() {
        LoadingState.COMPONENTS_REGISTERED.checkOccurred();
        return PluginManagerCore.buildPluginIdMap(Arrays.asList(ourPlugins));
    }

    @ApiStatus.Internal
    public static boolean processAllDependencies(@NotNull IdeaPluginDescriptorImpl rootDescriptor, boolean withOptionalDeps, @NotNull Function<IdeaPluginDescriptor, FileVisitResult> consumer) {
        if (rootDescriptor == null) {
            PluginManagerCore.$$$reportNull$$$0(109);
        }
        if (consumer == null) {
            PluginManagerCore.$$$reportNull$$$0(110);
        }
        return PluginManagerCore.processAllDependencies(rootDescriptor, withOptionalDeps, PluginManagerCore.buildPluginIdMap(), consumer);
    }

    @ApiStatus.Internal
    public static boolean processAllDependencies(@NotNull IdeaPluginDescriptorImpl rootDescriptor, boolean withOptionalDeps, @NotNull Map<PluginId, IdeaPluginDescriptorImpl> idToMap, @NotNull Function<IdeaPluginDescriptor, FileVisitResult> consumer) {
        if (rootDescriptor == null) {
            PluginManagerCore.$$$reportNull$$$0(111);
        }
        if (idToMap == null) {
            PluginManagerCore.$$$reportNull$$$0(112);
        }
        if (consumer == null) {
            PluginManagerCore.$$$reportNull$$$0(113);
        }
        return PluginManagerCore.processAllDependencies(rootDescriptor, withOptionalDeps, idToMap, new HashSet<IdeaPluginDescriptor>(), (id, descriptor) -> descriptor != null ? (FileVisitResult)((Object)((Object)consumer.apply((IdeaPluginDescriptor)descriptor))) : FileVisitResult.SKIP_SUBTREE);
    }

    @ApiStatus.Internal
    public static boolean processAllDependencies(@NotNull IdeaPluginDescriptorImpl rootDescriptor, boolean withOptionalDeps, @NotNull Map<PluginId, IdeaPluginDescriptorImpl> idToMap, @NotNull @NotNull BiFunction<? super @NotNull PluginId, ? super @Nullable IdeaPluginDescriptor, FileVisitResult> consumer) {
        if (rootDescriptor == null) {
            PluginManagerCore.$$$reportNull$$$0(114);
        }
        if (idToMap == null) {
            PluginManagerCore.$$$reportNull$$$0(115);
        }
        if (consumer == null) {
            PluginManagerCore.$$$reportNull$$$0(116);
        }
        return PluginManagerCore.processAllDependencies(rootDescriptor, withOptionalDeps, idToMap, new HashSet<IdeaPluginDescriptor>(), consumer);
    }

    @ApiStatus.Internal
    private static boolean processAllDependencies(@NotNull IdeaPluginDescriptorImpl rootDescriptor, boolean withOptionalDeps, @NotNull Map<PluginId, IdeaPluginDescriptorImpl> idToMap, @NotNull Set<IdeaPluginDescriptor> depProcessed, @NotNull BiFunction<? super PluginId, ? super IdeaPluginDescriptorImpl, FileVisitResult> consumer) {
        if (rootDescriptor == null) {
            PluginManagerCore.$$$reportNull$$$0(117);
        }
        if (idToMap == null) {
            PluginManagerCore.$$$reportNull$$$0(118);
        }
        if (depProcessed == null) {
            PluginManagerCore.$$$reportNull$$$0(119);
        }
        if (consumer == null) {
            PluginManagerCore.$$$reportNull$$$0(120);
        }
        if (rootDescriptor.pluginDependencies == null) {
            return true;
        }
        for (PluginDependency dependency : rootDescriptor.pluginDependencies) {
            if (!withOptionalDeps && dependency.isOptional) continue;
            IdeaPluginDescriptorImpl descriptor = idToMap.get(dependency.id);
            PluginId pluginId = descriptor == null ? dependency.id : descriptor.getPluginId();
            switch (consumer.apply(pluginId, descriptor)) {
                case TERMINATE: {
                    return false;
                }
                case CONTINUE: {
                    if (descriptor == null || !depProcessed.add(descriptor)) break;
                    PluginManagerCore.processAllDependencies(descriptor, withOptionalDeps, idToMap, depProcessed, consumer);
                    break;
                }
                case SKIP_SUBTREE: {
                    break;
                }
                case SKIP_SIBLINGS: {
                    throw new UnsupportedOperationException("FileVisitResult.SKIP_SIBLINGS is not supported");
                }
            }
        }
        return true;
    }

    public static boolean processAllBackwardDependencies(@NotNull IdeaPluginDescriptorImpl rootDescriptor, boolean withOptionalDeps, @NotNull Function<IdeaPluginDescriptor, FileVisitResult> consumer) {
        if (rootDescriptor == null) {
            PluginManagerCore.$$$reportNull$$$0(121);
        }
        if (consumer == null) {
            PluginManagerCore.$$$reportNull$$$0(122);
        }
        CachingSemiGraph<IdeaPluginDescriptorImpl> semiGraph = PluginManagerCore.createPluginIdGraph(Arrays.asList(ourPlugins), id -> (IdeaPluginDescriptorImpl)PluginManagerCore.getPlugin(id), withOptionalDeps, PluginManagerCore.findPluginByModuleDependency(ALL_MODULES_MARKER) != null);
        Graph<IdeaPluginDescriptorImpl> graph = GraphGenerator.generate(semiGraph);
        LinkedHashSet dependencies = new LinkedHashSet();
        GraphAlgorithms.getInstance().collectOutsRecursively(graph, rootDescriptor, dependencies);
        for (IdeaPluginDescriptorImpl dependency : dependencies) {
            if (dependency == rootDescriptor || consumer.apply(dependency) != FileVisitResult.TERMINATE) continue;
            return false;
        }
        return true;
    }

    @NotNull
    private static List<IdeaPluginDescriptorImpl> getOnlyEnabledPlugins(@NotNull @NotNull IdeaPluginDescriptorImpl @NotNull [] sortedAll) {
        if (sortedAll == null) {
            PluginManagerCore.$$$reportNull$$$0(123);
        }
        ArrayList<IdeaPluginDescriptorImpl> enabledPlugins = new ArrayList<IdeaPluginDescriptorImpl>(sortedAll.length);
        for (IdeaPluginDescriptorImpl descriptor : sortedAll) {
            if (!descriptor.isEnabled()) continue;
            enabledPlugins.add(descriptor);
        }
        ArrayList<IdeaPluginDescriptorImpl> arrayList = enabledPlugins;
        if (arrayList == null) {
            PluginManagerCore.$$$reportNull$$$0(124);
        }
        return arrayList;
    }

    @Deprecated
    public static void addDisablePluginListener(@NotNull Runnable listener) {
        if (listener == null) {
            PluginManagerCore.$$$reportNull$$$0(125);
        }
        PluginManager.getInstance().addDisablePluginListener(listener);
    }

    @Deprecated
    public static void removeDisablePluginListener(@NotNull Runnable listener) {
        if (listener == null) {
            PluginManagerCore.$$$reportNull$$$0(126);
        }
        PluginManager.getInstance().removeDisablePluginListener(listener);
    }

    public static synchronized boolean isUpdatedBundledPlugin(@NotNull PluginDescriptor plugin) {
        if (plugin == null) {
            PluginManagerCore.$$$reportNull$$$0(127);
        }
        return ourShadowedBundledPlugins != null && ourShadowedBundledPlugins.contains(plugin.getPluginId());
    }

    static {
        ourAdditionalLayoutMap = Collections.emptyMap();
        isUnitTestMode = Boolean.getBoolean("idea.is.unit.test");
        usePluginClassLoader = Boolean.getBoolean("idea.from.sources.plugins.class.loader");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 36: 
            case 37: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 62: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 71: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 91: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 104: 
            case 105: 
            case 106: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: 
            case 114: 
            case 115: 
            case 116: 
            case 117: 
            case 118: 
            case 119: 
            case 120: 
            case 121: 
            case 122: 
            case 123: 
            case 125: 
            case 126: 
            case 127: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 36: 
            case 37: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 62: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 71: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 91: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 104: 
            case 105: 
            case 106: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: 
            case 114: 
            case 115: 
            case 116: 
            case 117: 
            case 118: 
            case 119: 
            case 120: 
            case 121: 
            case 122: 
            case 123: 
            case 125: 
            case 126: 
            case 127: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sqldelight/com/intellij/ide/plugins/PluginManagerCore";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 5: 
            case 6: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginId";
                break;
            }
            case 7: 
            case 27: 
            case 28: 
            case 29: 
            case 37: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 93: 
            case 96: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ids";
                break;
            }
            case 12: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "writer";
                break;
            }
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 94: 
            case 108: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependentPluginId";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errorMessage";
                break;
            }
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginClass";
                break;
            }
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "className";
                break;
            }
            case 26: 
            case 57: {
                objectArray2 = objectArray3;
                objectArray3[0] = "loader";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "urlLoaderBuilder";
                break;
            }
            case 31: 
            case 84: 
            case 85: {
                objectArray2 = objectArray3;
                objectArray3[0] = "coreLoader";
                break;
            }
            case 32: 
            case 88: {
                objectArray2 = objectArray3;
                objectArray3[0] = "additionalLayoutMap";
                break;
            }
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentLoaders";
                break;
            }
            case 39: {
                objectArray2 = objectArray3;
                objectArray3[0] = "plugins";
                break;
            }
            case 40: 
            case 49: 
            case 56: 
            case 76: 
            case 102: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errors";
                break;
            }
            case 41: {
                objectArray2 = objectArray3;
                objectArray3[0] = "actions";
                break;
            }
            case 42: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginDescriptor";
                break;
            }
            case 45: 
            case 47: 
            case 74: 
            case 91: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptors";
                break;
            }
            case 46: 
            case 48: {
                objectArray2 = objectArray3;
                objectArray3[0] = "idToDescriptorMap";
                break;
            }
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginDir";
                break;
            }
            case 51: 
            case 83: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 52: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dir";
                break;
            }
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disabledIds";
                break;
            }
            case 54: 
            case 100: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disabledRequiredIds";
                break;
            }
            case 55: 
            case 65: 
            case 68: 
            case 75: 
            case 82: 
            case 95: 
            case 99: {
                objectArray2 = objectArray3;
                objectArray3[0] = "idMap";
                break;
            }
            case 62: {
                objectArray2 = objectArray3;
                objectArray3[0] = "coreClassLoader";
                break;
            }
            case 64: 
            case 87: {
                objectArray2 = objectArray3;
                objectArray3[0] = "enabledPlugins";
                break;
            }
            case 66: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mergedDescriptor";
                break;
            }
            case 67: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginDependencies";
                break;
            }
            case 71: 
            case 109: 
            case 111: 
            case 114: 
            case 117: 
            case 121: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootDescriptor";
                break;
            }
            case 81: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildNumber";
                break;
            }
            case 86: 
            case 89: {
                objectArray2 = objectArray3;
                objectArray3[0] = "graph";
                break;
            }
            case 97: {
                objectArray2 = objectArray3;
                objectArray3[0] = "loadedPluginIds";
                break;
            }
            case 98: {
                objectArray2 = objectArray3;
                objectArray3[0] = "loadedModuleIds";
                break;
            }
            case 101: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disabledPlugins";
                break;
            }
            case 104: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pluginRoot";
                break;
            }
            case 105: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
            case 106: {
                objectArray2 = objectArray3;
                objectArray3[0] = "area";
                break;
            }
            case 110: 
            case 113: 
            case 116: 
            case 120: 
            case 122: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
            case 112: 
            case 115: 
            case 118: {
                objectArray2 = objectArray3;
                objectArray3[0] = "idToMap";
                break;
            }
            case 119: {
                objectArray2 = objectArray3;
                objectArray3[0] = "depProcessed";
                break;
            }
            case 123: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sortedAll";
                break;
            }
            case 125: 
            case 126: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 127: {
                objectArray2 = objectArray3;
                objectArray3[0] = "plugin";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getPlugins";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getLoadedPlugins";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 36: 
            case 37: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 62: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 71: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 91: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 104: 
            case 105: 
            case 106: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: 
            case 114: 
            case 115: 
            case 116: 
            case 117: 
            case 118: 
            case 119: 
            case 120: 
            case 121: 
            case 122: 
            case 123: 
            case 125: 
            case 126: 
            case 127: {
                objectArray = objectArray2;
                objectArray2[1] = "sqldelight/com/intellij/ide/plugins/PluginManagerCore";
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getBrokenPluginVersions";
                break;
            }
            case 34: 
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "createPluginClassLoader";
                break;
            }
            case 38: {
                objectArray = objectArray2;
                objectArray2[1] = "localFileToUrl";
                break;
            }
            case 58: {
                objectArray = objectArray2;
                objectArray2[1] = "testLoadDescriptorsFromClassPath";
                break;
            }
            case 59: 
            case 60: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrScheduleLoading";
                break;
            }
            case 61: {
                objectArray = objectArray2;
                objectArray2[1] = "getEnabledPluginRawList";
                break;
            }
            case 63: {
                objectArray = objectArray2;
                objectArray2[1] = "initPlugins";
                break;
            }
            case 69: 
            case 70: {
                objectArray = objectArray2;
                objectArray2[1] = "loadAdditionalLayoutMap";
                break;
            }
            case 72: {
                objectArray = objectArray2;
                objectArray2[1] = "createUrlClassLoaderBuilder";
                break;
            }
            case 73: {
                objectArray = objectArray2;
                objectArray2[1] = "getBuildNumber";
                break;
            }
            case 90: {
                objectArray = objectArray2;
                objectArray2[1] = "getTopologicallySorted";
                break;
            }
            case 92: {
                objectArray = objectArray2;
                objectArray2[1] = "buildPluginIdMap";
                break;
            }
            case 103: {
                objectArray = objectArray2;
                objectArray2[1] = "toPresentableName";
                break;
            }
            case 107: {
                objectArray = objectArray2;
                objectArray2[1] = "getLogger";
                break;
            }
            case 124: {
                objectArray = objectArray2;
                objectArray2[1] = "getOnlyEnabledPlugins";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "doSetPlugins";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isDisabled";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isBrokenPlugin";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "savePluginsList";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "writePluginsList";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "disablePlugin";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "enablePlugin";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "isModuleDependency";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "createPluginException";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getPluginByClassName";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getPluginOrPlatformByClassName";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getPluginDescriptorOrPlatformByClassName";
                break;
            }
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "hasLoadedClass";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getImplicitDependency";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "hasModuleDependencies";
                break;
            }
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "createPluginClassLoader";
                break;
            }
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "localFileToUrl";
                break;
            }
            case 39: {
                objectArray = objectArray;
                objectArray[2] = "logPlugins";
                break;
            }
            case 40: 
            case 41: 
            case 53: 
            case 54: 
            case 55: 
            case 56: {
                objectArray = objectArray;
                objectArray[2] = "prepareLoadingPluginsErrorMessage";
                break;
            }
            case 42: {
                objectArray = objectArray;
                objectArray[2] = "getLoadingError";
                break;
            }
            case 43: {
                objectArray = objectArray;
                objectArray[2] = "getFirstDisabledDependency";
                break;
            }
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "findErrorForPlugin";
                break;
            }
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "createPluginIdGraph";
                break;
            }
            case 47: 
            case 48: 
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "checkPluginCycles";
                break;
            }
            case 50: 
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "createPluginJarsPathResolver";
                break;
            }
            case 52: {
                objectArray = objectArray;
                objectArray[2] = "getDescriptorsToMigrate";
                break;
            }
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "testLoadDescriptorsFromClassPath";
                break;
            }
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "initPlugins";
                break;
            }
            case 64: 
            case 65: {
                objectArray = objectArray;
                objectArray[2] = "mergeOptionalConfigs";
                break;
            }
            case 66: 
            case 67: 
            case 68: {
                objectArray = objectArray;
                objectArray[2] = "mergeOptionalDescriptors";
                break;
            }
            case 71: {
                objectArray = objectArray;
                objectArray[2] = "initClassLoader";
                break;
            }
            case 74: 
            case 75: 
            case 76: {
                objectArray = objectArray;
                objectArray[2] = "disableIncompatiblePlugins";
                break;
            }
            case 77: 
            case 78: {
                objectArray = objectArray;
                objectArray[2] = "isCompatible";
                break;
            }
            case 79: 
            case 80: {
                objectArray = objectArray;
                objectArray[2] = "isIncompatible";
                break;
            }
            case 81: {
                objectArray = objectArray;
                objectArray[2] = "getIncompatibleMessage";
                break;
            }
            case 82: {
                objectArray = objectArray;
                objectArray[2] = "checkEssentialPluginsAreAvailable";
                break;
            }
            case 83: 
            case 84: {
                objectArray = objectArray;
                objectArray[2] = "initializePlugins";
                break;
            }
            case 85: 
            case 86: 
            case 87: 
            case 88: {
                objectArray = objectArray;
                objectArray[2] = "configureClassLoaders";
                break;
            }
            case 89: {
                objectArray = objectArray;
                objectArray[2] = "getTopologicallySorted";
                break;
            }
            case 91: {
                objectArray = objectArray;
                objectArray[2] = "buildPluginIdMap";
                break;
            }
            case 93: 
            case 94: 
            case 95: {
                objectArray = objectArray;
                objectArray[2] = "checkAndPut";
                break;
            }
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: {
                objectArray = objectArray;
                objectArray[2] = "computePluginEnabled";
                break;
            }
            case 104: 
            case 105: 
            case 106: {
                objectArray = objectArray;
                objectArray[2] = "registerExtensionPointAndExtensions";
                break;
            }
            case 108: {
                objectArray = objectArray;
                objectArray[2] = "findPluginByModuleDependency";
                break;
            }
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: 
            case 114: 
            case 115: 
            case 116: 
            case 117: 
            case 118: 
            case 119: 
            case 120: {
                objectArray = objectArray;
                objectArray[2] = "processAllDependencies";
                break;
            }
            case 121: 
            case 122: {
                objectArray = objectArray;
                objectArray[2] = "processAllBackwardDependencies";
                break;
            }
            case 123: {
                objectArray = objectArray;
                objectArray[2] = "getOnlyEnabledPlugins";
                break;
            }
            case 125: {
                objectArray = objectArray;
                objectArray[2] = "addDisablePluginListener";
                break;
            }
            case 126: {
                objectArray = objectArray;
                objectArray[2] = "removeDisablePluginListener";
                break;
            }
            case 127: {
                objectArray = objectArray;
                objectArray[2] = "isUpdatedBundledPlugin";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 36: 
            case 37: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 62: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: 
            case 71: 
            case 74: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: 
            case 87: 
            case 88: 
            case 89: 
            case 91: 
            case 93: 
            case 94: 
            case 95: 
            case 96: 
            case 97: 
            case 98: 
            case 99: 
            case 100: 
            case 101: 
            case 102: 
            case 104: 
            case 105: 
            case 106: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: 
            case 114: 
            case 115: 
            case 116: 
            case 117: 
            case 118: 
            case 119: 
            case 120: 
            case 121: 
            case 122: 
            case 123: 
            case 125: 
            case 126: 
            case 127: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static final class EssentialPluginMissingException
    extends RuntimeException {
        public final List<String> pluginIds;

        EssentialPluginMissingException(@NotNull List<String> ids) {
            if (ids == null) {
                EssentialPluginMissingException.$$$reportNull$$$0(0);
            }
            super("Missing essential plugins: " + String.join((CharSequence)", ", ids));
            this.pluginIds = ids;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ids", "sqldelight/com/intellij/ide/plugins/PluginManagerCore$EssentialPluginMissingException", "<init>"));
        }
    }
}

