/*
 * Decompiled with CFR 0.152.
 */
package sqldelight.com.intellij.openapi.editor.impl;

import java.util.Comparator;
import sqldelight.com.intellij.util.ArrayFactory;
import sqldelight.com.intellij.util.ArrayUtil;
import sqldelight.com.intellij.util.concurrency.AtomicFieldUpdater;
import sqldelight.org.jetbrains.annotations.NotNull;

class LockFreeCOWSortedArray<T> {
    @NotNull
    private final Comparator<? super T> comparator;
    private final ArrayFactory<T> arrayFactory;
    private volatile T @NotNull [] listeners;
    private static final AtomicFieldUpdater<LockFreeCOWSortedArray, Object[]> UPDATER = AtomicFieldUpdater.forFieldOfType(LockFreeCOWSortedArray.class, Object[].class);

    LockFreeCOWSortedArray(@NotNull Comparator<? super T> comparator, @NotNull ArrayFactory<T> arrayFactory) {
        if (comparator == null) {
            LockFreeCOWSortedArray.$$$reportNull$$$0(0);
        }
        if (arrayFactory == null) {
            LockFreeCOWSortedArray.$$$reportNull$$$0(1);
        }
        this.comparator = comparator;
        this.arrayFactory = arrayFactory;
        this.listeners = arrayFactory.create(0);
    }

    void add(@NotNull T listener) {
        int i;
        T[] newListeners;
        T[] oldListeners;
        if (listener == null) {
            LockFreeCOWSortedArray.$$$reportNull$$$0(2);
        }
        while (!UPDATER.compareAndSet(this, oldListeners = this.listeners, newListeners = ArrayUtil.insert(oldListeners, i = this.insertionIndex(oldListeners, listener), listener))) {
        }
    }

    boolean remove(@NotNull T listener) {
        T[] newListeners;
        T[] oldListeners;
        if (listener == null) {
            LockFreeCOWSortedArray.$$$reportNull$$$0(3);
        }
        do {
            if ((oldListeners = this.listeners) != (newListeners = ArrayUtil.remove(oldListeners, listener, this.arrayFactory))) continue;
            return false;
        } while (!UPDATER.compareAndSet(this, oldListeners, newListeners));
        return true;
    }

    private int insertionIndex(T @NotNull [] elements, @NotNull T e) {
        if (e == null) {
            LockFreeCOWSortedArray.$$$reportNull$$$0(4);
        }
        if (elements == null) {
            LockFreeCOWSortedArray.$$$reportNull$$$0(5);
        }
        for (int i = 0; i < elements.length; ++i) {
            T element = elements[i];
            if (this.comparator.compare(e, element) >= 0) continue;
            return i;
        }
        return elements.length;
    }

    T @NotNull [] getArray() {
        if (this.listeners == null) {
            LockFreeCOWSortedArray.$$$reportNull$$$0(6);
        }
        return this.listeners;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comparator";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "arrayFactory";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sqldelight/com/intellij/openapi/editor/impl/LockFreeCOWSortedArray";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "sqldelight/com/intellij/openapi/editor/impl/LockFreeCOWSortedArray";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getArray";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "add";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "remove";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "insertionIndex";
                break;
            }
            case 6: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

