/*
 * Decompiled with CFR 0.152.
 */
package sqldelight.com.intellij.openapi.util;

import java.awt.Color;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentMap;
import sqldelight.com.intellij.openapi.diagnostic.Logger;
import sqldelight.com.intellij.openapi.util.InvalidDataException;
import sqldelight.com.intellij.openapi.util.JDOMExternalizable;
import sqldelight.com.intellij.openapi.util.WriteExternalException;
import sqldelight.com.intellij.util.ReflectionUtil;
import sqldelight.com.intellij.util.containers.ConcurrentFactoryMap;
import sqldelight.com.intellij.util.xmlb.annotations.Transient;
import sqldelight.org.jdom.Element;
import sqldelight.org.jdom.Verifier;
import sqldelight.org.jetbrains.annotations.ApiStatus;
import sqldelight.org.jetbrains.annotations.NotNull;
import sqldelight.org.jetbrains.annotations.Nullable;

@Deprecated
public final class DefaultJDOMExternalizer {
    private static final Logger LOG = Logger.getInstance(DefaultJDOMExternalizer.class);
    private static final ConcurrentMap<Class, Map<String, Field>> ourFieldCache = ConcurrentFactoryMap.createMap(c -> {
        LinkedHashMap<String, Field> result = new LinkedHashMap<String, Field>();
        for (Field field : c.getFields()) {
            int modifiers;
            String name = field.getName();
            if (name.indexOf(36) >= 0 || result.containsKey(name) || !Modifier.isPublic(modifiers = field.getModifiers()) || Modifier.isStatic(modifiers) || Modifier.isTransient(modifiers) || field.getAnnotation(Transient.class) != null) continue;
            field.setAccessible(true);
            if (field.getDeclaringClass().getAnnotation(Transient.class) != null) continue;
            result.put(name, field);
        }
        return result;
    });

    private DefaultJDOMExternalizer() {
    }

    public static void writeExternal(@NotNull Object data, @NotNull Element parentNode) throws WriteExternalException {
        if (data == null) {
            DefaultJDOMExternalizer.$$$reportNull$$$0(0);
        }
        if (parentNode == null) {
            DefaultJDOMExternalizer.$$$reportNull$$$0(1);
        }
        DefaultJDOMExternalizer.writeExternal(data, parentNode, null);
    }

    public static void writeExternal(@NotNull Object data, @NotNull Element parentNode, @Nullable(value="null means all elements are accepted") @Nullable(value="null means all elements are accepted") JDOMFilter filter) throws WriteExternalException {
        if (data == null) {
            DefaultJDOMExternalizer.$$$reportNull$$$0(2);
        }
        if (parentNode == null) {
            DefaultJDOMExternalizer.$$$reportNull$$$0(3);
        }
        for (Field field : ((Map)ourFieldCache.get(data.getClass())).values()) {
            Element element;
            String value;
            block25: {
                if (filter != null && !filter.isAccept(field)) continue;
                Class<?> type2 = field.getType();
                value = null;
                try {
                    if (type2.isPrimitive()) {
                        if (type2.equals(Byte.TYPE)) {
                            value = Byte.toString(field.getByte(data));
                        } else if (type2.equals(Short.TYPE)) {
                            value = Short.toString(field.getShort(data));
                        } else if (type2.equals(Integer.TYPE)) {
                            value = Integer.toString(field.getInt(data));
                        } else if (type2.equals(Long.TYPE)) {
                            value = Long.toString(field.getLong(data));
                        } else if (type2.equals(Float.TYPE)) {
                            value = Float.toString(field.getFloat(data));
                        } else if (type2.equals(Double.TYPE)) {
                            value = Double.toString(field.getDouble(data));
                        } else if (type2.equals(Character.TYPE)) {
                            value = String.valueOf(field.getChar(data));
                        } else {
                            if (!type2.equals(Boolean.TYPE)) continue;
                            value = Boolean.toString(field.getBoolean(data));
                        }
                        break block25;
                    }
                    if (type2.equals(String.class)) {
                        value = DefaultJDOMExternalizer.filterXMLCharacters((String)field.get(data));
                        break block25;
                    }
                    if (type2.isEnum()) {
                        value = field.get(data).toString();
                        break block25;
                    }
                    if (type2.equals(Color.class)) {
                        Color color = (Color)field.get(data);
                        if (color != null) {
                            value = Integer.toString(color.getRGB() & 0xFFFFFF, 16);
                        }
                        break block25;
                    }
                    if (ReflectionUtil.isAssignable(JDOMExternalizable.class, type2)) {
                        element = new Element("option");
                        parentNode.addContent(element);
                        element.setAttribute("name", field.getName());
                        JDOMExternalizable domValue = (JDOMExternalizable)field.get(data);
                        if (domValue == null) continue;
                        Element valueElement = new Element("value");
                        element.addContent(valueElement);
                        domValue.writeExternal(valueElement);
                        continue;
                    }
                    LOG.debug("Wrong field type: " + type2);
                }
                catch (IllegalAccessException e) {}
                continue;
            }
            element = new Element("option");
            parentNode.addContent(element);
            element.setAttribute("name", field.getName());
            if (value == null) continue;
            element.setAttribute("value", value);
        }
    }

    @Nullable
    static String filterXMLCharacters(@Nullable String value) {
        if (value == null) {
            return null;
        }
        StringBuilder builder = null;
        for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            if (Verifier.isXMLCharacter(c)) {
                if (builder == null) continue;
                builder.append(c);
                continue;
            }
            if (builder != null) continue;
            builder = new StringBuilder(value.length() + 5);
            builder.append(value, 0, i);
        }
        if (builder != null) {
            value = builder.toString();
        }
        return value;
    }

    public static void readExternal(@NotNull Object data, Element parentNode) throws InvalidDataException {
        if (data == null) {
            DefaultJDOMExternalizer.$$$reportNull$$$0(4);
        }
        if (parentNode == null) {
            return;
        }
        Map fields = (Map)ourFieldCache.get(data.getClass());
        block12: for (Element e : parentNode.getChildren("option")) {
            String fieldName = e.getAttributeValue("name");
            if (fieldName == null) {
                throw new InvalidDataException();
            }
            try {
                Object value;
                Field field = (Field)fields.get(fieldName);
                if (field == null) continue;
                if (Modifier.isFinal(field.getModifiers())) {
                    value = field.get(data);
                    if (!(value instanceof JDOMExternalizable)) continue;
                    List<Element> children2 = e.getChildren("value");
                    Iterator<Element> iterator = children2.iterator();
                    while (iterator.hasNext()) {
                        Element child;
                        Element valueTag = child = iterator.next();
                        ((JDOMExternalizable)value).readExternal(valueTag);
                    }
                    continue;
                }
                value = e.getAttributeValue("value");
                Class<?> type2 = field.getType();
                if (type2.isPrimitive()) {
                    if (value == null) continue;
                    if (type2.equals(Byte.TYPE)) {
                        try {
                            field.setByte(data, Byte.parseByte((String)value));
                            continue;
                        }
                        catch (NumberFormatException ex) {
                            throw new InvalidDataException();
                        }
                    }
                    if (type2.equals(Short.TYPE)) {
                        try {
                            field.setShort(data, Short.parseShort((String)value));
                            continue;
                        }
                        catch (NumberFormatException ex) {
                            throw new InvalidDataException();
                        }
                    }
                    if (type2.equals(Integer.TYPE)) {
                        int i = DefaultJDOMExternalizer.toInt((String)value);
                        field.setInt(data, i);
                        continue;
                    }
                    if (type2.equals(Long.TYPE)) {
                        try {
                            field.setLong(data, Long.parseLong((String)value));
                            continue;
                        }
                        catch (NumberFormatException ex) {
                            throw new InvalidDataException();
                        }
                    }
                    if (type2.equals(Float.TYPE)) {
                        try {
                            field.setFloat(data, Float.parseFloat((String)value));
                            continue;
                        }
                        catch (NumberFormatException ex) {
                            throw new InvalidDataException();
                        }
                    }
                    if (type2.equals(Double.TYPE)) {
                        try {
                            field.setDouble(data, Double.parseDouble((String)value));
                            continue;
                        }
                        catch (NumberFormatException ex) {
                            throw new InvalidDataException();
                        }
                    }
                    if (type2.equals(Character.TYPE)) {
                        if (((String)value).length() != 1) {
                            throw new InvalidDataException();
                        }
                        field.setChar(data, ((String)value).charAt(0));
                        continue;
                    }
                    if (type2.equals(Boolean.TYPE)) {
                        if (((String)value).equals("true")) {
                            field.setBoolean(data, true);
                            continue;
                        }
                        if (((String)value).equals("false")) {
                            field.setBoolean(data, false);
                            continue;
                        }
                        throw new InvalidDataException();
                    }
                    throw new InvalidDataException();
                }
                if (type2.isEnum()) {
                    for (Object enumValue : type2.getEnumConstants()) {
                        if (!enumValue.toString().equals(value)) continue;
                        field.set(data, enumValue);
                        continue block12;
                    }
                    continue;
                }
                if (type2.equals(String.class)) {
                    field.set(data, value);
                    continue;
                }
                if (type2.equals(Color.class)) {
                    Color color = DefaultJDOMExternalizer.toColor((String)value);
                    field.set(data, color);
                    continue;
                }
                if (ReflectionUtil.isAssignable(JDOMExternalizable.class, type2)) {
                    List<Element> children3 = e.getChildren("value");
                    if (children3.isEmpty()) continue;
                    JDOMExternalizable object = null;
                    for (Element element : children3) {
                        object = (JDOMExternalizable)type2.newInstance();
                        object.readExternal(element);
                    }
                    field.set(data, object);
                    continue;
                }
                throw new InvalidDataException("wrong type: " + type2);
            }
            catch (IllegalAccessException | InstantiationException | SecurityException ex) {
                throw new InvalidDataException(ex);
            }
        }
    }

    public static int toInt(@NotNull String value) throws InvalidDataException {
        int i;
        if (value == null) {
            DefaultJDOMExternalizer.$$$reportNull$$$0(5);
        }
        try {
            i = Integer.parseInt(value);
        }
        catch (NumberFormatException ex) {
            throw new InvalidDataException(value, ex);
        }
        return i;
    }

    public static Color toColor(@Nullable String value) throws InvalidDataException {
        Color color;
        if (value == null) {
            color = null;
        } else {
            try {
                int rgb = Integer.parseInt(value, 16);
                color = new Color(rgb);
            }
            catch (NumberFormatException ex) {
                LOG.debug("Wrong color value: " + value, ex);
                throw new InvalidDataException("Wrong color value: " + value, ex);
            }
        }
        return color;
    }

    @ApiStatus.Internal
    public static void clearFieldCache() {
        ourFieldCache.clear();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentNode";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
        }
        objectArray2[1] = "sqldelight/com/intellij/openapi/util/DefaultJDOMExternalizer";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "writeExternal";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "readExternal";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "toInt";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static interface JDOMFilter {
        public boolean isAccept(@NotNull Field var1);
    }
}

